/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;

final class DirectArrayOfDoublesSketchIterator
implements ArrayOfDoublesSketchIterator {
    private MemorySegment seg_;
    private int offset_;
    private int numEntries_;
    private int numValues_;
    private int i_;
    private static final int SIZE_OF_KEY_BYTES = 8;
    private static final int SIZE_OF_VALUE_BYTES = 8;

    DirectArrayOfDoublesSketchIterator(MemorySegment seg, int offset, int numEntries, int numValues) {
        this.seg_ = seg;
        this.offset_ = offset;
        this.numEntries_ = numEntries;
        this.numValues_ = numValues;
        this.i_ = -1;
    }

    @Override
    public boolean next() {
        ++this.i_;
        while (this.i_ < this.numEntries_) {
            long off = (long)this.offset_ + 8L * (long)this.i_;
            if (this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, off) != 0L) {
                return true;
            }
            ++this.i_;
        }
        return false;
    }

    @Override
    public long getKey() {
        long off = (long)this.offset_ + 8L * (long)this.i_;
        return this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, off);
    }

    @Override
    public double[] getValues() {
        if (this.numValues_ == 1) {
            long off = (long)this.offset_ + 8L * (long)this.numEntries_ + 8L * (long)this.i_;
            return new double[]{this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, off)};
        }
        double[] array = new double[this.numValues_];
        long off = (long)this.offset_ + 8L * (long)this.numEntries_ + 8L * (long)this.i_ * (long)this.numValues_;
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, off, array, 0, this.numValues_);
        return array;
    }
}

