/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummaryFactory;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleExamplesTest {
    private final IntegerSummary.Mode umode = IntegerSummary.Mode.Sum;
    private final IntegerSummary.Mode imode = IntegerSummary.Mode.AlwaysOne;
    private final IntegerSummarySetOperations isso = new IntegerSummarySetOperations(this.umode, this.imode);
    private final IntegerSummaryFactory ufactory = new IntegerSummaryFactory(this.umode);
    private final IntegerSummaryFactory ifactory = new IntegerSummaryFactory(this.imode);
    private final UpdateSketchBuilder thetaBldr = UpdateSketch.builder();
    private final UpdatableSketchBuilder<Integer, IntegerSummary> tupleBldr = new UpdatableSketchBuilder((SummaryFactory)this.ufactory);

    @Test
    public void example1() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.isso);
        union.union((Sketch)tupleSk);
        union.union((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        CompactSketch ucsk = union.getResult();
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("Union Stateful: tuple, theta: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.isso);
        inter.intersect((Sketch)tupleSk);
        inter.intersect((org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ifactory.newSummary().update(Integer.valueOf(1)));
        CompactSketch icsk = inter.getResult();
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("Intersection Stateful: tuple, theta: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example2() {
        UpdatableSketch tupleSk1 = this.tupleBldr.build();
        UpdatableSketch tupleSk2 = this.tupleBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk1.update((long)i, (Object)1);
            tupleSk2.update((long)(i + 3), (Object)1);
        }
        Union union = new Union((SummarySetOperations)this.isso);
        CompactSketch ucsk = union.union((Sketch)tupleSk1, (Sketch)tupleSk2);
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("Union: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.isso);
        CompactSketch icsk = inter.intersect((Sketch)tupleSk1, (Sketch)tupleSk2);
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("Intersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void example3() {
        UpdatableSketch tupleSk = this.tupleBldr.build();
        UpdateSketch thetaSk = this.thetaBldr.build();
        for (int i = 1; i <= 12; ++i) {
            tupleSk.update((long)i, (Object)1);
            thetaSk.update((long)(i + 3));
        }
        Union union = new Union((SummarySetOperations)this.isso);
        CompactSketch ucsk = union.union((Sketch)tupleSk, (org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        int entries = ucsk.getRetainedEntries();
        TupleExamplesTest.println("Union: " + entries);
        TupleSketchIterator uiter = ucsk.iterator();
        int counter = 1;
        int twos = 0;
        int ones = 0;
        while (uiter.next()) {
            int i = ((IntegerSummary)uiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            if (i == 1) {
                ++ones;
            }
            if (i != 2) continue;
            ++twos;
        }
        Assert.assertEquals((int)ones, (int)6);
        Assert.assertEquals((int)twos, (int)9);
        Intersection inter = new Intersection((SummarySetOperations)this.isso);
        CompactSketch icsk = inter.intersect((Sketch)tupleSk, (org.apache.datasketches.theta.Sketch)thetaSk, (Summary)this.ufactory.newSummary().update(Integer.valueOf(1)));
        entries = icsk.getRetainedEntries();
        TupleExamplesTest.println("Intersection: " + entries);
        TupleSketchIterator iiter = icsk.iterator();
        counter = 1;
        while (iiter.next()) {
            int i = ((IntegerSummary)iiter.getSummary()).getValue();
            TupleExamplesTest.println(counter++ + ", " + i);
            Assert.assertEquals((int)i, (int)1);
        }
    }

    @Test
    public void printlnTest() {
        TupleExamplesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

