/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.FileProcessor;
import org.apache.rat.document.DocumentName;

public class DescendingFileProcessor
implements FileProcessor {
    private final String fileName;
    protected final Predicate<String> commentFilter;

    public DescendingFileProcessor(String fileName, String commentPrefix) {
        this(fileName, commentPrefix == null ? null : Collections.singletonList(commentPrefix));
    }

    public DescendingFileProcessor(String fileName, Iterable<String> commentPrefixes) {
        this.fileName = fileName;
        this.commentFilter = commentPrefixes == null ? StringUtils::isNotBlank : ExclusionUtils.commentFilter(commentPrefixes);
    }

    protected List<String> process(DocumentName documentName) {
        return ExclusionUtils.asIterator(new File(documentName.getName()), this.commentFilter).map(entry -> this.modifyEntry(documentName, (String)entry)).filter(Objects::nonNull).map(entry -> FileProcessor.localizePattern(documentName, entry)).map(DocumentName::getName).addTo(new ArrayList());
    }

    private File[] listFiles(File dir, FileFilter filter) {
        File[] result = dir.listFiles(filter);
        return result == null ? new File[]{} : result;
    }

    private List<String> checkDirectory(DocumentName directory, FileFilter fileFilter) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File dirFile = new File(directory.getName());
        for (File f : this.listFiles(dirFile, fileFilter)) {
            fileNames.addAll(this.process(new DocumentName(f, directory)));
        }
        for (File dir : this.listFiles(dirFile, DirectoryFileFilter.DIRECTORY)) {
            fileNames.addAll(this.checkDirectory(new DocumentName(dir), fileFilter));
        }
        return fileNames;
    }

    @Override
    public List<String> apply(DocumentName dir) {
        return this.checkDirectory(dir, new NameFileFilter(this.fileName));
    }
}

