/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.ranking;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.commons.math3.stat.ranking.NaturalRanking;
import org.apache.commons.math3.stat.ranking.TiesStrategy;
import org.junit.Assert;
import org.junit.Test;

public class NaturalRankingTest {
    private final double[] exampleData = new double[]{20.0, 17.0, 30.0, 42.3, 17.0, 50.0, Double.NaN, Double.NEGATIVE_INFINITY, 17.0};
    private final double[] tiesFirst = new double[]{0.0, 0.0, 2.0, 1.0, 4.0};
    private final double[] tiesLast = new double[]{4.0, 4.0, 1.0, 0.0};
    private final double[] multipleNaNs = new double[]{0.0, 1.0, Double.NaN, Double.NaN};
    private final double[] multipleTies = new double[]{3.0, 2.0, 5.0, 5.0, 6.0, 6.0, 1.0};
    private final double[] allSame = new double[]{0.0, 0.0, 0.0, 0.0};

    @Test
    public void testDefault() {
        double[] ranks;
        NaturalRanking ranking = new NaturalRanking();
        try {
            ranks = ranking.rank(this.exampleData);
            Assert.fail((String)"expected NotANumberException due to NaNStrategy.FAILED");
        }
        catch (NotANumberException notANumberException) {
            // empty catch block
        }
        ranks = ranking.rank(this.tiesFirst);
        double[] correctRanks = new double[]{1.5, 1.5, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.5, 3.5, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        try {
            ranks = ranking.rank(this.multipleNaNs);
            Assert.fail((String)"expected NotANumberException due to NaNStrategy.FAILED");
        }
        catch (NotANumberException notANumberException) {
            // empty catch block
        }
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.5, 4.5, 6.5, 6.5, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{2.5, 2.5, 2.5, 2.5};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsMaximalTiesMinimum() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MAXIMAL, TiesStrategy.MINIMUM);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{5.0, 2.0, 6.0, 7.0, 2.0, 8.0, 9.0, 1.0, 2.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.0, 1.0, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.0, 3.0, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{1.0, 2.0, 3.0, 3.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.0, 4.0, 6.0, 6.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{1.0, 1.0, 1.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsRemovedTiesSequential() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.REMOVED, TiesStrategy.SEQUENTIAL);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{5.0, 2.0, 6.0, 7.0, 3.0, 8.0, 1.0, 4.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.0, 2.0, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.0, 4.0, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{1.0, 2.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.0, 5.0, 6.0, 7.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{1.0, 2.0, 3.0, 4.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsMinimalTiesMaximum() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MINIMAL, TiesStrategy.MAXIMUM);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{6.0, 5.0, 7.0, 8.0, 5.0, 9.0, 2.0, 2.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{2.0, 2.0, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{4.0, 4.0, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{3.0, 4.0, 2.0, 2.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 5.0, 5.0, 7.0, 7.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{4.0, 4.0, 4.0, 4.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsMinimalTiesAverage() {
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MINIMAL);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{6.0, 4.0, 7.0, 8.0, 4.0, 9.0, 1.5, 1.5, 4.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.5, 1.5, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.5, 3.5, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{3.0, 4.0, 1.5, 1.5};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.5, 4.5, 6.5, 6.5, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{2.5, 2.5, 2.5, 2.5};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsFixedTiesRandom() {
        JDKRandomGenerator randomGenerator = new JDKRandomGenerator();
        randomGenerator.setSeed(1000);
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FIXED, (RandomGenerator)randomGenerator);
        double[] ranks = ranking.rank(this.exampleData);
        double[] correctRanks = new double[]{5.0, 3.0, 6.0, 7.0, 3.0, 8.0, Double.NaN, 1.0, 2.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesFirst);
        correctRanks = new double[]{1.0, 2.0, 4.0, 3.0, 5.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.tiesLast);
        correctRanks = new double[]{3.0, 3.0, 2.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleNaNs);
        correctRanks = new double[]{1.0, 2.0, Double.NaN, Double.NaN};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.multipleTies);
        correctRanks = new double[]{3.0, 2.0, 4.0, 4.0, 6.0, 7.0, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranks = ranking.rank(this.allSame);
        correctRanks = new double[]{2.0, 3.0, 3.0, 3.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test
    public void testNaNsAndInfs() {
        double[] data = new double[]{0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.MAXIMAL);
        double[] ranks = ranking.rank(data);
        double[] correctRanks = new double[]{2.0, 3.5, 3.5, 1.0};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
        ranking = new NaturalRanking(NaNStrategy.MINIMAL);
        ranks = ranking.rank(data);
        correctRanks = new double[]{3.0, 4.0, 1.5, 1.5};
        TestUtils.assertEquals(correctRanks, ranks, 0.0);
    }

    @Test(expected=NotANumberException.class)
    public void testNaNsFailed() {
        double[] data = new double[]{0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FAILED);
        ranking.rank(data);
    }

    @Test
    public void testNoNaNsFailed() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0};
        NaturalRanking ranking = new NaturalRanking(NaNStrategy.FAILED);
        double[] ranks = ranking.rank(data);
        TestUtils.assertEquals(data, ranks, 0.0);
    }
}

