/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ListPopulation;
import org.apache.commons.math3.genetics.Population;
import org.junit.Assert;
import org.junit.Test;

public class ChromosomeTest {
    @Test
    public void testCompareTo() {
        Chromosome c1 = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        Chromosome c2 = new Chromosome(){

            public double fitness() {
                return 10.0;
            }
        };
        Chromosome c3 = new Chromosome(){

            public double fitness() {
                return 10.0;
            }
        };
        Assert.assertTrue((c1.compareTo(c2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((c2.compareTo(c1) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)c3.compareTo(c2));
        Assert.assertEquals((long)0L, (long)c2.compareTo(c3));
    }

    @Test
    public void testFindSameChromosome() {
        DummyChromosome c1 = new DummyChromosome(1){

            public double fitness() {
                return 1.0;
            }
        };
        DummyChromosome c2 = new DummyChromosome(2){

            public double fitness() {
                return 2.0;
            }
        };
        DummyChromosome c3 = new DummyChromosome(3){

            public double fitness() {
                return 3.0;
            }
        };
        DummyChromosome c4 = new DummyChromosome(1){

            public double fitness() {
                return 5.0;
            }
        };
        DummyChromosome c5 = new DummyChromosome(15){

            public double fitness() {
                return 15.0;
            }
        };
        ArrayList<DummyChromosome> popChr = new ArrayList<DummyChromosome>();
        popChr.add(c1);
        popChr.add(c2);
        popChr.add(c3);
        ListPopulation pop = new ListPopulation(popChr, 3){

            public Population nextGeneration() {
                return null;
            }
        };
        Assert.assertNull((Object)c5.findSameChromosome((Population)pop));
        Assert.assertEquals((Object)((Object)c1), (Object)c4.findSameChromosome((Population)pop));
        c4.searchForFitnessUpdate((Population)pop);
        Assert.assertEquals((double)1.0, (double)c4.getFitness(), (double)0.0);
    }

    private static abstract class DummyChromosome
    extends Chromosome {
        private final int repr;

        public DummyChromosome(int repr) {
            this.repr = repr;
        }

        protected boolean isSame(Chromosome another) {
            return ((DummyChromosome)another).repr == this.repr;
        }
    }
}

