CREATE PROCEDURE cayenne_tst_select_proc @aName VARCHAR(255), @paintingPrice INT AS 
BEGIN 
	BEGIN TRANSACTION
	UPDATE PAINTING SET ESTIMATED_PRICE = ESTIMATED_PRICE * 2
	WHERE ESTIMATED_PRICE < @paintingPrice 
	COMMIT 
	
	SELECT DISTINCT A.ARTIST_ID, A.ARTIST_NAME, A.DATE_OF_BIRTH
	FROM ARTIST A, PAINTING P 
	WHERE A.ARTIST_ID = P.ARTIST_ID AND
	A.ARTIST_NAME = @aName
	ORDER BY A.ARTIST_ID
END