package org.apache.cayenne.testdo.inheritance.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.inheritance.DirectToSubEntity;
import org.apache.cayenne.testdo.inheritance.RelatedEntity;

/**
 * Class _BaseEntity was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _BaseEntity extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final NumericProperty<Integer> BASE_ENTITY_ID_PK_PROPERTY = PropertyFactory.createNumeric(ExpressionFactory.dbPathExp("BASE_ENTITY_ID"), Integer.class);
    public static final String BASE_ENTITY_ID_PK_COLUMN = "BASE_ENTITY_ID";

    public static final StringProperty<String> ENTITY_TYPE = PropertyFactory.createString("entityType", String.class);
    public static final EntityProperty<DirectToSubEntity> TO_DIRECT_TO_SUB_ENTITY = PropertyFactory.createEntity("toDirectToSubEntity", DirectToSubEntity.class);
    public static final EntityProperty<RelatedEntity> TO_RELATED_ENTITY = PropertyFactory.createEntity("toRelatedEntity", RelatedEntity.class);

    protected String entityType;

    protected Object toDirectToSubEntity;
    protected Object toRelatedEntity;

    public void setEntityType(String entityType) {
        beforePropertyWrite("entityType", this.entityType, entityType);
        this.entityType = entityType;
    }

    public String getEntityType() {
        beforePropertyRead("entityType");
        return this.entityType;
    }

    public void setToDirectToSubEntity(DirectToSubEntity toDirectToSubEntity) {
        setToOneTarget("toDirectToSubEntity", toDirectToSubEntity, true);
    }

    public DirectToSubEntity getToDirectToSubEntity() {
        return (DirectToSubEntity)readProperty("toDirectToSubEntity");
    }

    public void setToRelatedEntity(RelatedEntity toRelatedEntity) {
        setToOneTarget("toRelatedEntity", toRelatedEntity, true);
    }

    public RelatedEntity getToRelatedEntity() {
        return (RelatedEntity)readProperty("toRelatedEntity");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "entityType":
                return this.entityType;
            case "toDirectToSubEntity":
                return this.toDirectToSubEntity;
            case "toRelatedEntity":
                return this.toRelatedEntity;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "entityType":
                this.entityType = (String)val;
                break;
            case "toDirectToSubEntity":
                this.toDirectToSubEntity = val;
                break;
            case "toRelatedEntity":
                this.toRelatedEntity = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.entityType);
        out.writeObject(this.toDirectToSubEntity);
        out.writeObject(this.toRelatedEntity);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.entityType = (String)in.readObject();
        this.toDirectToSubEntity = in.readObject();
        this.toRelatedEntity = in.readObject();
    }

}
