/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.twitter.common.base.Closure;
import com.twitter.common.base.Closures;
import com.twitter.common.base.ExceptionalSupplier;
import com.twitter.common.base.MorePreconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class StateMachine<T> {
    private static final Logger LOG = Logger.getLogger(StateMachine.class.getName());
    private final String name;
    private final Multimap<T, T> stateTransitions;
    private final Closure<Transition<T>> transitionCallback;
    private final boolean throwOnBadTransition;
    private volatile T currentState;
    private final Lock readLock;
    private final Lock writeLock;

    private StateMachine(String name, T initialState, Multimap<T, T> stateTransitions, Closure<Transition<T>> transitionCallback, boolean throwOnBadTransition) {
        this.name = name;
        this.currentState = initialState;
        this.stateTransitions = stateTransitions;
        this.transitionCallback = transitionCallback;
        this.throwOnBadTransition = throwOnBadTransition;
        ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock(true);
        this.readLock = stateLock.readLock();
        this.writeLock = stateLock.writeLock();
    }

    public String getName() {
        return this.name;
    }

    public T getState() {
        return this.currentState;
    }

    public void checkState(T expectedState) {
        this.checkState((Set<T>)ImmutableSet.of(expectedState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkState(Set<T> allowedStates) {
        Preconditions.checkNotNull(allowedStates);
        Preconditions.checkArgument((!allowedStates.isEmpty() ? 1 : 0) != 0, (Object)"At least one possible state must be provided.");
        this.readLock.lock();
        try {
            if (!allowedStates.contains(this.currentState)) {
                throw new IllegalStateException(String.format("In state %s, expected to be in %s.", this.currentState, allowedStates));
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O, E extends Exception> O doInState(T expectedState, ExceptionalSupplier<O, E> work) throws E {
        Preconditions.checkNotNull(expectedState);
        Preconditions.checkNotNull(work);
        this.readLock.lock();
        try {
            this.checkState(expectedState);
            Object object = work.get();
            return (O)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transition(T nextState) throws IllegalStateTransitionException {
        boolean transitionAllowed = false;
        T currentCopy = this.currentState;
        this.writeLock.lock();
        try {
            if (this.stateTransitions.containsEntry(this.currentState, nextState)) {
                this.currentState = nextState;
                transitionAllowed = true;
            } else if (this.throwOnBadTransition) {
                throw new IllegalStateTransitionException(String.format("State transition from %s to %s is not allowed.", this.currentState, nextState));
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.transitionCallback.execute(new Transition<T>(currentCopy, nextState, transitionAllowed));
        return transitionAllowed;
    }

    public static <T> Builder<T> builder(String name) {
        return new Builder(name);
    }

    public static class Transition<T> {
        private final T from;
        private final T to;
        private final boolean allowed;

        public Transition(T from, T to, boolean allowed) {
            this.from = Preconditions.checkNotNull(from);
            this.to = Preconditions.checkNotNull(to);
            this.allowed = allowed;
        }

        private static <T> Function<Transition<T>, T> from() {
            return new Function<Transition<T>, T>(){

                public T apply(Transition<T> transition) {
                    return transition.from;
                }
            };
        }

        private static <T> Function<Transition<T>, T> to() {
            return new Function<Transition<T>, T>(){

                public T apply(Transition<T> transition) {
                    return transition.to;
                }
            };
        }

        private static <T> Predicate<Transition<T>> oneSideFilter(Function<Transition<T>, T> extractor, T ... states) {
            Preconditions.checkArgument((boolean)Iterables.all(Arrays.asList(states), (Predicate)Predicates.notNull()));
            return Predicates.compose((Predicate)Predicates.in((Collection)ImmutableSet.copyOf((Object[])states)), extractor);
        }

        public static <T> Predicate<Transition<T>> from(T ... states) {
            return Transition.oneSideFilter(Transition.from(), states);
        }

        public static <T> Predicate<Transition<T>> to(T ... states) {
            return Transition.oneSideFilter(Transition.to(), states);
        }

        public static <T> Predicate<Transition<T>> transition(T from, T to) {
            Predicate<Transition<Object>> fromFilter = Transition.from(from);
            Predicate<Transition<Object>> toFilter = Transition.to(to);
            return Predicates.and(fromFilter, toFilter);
        }

        public T getFrom() {
            return this.from;
        }

        public T getTo() {
            return this.to;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public boolean isValidStateChange() {
            return this.isAllowed() && !this.from.equals(this.to);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Transition)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Transition other = (Transition)o;
            return this.from.equals(other.from) && this.to.equals(other.to);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.from).append(this.to).toHashCode();
        }

        public String toString() {
            String str = this.from.toString() + " -> " + this.to.toString();
            if (!this.isAllowed()) {
                str = str + " (not allowed)";
            }
            return str;
        }
    }

    public static class Builder<T> {
        private final String name;
        private T initialState;
        private final Multimap<T, T> stateTransitions = HashMultimap.create();
        private final List<Closure<Transition<T>>> transitionCallbacks = Lists.newArrayList();
        private boolean throwOnBadTransition = true;

        public Builder(String name) {
            this.name = MorePreconditions.checkNotBlank((String)name);
        }

        public Builder<T> initialState(T state) {
            Preconditions.checkNotNull(state);
            this.initialState = state;
            return this;
        }

        public Builder<T> addState(Rule<T> rule) {
            return this.addState(((Rule)rule).callback, ((Rule)rule).from, ((Rule)rule).to);
        }

        public Builder<T> addState(Closure<Transition<T>> callback, T state, Set<T> transitionStates) {
            Preconditions.checkNotNull(callback);
            Preconditions.checkNotNull(state);
            Preconditions.checkArgument((boolean)Iterables.all(transitionStates, (Predicate)Predicates.notNull()));
            this.stateTransitions.putAll(state, transitionStates);
            Predicate<Transition<Object>> filter = Transition.from(state);
            this.onTransition(filter, callback);
            return this;
        }

        public Builder<T> addState(Closure<Transition<T>> callback, T state, T ... transitionStates) {
            ImmutableSet states = ImmutableSet.copyOf((Object[])transitionStates);
            Preconditions.checkArgument((boolean)Iterables.all((Iterable)states, (Predicate)Predicates.notNull()));
            return this.addState(callback, state, (Set<T>)states);
        }

        public Builder<T> addState(T state, T ... transitionStates) {
            return this.addState(Closures.noop(), state, transitionStates);
        }

        private void onTransition(Predicate<Transition<T>> transitionFilter, Closure<Transition<T>> handler) {
            this.onAnyTransition(Closures.filter(transitionFilter, handler));
        }

        public Builder<T> onAnyTransition(Closure<Transition<T>> handler) {
            this.transitionCallbacks.add(handler);
            return this;
        }

        public Builder<T> logTransitions() {
            return this.onAnyTransition(new Closure<Transition<T>>(){

                public void execute(Transition<T> transition) {
                    LOG.info(Builder.this.name + " state machine transition " + transition);
                }
            });
        }

        public Builder<T> throwOnBadTransition(boolean throwOnBadTransition) {
            this.throwOnBadTransition = throwOnBadTransition;
            return this;
        }

        public StateMachine<T> build() {
            Preconditions.checkState((this.initialState != null ? 1 : 0) != 0, (Object)"Initial state must be specified.");
            Preconditions.checkArgument((!this.stateTransitions.isEmpty() ? 1 : 0) != 0, (Object)"No state transitions were specified.");
            return new StateMachine(this.name, this.initialState, this.stateTransitions, Closures.combine(this.transitionCallbacks), this.throwOnBadTransition);
        }
    }

    public static class Rule<T> {
        private final T from;
        private final Set<T> to;
        private final Closure<Transition<T>> callback;

        private Rule(T from) {
            this(from, (Set<T>)ImmutableSet.of());
        }

        private Rule(T from, Set<T> to) {
            this(from, to, Closures.noop());
        }

        private Rule(T from, Set<T> to, Closure<Transition<T>> callback) {
            this.from = Preconditions.checkNotNull(from);
            this.to = (Set)Preconditions.checkNotNull(to);
            this.callback = (Closure)Preconditions.checkNotNull(callback);
        }

        public Rule<T> withCallback(Closure<Transition<T>> callback) {
            return new Rule<T>(this.from, this.to, callback);
        }

        public static <T> AllowedTransition<T> from(T state) {
            return new AllowedTransition(new Rule<T>(state));
        }

        public static class AllowedTransition<T> {
            private final Rule<T> rule;

            private AllowedTransition(Rule<T> rule) {
                this.rule = rule;
            }

            public Rule<T> to(T state) {
                return new Rule(((Rule)this.rule).from, (Set)ImmutableSet.of(state), ((Rule)this.rule).callback);
            }

            public Rule<T> to(T state, T ... additionalStates) {
                return new Rule(((Rule)this.rule).from, (Set)ImmutableSet.copyOf((Collection)Lists.asList(state, (Object[])additionalStates)));
            }

            public Rule<T> noTransitions() {
                return this.rule;
            }
        }
    }

    public static class IllegalStateTransitionException
    extends IllegalStateException {
        public IllegalStateTransitionException(String msg) {
            super(msg);
        }
    }
}

