/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.streamset;

import com.google.common.base.Objects;

public class Partition {
    private final String stream;
    public final int id;

    public Partition(String stream, int id) {
        this.stream = stream;
        this.id = id;
    }

    public String getStream() {
        return this.stream;
    }

    public int getId() {
        return this.id;
    }

    public String getPaddedId() {
        return String.format("%06d", this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition partition = (Partition)o;
        return this.id == partition.id && Objects.equal((Object)this.stream, (Object)partition.stream);
    }

    public int hashCode() {
        int result = this.stream.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Partition(").append(this.stream).append(", ").append(this.id).append(")");
        return sb.toString();
    }
}

