/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.common.stats.BroadCastStatsLogger;
import org.apache.distributedlog.service.streamset.Partition;

public class StreamOpStats {
    private final StatsLogger baseStatsLogger;
    private final StatsLogger requestStatsLogger;
    private final StatsLogger recordsStatsLogger;
    private final StatsLogger requestDeniedStatsLogger;
    private final StatsLogger streamStatsLogger;

    public StreamOpStats(StatsLogger statsLogger, StatsLogger perStreamStatsLogger) {
        this.baseStatsLogger = statsLogger;
        this.requestStatsLogger = statsLogger.scope("request");
        this.recordsStatsLogger = statsLogger.scope("records");
        this.requestDeniedStatsLogger = statsLogger.scope("denied");
        this.streamStatsLogger = perStreamStatsLogger;
    }

    public StatsLogger baseStatsLogger(String opName) {
        return this.baseStatsLogger;
    }

    public Counter baseCounter(String opName) {
        return this.baseStatsLogger.getCounter(opName);
    }

    public StatsLogger baseScope(String opName) {
        return this.baseStatsLogger.scope(opName);
    }

    public OpStatsLogger requestLatencyStat(String opName) {
        return this.requestStatsLogger.getOpStatsLogger(opName);
    }

    public StatsLogger requestScope(String scopeName) {
        return this.requestStatsLogger.scope(scopeName);
    }

    public Counter scopedRequestCounter(String opName, String counterName) {
        return this.requestScope(opName).getCounter(counterName);
    }

    public Counter requestCounter(String counterName) {
        return this.requestStatsLogger.getCounter(counterName);
    }

    public Counter requestPendingCounter(String counterName) {
        return this.requestCounter(counterName);
    }

    public Counter requestDeniedCounter(String counterName) {
        return this.requestDeniedStatsLogger.getCounter(counterName);
    }

    public Counter recordsCounter(String counterName) {
        return this.recordsStatsLogger.getCounter(counterName);
    }

    public StatsLogger streamRequestStatsLogger(Partition partition) {
        return BroadCastStatsLogger.masterslave((StatsLogger)this.streamStatsLogger.scope(partition.getStream()).scope("partition").scope(partition.getPaddedId()), (StatsLogger)this.streamStatsLogger.scope(partition.getStream()).scope("aggregate"));
    }

    public StatsLogger streamRequestScope(Partition partition, String scopeName) {
        return this.streamRequestStatsLogger(partition).scope(scopeName);
    }

    public OpStatsLogger streamRequestLatencyStat(Partition partition, String opName) {
        return this.streamRequestStatsLogger(partition).getOpStatsLogger(opName);
    }

    public Counter streamRequestCounter(Partition partition, String opName, String counterName) {
        return this.streamRequestScope(partition, opName).getCounter(counterName);
    }
}

