/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.lock;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.lock.DistributedLockContext;
import org.apache.distributedlog.lock.SessionLock;
import org.apache.distributedlog.lock.SessionLockFactory;
import org.apache.distributedlog.lock.ZKSessionLock;
import org.apache.distributedlog.util.OrderedScheduler;

public class ZKSessionLockFactory
implements SessionLockFactory {
    private final ZooKeeperClient zkc;
    private final String clientId;
    private final OrderedScheduler lockStateExecutor;
    private final long lockOpTimeout;
    private final int lockCreationRetries;
    private final long zkRetryBackoffMs;
    private final StatsLogger lockStatsLogger;

    public ZKSessionLockFactory(ZooKeeperClient zkc, String clientId, OrderedScheduler lockStateExecutor, int lockCreationRetries, long lockOpTimeout, long zkRetryBackoffMs, StatsLogger statsLogger) {
        this.zkc = zkc;
        this.clientId = clientId;
        this.lockStateExecutor = lockStateExecutor;
        this.lockCreationRetries = lockCreationRetries;
        this.lockOpTimeout = lockOpTimeout;
        this.zkRetryBackoffMs = zkRetryBackoffMs;
        this.lockStatsLogger = statsLogger.scope("lock");
    }

    @Override
    public CompletableFuture<SessionLock> createLock(String lockPath, DistributedLockContext context) {
        AtomicInteger numRetries = new AtomicInteger(this.lockCreationRetries);
        AtomicReference<Object> interruptedException = new AtomicReference<Object>(null);
        CompletableFuture createPromise = FutureUtils.createFuture();
        createPromise.whenComplete((value, cause) -> {
            if (null != cause && cause instanceof CancellationException) {
                interruptedException.set(cause);
            }
        });
        this.createLock(lockPath, context, interruptedException, numRetries, createPromise, 0L);
        return createPromise;
    }

    void createLock(final String lockPath, final DistributedLockContext context, final AtomicReference<Throwable> interruptedException, final AtomicInteger numRetries, final CompletableFuture<SessionLock> createPromise, long delayMs) {
        this.lockStateExecutor.schedule((Object)lockPath, new Runnable(){

            @Override
            public void run() {
                if (null != interruptedException.get()) {
                    createPromise.completeExceptionally((Throwable)interruptedException.get());
                    return;
                }
                try {
                    ZKSessionLock lock = new ZKSessionLock(ZKSessionLockFactory.this.zkc, lockPath, ZKSessionLockFactory.this.clientId, ZKSessionLockFactory.this.lockStateExecutor, ZKSessionLockFactory.this.lockOpTimeout, ZKSessionLockFactory.this.lockStatsLogger, context);
                    createPromise.complete(lock);
                }
                catch (DLInterruptedException dlie) {
                    createPromise.completeExceptionally(dlie);
                    return;
                }
                catch (IOException e) {
                    if (numRetries.getAndDecrement() < 0) {
                        createPromise.completeExceptionally(e);
                        return;
                    }
                    ZKSessionLockFactory.this.createLock(lockPath, context, interruptedException, numRetries, createPromise, ZKSessionLockFactory.this.zkRetryBackoffMs);
                }
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }
}

