/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.openjdk.source.tree.ArrayTypeTree;
import org.openjdk.source.tree.AssignmentTree;
import org.openjdk.source.tree.ClassTree;
import org.openjdk.source.tree.ExpressionTree;
import org.openjdk.source.tree.IdentifierTree;
import org.openjdk.source.tree.MethodTree;
import org.openjdk.source.tree.ModifiersTree;
import org.openjdk.source.tree.Tree;
import org.openjdk.source.tree.VariableTree;
import org.openjdk.tools.internal.jshell.remote.RemoteCodes;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.Pretty;
import org.openjdk.tools.jshell.ClassTracker;
import org.openjdk.tools.jshell.Corraller;
import org.openjdk.tools.jshell.Diag;
import org.openjdk.tools.jshell.DiagList;
import org.openjdk.tools.jshell.ErroneousSnippet;
import org.openjdk.tools.jshell.EvalException;
import org.openjdk.tools.jshell.ExpressionSnippet;
import org.openjdk.tools.jshell.ImportSnippet;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.Key;
import org.openjdk.tools.jshell.MaskCommentsAndModifiers;
import org.openjdk.tools.jshell.MethodSnippet;
import org.openjdk.tools.jshell.OuterWrap;
import org.openjdk.tools.jshell.Snippet;
import org.openjdk.tools.jshell.SnippetEvent;
import org.openjdk.tools.jshell.StatementSnippet;
import org.openjdk.tools.jshell.TaskFactory;
import org.openjdk.tools.jshell.TreeDependencyScanner;
import org.openjdk.tools.jshell.TreeDissector;
import org.openjdk.tools.jshell.TypeDeclSnippet;
import org.openjdk.tools.jshell.Unit;
import org.openjdk.tools.jshell.UnresolvedReferenceException;
import org.openjdk.tools.jshell.Util;
import org.openjdk.tools.jshell.VarSnippet;
import org.openjdk.tools.jshell.Wrap;

class Eval {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\p{javaWhitespace}+(?<static>static\\p{javaWhitespace}+)?(?<fullname>[\\p{L}\\p{N}_\\$\\.]+\\.(?<name>[\\p{L}\\p{N}_\\$]+|\\*))");
    private int varNumber = 0;
    private final JShell state;

    Eval(JShell state) {
        this.state = state;
    }

    List<SnippetEvent> eval(String userSource) throws IllegalStateException {
        String compileSource = Util.trimEnd(new MaskCommentsAndModifiers(userSource, false).cleared());
        if (compileSource.length() == 0) {
            return Collections.emptyList();
        }
        TaskFactory taskFactory = this.state.taskFactory;
        taskFactory.getClass();
        TaskFactory.ParseTask pt = taskFactory.new TaskFactory.ParseTask(compileSource);
        if (pt.getDiagnostics().hasOtherThanNotStatementErrors()) {
            return this.compileFailResult(pt, userSource);
        }
        List<? extends Tree> units = pt.units();
        if (units.isEmpty()) {
            return this.compileFailResult(pt, userSource);
        }
        compileSource = new MaskCommentsAndModifiers(compileSource, true).cleared();
        Tree unitTree = units.get(0);
        this.state.debug(1, "Kind: %s -- %s\n", new Object[]{unitTree.getKind(), unitTree});
        switch (unitTree.getKind()) {
            case IMPORT: {
                return this.processImport(userSource, compileSource);
            }
            case VARIABLE: {
                return this.processVariables(userSource, units, compileSource, pt);
            }
            case EXPRESSION_STATEMENT: {
                return this.processExpression(userSource, compileSource);
            }
            case CLASS: {
                return this.processClass(userSource, unitTree, compileSource, Snippet.SubKind.CLASS_SUBKIND, pt);
            }
            case ENUM: {
                return this.processClass(userSource, unitTree, compileSource, Snippet.SubKind.ENUM_SUBKIND, pt);
            }
            case ANNOTATION_TYPE: {
                return this.processClass(userSource, unitTree, compileSource, Snippet.SubKind.ANNOTATION_TYPE_SUBKIND, pt);
            }
            case INTERFACE: {
                return this.processClass(userSource, unitTree, compileSource, Snippet.SubKind.INTERFACE_SUBKIND, pt);
            }
            case METHOD: {
                return this.processMethod(userSource, unitTree, compileSource, pt);
            }
        }
        return this.processStatement(userSource, compileSource);
    }

    private List<SnippetEvent> processImport(String userSource, String compileSource) {
        String keyName;
        String fullname;
        String name;
        boolean isStatic;
        Wrap guts = Wrap.importWrap(compileSource);
        Matcher mat = IMPORT_PATTERN.matcher(compileSource);
        if (mat.find()) {
            isStatic = mat.group("static") != null;
            name = mat.group("name");
            fullname = mat.group("fullname");
        } else {
            isStatic = compileSource.contains("static");
            name = fullname = compileSource;
        }
        String fullkey = (isStatic ? "static-" : "") + fullname;
        boolean isStar = name.equals("*");
        String string = keyName = isStar ? fullname : name;
        Snippet.SubKind snippetKind = isStar ? (isStatic ? Snippet.SubKind.STATIC_IMPORT_ON_DEMAND_SUBKIND : Snippet.SubKind.TYPE_IMPORT_ON_DEMAND_SUBKIND) : (isStatic ? Snippet.SubKind.SINGLE_STATIC_IMPORT_SUBKIND : Snippet.SubKind.SINGLE_TYPE_IMPORT_SUBKIND);
        ImportSnippet snip = new ImportSnippet(this.state.keyMap.keyForImport(keyName, snippetKind), userSource, guts, fullname, name, snippetKind, fullkey, isStatic, isStar);
        return this.declare(snip);
    }

    private List<SnippetEvent> processVariables(String userSource, List<? extends Tree> units, String compileSource, TaskFactory.ParseTask pt) {
        ArrayList<SnippetEvent> allEvents = new ArrayList<SnippetEvent>();
        TreeDissector dis = TreeDissector.createByFirstClass(pt);
        for (Tree tree : units) {
            Snippet.SubKind subkind;
            VariableTree vt = (VariableTree)tree;
            String name = vt.getName().toString();
            String typeName = EvalPretty.prettyExpr((JCTree)vt.getType(), false);
            Tree baseType = vt.getType();
            TreeDependencyScanner tds = new TreeDependencyScanner();
            tds.scan(baseType);
            StringBuilder sbBrackets = new StringBuilder();
            while (baseType instanceof ArrayTypeTree) {
                baseType = ((ArrayTypeTree)baseType).getType();
                sbBrackets.append("[]");
            }
            Wrap.Range rtype = dis.treeToRange(baseType);
            Wrap.Range runit = dis.treeToRange(vt);
            runit = new Wrap.Range(runit.begin, runit.end - 1);
            ExpressionTree it = vt.getInitializer();
            Wrap.Range rinit = null;
            int nameMax = runit.end - 1;
            if (it != null) {
                subkind = Snippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND;
                rinit = dis.treeToRange(it);
                nameMax = rinit.begin - 1;
            } else {
                subkind = Snippet.SubKind.VAR_DECLARATION_SUBKIND;
            }
            int nameStart = compileSource.lastIndexOf(name, nameMax);
            if (nameStart < 0) {
                throw new AssertionError((Object)("Name '" + name + "' not found"));
            }
            int nameEnd = nameStart + name.length();
            Wrap.Range rname = new Wrap.Range(nameStart, nameEnd);
            Wrap guts = Wrap.varWrap(compileSource, rtype, sbBrackets.toString(), rname, rinit);
            VarSnippet snip = new VarSnippet(this.state.keyMap.keyForVariable(name), userSource, guts, name, subkind, typeName, tds.declareReferences());
            DiagList modDiag = this.modifierDiagnostics(vt.getModifiers(), dis, true);
            List<SnippetEvent> res1 = this.declare(snip, modDiag);
            allEvents.addAll(res1);
        }
        return allEvents;
    }

    private List<SnippetEvent> processExpression(String userSource, String compileSource) {
        Snippet snip;
        String name = null;
        TreeDissector.ExpressionInfo ei = this.typeOfExpression(compileSource);
        if (ei != null && ei.isNonVoid) {
            ExpressionTree assignVar;
            Snippet.SubKind subkind;
            String typeName = ei.typeName;
            if (ei.tree instanceof IdentifierTree) {
                IdentifierTree id = (IdentifierTree)ei.tree;
                name = id.getName().toString();
                subkind = Snippet.SubKind.VAR_VALUE_SUBKIND;
            } else if (ei.tree instanceof AssignmentTree && (assignVar = ((AssignmentTree)ei.tree).getVariable()) instanceof IdentifierTree) {
                name = assignVar.toString();
                subkind = Snippet.SubKind.ASSIGNMENT_SUBKIND;
            } else {
                subkind = Snippet.SubKind.OTHER_EXPRESSION_SUBKIND;
            }
            if (this.shouldGenTempVar(subkind)) {
                if (this.state.tempVariableNameGenerator != null) {
                    name = this.state.tempVariableNameGenerator.get();
                }
                while (name == null || this.state.keyMap.doesVariableNameExist(name)) {
                    name = "$" + ++this.varNumber;
                }
                Wrap guts = Wrap.tempVarWrap(compileSource, typeName, name);
                Collection<String> declareReferences = null;
                snip = new VarSnippet(this.state.keyMap.keyForVariable(name), userSource, guts, name, Snippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND, typeName, declareReferences);
            } else {
                Wrap guts = Wrap.methodReturnWrap(compileSource);
                snip = new ExpressionSnippet(this.state.keyMap.keyForExpression(name, typeName), userSource, guts, name, subkind);
            }
        } else {
            Wrap guts = Wrap.methodWrap(compileSource);
            if (ei == null) {
                TaskFactory.AnalyzeTask at = this.trialCompile(guts);
                if (at.getDiagnostics().hasNotStatement()) {
                    guts = Wrap.methodReturnWrap(compileSource);
                    at = this.trialCompile(guts);
                }
                if (at.hasErrors()) {
                    return this.compileFailResult(at, userSource);
                }
            }
            snip = new StatementSnippet(this.state.keyMap.keyForStatement(), userSource, guts);
        }
        return this.declare(snip);
    }

    private List<SnippetEvent> processClass(String userSource, Tree unitTree, String compileSource, Snippet.SubKind snippetKind, TaskFactory.ParseTask pt) {
        TreeDependencyScanner tds = new TreeDependencyScanner();
        tds.scan(unitTree);
        TreeDissector dis = TreeDissector.createByFirstClass(pt);
        ClassTree klassTree = (ClassTree)unitTree;
        String name = klassTree.getSimpleName().toString();
        Wrap guts = Wrap.classMemberWrap(compileSource);
        Key.TypeDeclKey key = this.state.keyMap.keyForClass(name);
        Wrap corralled = new Corraller(key.index(), compileSource, dis).corralType(klassTree, 1);
        TypeDeclSnippet snip = new TypeDeclSnippet(this.state.keyMap.keyForClass(name), userSource, guts, name, snippetKind, corralled, tds.declareReferences(), tds.bodyReferences());
        DiagList modDiag = this.modifierDiagnostics(klassTree.getModifiers(), dis, false);
        return this.declare(snip, modDiag);
    }

    private List<SnippetEvent> processStatement(String userSource, String compileSource) {
        Wrap guts = Wrap.methodWrap(compileSource);
        TaskFactory.AnalyzeTask at = this.trialCompile(guts);
        if (at.hasErrors()) {
            if (at.getDiagnostics().hasUnreachableError()) {
                guts = Wrap.methodUnreachableSemiWrap(compileSource);
                at = this.trialCompile(guts);
                if (at.hasErrors()) {
                    if (at.getDiagnostics().hasUnreachableError()) {
                        guts = Wrap.methodUnreachableWrap(compileSource);
                        at = this.trialCompile(guts);
                    }
                    if (at.hasErrors()) {
                        return this.compileFailResult(at, userSource);
                    }
                }
            } else {
                return this.compileFailResult(at, userSource);
            }
        }
        StatementSnippet snip = new StatementSnippet(this.state.keyMap.keyForStatement(), userSource, guts);
        return this.declare(snip);
    }

    private OuterWrap wrapInClass(String className, Set<Key> except, String userSource, Wrap guts, Collection<Snippet> plus) {
        String imports = this.state.maps.packageAndImportsExcept(except, plus);
        return OuterWrap.wrapInClass(this.state.maps.packageName(), className, imports, userSource, guts);
    }

    OuterWrap wrapInClass(Snippet snip, Set<Key> except, Wrap guts, Collection<Snippet> plus) {
        return this.wrapInClass(snip.className(), except, snip.source(), guts, plus);
    }

    private TaskFactory.AnalyzeTask trialCompile(Wrap guts) {
        OuterWrap outer = this.wrapInClass("$REPL00DOESNOTMATTER", Collections.emptySet(), "", guts, null);
        TaskFactory taskFactory = this.state.taskFactory;
        taskFactory.getClass();
        return taskFactory.new TaskFactory.AnalyzeTask(outer);
    }

    private List<SnippetEvent> processMethod(String userSource, Tree unitTree, String compileSource, TaskFactory.ParseTask pt) {
        TreeDependencyScanner tds = new TreeDependencyScanner();
        tds.scan(unitTree);
        MethodTree mt = (MethodTree)unitTree;
        TreeDissector dis = TreeDissector.createByFirstClass(pt);
        DiagList modDiag = this.modifierDiagnostics(mt.getModifiers(), dis, true);
        if (modDiag.hasErrors()) {
            return this.compileFailResult(modDiag, userSource);
        }
        String unitName = mt.getName().toString();
        Wrap guts = Wrap.classMemberWrap(compileSource);
        Wrap.Range typeRange = dis.treeToRange(mt.getReturnType());
        String name = mt.getName().toString();
        String parameterTypes = mt.getParameters().stream().map(param -> dis.treeToRange(param.getType()).part(compileSource)).collect(Collectors.joining(","));
        String signature = "(" + parameterTypes + ")" + typeRange.part(compileSource);
        Key.MethodKey key = this.state.keyMap.keyForMethod(name, parameterTypes);
        Wrap corralled = new Corraller(key.index(), compileSource, dis).corralMethod(mt);
        MethodSnippet snip = new MethodSnippet(key, userSource, guts, unitName, signature, corralled, tds.declareReferences(), tds.bodyReferences());
        return this.declare(snip, modDiag);
    }

    private List<SnippetEvent> compileFailResult(TaskFactory.BaseTask xt, String userSource) {
        return this.compileFailResult(xt.getDiagnostics(), userSource);
    }

    private List<SnippetEvent> compileFailResult(DiagList diags, String userSource) {
        Key.ErroneousKey key = this.state.keyMap.keyForErroneous();
        ErroneousSnippet snip = new ErroneousSnippet(key, userSource, null, Snippet.SubKind.UNKNOWN_SUBKIND);
        snip.setFailed(diags);
        this.state.maps.installSnippet(snip);
        return Collections.singletonList(new SnippetEvent(snip, Snippet.Status.NONEXISTENT, Snippet.Status.REJECTED, false, null, null, null));
    }

    private TreeDissector.ExpressionInfo typeOfExpression(String expression) {
        Wrap guts = Wrap.methodReturnWrap(expression);
        TaskFactory.AnalyzeTask at = this.trialCompile(guts);
        if (!at.hasErrors() && at.firstCuTree() != null) {
            return TreeDissector.createByFirstClass(at).typeOfReturnStatement(at, this.state);
        }
        return null;
    }

    private boolean shouldGenTempVar(Snippet.SubKind snippetKind) {
        return snippetKind == Snippet.SubKind.OTHER_EXPRESSION_SUBKIND;
    }

    List<SnippetEvent> drop(Snippet si) {
        Unit c = new Unit(this.state, si);
        Set<Unit> ins = c.dependents().collect(Collectors.toSet());
        Set<Unit> outs = this.compileAndLoad(ins);
        return this.events(c, outs, null, null);
    }

    private List<SnippetEvent> declare(Snippet si) {
        return this.declare(si, new DiagList());
    }

    private List<SnippetEvent> declare(Snippet si, DiagList generatedDiagnostics) {
        Unit c = new Unit(this.state, si, null, generatedDiagnostics);
        if (c.isRedundant()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Unit> ins = new LinkedHashSet<Unit>();
        ins.add(c);
        Set<Unit> outs = this.compileAndLoad(ins);
        if (!si.status().isDefined && si.diagnostics().isEmpty() && si.unresolved().isEmpty()) {
            si.setDiagnostics(outs.stream().flatMap(u -> u.snippet().diagnostics().stream()).collect(Collectors.toCollection(DiagList::new)));
        }
        String value = null;
        Exception exception = null;
        if (si.isExecutable() && si.status().isDefined) {
            try {
                value = this.state.executionControl().commandInvoke(this.state.maps.classFullName(si));
                value = si.subKind().hasValue() ? Util.expunge(value) : "";
            }
            catch (EvalException ex) {
                exception = this.translateExecutionException(ex);
            }
            catch (UnresolvedReferenceException ex) {
                exception = ex;
            }
        }
        return this.events(c, outs, value, exception);
    }

    private List<SnippetEvent> events(Unit c, Collection<Unit> outs, String value, Exception exception) {
        ArrayList<SnippetEvent> events = new ArrayList<SnippetEvent>();
        events.add(c.event(value, exception));
        events.addAll(outs.stream().filter(u -> u != c).map(u -> u.event(null, null)).collect(Collectors.toList()));
        events.addAll(outs.stream().flatMap(u -> u.secondaryEvents().stream()).collect(Collectors.toList()));
        return events;
    }

    private Set<Unit> compileAndLoad(Set<Unit> ins) {
        boolean success;
        List newDependencies;
        if (ins.isEmpty()) {
            return ins;
        }
        LinkedHashSet replaced = new LinkedHashSet();
        do {
            block7: {
                TaskFactory.CompileTask ct2;
                List<Unit> legit;
                block8: {
                    TaskFactory.AnalyzeTask cat;
                    this.state.debug(1, "compileAndLoad  %s\n", ins);
                    ins.stream().forEach(u -> u.initialize(ins));
                    TaskFactory taskFactory = this.state.taskFactory;
                    taskFactory.getClass();
                    TaskFactory.AnalyzeTask at = taskFactory.new TaskFactory.AnalyzeTask(ins);
                    ins.stream().forEach(u -> u.setDiagnostics(at));
                    if (ins.stream().anyMatch(u -> u.corralIfNeeded(ins))) {
                        TaskFactory taskFactory2 = this.state.taskFactory;
                        taskFactory2.getClass();
                        cat = taskFactory2.new TaskFactory.AnalyzeTask(ins);
                        ins.stream().forEach(u -> u.setCorralledDiagnostics(cat));
                    } else {
                        cat = at;
                    }
                    ins.stream().forEach(u -> u.setStatus(cat));
                    do {
                        legit = ins.stream().filter(u -> u.isDefined()).collect(Collectors.toList());
                        this.state.debug(1, "compileAndLoad ins = %s -- legit = %s\n", ins, legit);
                        if (legit.isEmpty()) {
                            success = true;
                            break block7;
                        }
                        legit.stream().forEach(u -> u.setWrap(ins, legit));
                        TaskFactory taskFactory3 = this.state.taskFactory;
                        taskFactory3.getClass();
                        ct2 = taskFactory3.new TaskFactory.CompileTask(legit);
                        if (ct2.compile()) break block8;
                    } while (legit.stream().filter(u -> u.smashingErrorDiagnostics(ct2)).count() > 0L);
                    this.state.debug(1, "Should never happen error-less failure - %s\n", legit);
                }
                this.load(legit.stream().flatMap(u -> u.classesToLoad(ct2.classInfoList((Unit)u))).collect(Collectors.toList()));
                List toReplace = legit.stream().filter(u -> !u.doRedefines()).collect(Collectors.toList());
                if (!toReplace.isEmpty()) {
                    replaced.addAll(toReplace);
                    replaced.stream().forEach(u -> u.markForReplacement());
                }
                success = toReplace.isEmpty();
            }
            newDependencies = ins.stream().flatMap(u -> u.effectedDependents()).collect(Collectors.toList());
            this.state.debug(1, "compileAndLoad %s -- deps: %s  success: %s\n", ins, newDependencies, success);
        } while (ins.addAll(newDependencies) || !success);
        ins.stream().forEach(u -> u.finish());
        return ins;
    }

    private void load(List<ClassTracker.ClassInfo> cil) {
        if (!cil.isEmpty()) {
            this.state.executionControl().commandLoad(cil);
        }
    }

    private EvalException translateExecutionException(EvalException ex) {
        StackTraceElement[] raw = ex.getStackTrace();
        int last = raw.length;
        do {
            if (last != 0) continue;
            last = raw.length - 1;
            break;
        } while (!this.isWrap(raw[--last]));
        StackTraceElement[] elems = new StackTraceElement[last + 1];
        for (int i = 0; i <= last; ++i) {
            String num;
            StackTraceElement r = raw[i];
            String rawKlass = r.getClassName();
            Matcher matcher = RemoteCodes.prefixPattern.matcher(rawKlass);
            if (matcher.find() && (num = matcher.group("num")) != null) {
                int end = matcher.end();
                if (rawKlass.charAt(end - 1) == '$') {
                    --end;
                }
                int id = Integer.parseInt(num);
                Snippet si = this.state.maps.getSnippet(id);
                String klass = Util.expunge(rawKlass);
                String method = r.getMethodName().equals("do_it$") ? "" : r.getMethodName();
                String file = "#" + id;
                int line = si.outerWrap().wrapLineToSnippetLine(r.getLineNumber() - 1) + 1;
                elems[i] = new StackTraceElement(klass, method, file, line);
                continue;
            }
            elems[i] = r.getFileName().equals("<none>") ? new StackTraceElement(r.getClassName(), r.getMethodName(), null, r.getLineNumber()) : r;
        }
        String msg = ex.getMessage();
        if (msg.equals("<none>")) {
            msg = null;
        }
        return new EvalException(msg, ex.getExceptionClassName(), elems);
    }

    private boolean isWrap(StackTraceElement ste) {
        return RemoteCodes.prefixPattern.matcher(ste.getClassName()).find();
    }

    private DiagList modifierDiagnostics(final ModifiersTree modtree, final TreeDissector dis, boolean isAbstractProhibited) {
        ArrayList<Modifier> list = new ArrayList<Modifier>();
        boolean fatal = false;
        for (Modifier mod : modtree.getFlags()) {
            switch (mod) {
                case SYNCHRONIZED: 
                case NATIVE: {
                    list.add(mod);
                    fatal = true;
                    break;
                }
                case ABSTRACT: {
                    if (!isAbstractProhibited) break;
                    list.add(mod);
                    fatal = true;
                    break;
                }
                case PUBLIC: 
                case PROTECTED: 
                case PRIVATE: 
                case STATIC: 
                case FINAL: {
                    list.add(mod);
                }
            }
        }
        class ModifierDiagnostic
        extends Diag {
            final boolean fatal;
            final String message;

            ModifierDiagnostic(List<Modifier> list, boolean fatal) {
                this.fatal = fatal;
                StringBuilder sb = new StringBuilder();
                sb.append(list.size() > 1 ? "Modifiers " : "Modifier ");
                for (Modifier mod : list) {
                    sb.append("'");
                    sb.append(mod.toString());
                    sb.append("' ");
                }
                sb.append("not permitted in top-level declarations");
                if (!fatal) {
                    sb.append(", ignored");
                }
                this.message = sb.toString();
            }

            @Override
            public boolean isError() {
                return this.fatal;
            }

            @Override
            public long getPosition() {
                return dis.getStartPosition(modtree);
            }

            @Override
            public long getStartPosition() {
                return dis.getStartPosition(modtree);
            }

            @Override
            public long getEndPosition() {
                return dis.getEndPosition(modtree);
            }

            @Override
            public String getCode() {
                return this.fatal ? "org.openjdk.tools.eval.error.illegal.modifiers" : "org.openjdk.tools.eval.warn.illegal.modifiers";
            }

            @Override
            public String getMessage(Locale locale) {
                return this.message;
            }

            @Override
            Unit unitOrNull() {
                return null;
            }
        }
        return list.isEmpty() ? new DiagList() : new DiagList(new ModifierDiagnostic(list, fatal));
    }

    private static class EvalPretty
    extends Pretty {
        private final Writer out;

        public EvalPretty(Writer writer, boolean bln) {
            super(writer, bln);
            this.out = writer;
        }

        @Override
        public void print(Object o) throws IOException {
            this.out.write(o.toString());
        }

        static String prettyExpr(JCTree tree, boolean bln) {
            StringWriter out = new StringWriter();
            try {
                new EvalPretty(out, bln).printExpr(tree);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return out.toString();
        }
    }
}

