/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.doclet.DocletEnvironment;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class ClassTree {
    private final SortedSet<TypeElement> baseClasses;
    private final Map<TypeElement, SortedSet<TypeElement>> subClasses = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final SortedSet<TypeElement> baseInterfaces;
    private final Map<TypeElement, SortedSet<TypeElement>> subInterfaces = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final SortedSet<TypeElement> baseEnums;
    private final Map<TypeElement, SortedSet<TypeElement>> subEnums = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final SortedSet<TypeElement> baseAnnotationTypes;
    private final Map<TypeElement, SortedSet<TypeElement>> subAnnotationTypes = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final Map<TypeElement, SortedSet<TypeElement>> implementingClasses = new HashMap<TypeElement, SortedSet<TypeElement>>();
    private final Configuration configuration;
    private final Utils utils;
    private final Comparator<Element> comparator;

    public ClassTree(Configuration configuration, boolean noDeprecated) {
        configuration.message.notice("doclet.Building_Tree", new Object[0]);
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeClassUseComparator();
        this.baseAnnotationTypes = new TreeSet<Element>(this.comparator);
        this.baseEnums = new TreeSet<Element>(this.comparator);
        this.baseClasses = new TreeSet<Element>(this.comparator);
        this.baseInterfaces = new TreeSet<Element>(this.comparator);
        this.buildTree(configuration.root.getIncludedClasses());
    }

    public ClassTree(DocletEnvironment root, Configuration configuration) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeClassUseComparator();
        this.baseAnnotationTypes = new TreeSet<Element>(this.comparator);
        this.baseEnums = new TreeSet<Element>(this.comparator);
        this.baseClasses = new TreeSet<Element>(this.comparator);
        this.baseInterfaces = new TreeSet<Element>(this.comparator);
        this.buildTree(configuration.root.getIncludedClasses());
    }

    public ClassTree(SortedSet<TypeElement> classesSet, Configuration configuration) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeClassUseComparator();
        this.baseAnnotationTypes = new TreeSet<Element>(this.comparator);
        this.baseEnums = new TreeSet<Element>(this.comparator);
        this.baseClasses = new TreeSet<Element>(this.comparator);
        this.baseInterfaces = new TreeSet<Element>(this.comparator);
        this.buildTree(classesSet);
    }

    private void buildTree(Iterable<TypeElement> classes) {
        for (TypeElement aClass : classes) {
            if (this.configuration.nodeprecated && (this.utils.isDeprecated(aClass) || this.utils.isDeprecated(this.utils.containingPackage(aClass))) || this.configuration.javafx && !this.utils.getBlockTags((Element)aClass, "treatAsPrivate").isEmpty()) continue;
            if (this.utils.isEnum(aClass)) {
                this.processType(aClass, this.configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (this.utils.isClass(aClass)) {
                this.processType(aClass, this.configuration, this.baseClasses, this.subClasses);
                continue;
            }
            if (this.utils.isInterface(aClass)) {
                this.processInterface(aClass);
                continue;
            }
            if (!this.utils.isAnnotationType(aClass)) continue;
            this.processType(aClass, this.configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
    }

    private void processType(TypeElement typeElement, Configuration configuration, Collection<TypeElement> bases, Map<TypeElement, SortedSet<TypeElement>> subs) {
        TypeElement superclass = this.utils.getFirstVisibleSuperClassAsTypeElement(typeElement);
        if (superclass != null) {
            if (!this.add(subs, superclass, typeElement)) {
                return;
            }
            this.processType(superclass, configuration, bases, subs);
        } else if (!bases.contains(typeElement)) {
            bases.add(typeElement);
        }
        Set<TypeMirror> intfacs = this.utils.getAllInterfaces(typeElement);
        for (TypeMirror intfac : intfacs) {
            this.add(this.implementingClasses, this.utils.asTypeElement(intfac), typeElement);
        }
    }

    private void processInterface(TypeElement typeElement) {
        List<? extends TypeMirror> intfacs = typeElement.getInterfaces();
        if (!intfacs.isEmpty()) {
            for (TypeMirror typeMirror : intfacs) {
                if (!this.add(this.subInterfaces, this.utils.asTypeElement(typeMirror), typeElement)) {
                    return;
                }
                this.processInterface(this.utils.asTypeElement(typeMirror));
            }
        } else if (!this.baseInterfaces.contains(typeElement)) {
            this.baseInterfaces.add(typeElement);
        }
    }

    private boolean add(Map<TypeElement, SortedSet<TypeElement>> map, TypeElement superclass, TypeElement typeElement) {
        SortedSet sset = map.computeIfAbsent(superclass, s -> new TreeSet<Element>(this.comparator));
        if (sset.contains(typeElement)) {
            return false;
        }
        sset.add(typeElement);
        return true;
    }

    private SortedSet<TypeElement> get(Map<TypeElement, SortedSet<TypeElement>> map, TypeElement typeElement) {
        return map.computeIfAbsent(typeElement, t -> new TreeSet<Element>(this.comparator));
    }

    public SortedSet<TypeElement> subClasses(TypeElement typeElement) {
        return this.get(this.subClasses, typeElement);
    }

    public SortedSet<TypeElement> subInterfaces(TypeElement typeElement) {
        return this.get(this.subInterfaces, typeElement);
    }

    public SortedSet<TypeElement> implementingClasses(TypeElement typeElement) {
        SortedSet<TypeElement> result = this.get(this.implementingClasses, typeElement);
        SortedSet<TypeElement> intfcs = this.allSubClasses(typeElement, false);
        Iterator subInterfacesIter = intfcs.iterator();
        while (subInterfacesIter.hasNext()) {
            for (TypeElement c : this.implementingClasses((TypeElement)subInterfacesIter.next())) {
                if (result.contains(c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public SortedSet<TypeElement> directSubClasses(TypeElement typeElement, boolean isEnum) {
        return this.directSubClasses0(typeElement, isEnum);
    }

    private SortedSet<TypeElement> directSubClasses0(TypeElement typeElement, boolean isEnum) {
        if (isEnum) {
            return this.get(this.subEnums, typeElement);
        }
        if (this.utils.isAnnotationType(typeElement)) {
            return this.get(this.subAnnotationTypes, typeElement);
        }
        if (this.utils.isInterface(typeElement)) {
            return this.get(this.subInterfaces, typeElement);
        }
        if (this.utils.isClass(typeElement)) {
            return this.get(this.subClasses, typeElement);
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<TypeElement> allSubClasses(TypeElement typeElement, boolean isEnum) {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>(this.directSubClasses(typeElement, isEnum));
        for (int i = 0; i < list.size(); ++i) {
            TypeElement te = (TypeElement)list.get(i);
            SortedSet<TypeElement> tset = this.directSubClasses0(te, isEnum);
            for (TypeElement tte : tset) {
                if (list.contains(tte)) continue;
                list.add(tte);
            }
        }
        TreeSet<Element> out = new TreeSet<Element>(this.comparator);
        out.addAll(list);
        return out;
    }

    public SortedSet<TypeElement> baseClasses() {
        return this.baseClasses;
    }

    public SortedSet<TypeElement> baseInterfaces() {
        return this.baseInterfaces;
    }

    public SortedSet<TypeElement> baseEnums() {
        return this.baseEnums;
    }

    public SortedSet<TypeElement> baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

