/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.file.FSInfo;
import org.openjdk.tools.javac.file.Locations;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.main.OptionHelper;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;

public abstract class BaseFileManager
implements JavaFileManager {
    public Log log;
    protected Charset charset;
    protected Options options;
    protected String classLoaderClass;
    protected Locations locations;
    public boolean autoClose;
    private long lastUsedTime = System.currentTimeMillis();
    protected long deferredCloseTimeout = 0L;
    private static final Set<Option> javacFileManagerOptions = Option.getJavacFileManagerOptions();
    private String encodingName;
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.byteBufferCache = new ByteBufferCache();
        this.locations = this.createLocations();
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.classLoaderClass = this.options.get("procloader");
        this.locations.update(this.log, Lint.instance(context), FSInfo.instance(context));
        String s = this.options.get("fileManager.deferClose");
        if (s != null) {
            try {
                this.deferredCloseTimeout = (int)(Float.parseFloat(s) * 1000.0f);
            }
            catch (NumberFormatException e) {
                this.deferredCloseTimeout = 60000L;
            }
        }
    }

    protected Locations createLocations() {
        return new Locations();
    }

    protected void deferredClose() {
        Thread t = new Thread(this.getClass().getName() + " DeferredClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BaseFileManager baseFileManager = BaseFileManager.this;
                    synchronized (baseFileManager) {
                        long now = System.currentTimeMillis();
                        while (now < BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout) {
                            BaseFileManager.this.wait(BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout - now);
                            now = System.currentTimeMillis();
                        }
                        BaseFileManager.this.deferredCloseTimeout = 0L;
                        BaseFileManager.this.close();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    synchronized void updateLastUsedTime() {
        if (this.deferredCloseTimeout > 0L) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    protected Source getSource() {
        String sourceName = this.options.get(Option.SOURCE);
        Source source = null;
        if (sourceName != null) {
            source = Source.lookup(sourceName);
        }
        return source != null ? source : Source.DEFAULT;
    }

    protected ClassLoader getClassLoader(URL[] urls) {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        if (this.classLoaderClass != null) {
            try {
                Class<ClassLoader> loader = Class.forName(this.classLoaderClass).asSubclass(ClassLoader.class);
                Class[] constrArgTypes = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constr = loader.getConstructor(constrArgTypes);
                return constr.newInstance(urls, thisClassLoader);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls, thisClassLoader);
    }

    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        OptionHelper.GrumpyHelper helper = new OptionHelper.GrumpyHelper(this.log){

            @Override
            public String get(Option option) {
                return BaseFileManager.this.options.get(option.getText());
            }

            @Override
            public void put(String name, String value) {
                BaseFileManager.this.options.put(name, value);
            }

            @Override
            public void remove(String name) {
                BaseFileManager.this.options.remove(name);
            }

            @Override
            public boolean handleFileManagerOption(Option option, String value) {
                return BaseFileManager.this.handleOption(option, value);
            }
        };
        for (Option o : javacFileManagerOptions) {
            if (!o.matches(current)) continue;
            if (o.hasArg() ? remaining.hasNext() && !o.process(helper, current, remaining.next()) : !o.process(helper, current)) {
                return true;
            }
            throw new IllegalArgumentException(current);
        }
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        for (Option o : javacFileManagerOptions) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }

    public boolean handleOption(Option option, String value) {
        switch (option) {
            case ENCODING: {
                this.encodingName = value;
                return true;
            }
        }
        return this.locations.handleOption(option, value);
    }

    public boolean handleOptions(Map<Option, String> map) {
        boolean ok = true;
        for (Map.Entry<Option, String> e : map.entrySet()) {
            ok &= this.handleOption(e.getKey(), e.getValue());
        }
        return ok;
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        return this.encodingName != null ? this.encodingName : this.getDefaultEncodingName();
    }

    public CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encodingName = this.getEncodingName();
        try {
            decoder = this.getDecoder(encodingName, ignoreEncodingErrors);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    public CharsetDecoder getDecoder(String encodingName, boolean ignoreEncodingErrors) {
        Charset cs = this.charset == null ? Charset.forName(encodingName) : this.charset;
        CharsetDecoder decoder = cs.newDecoder();
        CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return decoder.onMalformedInput(action).onUnmappableCharacter(action);
    }

    public ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = this.byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    public void recycleByteBuffer(ByteBuffer bb) {
        this.byteBufferCache.put(bb);
    }

    public CharBuffer getCachedContent(JavaFileObject file) {
        ContentCacheEntry e = this.contentCache.get(file);
        if (e == null) {
            return null;
        }
        if (!e.isValid(file)) {
            this.contentCache.remove(file);
            return null;
        }
        return e.getValue();
    }

    public void cache(JavaFileObject file, CharBuffer cb) {
        this.contentCache.put(file, new ContentCacheEntry(file, cb));
    }

    public void flushCache(JavaFileObject file) {
        this.contentCache.remove(file);
    }

    public static JavaFileObject.Kind getKind(Path path) {
        return BaseFileManager.getKind(path.getFileName().toString());
    }

    public static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T o) {
        return Objects.requireNonNull(o);
    }

    protected static <T> Collection<T> nullCheck(Collection<T> it) {
        for (T t : it) {
            Objects.requireNonNull(t);
        }
        return it;
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject file, CharBuffer cb) {
            this.timestamp = file.getLastModified();
            this.ref = new SoftReference<CharBuffer>(cb);
        }

        boolean isValid(JavaFileObject file) {
            return this.timestamp == file.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }
    }
}

