/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.jute.Record;
import org.apache.zookeeper.server.ObserverBean;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

public class Observer
extends Learner {
    Observer(QuorumPeer self, ObserverZooKeeperServer observerZooKeeperServer) {
        this.self = self;
        this.zk = observerZooKeeperServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Observer ").append(this.sock);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observeLeader() throws Exception {
        this.zk.registerJMX(new ObserverBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            InetSocketAddress addr = this.findLeader();
            LOG.info("Observing " + addr);
            try {
                this.connectToLeader(addr);
                long newLeaderZxid = this.registerWithLeader(16);
                if (this.self.isReconfigStateChange()) {
                    throw new Exception("learned about role change");
                }
                this.syncWithLeader(newLeaderZxid);
                QuorumPacket qp = new QuorumPacket();
                while (this.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception when observing the leader", (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.pendingRevalidations.clear();
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    protected void processPacket(QuorumPacket qp) throws Exception {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                LOG.warn("Ignoring proposal");
                break;
            }
            case 4: {
                LOG.warn("Ignoring commit");
                break;
            }
            case 12: {
                LOG.error("Received an UPTODATE message after Observer started");
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                ((ObserverZooKeeperServer)this.zk).sync();
                break;
            }
            case 8: {
                TxnHeader hdr = new TxnHeader();
                Record txn = SerializeUtils.deserializeTxn(qp.getData(), hdr);
                Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, 0L);
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                obs.commitRequest(request);
                break;
            }
            case 19: {
                TxnHeader hdr = new TxnHeader();
                ByteBuffer buffer = ByteBuffer.wrap(qp.getData());
                long suggestedLeaderId = buffer.getLong();
                byte[] remainingdata = new byte[buffer.remaining()];
                buffer.get(remainingdata);
                Record txn = SerializeUtils.deserializeTxn(remainingdata, hdr);
                QuorumVerifier qv = this.self.configFromString(new String(((SetDataTxn)txn).getData()));
                Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, 0L);
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                boolean majorChange = this.self.processReconfig(qv, suggestedLeaderId, qp.getZxid(), true);
                obs.commitRequest(request);
                if (!majorChange) break;
                throw new Exception("changes proposed in reconfig");
            }
            default: {
                LOG.warn("Unknown packet type: {}", (Object)LearnerHandler.packetToString(qp));
            }
        }
    }

    @Override
    public void shutdown() {
        LOG.info("shutdown called", (Throwable)new Exception("shutdown Observer"));
        super.shutdown();
    }
}

