/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.osgi.framework.Bundle;
import org.osgi.service.subsystem.SubsystemException;

public class BundleDirectory
implements IDirectory {
    private final Bundle bundle;

    public BundleDirectory(Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        this.bundle = bundle;
    }

    public Iterator<IFile> iterator() {
        return this.listAllFiles().iterator();
    }

    public IDirectory convert() {
        return this;
    }

    public IDirectory convertNested() {
        return this;
    }

    public long getLastModified() {
        return 0L;
    }

    public String getName() {
        return "";
    }

    public IDirectory getParent() {
        return null;
    }

    public IDirectory getRoot() {
        return this;
    }

    public long getSize() {
        return 0L;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public InputStream open() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public URL toURL() throws MalformedURLException {
        return this.bundle.getEntry("/");
    }

    public IFile getFile(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if ("/".equals(name)) {
            return this;
        }
        URL entry = this.bundle.getEntry(name);
        if (entry == null) {
            return null;
        }
        return new BundleFile(name, entry, this);
    }

    public boolean isRoot() {
        return true;
    }

    public List<IFile> listAllFiles() {
        return this.listFiles(true);
    }

    public List<IFile> listFiles() {
        return this.listFiles(false);
    }

    public ICloseableDirectory toCloseable() {
        return null;
    }

    private List<IFile> listFiles(boolean recurse) {
        Enumeration entries = this.bundle.findEntries("/", null, recurse);
        if (entries == null) {
            return Collections.emptyList();
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        while (entries.hasMoreElements()) {
            URL entry = (URL)entries.nextElement();
            if (entry.getPath().endsWith("/")) continue;
            files.add(new BundleFile(entry.getPath(), entry, this));
        }
        files.trimToSize();
        return files;
    }

    private static class BundleFile
    implements IFile {
        private final BundleDirectory directory;
        private final String name;
        private final URL url;

        public BundleFile(String name, URL url, BundleDirectory directory) {
            this.name = name;
            this.url = url;
            this.directory = directory;
        }

        public IDirectory convert() {
            return null;
        }

        public IDirectory convertNested() {
            try {
                return FileSystem.getFSRoot((InputStream)this.url.openStream());
            }
            catch (IOException e) {
                throw new SubsystemException(e);
            }
        }

        public long getLastModified() {
            return 0L;
        }

        public String getName() {
            if (this.name.startsWith("/")) {
                return this.name.substring(1);
            }
            return this.name;
        }

        public IDirectory getParent() {
            return this.directory;
        }

        public IDirectory getRoot() {
            return this.directory;
        }

        public long getSize() {
            return 0L;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isFile() {
            return true;
        }

        public InputStream open() throws IOException, UnsupportedOperationException {
            return this.url.openStream();
        }

        public URL toURL() throws MalformedURLException {
            return this.url;
        }
    }
}

