/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.ipc.http;

import io.micrometer.core.ipc.http.HttpSender;
import io.netty.handler.codec.http.HttpMethod;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.function.Tuple2;

public class ReactorNettySender
implements HttpSender {
    private final HttpClient httpClient;

    public ReactorNettySender(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ReactorNettySender() {
        this(HttpClient.create());
    }

    @Override
    public HttpSender.Response send(HttpSender.Request request) {
        Tuple2 response = (Tuple2)((HttpClient.RequestSender)this.httpClient.request(this.toNettyHttpMethod(request.getMethod())).uri(request.getUrl().toString())).send((Publisher)ByteBufFlux.fromString((Publisher)Mono.just((Object)new String(request.getEntity())))).responseSingle((r, body) -> Mono.just((Object)r.status().code()).zipWith(body.asString().defaultIfEmpty((Object)""))).log().block();
        return new HttpSender.Response((Integer)response.getT1(), (String)response.getT2());
    }

    private HttpMethod toNettyHttpMethod(HttpSender.Method method) {
        switch (method) {
            case PUT: {
                return HttpMethod.PUT;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case HEAD: {
                return HttpMethod.HEAD;
            }
            case GET: {
                return HttpMethod.GET;
            }
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case OPTIONS: {
                return HttpMethod.OPTIONS;
            }
        }
        throw new UnsupportedOperationException("http method " + method.toString() + " is not supported by the reactor netty client");
    }
}

