/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.cli.kahadb.exporter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.utils.SizeFormatterUtil;
import org.apache.activemq.cli.kahadb.exporter.MessageStoreExporter;
import org.apache.activemq.cli.kahadb.exporter.MessageStoreMetadataExporter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBExporter
implements MessageStoreExporter {
    static final Logger LOG = LoggerFactory.getLogger(KahaDBExporter.class);
    private final KahaDBPersistenceAdapter adapter;
    private final MessageStoreMetadataExporter metadataExporter;
    private final MessageRecoveryListener recoveryListener;

    public KahaDBExporter(KahaDBPersistenceAdapter adapter, MessageStoreMetadataExporter metadataExporter, MessageRecoveryListener recoveryListener) {
        this.adapter = adapter;
        this.metadataExporter = metadataExporter;
        this.recoveryListener = recoveryListener;
    }

    @Override
    public void exportMetadata() throws IOException {
        this.metadataExporter.export();
    }

    @Override
    public void exportQueues() throws IOException {
        this.exportQueues(">");
    }

    @Override
    public void exportTopics() throws IOException {
        this.exportTopics(">");
    }

    @Override
    public void exportQueues(String pattern) throws IOException {
        pattern = pattern != null ? pattern : ">";
        this.exportDestinations((ActiveMQDestination)new ActiveMQQueue(pattern));
    }

    @Override
    public void exportTopics(String pattern) throws IOException {
        pattern = pattern != null ? pattern : ">";
        this.exportDestinations((ActiveMQDestination)new ActiveMQTopic(pattern));
    }

    private void exportDestinations(ActiveMQDestination destPattern) throws IOException {
        DestinationFilter destFilter = DestinationFilter.parseFilter((ActiveMQDestination)destPattern);
        Predicate<ActiveMQDestination> f = this.getExportDestinationFilter(destPattern);
        Set destinations = this.adapter.getDestinations().stream().filter(dest -> destFilter.matches(dest)).filter(f).collect(Collectors.toSet());
        for (ActiveMQDestination destination : destinations) {
            MessageStore messageStore = destination.isQueue() ? this.adapter.createQueueMessageStore((ActiveMQQueue)destination) : this.adapter.createTopicMessageStore((ActiveMQTopic)destination);
            try {
                messageStore.start();
                LOG.info("Starting export of: {}; message count: {} message(s); message size: {}", new Object[]{destination, messageStore.getMessageCount(), SizeFormatterUtil.sizeof((long)messageStore.getMessageSize())});
                messageStore.recover(this.recoveryListener);
                messageStore.stop();
            }
            catch (Exception e) {
                IOExceptionSupport.create((Exception)e);
            }
        }
    }

    private Predicate<ActiveMQDestination> getExportDestinationFilter(ActiveMQDestination destPattern) {
        List<ActiveMQDestination> nonComposite = destPattern.isComposite() ? Arrays.asList(destPattern.getCompositeDestinations()) : Arrays.asList(destPattern);
        return e -> {
            boolean match = false;
            for (ActiveMQDestination d : nonComposite) {
                String destString = d.getPhysicalName();
                if (destPattern.isPattern() && destString.length() > 1 && destString.endsWith(">")) {
                    String startsWithString = destString.substring(0, destString.length() - 2);
                    match = e.getPhysicalName().startsWith(startsWithString) && !e.getPhysicalName().equals(startsWithString);
                } else {
                    match = !destPattern.isPattern() ? e.getPhysicalName().equals(destString) : true;
                }
                if (!match) continue;
                break;
            }
            return match;
        };
    }
}

