
# Summary

* [Getting started](getting-started/README.md)
  * [Where is the code?](getting-started/where-is-the-code.md)
  * [Architecture overview](getting-started/architecture-overview.md)
  * [Set up to build DevTools](getting-started/build.md)
  * [Development profiles](getting-started/development-profiles.md)
* [Contributing](./contributing.md)
  * [Coding standards](./contributing/coding-standards.md)
    * [JavaScript](./contributing/javascript.md)
      * [ESLint](./contributing/eslint.md)
    * [CSS](./contributing/css.md)
  * [Creating and sending patches](./contributing/making-prs.md)
  * [Code reviews](./contributing/code-reviews.md)
  * [Filing good bugs](./contributing/filing-good-bugs.md)
  * [Investigating performance issues](./contributing/performance.md)
  * [Writing efficient React code](./contributing/react-performance-tips.md)
* [Automated tests](tests/README.md)
  * Running tests
    * [`xpcshell`](tests/xpcshell.md)
    * [Chrome mochitests](tests/mochitest-chrome.md)
    * [DevTools mochitests](tests/mochitest-devtools.md)
  * [Writing tests](tests/writing-tests.md)
  * [Debugging intermittent failures](tests/debugging-intermittents.md)
  * [Performance tests (DAMP)](tests/performance-tests.md)
    * [Writing a new test](tests/writing-perf-tests.md)
* [Bugs and issue trackers](bugs-issues.md)
* [Files and directories](files/README.md)
  * [Adding New Files](files/adding-files.md)
* [Tool Architectures](tools/tools.md)
  * [Inspector](tools/inspector.md)
    * [Panel Architecture](tools/inspector-panel.md)
    * [Highlighters](tools/highlighters.md)
  * [Memory](tools/memory-panel.md)
  * [Debugger](tools/debugger-panel.md)
  * [Responsive Design Mode](tools/responsive-design-mode.md)
  * [HTTP Inspector](tools/http-inspector.md)
  * [Console](tools/console-panel.md)
* [Frontend](frontend/frontend.md)
  * [Panel SVGs](frontend/svgs.md)
  * [React](frontend/react.md)
    * [Guidelines](frontend/react-guidelines.md)
  * [Redux](frontend/redux.md)
    * [Guidelines](frontend/redux-guidelines.md)
  * [Telemetry](frontend/telemetry.md)
* [Backend](backend/backend.md)
  * [Remote Debugging Protocol](backend/protocol.md)
  * [Client API](backend/client-api.md)
  * [Debugger API](backend/debugger-api.md)
  * [Backward Compatibility](backend/backward-compatibility.md)
  * Actors
    * [Actors Organization](backend/actor-hierarchy.md)
    * [Handling Multi-Processes in Actors](backend/actor-e10s-handling.md)
    * [Writing Actors With protocol.js](backend/protocol.js.md)
    * [Registering A New Actor](backend/actor-registration.md)
    * [Actor Best Practices](backend/actor-best-practices.md)
* [Preferences](preferences.md)
