// Copyright 2017 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Inscriptional_Pahlavi`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v9.0.0
  Emoji v5.0 (UTR51)
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x010B60, 0x010B72],
    [0x010B78, 0x010B7F]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Inscriptional_Pahlavi}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Inscriptional_Pahlavi}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Phli}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Phli}"
);
testPropertyEscapes(
  /^\p{scx=Inscriptional_Pahlavi}+$/u,
  matchSymbols,
  "\\p{scx=Inscriptional_Pahlavi}"
);
testPropertyEscapes(
  /^\p{scx=Phli}+$/u,
  matchSymbols,
  "\\p{scx=Phli}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x010B5F],
    [0x010B73, 0x010B77],
    [0x010B80, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Inscriptional_Pahlavi}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Inscriptional_Pahlavi}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Phli}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Phli}"
);
testPropertyEscapes(
  /^\P{scx=Inscriptional_Pahlavi}+$/u,
  nonMatchSymbols,
  "\\P{scx=Inscriptional_Pahlavi}"
);
testPropertyEscapes(
  /^\P{scx=Phli}+$/u,
  nonMatchSymbols,
  "\\P{scx=Phli}"
);

reportCompare(0, 0);
