// Copyright (C) 2015 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 22.1.3.8
description: Array.prototype.find.length value and descriptor.
info: >
  17 ECMAScript Standard Built-in Objects
includes: [propertyHelper.js]
---*/

assert.sameValue(
  Array.prototype.find.length, 1,
  'The value of `Array.prototype.find.length` is `1`'
);

verifyNotEnumerable(Array.prototype.find, 'length');
verifyNotWritable(Array.prototype.find, 'length');
verifyConfigurable(Array.prototype.find, 'length');

reportCompare(0, 0);
