---
layout: page
title: Release checklist
permalink: /contributing/release-checklist
---

These are instructions for preparing a release branch for Firefox Android and starting the next Nightly development cycle.

## [Release Management] Creating a new Beta release branch

**This part is 100% covered by the Release Management team. The dev team should not perform these steps.**

1. Create a branch name with the format `releases_v[beta_version]` off of the `main` branch (for example, `releases_v109`) through the GitHub UI.
`[beta_version]` should follow the Firefox Beta release number. See [Firefox Release Calendar](https://whattrainisitnow.com/calendar/). The following below should be performed in this new beta release branch:
    - In [version.txt](https://github.com/mozilla-mobile/firefox-android/blob/main/version.txt), update the version from `[beta_version].0a1` to `[beta_version].0b1`. Create a commit named `Set version to [beta_version].0b1` for this change. This change can either be directly committed to the `releases_v[beta_version]` branch or a pull request can be created against it and then merged.
        ```diff
        diff --git a/version.txt b/version.txt
        --- a/version.txt
        +++ b/version.txt
        @@ -1 +1 @@
        -109.0a1
        +109.0b1
        ```
    - In [ApplicationServices.kt](https://github.com/mozilla-mobile/firefox-android/blob/main/android-components/plugins/dependencies/src/main/java/ApplicationServices.kt):
      - Set `CHANNEL` to `ApplicationServicesChannel.RELEASE`
      - Set `VERSION` to `[major-version].0`

      ```diff
      diff --git a/android-components/plugins/dependencies/src/main/java/ApplicationServices.kt b/android-components/plugins/dependencies/src/main/java/ApplicationServices.kt
      index f64b26d7a1..72574ab057 100644
      --- a/android-components/plugins/dependencies/src/main/java/ApplicationServices.kt
      +++ b/android-components/plugins/dependencies/src/main/java/ApplicationServices.kt
      @@ -3,8 +3,8 @@
        * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

      -// These lines are generated by android-components/automation/application-services-nightly-bump.py
      -val VERSION = "114.20230420185101"
      -val CHANNEL = ApplicationServicesChannel.NIGHTLY
      +val VERSION = "114.0"
      +val CHANNEL = ApplicationServicesChannel.RELEASE
      ```
      - Create a commit named `Switch to Application Services Release`. (Note: application-services releases directly after the nightly cycle, there's no beta cycle).
    - In [Gecko.kt](https://github.com/mozilla-mobile/firefox-android/blob/main/android-components/plugins/dependencies/src/main/java/Gecko.kt), set the `channel` to `GeckoChannel.BETA`. Create a commit named `Switch to GeckoView Beta` for this change. This change can either be directly committed to the `releases_v[beta_version]` branch or a pull request can be created against it and then merged. Once landed, it is expected that this change will temporarily break builds on the branch. Step #4 will fix them.
        ```diff
        diff --git a/android-components/plugins/dependencies/src/main/java/Gecko.kt b/android-components/plugins/dependencies/src/main/java/Gecko.kt
        --- a/android-components/plugins/dependencies/src/main/java/Gecko.kt
        +++ b/android-components/plugins/dependencies/src/main/java/Gecko.kt
        @@ -14,7 +14,7 @@ object Gecko {
            /**
              * GeckoView channel
              */
        -    val channel = GeckoChannel.NIGHTLY
        +    val channel = GeckoChannel.BETA
        }

        /**
        ```
2. In `main` [version.txt](https://github.com/mozilla-mobile/firefox-android/blob/main/version.txt), update the version from `[previous_nightly_version].0a1` to `[nightly_version].0a1`. Create a commit named `Set version to [nightly_version].0a1` for this change. This change can either be directly committed to the `main` branch or a pull request can be created against it and then merged.
    ```diff
    diff --git a/version.txt b/version.txt
    --- a/version.txt
    +++ b/version.txt
    @@ -1 +1 @@
    -110.0a1
    +111.0a1
    ```
3. Notify the dev team that they can start the new Nightly development cycle per the steps given in the next section ⬇️
4. The Github Action will automatically bump the GeckoView version once the new Beta build is created and uploaded to Maven, as shown in [#324](https://github.com/mozilla-mobile/firefox-android/pull/324) for example.
5. Once all of the above commits have landed, create a new `Firefox Android (Android-Components, Fenix, Focus)` release in [Ship-It](https://shipit.mozilla-releng.net/) and continue with the release checklist per normal practice.

## [Dev team] Starting the next Nightly development cycle

**Please handle this part once Release Management gives you the go.**

Now that we made the Beta cut, we can remove all the unused strings marked moz:removedIn <= `[release_version subtract 1]`. `[release_version]` should follow the Firefox Release version. See [Firefox Release Calendar](https://wiki.mozilla.org/Release_Management/Calendar) for the current Release version. We will also want to bump the Android Component's [changelog.md](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/changelog.md) with the new Nightly development section.

0. Wait for greenlight coming from Release Management.
1. File a Bugzilla issue named "Start the Nightly `[nightly_version]` development cycle".
2. Search and remove all strings marked `moz:removedIn="[release_version subtract 1]"` across Fenix, Focus and Android Components. Please avoid removing strings in the localized `strings.xml` and limit changes only to `values/strings.xml`.
3. Add the next Nightly in development section in the [changelog.md](https://github.com/mozilla-mobile/firefox-android/blob/main/docs/changelog.md).:
  - Add a new `[nightly_version].0 (In Development)` section for the next Nightly version with the next commit and milestone numbers.
  - Update the `[beta_version].0` section, update the links to `release_v[beta_version]` and specifying the correct commit ranges. This should equate to changing `/blob/main/` to `/blob/releases_v[beta_version]/`.

      ```diff
      diff --git a/docs/changelog.md b/docs/changelog.md
      index 9e95d0e2adc..d901ed38cdd 100644
      --- a/docs/changelog.md
      +++ b/docs/changelog.md
      @@ -4,12 +4,18 @@ title: Changelog
      permalink: /changelog/
      ---

      -# 114.0 (In Development)
      -* [Commits](https://github.com/mozilla-mobile/firefox-android/compare/releases_v113..main)
      +# 115.0 (In Development)
      +* [Commits](https://github.com/mozilla-mobile/firefox-android/compare/releases_v114..main)
      * [Dependencies](https://github.com/mozilla-mobile/firefox-android/blob/main/android-components/plugins/dependencies/src/main/java/DependenciesPlugin.kt)
      * [Gecko](https://github.com/mozilla-mobile/firefox-android/blob/main/android-components/plugins/dependencies/src/main/java/Gecko.kt)
      * [Configuration](https://github.com/mozilla-mobile/firefox-android/blob/main/android-components/.config.yml)

      +# 114.0
      +* [Commits](https://github.com/mozilla-mobile/firefox-android/compare/releases_v113..releases_v114)
      +* [Dependencies](https://github.com/mozilla-mobile/firefox-android/blob/releases_v114/android-components/plugins/dependencies/src/main/java/DependenciesPlugin.kt)
      +* [Gecko](https://github.com/mozilla-mobile/firefox-android/blob/releases_v114/android-components/plugins/dependencies/src/main/java/Gecko.kt)
      +* [Configuration](https://github.com/mozilla-mobile/firefox-android/blob/releases_v114/android-components/.config.yml)
      +
      * * **browser-state**
        * 🌟 Added `DownloadState`.`openInApp` to indicate whether or not the file associated with the download should be opened in a third party app after downloaded successfully, for more information see [bug 1829371](https://bugzilla.mozilla.org/show_bug.cgi?id=1829371) and [bug 1829372](https://bugzilla.mozilla.org/show_bug.cgi?id=1829372).
      ```

3. Create a pull request with this commit and land.

### [Dev Team] Renew telemetry

After the Beta cut, another task is to renew/remove all soon to expire telemetry probes. What we're looking for is to create a list of telemetry that will expire in `[nightly_version add 2]`.  See [Firefox Release Calendar](https://whattrainisitnow.com/calendar/) for the current Release version.  There is a script that will help with finding these soon to expire telemetry.

1. Use the helper in tools folder `python3 data_renewal_generate.py [nightly_version add 2]` to detected and generate files that will help create the following files:
    - `[nightly_version add 2]`_expiry_list.csv
    - `[nightly_version add 2]`_renewal_request.txt
2. Upload the `[nightly_version add 2]`_expiry_list.csv to Google sheet in this [shared Google Drive](https://drive.google.com/drive/folders/1_ertMvn59eE9JmN721RqOjW6nNtxq9oS?usp=sharing) and contact product to review.  For each telemetry listed answer decide for:
    - Renew the metric (Recommendation is to use nightly_version + 12)
    - Choose not to renew (but not delete)
    - Choose to remove the metric
    - Renew the metric and set to never expire (this should only be for business critical metrics)
3. Note that `metrics.yaml` is also modified.  Once the review is over, continue to modify `metrics.yaml` to match the decision made in the Google sheet.  Make sure to add the PR link and if the telemetry never expires, add the email of the owner as contact.
4. File an issue for telemetry renewal so that a patch can target it and assign the issue to Product for increased visibility, as a reminder to to address the expiring metrics. See [issue 28190](https://github.com/mozilla-mobile/fenix/issues/28190) for an example.
5. Create a PR for review.  Modify `[nightly_version add 2]`_renewal_request.txt and paste it to the PR for data review. This comment can be auto-generated using the filled `[nightly_version add 2]`_expiry_list.csv and the `tools/data_renewal_request.py` helper. Copy the filled CSV into the tools directory and run the script to create a `[nightly_version add 2]`_filled_renewal_request.txt file that will contain the text required for data review. Make sure it includes (or add manually if necessary):
 - When will this collection now expire?
 - Why was the initial period of collection insufficient?
6. Please also check if you're responsible for Focus telemetry renewal.

### Ask for Help

- Issues related to releases `#releaseduty` on Element
- Topics about CI (and the way we use Taskcluster) `#Firefox CI` on Element
- Breakage in PRs due to Gradle issues or GV upgrade problems `#mobile-android-team` on Slack
