# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
"""
Apply some defaults and minor modifications to the jobs defined in the version bump kind
kind.
"""


from taskgraph.transforms.base import TransformSequence
from taskgraph.util.schema import resolve_keyed_by

transforms = TransformSequence()


@transforms.add
def set_name_and_clear_artifacts(config, tasks):
    for task in tasks:
        task["name"] = task["attributes"]["build-type"]
        task["attributes"]["artifacts"] = {}
        yield task


@transforms.add
def resolve_keys(config, tasks):
    for task in tasks:
        for key in ("worker.push", "treeherder.symbol"):
            resolve_keyed_by(
                task,
                key,
                item_name=task["name"],
                **{
                    "build-type": task["attributes"]["build-type"],
                    "level": config.params["level"],
                }
            )
        yield task


@transforms.add
def build_worker_definition(config, tasks):
    for task in tasks:
        worker_definition = {
            "branch": config.params["head_ref"],
        }
        task["worker"].update(worker_definition)

        yield task
