<!-- AUTOGENERATED BY glean_parser v8.1.1. DO NOT EDIT. -->

# Metrics

This document enumerates the metrics collected by this project using the [Glean SDK](https://mozilla.github.io/glean/book/index.html).
This project may depend on other projects which also collect metrics.
This means you might have to go searching through the dependency tree to get a full picture of everything collected by this project.

# Pings

- [crash](#crash)
- [metrics](#metrics)

## crash

A ping to report crash information. This information is sent as soon as possible after a crash occurs (whether the crash is a background/content process or the main process). It is expected to be used for crash report analysis and to reduce blind spots in crash reporting.


This ping includes the [client id](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section).

**Data reviews for this ping:**

- <https://bugzilla.mozilla.org/show_bug.cgi?id=1790569#c12>

**Bugs related to this ping:**

- <https://bugzilla.mozilla.org/show_bug.cgi?id=1790569>

**Reasons this ping may be sent:**

- `crash`: A process crashed and a ping was immediately sent.

- `event_found`: A process crashed and produced a crash event, which was later found and sent in a ping.


All Glean pings contain built-in metrics in the [`ping_info`](https://mozilla.github.io/glean/book/user/pings/index.html#the-ping_info-section) and [`client_info`](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section) sections.

In addition to those built-in metrics, the following metrics are added to the ping:

| Name | Type | Description | Data reviews | Extras | Expiration | [Data Sensitivity](https://wiki.mozilla.org/Firefox/Data_Collection) |
| --- | --- | --- | --- | --- | --- | --- |
| crash.cause |[string](https://mozilla.github.io/glean/book/user/metrics/string.html) |The cause of the crash. May be one of `os_fault` or `java_exception`.  |[Bug 1839697](https://bugzilla.mozilla.org/show_bug.cgi?id=1839697#c5)||never |1 |
| crash.process_type |[string](https://mozilla.github.io/glean/book/user/metrics/string.html) |The type of process that experienced a crash. See the full list of options [here](https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#process-types).  |[Bug 1790569](https://bugzilla.mozilla.org/show_bug.cgi?id=1790569#c12)||never |1 |
| crash.remote_type |[string](https://mozilla.github.io/glean/book/user/metrics/string.html) |Type of the child process, can be set to "web", "file" or "extension" but could also be unavailable.  |[Bug 1851518](https://bugzilla.mozilla.org/show_bug.cgi?id=1851518#c6)||never |1 |
| crash.startup |[boolean](https://mozilla.github.io/glean/book/user/metrics/boolean.html) |If true, the crash occurred during process startup.  |[Bug 1790569](https://bugzilla.mozilla.org/show_bug.cgi?id=1790569#c12)||never |1 |
| crash.time |[datetime](https://mozilla.github.io/glean/book/user/metrics/datetime.html) |The time at which the crash occurred.  |[Bug 1790569](https://bugzilla.mozilla.org/show_bug.cgi?id=1790569#c12)||never |1 |
| crash.uptime |[timespan](https://mozilla.github.io/glean/book/user/metrics/timespan.html) |The application uptime. This is equivalent to the legacy crash ping's `UptimeTS` field.  |[Bug 1790569](https://bugzilla.mozilla.org/show_bug.cgi?id=1790569#c12)||never |1 |

## metrics

This is a built-in ping that is assembled out of the box by the Glean SDK.

See the Glean SDK documentation for the [`metrics` ping](https://mozilla.github.io/glean/book/user/pings/metrics.html).

All Glean pings contain built-in metrics in the [`ping_info`](https://mozilla.github.io/glean/book/user/pings/index.html#the-ping_info-section) and [`client_info`](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section) sections.

In addition to those built-in metrics, the following metrics are added to the ping:

| Name | Type | Description | Data reviews | Extras | Expiration | [Data Sensitivity](https://wiki.mozilla.org/Firefox/Data_Collection) |
| --- | --- | --- | --- | --- | --- | --- |
| crash_metrics.crash_count |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of crashes that occur in the application. This measures only the counts of each crash in association with the labeled type of the crash. The labels correspond to the types of crashes handled by lib-crash. Deprecated: `native_code_crash`, `fatal_native_code_crash` and `nonfatal_native_code_crash` replaced by `main_proc_native_code_crash`, `fg_proc_native_code_crash` and `bg_proc_native_code_crash`.  |[Bug 1553935](https://bugzilla.mozilla.org/show_bug.cgi?id=1553935#c3), [mozilla-mobile/android-components#5700](https://github.com/mozilla-mobile/android-components/pull/5700#pullrequestreview-347721248), [mozilla-mobile/android-components#11908](https://github.com/mozilla-mobile/android-components/pull/11908#issuecomment-1075243414)|<ul><li>uncaught_exception</li><li>caught_exception</li><li>main_proc_native_code_crash</li><li>fg_proc_native_code_crash</li><li>bg_proc_native_code_crash</li><li>fatal_native_code_crash</li><li>nonfatal_native_code_crash</li></ul>|never |1 |

Data categories are [defined here](https://wiki.mozilla.org/Firefox/Data_Collection).

<!-- AUTOGENERATED BY glean_parser v8.1.1. DO NOT EDIT. -->

