// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package grpc_channelz_v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// ChannelzService is the service API for Channelz service.
// Fields should be assigned to their respective handler implementations only before
// RegisterChannelzService is called.  Any unassigned fields will result in the
// handler for that method returning an Unimplemented error.
type ChannelzService struct {
	// Gets all root channels (i.e. channels the application has directly
	// created). This does not include subchannels nor non-top level channels.
	GetTopChannels func(context.Context, *GetTopChannelsRequest) (*GetTopChannelsResponse, error)
	// Gets all servers that exist in the process.
	GetServers func(context.Context, *GetServersRequest) (*GetServersResponse, error)
	// Returns a single Server, or else a NOT_FOUND code.
	GetServer func(context.Context, *GetServerRequest) (*GetServerResponse, error)
	// Gets all server sockets that exist in the process.
	GetServerSockets func(context.Context, *GetServerSocketsRequest) (*GetServerSocketsResponse, error)
	// Returns a single Channel, or else a NOT_FOUND code.
	GetChannel func(context.Context, *GetChannelRequest) (*GetChannelResponse, error)
	// Returns a single Subchannel, or else a NOT_FOUND code.
	GetSubchannel func(context.Context, *GetSubchannelRequest) (*GetSubchannelResponse, error)
	// Returns a single Socket or else a NOT_FOUND code.
	GetSocket func(context.Context, *GetSocketRequest) (*GetSocketResponse, error)
}

func (s *ChannelzService) getTopChannels(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetTopChannels == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetTopChannels not implemented")
	}
	in := new(GetTopChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetTopChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetTopChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetTopChannels(ctx, req.(*GetTopChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getServers(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetServers == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetServers not implemented")
	}
	in := new(GetServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetServers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetServers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetServers(ctx, req.(*GetServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getServer(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetServer == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetServer not implemented")
	}
	in := new(GetServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetServer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetServer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetServer(ctx, req.(*GetServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getServerSockets(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetServerSockets == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetServerSockets not implemented")
	}
	in := new(GetServerSocketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetServerSockets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetServerSockets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetServerSockets(ctx, req.(*GetServerSocketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getChannel(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetChannel == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetChannel not implemented")
	}
	in := new(GetChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetChannel(ctx, req.(*GetChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getSubchannel(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetSubchannel == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetSubchannel not implemented")
	}
	in := new(GetSubchannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetSubchannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetSubchannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetSubchannel(ctx, req.(*GetSubchannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}
func (s *ChannelzService) getSocket(_ interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	if s.GetSocket == nil {
		return nil, status.Errorf(codes.Unimplemented, "method GetSocket not implemented")
	}
	in := new(GetSocketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return s.GetSocket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     s,
		FullMethod: "/grpc.channelz.v1.Channelz/GetSocket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return s.GetSocket(ctx, req.(*GetSocketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RegisterChannelzService registers a service implementation with a gRPC server.
func RegisterChannelzService(s grpc.ServiceRegistrar, srv *ChannelzService) {
	sd := grpc.ServiceDesc{
		ServiceName: "grpc.channelz.v1.Channelz",
		Methods: []grpc.MethodDesc{
			{
				MethodName: "GetTopChannels",
				Handler:    srv.getTopChannels,
			},
			{
				MethodName: "GetServers",
				Handler:    srv.getServers,
			},
			{
				MethodName: "GetServer",
				Handler:    srv.getServer,
			},
			{
				MethodName: "GetServerSockets",
				Handler:    srv.getServerSockets,
			},
			{
				MethodName: "GetChannel",
				Handler:    srv.getChannel,
			},
			{
				MethodName: "GetSubchannel",
				Handler:    srv.getSubchannel,
			},
			{
				MethodName: "GetSocket",
				Handler:    srv.getSocket,
			},
		},
		Streams:  []grpc.StreamDesc{},
		Metadata: "grpc/channelz/v1/channelz.proto",
	}

	s.RegisterService(&sd, nil)
}

// NewChannelzService creates a new ChannelzService containing the
// implemented methods of the Channelz service in s.  Any unimplemented
// methods will result in the gRPC server returning an UNIMPLEMENTED status to the client.
// This includes situations where the method handler is misspelled or has the wrong
// signature.  For this reason, this function should be used with great care and
// is not recommended to be used by most users.
func NewChannelzService(s interface{}) *ChannelzService {
	ns := &ChannelzService{}
	if h, ok := s.(interface {
		GetTopChannels(context.Context, *GetTopChannelsRequest) (*GetTopChannelsResponse, error)
	}); ok {
		ns.GetTopChannels = h.GetTopChannels
	}
	if h, ok := s.(interface {
		GetServers(context.Context, *GetServersRequest) (*GetServersResponse, error)
	}); ok {
		ns.GetServers = h.GetServers
	}
	if h, ok := s.(interface {
		GetServer(context.Context, *GetServerRequest) (*GetServerResponse, error)
	}); ok {
		ns.GetServer = h.GetServer
	}
	if h, ok := s.(interface {
		GetServerSockets(context.Context, *GetServerSocketsRequest) (*GetServerSocketsResponse, error)
	}); ok {
		ns.GetServerSockets = h.GetServerSockets
	}
	if h, ok := s.(interface {
		GetChannel(context.Context, *GetChannelRequest) (*GetChannelResponse, error)
	}); ok {
		ns.GetChannel = h.GetChannel
	}
	if h, ok := s.(interface {
		GetSubchannel(context.Context, *GetSubchannelRequest) (*GetSubchannelResponse, error)
	}); ok {
		ns.GetSubchannel = h.GetSubchannel
	}
	if h, ok := s.(interface {
		GetSocket(context.Context, *GetSocketRequest) (*GetSocketResponse, error)
	}); ok {
		ns.GetSocket = h.GetSocket
	}
	return ns
}

// UnstableChannelzService is the service API for Channelz service.
// New methods may be added to this interface if they are added to the service
// definition, which is not a backward-compatible change.  For this reason,
// use of this type is not recommended.
type UnstableChannelzService interface {
	// Gets all root channels (i.e. channels the application has directly
	// created). This does not include subchannels nor non-top level channels.
	GetTopChannels(context.Context, *GetTopChannelsRequest) (*GetTopChannelsResponse, error)
	// Gets all servers that exist in the process.
	GetServers(context.Context, *GetServersRequest) (*GetServersResponse, error)
	// Returns a single Server, or else a NOT_FOUND code.
	GetServer(context.Context, *GetServerRequest) (*GetServerResponse, error)
	// Gets all server sockets that exist in the process.
	GetServerSockets(context.Context, *GetServerSocketsRequest) (*GetServerSocketsResponse, error)
	// Returns a single Channel, or else a NOT_FOUND code.
	GetChannel(context.Context, *GetChannelRequest) (*GetChannelResponse, error)
	// Returns a single Subchannel, or else a NOT_FOUND code.
	GetSubchannel(context.Context, *GetSubchannelRequest) (*GetSubchannelResponse, error)
	// Returns a single Socket or else a NOT_FOUND code.
	GetSocket(context.Context, *GetSocketRequest) (*GetSocketResponse, error)
}
