package trafficmanager

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// EndpointMonitorStatus enumerates the values for endpoint monitor status.
type EndpointMonitorStatus string

const (
	// CheckingEndpoint ...
	CheckingEndpoint EndpointMonitorStatus = "CheckingEndpoint"
	// Degraded ...
	Degraded EndpointMonitorStatus = "Degraded"
	// Disabled ...
	Disabled EndpointMonitorStatus = "Disabled"
	// Inactive ...
	Inactive EndpointMonitorStatus = "Inactive"
	// Online ...
	Online EndpointMonitorStatus = "Online"
	// Stopped ...
	Stopped EndpointMonitorStatus = "Stopped"
)

// PossibleEndpointMonitorStatusValues returns an array of possible values for the EndpointMonitorStatus const type.
func PossibleEndpointMonitorStatusValues() []EndpointMonitorStatus {
	return []EndpointMonitorStatus{CheckingEndpoint, Degraded, Disabled, Inactive, Online, Stopped}
}

// EndpointStatus enumerates the values for endpoint status.
type EndpointStatus string

const (
	// EndpointStatusDisabled ...
	EndpointStatusDisabled EndpointStatus = "Disabled"
	// EndpointStatusEnabled ...
	EndpointStatusEnabled EndpointStatus = "Enabled"
)

// PossibleEndpointStatusValues returns an array of possible values for the EndpointStatus const type.
func PossibleEndpointStatusValues() []EndpointStatus {
	return []EndpointStatus{EndpointStatusDisabled, EndpointStatusEnabled}
}

// MonitorProtocol enumerates the values for monitor protocol.
type MonitorProtocol string

const (
	// HTTP ...
	HTTP MonitorProtocol = "HTTP"
	// HTTPS ...
	HTTPS MonitorProtocol = "HTTPS"
	// TCP ...
	TCP MonitorProtocol = "TCP"
)

// PossibleMonitorProtocolValues returns an array of possible values for the MonitorProtocol const type.
func PossibleMonitorProtocolValues() []MonitorProtocol {
	return []MonitorProtocol{HTTP, HTTPS, TCP}
}

// ProfileMonitorStatus enumerates the values for profile monitor status.
type ProfileMonitorStatus string

const (
	// ProfileMonitorStatusCheckingEndpoints ...
	ProfileMonitorStatusCheckingEndpoints ProfileMonitorStatus = "CheckingEndpoints"
	// ProfileMonitorStatusDegraded ...
	ProfileMonitorStatusDegraded ProfileMonitorStatus = "Degraded"
	// ProfileMonitorStatusDisabled ...
	ProfileMonitorStatusDisabled ProfileMonitorStatus = "Disabled"
	// ProfileMonitorStatusInactive ...
	ProfileMonitorStatusInactive ProfileMonitorStatus = "Inactive"
	// ProfileMonitorStatusOnline ...
	ProfileMonitorStatusOnline ProfileMonitorStatus = "Online"
)

// PossibleProfileMonitorStatusValues returns an array of possible values for the ProfileMonitorStatus const type.
func PossibleProfileMonitorStatusValues() []ProfileMonitorStatus {
	return []ProfileMonitorStatus{ProfileMonitorStatusCheckingEndpoints, ProfileMonitorStatusDegraded, ProfileMonitorStatusDisabled, ProfileMonitorStatusInactive, ProfileMonitorStatusOnline}
}

// ProfileStatus enumerates the values for profile status.
type ProfileStatus string

const (
	// ProfileStatusDisabled ...
	ProfileStatusDisabled ProfileStatus = "Disabled"
	// ProfileStatusEnabled ...
	ProfileStatusEnabled ProfileStatus = "Enabled"
)

// PossibleProfileStatusValues returns an array of possible values for the ProfileStatus const type.
func PossibleProfileStatusValues() []ProfileStatus {
	return []ProfileStatus{ProfileStatusDisabled, ProfileStatusEnabled}
}

// TrafficRoutingMethod enumerates the values for traffic routing method.
type TrafficRoutingMethod string

const (
	// Geographic ...
	Geographic TrafficRoutingMethod = "Geographic"
	// Performance ...
	Performance TrafficRoutingMethod = "Performance"
	// Priority ...
	Priority TrafficRoutingMethod = "Priority"
	// Weighted ...
	Weighted TrafficRoutingMethod = "Weighted"
)

// PossibleTrafficRoutingMethodValues returns an array of possible values for the TrafficRoutingMethod const type.
func PossibleTrafficRoutingMethodValues() []TrafficRoutingMethod {
	return []TrafficRoutingMethod{Geographic, Performance, Priority, Weighted}
}
