package searchapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/search/mgmt/2015-02-28/search"
	"github.com/Azure/go-autorest/autorest"
)

// AdminKeysClientAPI contains the set of methods on the AdminKeysClient type.
type AdminKeysClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string) (result search.AdminKeyResult, err error)
}

var _ AdminKeysClientAPI = (*search.AdminKeysClient)(nil)

// QueryKeysClientAPI contains the set of methods on the QueryKeysClient type.
type QueryKeysClientAPI interface {
	List(ctx context.Context, resourceGroupName string, serviceName string) (result search.ListQueryKeysResult, err error)
}

var _ QueryKeysClientAPI = (*search.QueryKeysClient)(nil)

// ServicesClientAPI contains the set of methods on the ServicesClient type.
type ServicesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serviceName string, parameters search.ServiceCreateOrUpdateParameters) (result search.ServiceResource, err error)
	Delete(ctx context.Context, resourceGroupName string, serviceName string) (result autorest.Response, err error)
	List(ctx context.Context, resourceGroupName string) (result search.ServiceListResult, err error)
}

var _ ServicesClientAPI = (*search.ServicesClient)(nil)
