package kusto

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AzureScaleType enumerates the values for azure scale type.
type AzureScaleType string

const (
	// Automatic ...
	Automatic AzureScaleType = "automatic"
	// Manual ...
	Manual AzureScaleType = "manual"
	// None ...
	None AzureScaleType = "none"
)

// PossibleAzureScaleTypeValues returns an array of possible values for the AzureScaleType const type.
func PossibleAzureScaleTypeValues() []AzureScaleType {
	return []AzureScaleType{Automatic, Manual, None}
}

// AzureSkuName enumerates the values for azure sku name.
type AzureSkuName string

const (
	// D13V2 ...
	D13V2 AzureSkuName = "D13_v2"
	// D14V2 ...
	D14V2 AzureSkuName = "D14_v2"
	// KC16 ...
	KC16 AzureSkuName = "KC16"
	// KC8 ...
	KC8 AzureSkuName = "KC8"
	// KS16 ...
	KS16 AzureSkuName = "KS16"
	// KS8 ...
	KS8 AzureSkuName = "KS8"
	// L16 ...
	L16 AzureSkuName = "L16"
	// L8 ...
	L8 AzureSkuName = "L8"
)

// PossibleAzureSkuNameValues returns an array of possible values for the AzureSkuName const type.
func PossibleAzureSkuNameValues() []AzureSkuName {
	return []AzureSkuName{D13V2, D14V2, KC16, KC8, KS16, KS8, L16, L8}
}

// DatabasePrincipalRole enumerates the values for database principal role.
type DatabasePrincipalRole string

const (
	// Admin ...
	Admin DatabasePrincipalRole = "Admin"
	// Ingestor ...
	Ingestor DatabasePrincipalRole = "Ingestor"
	// Monitor ...
	Monitor DatabasePrincipalRole = "Monitor"
	// UnrestrictedViewers ...
	UnrestrictedViewers DatabasePrincipalRole = "UnrestrictedViewers"
	// User ...
	User DatabasePrincipalRole = "User"
	// Viewer ...
	Viewer DatabasePrincipalRole = "Viewer"
)

// PossibleDatabasePrincipalRoleValues returns an array of possible values for the DatabasePrincipalRole const type.
func PossibleDatabasePrincipalRoleValues() []DatabasePrincipalRole {
	return []DatabasePrincipalRole{Admin, Ingestor, Monitor, UnrestrictedViewers, User, Viewer}
}

// DatabasePrincipalType enumerates the values for database principal type.
type DatabasePrincipalType string

const (
	// DatabasePrincipalTypeApp ...
	DatabasePrincipalTypeApp DatabasePrincipalType = "App"
	// DatabasePrincipalTypeGroup ...
	DatabasePrincipalTypeGroup DatabasePrincipalType = "Group"
	// DatabasePrincipalTypeUser ...
	DatabasePrincipalTypeUser DatabasePrincipalType = "User"
)

// PossibleDatabasePrincipalTypeValues returns an array of possible values for the DatabasePrincipalType const type.
func PossibleDatabasePrincipalTypeValues() []DatabasePrincipalType {
	return []DatabasePrincipalType{DatabasePrincipalTypeApp, DatabasePrincipalTypeGroup, DatabasePrincipalTypeUser}
}

// DataFormat enumerates the values for data format.
type DataFormat string

const (
	// CSV ...
	CSV DataFormat = "CSV"
	// JSON ...
	JSON DataFormat = "JSON"
	// MULTIJSON ...
	MULTIJSON DataFormat = "MULTIJSON"
)

// PossibleDataFormatValues returns an array of possible values for the DataFormat const type.
func PossibleDataFormatValues() []DataFormat {
	return []DataFormat{CSV, JSON, MULTIJSON}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Running ...
	Running ProvisioningState = "Running"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Deleting, Failed, Running, Succeeded}
}

// State enumerates the values for state.
type State string

const (
	// StateCreating ...
	StateCreating State = "Creating"
	// StateDeleted ...
	StateDeleted State = "Deleted"
	// StateDeleting ...
	StateDeleting State = "Deleting"
	// StateRunning ...
	StateRunning State = "Running"
	// StateStarting ...
	StateStarting State = "Starting"
	// StateStopped ...
	StateStopped State = "Stopped"
	// StateStopping ...
	StateStopping State = "Stopping"
	// StateUnavailable ...
	StateUnavailable State = "Unavailable"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateCreating, StateDeleted, StateDeleting, StateRunning, StateStarting, StateStopped, StateStopping, StateUnavailable}
}
