package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// QueryClient is the a service for managing and querying digital twins and digital twin models.
type QueryClient struct {
	BaseClient
}

// NewQueryClient creates an instance of the QueryClient client.
func NewQueryClient() QueryClient {
	return NewQueryClientWithBaseURI(DefaultBaseURI)
}

// NewQueryClientWithBaseURI creates an instance of the QueryClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewQueryClientWithBaseURI(baseURI string) QueryClient {
	return QueryClient{NewWithBaseURI(baseURI)}
}

// QueryTwins executes a query that allows traversing relationships and filtering by property values.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// Parameters:
// querySpecification - the query specification to execute.
func (client QueryClient) QueryTwins(ctx context.Context, querySpecification QuerySpecification) (result QueryResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QueryClient.QueryTwins")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.QueryTwinsPreparer(ctx, querySpecification)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.QueryClient", "QueryTwins", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryTwinsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.QueryClient", "QueryTwins", resp, "Failure sending request")
		return
	}

	result, err = client.QueryTwinsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.QueryClient", "QueryTwins", resp, "Failure responding to request")
	}

	return
}

// QueryTwinsPreparer prepares the QueryTwins request.
func (client QueryClient) QueryTwinsPreparer(ctx context.Context, querySpecification QuerySpecification) (*http.Request, error) {
	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/query"),
		autorest.WithJSON(querySpecification),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QueryTwinsSender sends the QueryTwins request. The method will close the
// http.Response Body if it receives an error.
func (client QueryClient) QueryTwinsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// QueryTwinsResponder handles the response to the QueryTwins request. The method always
// closes the http.Response Body.
func (client QueryClient) QueryTwinsResponder(resp *http.Response) (result QueryResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
