package datamigration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datamigration/mgmt/2018-03-31-preview/datamigration"

// APIError error information.
type APIError struct {
	// Error - Error information in OData format
	Error *ODataError `json:"error,omitempty"`
}

// AvailableServiceSku describes the available service SKU.
type AvailableServiceSku struct {
	// ResourceType - The resource type, including the provider namespace
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - SKU name, tier, etc.
	Sku *AvailableServiceSkuSku `json:"sku,omitempty"`
	// Capacity - A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSkuCapacity `json:"capacity,omitempty"`
}

// AvailableServiceSkuCapacity a description of the scaling capacities of the SKU
type AvailableServiceSkuCapacity struct {
	// Minimum - The minimum capacity, usually 0 or 1.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity
	Default *int32 `json:"default,omitempty"`
	// ScaleType - The scalability approach. Possible values include: 'ServiceScalabilityNone', 'ServiceScalabilityManual', 'ServiceScalabilityAutomatic'
	ScaleType ServiceScalability `json:"scaleType,omitempty"`
}

// AvailableServiceSkuSku SKU name, tier, etc.
type AvailableServiceSkuSku struct {
	// Name - The name of the SKU
	Name *string `json:"name,omitempty"`
	// Family - SKU family
	Family *string `json:"family,omitempty"`
	// Size - SKU size
	Size *string `json:"size,omitempty"`
	// Tier - The tier of the SKU, such as "Free", "Basic", "Standard", or "Premium"
	Tier *string `json:"tier,omitempty"`
}

// BlobShare blob container storage information.
type BlobShare struct {
	// SasURI - SAS URI of Azure Storage Account Container.
	SasURI *string `json:"sasUri,omitempty"`
}

// BasicConnectionInfo defines the connection properties of a server
type BasicConnectionInfo interface {
	AsSQLConnectionInfo() (*SQLConnectionInfo, bool)
	AsConnectionInfo() (*ConnectionInfo, bool)
}

// ConnectionInfo defines the connection properties of a server
type ConnectionInfo struct {
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicConnectionInfo(body []byte) (BasicConnectionInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeSQLConnectionInfo):
		var sci SQLConnectionInfo
		err := json.Unmarshal(body, &sci)
		return sci, err
	default:
		var ci ConnectionInfo
		err := json.Unmarshal(body, &ci)
		return ci, err
	}
}
func unmarshalBasicConnectionInfoArray(body []byte) ([]BasicConnectionInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ciArray := make([]BasicConnectionInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ci, err := unmarshalBasicConnectionInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		ciArray[index] = ci
	}
	return ciArray, nil
}

// MarshalJSON is the custom marshaler for ConnectionInfo.
func (ci ConnectionInfo) MarshalJSON() ([]byte, error) {
	ci.Type = TypeConnectionInfo
	objectMap := make(map[string]interface{})
	if ci.UserName != nil {
		objectMap["userName"] = ci.UserName
	}
	if ci.Password != nil {
		objectMap["password"] = ci.Password
	}
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	return json.Marshal(objectMap)
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return &ci, true
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &ci, true
}

// ConnectToSourceSQLServerTaskInput input for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// SourceConnectionInfo - Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
	// CollectLogins - Flag for whether to collect logins from source server.
	CollectLogins *bool `json:"CollectLogins,omitempty"`
	// CollectAgentJobs - Flag for whether to collect agent jobs from source server.
	CollectAgentJobs *bool `json:"CollectAgentJobs,omitempty"`
}

// BasicConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type BasicConnectToSourceSQLServerTaskOutput interface {
	AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool)
	AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool)
	AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool)
	AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool)
	AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool)
}

// ConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicConnectToSourceSQLServerTaskOutput(body []byte) (BasicConnectToSourceSQLServerTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput):
		var ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel
		err := json.Unmarshal(body, &ctssstoajl)
		return ctssstoajl, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput):
		var ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel
		err := json.Unmarshal(body, &ctssstoll)
		return ctssstoll, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput):
		var ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &ctssstodl)
		return ctssstodl, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput):
		var ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel
		err := json.Unmarshal(body, &ctssstotl)
		return ctssstotl, err
	default:
		var ctsssto ConnectToSourceSQLServerTaskOutput
		err := json.Unmarshal(body, &ctsssto)
		return ctsssto, err
	}
}
func unmarshalBasicConnectToSourceSQLServerTaskOutputArray(body []byte) ([]BasicConnectToSourceSQLServerTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctssstoArray := make([]BasicConnectToSourceSQLServerTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ctsssto, err := unmarshalBasicConnectToSourceSQLServerTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctssstoArray[index] = ctsssto
	}
	return ctssstoArray, nil
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) MarshalJSON() ([]byte, error) {
	ctsssto.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput
	objectMap := make(map[string]interface{})
	if ctsssto.ResultType != "" {
		objectMap["resultType"] = ctsssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// ConnectToSourceSQLServerTaskOutputAgentJobLevel agentJob level output for the task that validates connection
// to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; AgentJob name
	Name *string `json:"name,omitempty"`
	// JobCategory - READ-ONLY; The type of AgentJob.
	JobCategory *string `json:"jobCategory,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original AgentJob.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// JobOwner - READ-ONLY; The owner of the AgentJob
	JobOwner *string `json:"jobOwner,omitempty"`
	// LastExecutedOn - READ-ONLY; UTC Date and time when the AgentJob was last executed.
	LastExecutedOn *date.Time `json:"lastExecutedOn,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of agent job for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	ctssstoajl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoajl.ResultType != "" {
		objectMap["resultType"] = ctssstoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return &ctssstoajl, true
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoajl, true
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel database level output for the task that validates connection
// to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// Name - READ-ONLY; Database name
	Name *string `json:"name,omitempty"`
	// SizeMB - READ-ONLY; Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// DatabaseFiles - READ-ONLY; The list of database files
	DatabaseFiles *[]DatabaseFileInfo `json:"databaseFiles,omitempty"`
	// CompatibilityLevel - READ-ONLY; SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// DatabaseState - READ-ONLY; State of the database. Possible values include: 'Online', 'Restoring', 'Recovering', 'RecoveryPending', 'Suspect', 'Emergency', 'Offline', 'Copying', 'OfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	ctssstodl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstodl.ResultType != "" {
		objectMap["resultType"] = ctssstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return &ctssstodl, true
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstodl, true
}

// ConnectToSourceSQLServerTaskOutputLoginLevel login level output for the task that validates connection to
// SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputLoginLevel struct {
	// Name - READ-ONLY; Login name.
	Name *string `json:"name,omitempty"`
	// LoginType - READ-ONLY; The type of login. Possible values include: 'WindowsUser', 'WindowsGroup', 'SQLLogin', 'Certificate', 'AsymmetricKey', 'ExternalUser', 'ExternalGroup'
	LoginType LoginType `json:"loginType,omitempty"`
	// DefaultDatabase - READ-ONLY; The default database for the login.
	DefaultDatabase *string `json:"defaultDatabase,omitempty"`
	// IsEnabled - READ-ONLY; The state of the login.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of login for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	ctssstoll.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoll.ResultType != "" {
		objectMap["resultType"] = ctssstoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return &ctssstoll, true
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoll, true
}

// ConnectToSourceSQLServerTaskOutputTaskLevel task level output for the task that validates connection to SQL
// Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// Logins - READ-ONLY; Source logins as a map from login name to login id.
	Logins map[string]*string `json:"Logins"`
	// AgentJobs - READ-ONLY; Source agent jobs as a map from agent job name to id.
	AgentJobs map[string]*string `json:"AgentJobs"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) MarshalJSON() ([]byte, error) {
	ctssstotl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstotl.ResultType != "" {
		objectMap["resultType"] = ctssstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return &ctssstotl, true
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstotl, true
}

// ConnectToSourceSQLServerTaskProperties properties for the task that validates connection to SQL Server and
// also validates source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) MarshalJSON() ([]byte, error) {
	ctssstp.TaskType = TaskTypeConnectToSourceSQLServer
	objectMap := make(map[string]interface{})
	if ctssstp.Input != nil {
		objectMap["input"] = ctssstp.Input
	}
	if ctssstp.TaskType != "" {
		objectMap["taskType"] = ctssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return &ctssstp, true
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerTaskProperties struct.
func (ctssstp *ConnectToSourceSQLServerTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctssstp.State = state
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLDbTaskInput input for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbTaskOutput output for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskOutput.
func (cttsdto ConnectToTargetSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectToTargetSQLDbTaskProperties properties for the task that validates connection to SQL DB and target
// server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	cttsdtp.TaskType = TaskTypeConnectToTargetSQLDb
	objectMap := make(map[string]interface{})
	if cttsdtp.Input != nil {
		objectMap["input"] = cttsdtp.Input
	}
	if cttsdtp.TaskType != "" {
		objectMap["taskType"] = cttsdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return &cttsdtp, true
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsdtp, true
}

// ConnectToTargetSQLMITaskInput input for the task that validates connection to Azure SQL Database Managed
// Instance.
type ConnectToTargetSQLMITaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL Server
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLMITaskOutput output for the task that validates connection to Azure SQL Database Managed
// Instance.
type ConnectToTargetSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// Logins - READ-ONLY; List of logins on the target server.
	Logins *[]string `json:"Logins,omitempty"`
	// AgentJobs - READ-ONLY; List of agent jobs on the target server.
	AgentJobs *[]string `json:"AgentJobs,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetSQLMITaskProperties properties for the task that validates connection to Azure SQL Database
// Managed Instance
type ConnectToTargetSQLMITaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	cttsmtp.TaskType = TaskTypeConnectToTargetAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if cttsmtp.Input != nil {
		objectMap["input"] = cttsmtp.Input
	}
	if cttsmtp.TaskType != "" {
		objectMap["taskType"] = cttsmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return &cttsmtp, true
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsmtp, true
}

// Database information about a single database
type Database struct {
	// ID - Unique identifier for the database
	ID *string `json:"id,omitempty"`
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// CompatibilityLevel - SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// Collation - Collation name of the database
	Collation *string `json:"collation,omitempty"`
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Fqdn - Fully qualified name
	Fqdn *string `json:"fqdn,omitempty"`
	// InstallID - Install id of the database
	InstallID *string `json:"installId,omitempty"`
	// ServerVersion - Version of the server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ServerEdition - Edition of the server
	ServerEdition *string `json:"serverEdition,omitempty"`
	// ServerLevel - Product level of the server (RTM, SP, CTP).
	ServerLevel *string `json:"serverLevel,omitempty"`
	// ServerDefaultDataPath - Default path of the data files
	ServerDefaultDataPath *string `json:"serverDefaultDataPath,omitempty"`
	// ServerDefaultLogPath - Default path of the log files
	ServerDefaultLogPath *string `json:"serverDefaultLogPath,omitempty"`
	// ServerDefaultBackupPath - Default path of the backup folder
	ServerDefaultBackupPath *string `json:"serverDefaultBackupPath,omitempty"`
	// ServerCoreCount - Number of cores on the server
	ServerCoreCount *int32 `json:"serverCoreCount,omitempty"`
	// ServerVisibleOnlineCoreCount - Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32 `json:"serverVisibleOnlineCoreCount,omitempty"`
	// DatabaseState - State of the database. Possible values include: 'Online', 'Restoring', 'Recovering', 'RecoveryPending', 'Suspect', 'Emergency', 'Offline', 'Copying', 'OfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ServerID - The unique Server Id
	ServerID *string `json:"serverId,omitempty"`
}

// DatabaseFileInfo database file specific information
type DatabaseFileInfo struct {
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
	// SizeMB - Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
}

// DatabaseFileInput database file specific information for input
type DatabaseFileInput struct {
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
}

// DatabaseInfo project Database Details
type DatabaseInfo struct {
	// SourceDatabaseName - Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// DatabaseObjectName a representation of the name of an object in a database
type DatabaseObjectName struct {
	// DatabaseName - READ-ONLY; The unescaped name of the database containing the object
	DatabaseName *string `json:"databaseName,omitempty"`
	// ObjectName - READ-ONLY; The unescaped name of the object
	ObjectName *string `json:"objectName,omitempty"`
	// SchemaName - READ-ONLY; The unescaped name of the schema containing the object
	SchemaName *string `json:"schemaName,omitempty"`
	// ObjectType - Type of the object in the database. Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseObjectName.
func (don DatabaseObjectName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if don.ObjectType != "" {
		objectMap["objectType"] = don.ObjectType
	}
	return json.Marshal(objectMap)
}

// DatabaseSummaryResult summary of database results in the migration
type DatabaseSummaryResult struct {
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// DatabaseTable table properties
type DatabaseTable struct {
	// HasRows - READ-ONLY; Indicates whether table is empty or not
	HasRows *bool `json:"hasRows,omitempty"`
	// Name - READ-ONLY; Schema-qualified name of the table
	Name *string `json:"name,omitempty"`
}

// DataIntegrityValidationResult results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// FailedObjects - List of failed table names of source and target pair
	FailedObjects map[string]*string `json:"failedObjects"`
	// ValidationErrors - List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for DataIntegrityValidationResult.
func (divr DataIntegrityValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if divr.FailedObjects != nil {
		objectMap["failedObjects"] = divr.FailedObjects
	}
	if divr.ValidationErrors != nil {
		objectMap["validationErrors"] = divr.ValidationErrors
	}
	return json.Marshal(objectMap)
}

// DataItemMigrationSummaryResult basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// Error migration Task errors
type Error struct {
	// Message - READ-ONLY; Error description
	Message *string `json:"message,omitempty"`
	// Type - Type of error. Possible values include: 'ErrorTypeDefault', 'ErrorTypeWarning', 'ErrorTypeError'
	Type ErrorType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.Type != "" {
		objectMap["type"] = e.Type
	}
	return json.Marshal(objectMap)
}

// ExecutionStatistics description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// ExecutionCount - No. of query executions
	ExecutionCount *int64 `json:"executionCount,omitempty"`
	// CPUTimeMs - CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float64 `json:"cpuTimeMs,omitempty"`
	// ElapsedTimeMs - Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float64 `json:"elapsedTimeMs,omitempty"`
	// WaitStats - Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics `json:"waitStats"`
	// HasErrors - Indicates whether the query resulted in an error
	HasErrors *bool `json:"hasErrors,omitempty"`
	// SQLErrors - List of sql Errors
	SQLErrors *[]string `json:"sqlErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ExecutionStatistics.
func (es ExecutionStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.ExecutionCount != nil {
		objectMap["executionCount"] = es.ExecutionCount
	}
	if es.CPUTimeMs != nil {
		objectMap["cpuTimeMs"] = es.CPUTimeMs
	}
	if es.ElapsedTimeMs != nil {
		objectMap["elapsedTimeMs"] = es.ElapsedTimeMs
	}
	if es.WaitStats != nil {
		objectMap["waitStats"] = es.WaitStats
	}
	if es.HasErrors != nil {
		objectMap["hasErrors"] = es.HasErrors
	}
	if es.SQLErrors != nil {
		objectMap["sqlErrors"] = es.SQLErrors
	}
	return json.Marshal(objectMap)
}

// FileShare file share information with Path, Username, and Password.
type FileShare struct {
	// UserName - User name credential to connect to the share location
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential used to connect to the share location.
	Password *string `json:"password,omitempty"`
	// Path - The folder path for this share.
	Path *string `json:"path,omitempty"`
}

// GetUserTablesSQLTaskInput input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedDatabases - List of database names to collect tables for
	SelectedDatabases *[]string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesSQLTaskOutput output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// DatabasesToTables - READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables map[string][]DatabaseTable `json:"databasesToTables"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskOutput.
func (gutsto GetUserTablesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetUserTablesSQLTaskProperties properties for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gutstp.TaskType = TaskTypeGetUserTablesSQL
	objectMap := make(map[string]interface{})
	if gutstp.Input != nil {
		objectMap["input"] = gutstp.Input
	}
	if gutstp.TaskType != "" {
		objectMap["taskType"] = gutstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return &gutstp, true
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutstp, true
}

// MigrateSQLServerSQLDbDatabaseInput database specific information for SQL to Azure SQL DB migration task
// inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MakeSourceDbReadOnly - Whether to set database read only before migration
	MakeSourceDbReadOnly *bool `json:"makeSourceDbReadOnly,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbDatabaseInput.
func (msssddi MigrateSQLServerSQLDbDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssddi.Name != nil {
		objectMap["name"] = msssddi.Name
	}
	if msssddi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssddi.TargetDatabaseName
	}
	if msssddi.MakeSourceDbReadOnly != nil {
		objectMap["makeSourceDbReadOnly"] = msssddi.MakeSourceDbReadOnly
	}
	if msssddi.TableMap != nil {
		objectMap["tableMap"] = msssddi.TableMap
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbTaskInput input for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type MigrateSQLServerSQLDbTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Options for enabling various post migration validations. Available options,
	//  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
	//  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type BasicMigrateSQLServerSQLDbTaskOutput interface {
	AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool)
	AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool)
}

// MigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeErrorOutput):
		var msssdtoe MigrateSQLServerSQLDbTaskOutputError
		err := json.Unmarshal(body, &msssdtoe)
		return msssdtoe, err
	case string(ResultTypeTableLevelOutput):
		var msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdtotl)
		return msssdtotl, err
	case string(ResultTypeDatabaseLevelOutput):
		var msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdtodl)
		return msssdtodl, err
	case string(ResultTypeMigrationLevelOutput):
		var msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdtoml)
		return msssdtoml, err
	default:
		var msssdto MigrateSQLServerSQLDbTaskOutput
		err := json.Unmarshal(body, &msssdto)
		return msssdto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdtoArray := make([]BasicMigrateSQLServerSQLDbTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdto, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdtoArray[index] = msssdto
	}
	return msssdtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	msssdto.ResultType = ResultTypeMigrateSQLServerSQLDbTaskOutput
	objectMap := make(map[string]interface{})
	if msssdto.ResultType != "" {
		objectMap["resultType"] = msssdto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// MigrateSQLServerSQLDbTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the item
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Migration stage that this database is in. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// NumberOfObjects - READ-ONLY; Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty"`
	// NumberOfObjectsCompleted - READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty"`
	// ErrorCount - READ-ONLY; Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ObjectSummary - READ-ONLY; Summary of object results in the migration
	ObjectSummary map[string]*DataItemMigrationSummaryResult `json:"objectSummary"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdtodl.ResultType = ResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtodl.ResultType != "" {
		objectMap["resultType"] = msssdtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return &msssdtodl, true
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtodl, true
}

// MigrateSQLServerSQLDbTaskOutputError ...
type MigrateSQLServerSQLDbTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdtoe.ResultType = ResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdtoe.ResultType != "" {
		objectMap["resultType"] = msssdtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return &msssdtoe, true
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoe, true
}

// MigrateSQLServerSQLDbTaskOutputMigrationLevel ...
type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DurationInSeconds - READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// StatusMessage - READ-ONLY; Migration status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// DatabaseSummary - READ-ONLY; Summary of database results in the migration
	DatabaseSummary map[string]*DatabaseSummaryResult `json:"databaseSummary"`
	// MigrationReportResult - Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult `json:"migrationReportResult,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdtoml.ResultType = ResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtoml.MigrationReportResult != nil {
		objectMap["migrationReportResult"] = msssdtoml.MigrationReportResult
	}
	if msssdtoml.ResultType != "" {
		objectMap["resultType"] = msssdtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return &msssdtoml, true
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoml, true
}

// MigrateSQLServerSQLDbTaskOutputTableLevel ...
type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// ObjectName - READ-ONLY; Name of the item
	ObjectName *string `json:"objectName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdtotl.ResultType = ResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtotl.ResultType != "" {
		objectMap["resultType"] = msssdtotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return &msssdtotl, true
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtotl, true
}

// MigrateSQLServerSQLDbTaskProperties properties for the task that migrates on-prem SQL Server databases to
// Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	msssdtp.TaskType = TaskTypeMigrateSQLServerSQLDb
	objectMap := make(map[string]interface{})
	if msssdtp.Input != nil {
		objectMap["input"] = msssdtp.Input
	}
	if msssdtp.TaskType != "" {
		objectMap["taskType"] = msssdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return &msssdtp, true
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbTaskProperties struct.
func (msssdtp *MigrateSQLServerSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdtp.State = state
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLMIDatabaseInput database specific information for SQL to Azure SQL DB Managed Instance
// migration task inputs
type MigrateSQLServerSQLMIDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupFileShare - Backup file share information for backing up this database.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
}

// MigrateSQLServerSQLMITaskInput input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// SelectedLogins - Logins to migrate.
	SelectedLogins *[]string `json:"selectedLogins,omitempty"`
	// SelectedAgentJobs - Agent Jobs to migrate.
	SelectedAgentJobs *[]string `json:"selectedAgentJobs,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupBlobShare - SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type BasicMigrateSQLServerSQLMITaskOutput interface {
	AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool)
	AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool)
}

// MigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLMITaskOutput(body []byte) (BasicMigrateSQLServerSQLMITaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput):
		var msssmtoe MigrateSQLServerSQLMITaskOutputError
		err := json.Unmarshal(body, &msssmtoe)
		return msssmtoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput):
		var msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel
		err := json.Unmarshal(body, &msssmtoll)
		return msssmtoll, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput):
		var msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel
		err := json.Unmarshal(body, &msssmtoajl)
		return msssmtoajl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput):
		var msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssmtodl)
		return msssmtodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput):
		var msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssmtoml)
		return msssmtoml, err
	default:
		var msssmto MigrateSQLServerSQLMITaskOutput
		err := json.Unmarshal(body, &msssmto)
		return msssmto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLMITaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssmtoArray := make([]BasicMigrateSQLServerSQLMITaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssmto, err := unmarshalBasicMigrateSQLServerSQLMITaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssmtoArray[index] = msssmto
	}
	return msssmtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) MarshalJSON() ([]byte, error) {
	msssmto.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput
	objectMap := make(map[string]interface{})
	if msssmto.ResultType != "" {
		objectMap["resultType"] = msssmto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// MigrateSQLServerSQLMITaskOutputAgentJobLevel ...
type MigrateSQLServerSQLMITaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; AgentJob name.
	Name *string `json:"name,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original AgentJob.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration errors and warnings per job
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	msssmtoajl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoajl.ResultType != "" {
		objectMap["resultType"] = msssmtoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return &msssmtoajl, true
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoajl, true
}

// MigrateSQLServerSQLMITaskOutputDatabaseLevel ...
type MigrateSQLServerSQLMITaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of migration. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssmtodl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtodl.ResultType != "" {
		objectMap["resultType"] = msssmtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return &msssmtodl, true
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtodl, true
}

// MigrateSQLServerSQLMITaskOutputError ...
type MigrateSQLServerSQLMITaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) MarshalJSON() ([]byte, error) {
	msssmtoe.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssmtoe.ResultType != "" {
		objectMap["resultType"] = msssmtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return &msssmtoe, true
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoe, true
}

// MigrateSQLServerSQLMITaskOutputLoginLevel ...
type MigrateSQLServerSQLMITaskOutputLoginLevel struct {
	// LoginName - READ-ONLY; Login name.
	LoginName *string `json:"loginName,omitempty"`
	// State - READ-ONLY; Current state of login. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of login. Possible values include: 'LoginMigrationStageNone', 'LoginMigrationStageInitialize', 'LoginMigrationStageLoginMigration', 'LoginMigrationStageEstablishUserMapping', 'LoginMigrationStageAssignRoleMembership', 'LoginMigrationStageAssignRoleOwnership', 'LoginMigrationStageEstablishServerPermissions', 'LoginMigrationStageEstablishObjectPermissions', 'LoginMigrationStageCompleted'
	Stage LoginMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Login migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Login migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Login migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Login migration errors and warnings per login
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	msssmtoll.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoll.ResultType != "" {
		objectMap["resultType"] = msssmtoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return &msssmtoll, true
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoll, true
}

// MigrateSQLServerSQLMITaskOutputMigrationLevel ...
type MigrateSQLServerSQLMITaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// AgentJobs - READ-ONLY; Selected agent jobs as a map from name to id
	AgentJobs map[string]*string `json:"agentJobs"`
	// Logins - READ-ONLY; Selected logins as a map from name to id
	Logins map[string]*string `json:"logins"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ServerRoleResults - READ-ONLY; Map of server role migration results.
	ServerRoleResults map[string]*StartMigrationScenarioServerRoleResult `json:"serverRoleResults"`
	// OrphanedUsers - READ-ONLY; Map of users to database name of orphaned users.
	OrphanedUsers map[string]*string `json:"orphanedUsers"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssmtoml.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoml.ResultType != "" {
		objectMap["resultType"] = msssmtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return &msssmtoml, true
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoml, true
}

// MigrateSQLServerSQLMITaskProperties properties for task that migrates SQL Server databases to Azure SQL
// Database Managed Instance
type MigrateSQLServerSQLMITaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	msssmtp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if msssmtp.Input != nil {
		objectMap["input"] = msssmtp.Input
	}
	if msssmtp.TaskType != "" {
		objectMap["taskType"] = msssmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return &msssmtp, true
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssmtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLMITaskProperties struct.
func (msssmtp *MigrateSQLServerSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssmtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssmtp.State = state
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLServerDatabaseInput database specific information for SQL to SQL migration task inputs
type MigrateSQLServerSQLServerDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupFileShare - Backup file share information for this database.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// DatabaseFiles - The list of database files
	DatabaseFiles *[]DatabaseFileInput `json:"databaseFiles,omitempty"`
}

// MigrationEligibilityInfo information about migration eligibility of a server object
type MigrationEligibilityInfo struct {
	// IsEligibleForMigration - READ-ONLY; Whether object is eligible for migration or not.
	IsEligibleForMigration *bool `json:"isEligibleForMigration,omitempty"`
	// ValidationMessages - READ-ONLY; Information about eligibility failure for the server object.
	ValidationMessages *[]string `json:"validationMessages,omitempty"`
}

// MigrationReportResult migration validation report result, contains the url for downloading the generated
// report.
type MigrationReportResult struct {
	// ID - Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// ReportURL - The url of the report.
	ReportURL *string `json:"reportUrl,omitempty"`
}

// MigrationTableMetadata metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// SourceTableName - READ-ONLY; Source table name
	SourceTableName *string `json:"sourceTableName,omitempty"`
	// TargetTableName - READ-ONLY; Target table name
	TargetTableName *string `json:"targetTableName,omitempty"`
}

// MigrationValidationDatabaseLevelResult database level validation results
type MigrationValidationDatabaseLevelResult struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DataIntegrityValidationResult - READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty"`
	// SchemaValidationResult - READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty"`
	// QueryAnalysisValidationResult - READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationDatabaseSummaryResult migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationOptions types of validations to run after the migration
type MigrationValidationOptions struct {
	// EnableSchemaValidation - Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool `json:"enableSchemaValidation,omitempty"`
	// EnableDataIntegrityValidation - Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
	EnableDataIntegrityValidation *bool `json:"enableDataIntegrityValidation,omitempty"`
	// EnableQueryAnalysisValidation - Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool `json:"enableQueryAnalysisValidation,omitempty"`
}

// MigrationValidationResult migration Validation Result
type MigrationValidationResult struct {
	// ID - READ-ONLY; Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SummaryResults - Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults"`
	// Status - READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will be aggregated here. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationValidationResult.
func (mvr MigrationValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mvr.SummaryResults != nil {
		objectMap["summaryResults"] = mvr.SummaryResults
	}
	return json.Marshal(objectMap)
}

// NameAvailabilityRequest a resource type and proposed name
type NameAvailabilityRequest struct {
	// Name - The proposed resource name
	Name *string `json:"name,omitempty"`
	// Type - The resource type chain (e.g. virtualMachines/extensions)
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityResponse indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available, if nameAvailable is false. Possible values include: 'AlreadyExists', 'Invalid'
	Reason NameCheckFailureReason `json:"reason,omitempty"`
	// Message - The localized reason why the name is not available, if nameAvailable is false
	Message *string `json:"message,omitempty"`
}

// ODataError error information in OData format.
type ODataError struct {
	// Code - The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string `json:"code,omitempty"`
	// Message - The human-readable description of the error
	Message *string `json:"message,omitempty"`
	// Details - Inner errors that caused this error
	Details *[]ODataError `json:"details,omitempty"`
}

// Project a project resource
type Project struct {
	autorest.Response `json:"-"`
	// ProjectProperties - Project properties
	*ProjectProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProjectList oData page of project resources
type ProjectList struct {
	autorest.Response `json:"-"`
	// Value - List of projects
	Value *[]Project `json:"value,omitempty"`
	// NextLink - URL to load the next page of projects
	NextLink *string `json:"nextLink,omitempty"`
}

// ProjectListIterator provides access to a complete listing of Project values.
type ProjectListIterator struct {
	i    int
	page ProjectListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProjectListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProjectListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProjectListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProjectListIterator) Response() ProjectList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProjectListIterator) Value() Project {
	if !iter.page.NotDone() {
		return Project{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProjectListIterator type.
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return ProjectListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl ProjectList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pl ProjectList) hasNextLink() bool {
	return pl.NextLink != nil && len(*pl.NextLink) != 0
}

// projectListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl ProjectList) projectListPreparer(ctx context.Context) (*http.Request, error) {
	if !pl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// ProjectListPage contains a page of Project values.
type ProjectListPage struct {
	fn func(context.Context, ProjectList) (ProjectList, error)
	pl ProjectList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProjectListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pl)
		if err != nil {
			return err
		}
		page.pl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProjectListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProjectListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProjectListPage) Response() ProjectList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProjectListPage) Values() []Project {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the ProjectListPage type.
func NewProjectListPage(getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return ProjectListPage{fn: getNextPage}
}

// ProjectMetadata common metadata for migration projects
type ProjectMetadata struct {
	// SourceServerName - READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerPort - READ-ONLY; Source server port number
	SourceServerPort *string `json:"sourceServerPort,omitempty"`
	// SourceUsername - READ-ONLY; Source username
	SourceUsername *string `json:"sourceUsername,omitempty"`
	// TargetServerName - READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetUsername - READ-ONLY; Target username
	TargetUsername *string `json:"targetUsername,omitempty"`
	// TargetDbName - READ-ONLY; Target database name
	TargetDbName *string `json:"targetDbName,omitempty"`
	// TargetUsingWinAuth - READ-ONLY; Whether target connection is Windows authentication
	TargetUsingWinAuth *bool `json:"targetUsingWinAuth,omitempty"`
	// SelectedMigrationTables - READ-ONLY; List of tables selected for migration
	SelectedMigrationTables *[]MigrationTableMetadata `json:"selectedMigrationTables,omitempty"`
}

// ProjectProperties project-specific properties
type ProjectProperties struct {
	// SourcePlatform - Source platform for the project. Possible values include: 'SQL', 'Unknown'
	SourcePlatform ProjectSourcePlatform `json:"sourcePlatform,omitempty"`
	// TargetPlatform - Target platform for the project. Possible values include: 'ProjectTargetPlatformSQLDB', 'ProjectTargetPlatformSQLMI', 'ProjectTargetPlatformUnknown'
	TargetPlatform ProjectTargetPlatform `json:"targetPlatform,omitempty"`
	// CreationTime - READ-ONLY; UTC Date and time when project was created
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo BasicConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo BasicConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// DatabasesInfo - List of DatabaseInfo
	DatabasesInfo *[]DatabaseInfo `json:"databasesInfo,omitempty"`
	// ProvisioningState - READ-ONLY; The project's provisioning state. Possible values include: 'Deleting', 'Succeeded'
	ProvisioningState ProjectProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProjectProperties.
func (pp ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.SourcePlatform != "" {
		objectMap["sourcePlatform"] = pp.SourcePlatform
	}
	if pp.TargetPlatform != "" {
		objectMap["targetPlatform"] = pp.TargetPlatform
	}
	objectMap["sourceConnectionInfo"] = pp.SourceConnectionInfo
	objectMap["targetConnectionInfo"] = pp.TargetConnectionInfo
	if pp.DatabasesInfo != nil {
		objectMap["databasesInfo"] = pp.DatabasesInfo
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProjectProperties struct.
func (pp *ProjectProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sourcePlatform":
			if v != nil {
				var sourcePlatform ProjectSourcePlatform
				err = json.Unmarshal(*v, &sourcePlatform)
				if err != nil {
					return err
				}
				pp.SourcePlatform = sourcePlatform
			}
		case "targetPlatform":
			if v != nil {
				var targetPlatform ProjectTargetPlatform
				err = json.Unmarshal(*v, &targetPlatform)
				if err != nil {
					return err
				}
				pp.TargetPlatform = targetPlatform
			}
		case "creationTime":
			if v != nil {
				var creationTime date.Time
				err = json.Unmarshal(*v, &creationTime)
				if err != nil {
					return err
				}
				pp.CreationTime = &creationTime
			}
		case "sourceConnectionInfo":
			if v != nil {
				sourceConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.SourceConnectionInfo = sourceConnectionInfo
			}
		case "targetConnectionInfo":
			if v != nil {
				targetConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.TargetConnectionInfo = targetConnectionInfo
			}
		case "databasesInfo":
			if v != nil {
				var databasesInfo []DatabaseInfo
				err = json.Unmarshal(*v, &databasesInfo)
				if err != nil {
					return err
				}
				pp.DatabasesInfo = &databasesInfo
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProjectProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				pp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// ProjectTask a task resource
type ProjectTask struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`
	// Properties - Custom task properties
	Properties BasicProjectTaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProjectTask.
func (pt ProjectTask) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pt.Etag != nil {
		objectMap["etag"] = pt.Etag
	}
	objectMap["properties"] = pt.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProjectTask struct.
func (pt *ProjectTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pt.Etag = &etag
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProjectTaskProperties(*v)
				if err != nil {
					return err
				}
				pt.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type BasicProjectTaskProperties interface {
	AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool)
	AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool)
	AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool)
	AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool)
	AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool)
	AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool)
	AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool)
	AsProjectTaskProperties() (*ProjectTaskProperties, bool)
}

// ProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type ProjectTaskProperties struct {
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

func unmarshalBasicProjectTaskProperties(body []byte) (BasicProjectTaskProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["taskType"] {
	case string(TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI):
		var vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &vmisssmtp)
		return vmisssmtp, err
	case string(TaskTypeMigrateSQLServerSQLDb):
		var msssdtp MigrateSQLServerSQLDbTaskProperties
		err := json.Unmarshal(body, &msssdtp)
		return msssdtp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbMI):
		var msssmtp MigrateSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &msssmtp)
		return msssmtp, err
	case string(TaskTypeGetUserTablesSQL):
		var gutstp GetUserTablesSQLTaskProperties
		err := json.Unmarshal(body, &gutstp)
		return gutstp, err
	case string(TaskTypeConnectToTargetSQLDb):
		var cttsdtp ConnectToTargetSQLDbTaskProperties
		err := json.Unmarshal(body, &cttsdtp)
		return cttsdtp, err
	case string(TaskTypeConnectToTargetAzureSQLDbMI):
		var cttsmtp ConnectToTargetSQLMITaskProperties
		err := json.Unmarshal(body, &cttsmtp)
		return cttsmtp, err
	case string(TaskTypeConnectToSourceSQLServer):
		var ctssstp ConnectToSourceSQLServerTaskProperties
		err := json.Unmarshal(body, &ctssstp)
		return ctssstp, err
	default:
		var ptp ProjectTaskProperties
		err := json.Unmarshal(body, &ptp)
		return ptp, err
	}
}
func unmarshalBasicProjectTaskPropertiesArray(body []byte) ([]BasicProjectTaskProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ptpArray := make([]BasicProjectTaskProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ptp, err := unmarshalBasicProjectTaskProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		ptpArray[index] = ptp
	}
	return ptpArray, nil
}

// MarshalJSON is the custom marshaler for ProjectTaskProperties.
func (ptp ProjectTaskProperties) MarshalJSON() ([]byte, error) {
	ptp.TaskType = TaskTypeProjectTaskProperties
	objectMap := make(map[string]interface{})
	if ptp.TaskType != "" {
		objectMap["taskType"] = ptp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return &ptp, true
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ptp, true
}

// QueryAnalysisValidationResult results for query analysis comparison between the source and target
type QueryAnalysisValidationResult struct {
	// QueryResults - List of queries executed and it's execution results in source and target
	QueryResults *QueryExecutionResult `json:"queryResults,omitempty"`
	// ValidationErrors - Errors that are part of the execution
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// QueryExecutionResult describes query analysis results for execution in source and target
type QueryExecutionResult struct {
	// QueryText - Query text retrieved from the source server
	QueryText *string `json:"queryText,omitempty"`
	// StatementsInBatch - Total no. of statements in the batch
	StatementsInBatch *int64 `json:"statementsInBatch,omitempty"`
	// SourceResult - Query analysis result from the source
	SourceResult *ExecutionStatistics `json:"sourceResult,omitempty"`
	// TargetResult - Query analysis result from the target
	TargetResult *ExecutionStatistics `json:"targetResult,omitempty"`
}

// Quota describes a quota for or usage details about a resource
type Quota struct {
	// CurrentValue - The current value of the quota. If null or missing, the current value cannot be determined in the context of the request.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// ID - The resource ID of the quota object
	ID *string `json:"id,omitempty"`
	// Limit - The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage.
	Limit *float64 `json:"limit,omitempty"`
	// Name - The name of the quota
	Name *QuotaName `json:"name,omitempty"`
	// Unit - The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
	Unit *string `json:"unit,omitempty"`
}

// QuotaList oData page of quota objects
type QuotaList struct {
	autorest.Response `json:"-"`
	// Value - List of quotas
	Value *[]Quota `json:"value,omitempty"`
	// NextLink - URL to load the next page of quotas, or null or missing if this is the last page
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaListIterator provides access to a complete listing of Quota values.
type QuotaListIterator struct {
	i    int
	page QuotaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QuotaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QuotaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QuotaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QuotaListIterator) Response() QuotaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QuotaListIterator) Value() Quota {
	if !iter.page.NotDone() {
		return Quota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QuotaListIterator type.
func NewQuotaListIterator(page QuotaListPage) QuotaListIterator {
	return QuotaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ql QuotaList) IsEmpty() bool {
	return ql.Value == nil || len(*ql.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ql QuotaList) hasNextLink() bool {
	return ql.NextLink != nil && len(*ql.NextLink) != 0
}

// quotaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ql QuotaList) quotaListPreparer(ctx context.Context) (*http.Request, error) {
	if !ql.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ql.NextLink)))
}

// QuotaListPage contains a page of Quota values.
type QuotaListPage struct {
	fn func(context.Context, QuotaList) (QuotaList, error)
	ql QuotaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QuotaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ql)
		if err != nil {
			return err
		}
		page.ql = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QuotaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QuotaListPage) NotDone() bool {
	return !page.ql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QuotaListPage) Response() QuotaList {
	return page.ql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QuotaListPage) Values() []Quota {
	if page.ql.IsEmpty() {
		return nil
	}
	return *page.ql.Value
}

// Creates a new instance of the QuotaListPage type.
func NewQuotaListPage(getNextPage func(context.Context, QuotaList) (QuotaList, error)) QuotaListPage {
	return QuotaListPage{fn: getNextPage}
}

// QuotaName the name of the quota
type QuotaName struct {
	// LocalizedValue - The localized name of the quota
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - The unlocalized name (or ID) of the quota
	Value *string `json:"value,omitempty"`
}

// ReportableException exception object for all custom exceptions
type ReportableException struct {
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// FilePath - The path to the file where exception occurred
	FilePath *string `json:"filePath,omitempty"`
	// LineNumber - The line number where exception occurred
	LineNumber *string `json:"lineNumber,omitempty"`
	// HResult - Coded numerical value that is assigned to a specific exception
	HResult *int32 `json:"hResult,omitempty"`
	// StackTrace - Stack trace
	StackTrace *string `json:"stackTrace,omitempty"`
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceSku describes an available DMS SKU.
type ResourceSku struct {
	// ResourceType - READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; Specifies the tier of DMS in a scale set.
	Tier *string `json:"tier,omitempty"`
	// Size - READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty"`
	// Kind - READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`
	// Capacity - READ-ONLY; Not used.
	Capacity *ResourceSkuCapacity `json:"capacity,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// APIVersions - READ-ONLY; The api versions that support this SKU.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Costs - READ-ONLY; Metadata for retrieving price info.
	Costs *[]ResourceSkuCosts `json:"costs,omitempty"`
	// Capabilities - READ-ONLY; A name value pair to describe the capability.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities describes The SKU capabilities object.
type ResourceSkuCapabilities struct {
	// Name - READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCapacity describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	// Minimum - READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum capacity.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default capacity.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - READ-ONLY; The scale type applicable to the SKU. Possible values include: 'ResourceSkuCapacityScaleTypeAutomatic', 'ResourceSkuCapacityScaleTypeManual', 'ResourceSkuCapacityScaleTypeNone'
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// ResourceSkuCosts describes metadata for retrieving price info.
type ResourceSkuCosts struct {
	// MeterID - READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty"`
	// Quantity - READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty"`
	// ExtendedUnit - READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// ResourceSkuRestrictions describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	// Type - READ-ONLY; The type of restrictions. Possible values include: 'Location'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - READ-ONLY; The reason code for restriction. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkusResult the DMS List SKUs operation response.
type ResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKUs available for the subscription.
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of DMS SKUs. Call ListNext() with this to fetch the next page of DMS SKUs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkusResultIterator provides access to a complete listing of ResourceSku values.
type ResourceSkusResultIterator struct {
	i    int
	page ResourceSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkusResultIterator) Response() ResourceSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkusResultIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkusResultIterator type.
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return ResourceSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsr ResourceSkusResult) IsEmpty() bool {
	return rsr.Value == nil || len(*rsr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rsr ResourceSkusResult) hasNextLink() bool {
	return rsr.NextLink != nil && len(*rsr.NextLink) != 0
}

// resourceSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsr ResourceSkusResult) resourceSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rsr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsr.NextLink)))
}

// ResourceSkusResultPage contains a page of ResourceSku values.
type ResourceSkusResultPage struct {
	fn  func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)
	rsr ResourceSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rsr)
		if err != nil {
			return err
		}
		page.rsr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkusResultPage) NotDone() bool {
	return !page.rsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkusResultPage) Response() ResourceSkusResult {
	return page.rsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkusResultPage) Values() []ResourceSku {
	if page.rsr.IsEmpty() {
		return nil
	}
	return *page.rsr.Value
}

// Creates a new instance of the ResourceSkusResultPage type.
func NewResourceSkusResultPage(getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return ResourceSkusResultPage{fn: getNextPage}
}

// SchemaComparisonValidationResult results for schema comparison between the source and target
type SchemaComparisonValidationResult struct {
	// SchemaDifferences - List of schema differences between the source and target databases
	SchemaDifferences *SchemaComparisonValidationResultType `json:"schemaDifferences,omitempty"`
	// ValidationErrors - List of errors that happened while performing schema compare validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
	// SourceDatabaseObjectCount - Count of source database objects
	SourceDatabaseObjectCount map[string]*int64 `json:"sourceDatabaseObjectCount"`
	// TargetDatabaseObjectCount - Count of target database objects
	TargetDatabaseObjectCount map[string]*int64 `json:"targetDatabaseObjectCount"`
}

// MarshalJSON is the custom marshaler for SchemaComparisonValidationResult.
func (scvr SchemaComparisonValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scvr.SchemaDifferences != nil {
		objectMap["schemaDifferences"] = scvr.SchemaDifferences
	}
	if scvr.ValidationErrors != nil {
		objectMap["validationErrors"] = scvr.ValidationErrors
	}
	if scvr.SourceDatabaseObjectCount != nil {
		objectMap["sourceDatabaseObjectCount"] = scvr.SourceDatabaseObjectCount
	}
	if scvr.TargetDatabaseObjectCount != nil {
		objectMap["targetDatabaseObjectCount"] = scvr.TargetDatabaseObjectCount
	}
	return json.Marshal(objectMap)
}

// SchemaComparisonValidationResultType description about the errors happen while performing migration
// validation
type SchemaComparisonValidationResultType struct {
	// ObjectName - Name of the object that has the difference
	ObjectName *string `json:"objectName,omitempty"`
	// ObjectType - Type of the object that has the difference. e.g (Table/View/StoredProcedure). Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
	// UpdateAction - Update action type with respect to target. Possible values include: 'DeletedOnTarget', 'ChangedOnTarget', 'AddedOnTarget'
	UpdateAction UpdateActionType `json:"updateAction,omitempty"`
}

// Service a Data Migration Service resource
type Service struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. Ignored if submitted
	Etag *string `json:"etag,omitempty"`
	// Kind - The resource kind. Only 'vm' (the default) is supported.
	Kind *string `json:"kind,omitempty"`
	// ServiceProperties - Custom service properties
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - Service SKU
	Sku *ServiceSku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceList oData page of service objects
type ServiceList struct {
	autorest.Response `json:"-"`
	// Value - List of services
	Value *[]Service `json:"value,omitempty"`
	// NextLink - URL to load the next page of services
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListIterator provides access to a complete listing of Service values.
type ServiceListIterator struct {
	i    int
	page ServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListIterator) Response() ServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListIterator type.
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return ServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ServiceList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl ServiceList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// serviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ServiceList) serviceListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ServiceListPage contains a page of Service values.
type ServiceListPage struct {
	fn func(context.Context, ServiceList) (ServiceList, error)
	sl ServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListPage) Response() ServiceList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListPage) Values() []Service {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ServiceListPage type.
func NewServiceListPage(getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return ServiceListPage{fn: getNextPage}
}

// ServiceOperation description of an action supported by the Data Migration Service
type ServiceOperation struct {
	// Name - The fully qualified action name, e.g. Microsoft.DataMigration/services/read
	Name *string `json:"name,omitempty"`
	// Display - Localized display text
	Display *ServiceOperationDisplay `json:"display,omitempty"`
}

// ServiceOperationDisplay localized display text
type ServiceOperationDisplay struct {
	// Provider - The localized resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized resource type name
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized operation name
	Operation *string `json:"operation,omitempty"`
	// Description - The localized operation description
	Description *string `json:"description,omitempty"`
}

// ServiceOperationList oData page of action (operation) objects
type ServiceOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of actions
	Value *[]ServiceOperation `json:"value,omitempty"`
	// NextLink - URL to load the next page of actions
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceOperationListIterator provides access to a complete listing of ServiceOperation values.
type ServiceOperationListIterator struct {
	i    int
	page ServiceOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceOperationListIterator) Response() ServiceOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceOperationListIterator) Value() ServiceOperation {
	if !iter.page.NotDone() {
		return ServiceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceOperationListIterator type.
func NewServiceOperationListIterator(page ServiceOperationListPage) ServiceOperationListIterator {
	return ServiceOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sol ServiceOperationList) IsEmpty() bool {
	return sol.Value == nil || len(*sol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sol ServiceOperationList) hasNextLink() bool {
	return sol.NextLink != nil && len(*sol.NextLink) != 0
}

// serviceOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sol ServiceOperationList) serviceOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if !sol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sol.NextLink)))
}

// ServiceOperationListPage contains a page of ServiceOperation values.
type ServiceOperationListPage struct {
	fn  func(context.Context, ServiceOperationList) (ServiceOperationList, error)
	sol ServiceOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sol)
		if err != nil {
			return err
		}
		page.sol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceOperationListPage) NotDone() bool {
	return !page.sol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceOperationListPage) Response() ServiceOperationList {
	return page.sol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceOperationListPage) Values() []ServiceOperation {
	if page.sol.IsEmpty() {
		return nil
	}
	return *page.sol.Value
}

// Creates a new instance of the ServiceOperationListPage type.
func NewServiceOperationListPage(getNextPage func(context.Context, ServiceOperationList) (ServiceOperationList, error)) ServiceOperationListPage {
	return ServiceOperationListPage{fn: getNextPage}
}

// ServiceProperties properties of the Data Migration service instance
type ServiceProperties struct {
	// ProvisioningState - READ-ONLY; The resource's provisioning state. Possible values include: 'ServiceProvisioningStateAccepted', 'ServiceProvisioningStateDeleting', 'ServiceProvisioningStateDeploying', 'ServiceProvisioningStateStopped', 'ServiceProvisioningStateStopping', 'ServiceProvisioningStateStarting', 'ServiceProvisioningStateFailedToStart', 'ServiceProvisioningStateFailedToStop', 'ServiceProvisioningStateSucceeded', 'ServiceProvisioningStateFailed'
	ProvisioningState ServiceProvisioningState `json:"provisioningState,omitempty"`
	// PublicKey - The public key of the service, used to encrypt secrets sent to the service
	PublicKey *string `json:"publicKey,omitempty"`
	// VirtualSubnetID - The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
	VirtualSubnetID *string `json:"virtualSubnetId,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.PublicKey != nil {
		objectMap["publicKey"] = sp.PublicKey
	}
	if sp.VirtualSubnetID != nil {
		objectMap["virtualSubnetId"] = sp.VirtualSubnetID
	}
	return json.Marshal(objectMap)
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesCreateOrUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesDeleteFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSku an Azure SKU instance
type ServiceSku struct {
	// Name - The unique name of the SKU, such as 'P3'
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
	Tier *string `json:"tier,omitempty"`
	// Family - The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
	Family *string `json:"family,omitempty"`
	// Size - The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
	Size *string `json:"size,omitempty"`
	// Capacity - The capacity of the SKU, if it supports scaling
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServiceSkuList oData page of available SKUs
type ServiceSkuList struct {
	autorest.Response `json:"-"`
	// Value - List of service SKUs
	Value *[]AvailableServiceSku `json:"value,omitempty"`
	// NextLink - URL to load the next page of service SKUs
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceSkuListIterator provides access to a complete listing of AvailableServiceSku values.
type ServiceSkuListIterator struct {
	i    int
	page ServiceSkuListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceSkuListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceSkuListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceSkuListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceSkuListIterator) Response() ServiceSkuList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceSkuListIterator) Value() AvailableServiceSku {
	if !iter.page.NotDone() {
		return AvailableServiceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceSkuListIterator type.
func NewServiceSkuListIterator(page ServiceSkuListPage) ServiceSkuListIterator {
	return ServiceSkuListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl ServiceSkuList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssl ServiceSkuList) hasNextLink() bool {
	return ssl.NextLink != nil && len(*ssl.NextLink) != 0
}

// serviceSkuListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl ServiceSkuList) serviceSkuListPreparer(ctx context.Context) (*http.Request, error) {
	if !ssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// ServiceSkuListPage contains a page of AvailableServiceSku values.
type ServiceSkuListPage struct {
	fn  func(context.Context, ServiceSkuList) (ServiceSkuList, error)
	ssl ServiceSkuList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceSkuListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssl)
		if err != nil {
			return err
		}
		page.ssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceSkuListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceSkuListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceSkuListPage) Response() ServiceSkuList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceSkuListPage) Values() []AvailableServiceSku {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// Creates a new instance of the ServiceSkuListPage type.
func NewServiceSkuListPage(getNextPage func(context.Context, ServiceSkuList) (ServiceSkuList, error)) ServiceSkuListPage {
	return ServiceSkuListPage{fn: getNextPage}
}

// ServicesStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStartFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStopFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceStatusResponse service health status
type ServiceStatusResponse struct {
	autorest.Response `json:"-"`
	// AgentVersion - The DMS instance agent version
	AgentVersion *string `json:"agentVersion,omitempty"`
	// Status - The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
	Status *string `json:"status,omitempty"`
	// VMSize - The services virtual machine size, such as 'Standard_D2_v2'
	VMSize *string `json:"vmSize,omitempty"`
	// SupportedTaskTypes - The list of supported task types
	SupportedTaskTypes *[]string `json:"supportedTaskTypes,omitempty"`
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLConnectionInfo information for connecting to SQL database server
type SQLConnectionInfo struct {
	// DataSource - Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
	DataSource *string `json:"dataSource,omitempty"`
	// Authentication - Authentication type to use for connection. Possible values include: 'None', 'WindowsAuthentication', 'SQLAuthentication', 'ActiveDirectoryIntegrated', 'ActiveDirectoryPassword'
	Authentication AuthenticationType `json:"authentication,omitempty"`
	// EncryptConnection - Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`
	// AdditionalSettings - Additional connection settings
	AdditionalSettings *string `json:"additionalSettings,omitempty"`
	// TrustServerCertificate - Whether to trust the server certificate
	TrustServerCertificate *bool `json:"trustServerCertificate,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLConnectionInfo.
func (sci SQLConnectionInfo) MarshalJSON() ([]byte, error) {
	sci.Type = TypeSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if sci.DataSource != nil {
		objectMap["dataSource"] = sci.DataSource
	}
	if sci.Authentication != "" {
		objectMap["authentication"] = sci.Authentication
	}
	if sci.EncryptConnection != nil {
		objectMap["encryptConnection"] = sci.EncryptConnection
	}
	if sci.AdditionalSettings != nil {
		objectMap["additionalSettings"] = sci.AdditionalSettings
	}
	if sci.TrustServerCertificate != nil {
		objectMap["trustServerCertificate"] = sci.TrustServerCertificate
	}
	if sci.UserName != nil {
		objectMap["userName"] = sci.UserName
	}
	if sci.Password != nil {
		objectMap["password"] = sci.Password
	}
	if sci.Type != "" {
		objectMap["type"] = sci.Type
	}
	return json.Marshal(objectMap)
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return &sci, true
}

// AsConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &sci, true
}

// SQLMigrationTaskInput base class for migration task input
type SQLMigrationTaskInput struct {
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// StartMigrationScenarioServerRoleResult server role migration result
type StartMigrationScenarioServerRoleResult struct {
	// Name - READ-ONLY; Name of server role.
	Name *string `json:"name,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
}

// TaskList oData page of tasks
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - List of tasks
	Value *[]ProjectTask `json:"value,omitempty"`
	// NextLink - URL to load the next page of tasks
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListIterator provides access to a complete listing of ProjectTask values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() ProjectTask {
	if !iter.page.NotDone() {
		return ProjectTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TaskList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of ProjectTask values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []ProjectTask {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{fn: getNextPage}
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// ValidateMigrationInputSQLServerSQLMITaskInput input for task that validates migration input for SQL to Azure
// SQL Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskInput struct {
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupBlobShare - SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMITaskOutput output for task that validates migration input for SQL to
// Azure SQL Managed Instance migrations
type ValidateMigrationInputSQLServerSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseNameErrors - READ-ONLY; Errors associated with the RestoreDatabaseName
	RestoreDatabaseNameErrors *[]ReportableException `json:"restoreDatabaseNameErrors,omitempty"`
	// BackupFolderErrors - READ-ONLY; Errors associated with the BackupFolder path
	BackupFolderErrors *[]ReportableException `json:"backupFolderErrors,omitempty"`
	// BackupShareCredentialsErrors - READ-ONLY; Errors associated with backup share user name and password credentials
	BackupShareCredentialsErrors *[]ReportableException `json:"backupShareCredentialsErrors,omitempty"`
	// BackupStorageAccountErrors - READ-ONLY; Errors associated with the storage account provided.
	BackupStorageAccountErrors *[]ReportableException `json:"backupStorageAccountErrors,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMITaskProperties properties for task that validates migration input for
// SQL to Azure SQL Database Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskProperties struct {
	// Input - Task input
	Input *ValidateMigrationInputSQLServerSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ValidateMigrationInputSQLServerSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	vmisssmtp.TaskType = TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if vmisssmtp.Input != nil {
		objectMap["input"] = vmisssmtp.Input
	}
	if vmisssmtp.TaskType != "" {
		objectMap["taskType"] = vmisssmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return &vmisssmtp, true
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &vmisssmtp, true
}

// ValidationError description about the errors happen while performing migration validation
type ValidationError struct {
	// Text - Error Text
	Text *string `json:"text,omitempty"`
	// Severity - Severity of the error. Possible values include: 'SeverityMessage', 'SeverityWarning', 'SeverityError'
	Severity Severity `json:"severity,omitempty"`
}

// WaitStatistics wait statistics gathered during query batch execution
type WaitStatistics struct {
	// WaitType - Type of the Wait
	WaitType *string `json:"waitType,omitempty"`
	// WaitTimeMs - Total wait time in millisecond(s)
	WaitTimeMs *float64 `json:"waitTimeMs,omitempty"`
	// WaitCount - Total no. of waits
	WaitCount *int64 `json:"waitCount,omitempty"`
}
