package avs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// Cancelled ...
	Cancelled ClusterProvisioningState = "Cancelled"
	// Failed ...
	Failed ClusterProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ClusterProvisioningState = "Succeeded"
	// Updating ...
	Updating ClusterProvisioningState = "Updating"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{Cancelled, Failed, Succeeded, Updating}
}

// InternetEnum enumerates the values for internet enum.
type InternetEnum string

const (
	// Disabled ...
	Disabled InternetEnum = "Disabled"
	// Enabled ...
	Enabled InternetEnum = "Enabled"
)

// PossibleInternetEnumValues returns an array of possible values for the InternetEnum const type.
func PossibleInternetEnumValues() []InternetEnum {
	return []InternetEnum{Disabled, Enabled}
}

// PrivateCloudProvisioningState enumerates the values for private cloud provisioning state.
type PrivateCloudProvisioningState string

const (
	// PrivateCloudProvisioningStateBuilding ...
	PrivateCloudProvisioningStateBuilding PrivateCloudProvisioningState = "Building"
	// PrivateCloudProvisioningStateCancelled ...
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = "Cancelled"
	// PrivateCloudProvisioningStateFailed ...
	PrivateCloudProvisioningStateFailed PrivateCloudProvisioningState = "Failed"
	// PrivateCloudProvisioningStatePending ...
	PrivateCloudProvisioningStatePending PrivateCloudProvisioningState = "Pending"
	// PrivateCloudProvisioningStateSucceeded ...
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = "Succeeded"
	// PrivateCloudProvisioningStateUpdating ...
	PrivateCloudProvisioningStateUpdating PrivateCloudProvisioningState = "Updating"
)

// PossiblePrivateCloudProvisioningStateValues returns an array of possible values for the PrivateCloudProvisioningState const type.
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return []PrivateCloudProvisioningState{PrivateCloudProvisioningStateBuilding, PrivateCloudProvisioningStateCancelled, PrivateCloudProvisioningStateFailed, PrivateCloudProvisioningStatePending, PrivateCloudProvisioningStateSucceeded, PrivateCloudProvisioningStateUpdating}
}

// QuotaEnabled enumerates the values for quota enabled.
type QuotaEnabled string

const (
	// QuotaEnabledDisabled ...
	QuotaEnabledDisabled QuotaEnabled = "Disabled"
	// QuotaEnabledEnabled ...
	QuotaEnabledEnabled QuotaEnabled = "Enabled"
)

// PossibleQuotaEnabledValues returns an array of possible values for the QuotaEnabled const type.
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return []QuotaEnabled{QuotaEnabledDisabled, QuotaEnabledEnabled}
}

// SslEnum enumerates the values for ssl enum.
type SslEnum string

const (
	// SslEnumDisabled ...
	SslEnumDisabled SslEnum = "Disabled"
	// SslEnumEnabled ...
	SslEnumEnabled SslEnum = "Enabled"
)

// PossibleSslEnumValues returns an array of possible values for the SslEnum const type.
func PossibleSslEnumValues() []SslEnum {
	return []SslEnum{SslEnumDisabled, SslEnumEnabled}
}

// Status enumerates the values for status.
type Status string

const (
	// TrialAvailable ...
	TrialAvailable Status = "TrialAvailable"
	// TrialDisabled ...
	TrialDisabled Status = "TrialDisabled"
	// TrialUsed ...
	TrialUsed Status = "TrialUsed"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{TrialAvailable, TrialDisabled, TrialUsed}
}
