package devices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// DeviceConnect ...
	DeviceConnect AccessRights = "DeviceConnect"
	// RegistryRead ...
	RegistryRead AccessRights = "RegistryRead"
	// RegistryReadDeviceConnect ...
	RegistryReadDeviceConnect AccessRights = "RegistryRead, DeviceConnect"
	// RegistryReadRegistryWrite ...
	RegistryReadRegistryWrite AccessRights = "RegistryRead, RegistryWrite"
	// RegistryReadRegistryWriteDeviceConnect ...
	RegistryReadRegistryWriteDeviceConnect AccessRights = "RegistryRead, RegistryWrite, DeviceConnect"
	// RegistryReadRegistryWriteServiceConnect ...
	RegistryReadRegistryWriteServiceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect"
	// RegistryReadRegistryWriteServiceConnectDeviceConnect ...
	RegistryReadRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"
	// RegistryReadServiceConnect ...
	RegistryReadServiceConnect AccessRights = "RegistryRead, ServiceConnect"
	// RegistryReadServiceConnectDeviceConnect ...
	RegistryReadServiceConnectDeviceConnect AccessRights = "RegistryRead, ServiceConnect, DeviceConnect"
	// RegistryWrite ...
	RegistryWrite AccessRights = "RegistryWrite"
	// RegistryWriteDeviceConnect ...
	RegistryWriteDeviceConnect AccessRights = "RegistryWrite, DeviceConnect"
	// RegistryWriteServiceConnect ...
	RegistryWriteServiceConnect AccessRights = "RegistryWrite, ServiceConnect"
	// RegistryWriteServiceConnectDeviceConnect ...
	RegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryWrite, ServiceConnect, DeviceConnect"
	// ServiceConnect ...
	ServiceConnect AccessRights = "ServiceConnect"
	// ServiceConnectDeviceConnect ...
	ServiceConnectDeviceConnect AccessRights = "ServiceConnect, DeviceConnect"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{DeviceConnect, RegistryRead, RegistryReadDeviceConnect, RegistryReadRegistryWrite, RegistryReadRegistryWriteDeviceConnect, RegistryReadRegistryWriteServiceConnect, RegistryReadRegistryWriteServiceConnectDeviceConnect, RegistryReadServiceConnect, RegistryReadServiceConnectDeviceConnect, RegistryWrite, RegistryWriteDeviceConnect, RegistryWriteServiceConnect, RegistryWriteServiceConnectDeviceConnect, ServiceConnect, ServiceConnectDeviceConnect}
}

// Capabilities enumerates the values for capabilities.
type Capabilities string

const (
	// DeviceManagement ...
	DeviceManagement Capabilities = "DeviceManagement"
	// None ...
	None Capabilities = "None"
)

// PossibleCapabilitiesValues returns an array of possible values for the Capabilities const type.
func PossibleCapabilitiesValues() []Capabilities {
	return []Capabilities{DeviceManagement, None}
}

// IotHubNameUnavailabilityReason enumerates the values for iot hub name unavailability reason.
type IotHubNameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists IotHubNameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid IotHubNameUnavailabilityReason = "Invalid"
)

// PossibleIotHubNameUnavailabilityReasonValues returns an array of possible values for the IotHubNameUnavailabilityReason const type.
func PossibleIotHubNameUnavailabilityReasonValues() []IotHubNameUnavailabilityReason {
	return []IotHubNameUnavailabilityReason{AlreadyExists, Invalid}
}

// IotHubScaleType enumerates the values for iot hub scale type.
type IotHubScaleType string

const (
	// IotHubScaleTypeAutomatic ...
	IotHubScaleTypeAutomatic IotHubScaleType = "Automatic"
	// IotHubScaleTypeManual ...
	IotHubScaleTypeManual IotHubScaleType = "Manual"
	// IotHubScaleTypeNone ...
	IotHubScaleTypeNone IotHubScaleType = "None"
)

// PossibleIotHubScaleTypeValues returns an array of possible values for the IotHubScaleType const type.
func PossibleIotHubScaleTypeValues() []IotHubScaleType {
	return []IotHubScaleType{IotHubScaleTypeAutomatic, IotHubScaleTypeManual, IotHubScaleTypeNone}
}

// IotHubSku enumerates the values for iot hub sku.
type IotHubSku string

const (
	// F1 ...
	F1 IotHubSku = "F1"
	// S1 ...
	S1 IotHubSku = "S1"
	// S2 ...
	S2 IotHubSku = "S2"
	// S3 ...
	S3 IotHubSku = "S3"
)

// PossibleIotHubSkuValues returns an array of possible values for the IotHubSku const type.
func PossibleIotHubSkuValues() []IotHubSku {
	return []IotHubSku{F1, S1, S2, S3}
}

// IotHubSkuTier enumerates the values for iot hub sku tier.
type IotHubSkuTier string

const (
	// Free ...
	Free IotHubSkuTier = "Free"
	// Standard ...
	Standard IotHubSkuTier = "Standard"
)

// PossibleIotHubSkuTierValues returns an array of possible values for the IotHubSkuTier const type.
func PossibleIotHubSkuTierValues() []IotHubSkuTier {
	return []IotHubSkuTier{Free, Standard}
}

// IPFilterActionType enumerates the values for ip filter action type.
type IPFilterActionType string

const (
	// Accept ...
	Accept IPFilterActionType = "Accept"
	// Reject ...
	Reject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns an array of possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{Accept, Reject}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Cancelled ...
	Cancelled JobStatus = "cancelled"
	// Completed ...
	Completed JobStatus = "completed"
	// Enqueued ...
	Enqueued JobStatus = "enqueued"
	// Failed ...
	Failed JobStatus = "failed"
	// Running ...
	Running JobStatus = "running"
	// Unknown ...
	Unknown JobStatus = "unknown"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{Cancelled, Completed, Enqueued, Failed, Running, Unknown}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "backup"
	// JobTypeExport ...
	JobTypeExport JobType = "export"
	// JobTypeFactoryResetDevice ...
	JobTypeFactoryResetDevice JobType = "factoryResetDevice"
	// JobTypeFirmwareUpdate ...
	JobTypeFirmwareUpdate JobType = "firmwareUpdate"
	// JobTypeImport ...
	JobTypeImport JobType = "import"
	// JobTypeReadDeviceProperties ...
	JobTypeReadDeviceProperties JobType = "readDeviceProperties"
	// JobTypeRebootDevice ...
	JobTypeRebootDevice JobType = "rebootDevice"
	// JobTypeUnknown ...
	JobTypeUnknown JobType = "unknown"
	// JobTypeUpdateDeviceConfiguration ...
	JobTypeUpdateDeviceConfiguration JobType = "updateDeviceConfiguration"
	// JobTypeWriteDeviceProperties ...
	JobTypeWriteDeviceProperties JobType = "writeDeviceProperties"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeExport, JobTypeFactoryResetDevice, JobTypeFirmwareUpdate, JobTypeImport, JobTypeReadDeviceProperties, JobTypeRebootDevice, JobTypeUnknown, JobTypeUpdateDeviceConfiguration, JobTypeWriteDeviceProperties}
}

// OperationMonitoringLevel enumerates the values for operation monitoring level.
type OperationMonitoringLevel string

const (
	// OperationMonitoringLevelError ...
	OperationMonitoringLevelError OperationMonitoringLevel = "Error"
	// OperationMonitoringLevelErrorInformation ...
	OperationMonitoringLevelErrorInformation OperationMonitoringLevel = "Error, Information"
	// OperationMonitoringLevelInformation ...
	OperationMonitoringLevelInformation OperationMonitoringLevel = "Information"
	// OperationMonitoringLevelNone ...
	OperationMonitoringLevelNone OperationMonitoringLevel = "None"
)

// PossibleOperationMonitoringLevelValues returns an array of possible values for the OperationMonitoringLevel const type.
func PossibleOperationMonitoringLevelValues() []OperationMonitoringLevel {
	return []OperationMonitoringLevel{OperationMonitoringLevelError, OperationMonitoringLevelErrorInformation, OperationMonitoringLevelInformation, OperationMonitoringLevelNone}
}

// RoutingSource enumerates the values for routing source.
type RoutingSource string

const (
	// DeviceJobLifecycleEvents ...
	DeviceJobLifecycleEvents RoutingSource = "DeviceJobLifecycleEvents"
	// DeviceLifecycleEvents ...
	DeviceLifecycleEvents RoutingSource = "DeviceLifecycleEvents"
	// DeviceMessages ...
	DeviceMessages RoutingSource = "DeviceMessages"
	// TwinChangeEvents ...
	TwinChangeEvents RoutingSource = "TwinChangeEvents"
)

// PossibleRoutingSourceValues returns an array of possible values for the RoutingSource const type.
func PossibleRoutingSourceValues() []RoutingSource {
	return []RoutingSource{DeviceJobLifecycleEvents, DeviceLifecycleEvents, DeviceMessages, TwinChangeEvents}
}
