package hybriddata

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// IsJobCancellable enumerates the values for is job cancellable.
type IsJobCancellable string

const (
	// Cancellable ...
	Cancellable IsJobCancellable = "Cancellable"
	// NotCancellable ...
	NotCancellable IsJobCancellable = "NotCancellable"
)

// PossibleIsJobCancellableValues returns an array of possible values for the IsJobCancellable const type.
func PossibleIsJobCancellableValues() []IsJobCancellable {
	return []IsJobCancellable{Cancellable, NotCancellable}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Cancelled ...
	Cancelled JobStatus = "Cancelled"
	// Cancelling ...
	Cancelling JobStatus = "Cancelling"
	// Failed ...
	Failed JobStatus = "Failed"
	// InProgress ...
	InProgress JobStatus = "InProgress"
	// None ...
	None JobStatus = "None"
	// Succeeded ...
	Succeeded JobStatus = "Succeeded"
	// WaitingForAction ...
	WaitingForAction JobStatus = "WaitingForAction"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{Cancelled, Cancelling, Failed, InProgress, None, Succeeded, WaitingForAction}
}

// RunLocation enumerates the values for run location.
type RunLocation string

const (
	// RunLocationAustraliaeast ...
	RunLocationAustraliaeast RunLocation = "australiaeast"
	// RunLocationAustraliasoutheast ...
	RunLocationAustraliasoutheast RunLocation = "australiasoutheast"
	// RunLocationBrazilsouth ...
	RunLocationBrazilsouth RunLocation = "brazilsouth"
	// RunLocationCanadacentral ...
	RunLocationCanadacentral RunLocation = "canadacentral"
	// RunLocationCanadaeast ...
	RunLocationCanadaeast RunLocation = "canadaeast"
	// RunLocationCentralindia ...
	RunLocationCentralindia RunLocation = "centralindia"
	// RunLocationCentralus ...
	RunLocationCentralus RunLocation = "centralus"
	// RunLocationEastasia ...
	RunLocationEastasia RunLocation = "eastasia"
	// RunLocationEastus ...
	RunLocationEastus RunLocation = "eastus"
	// RunLocationEastus2 ...
	RunLocationEastus2 RunLocation = "eastus2"
	// RunLocationJapaneast ...
	RunLocationJapaneast RunLocation = "japaneast"
	// RunLocationJapanwest ...
	RunLocationJapanwest RunLocation = "japanwest"
	// RunLocationKoreacentral ...
	RunLocationKoreacentral RunLocation = "koreacentral"
	// RunLocationKoreasouth ...
	RunLocationKoreasouth RunLocation = "koreasouth"
	// RunLocationNone ...
	RunLocationNone RunLocation = "none"
	// RunLocationNorthcentralus ...
	RunLocationNorthcentralus RunLocation = "northcentralus"
	// RunLocationNortheurope ...
	RunLocationNortheurope RunLocation = "northeurope"
	// RunLocationSouthcentralus ...
	RunLocationSouthcentralus RunLocation = "southcentralus"
	// RunLocationSoutheastasia ...
	RunLocationSoutheastasia RunLocation = "southeastasia"
	// RunLocationSouthindia ...
	RunLocationSouthindia RunLocation = "southindia"
	// RunLocationUksouth ...
	RunLocationUksouth RunLocation = "uksouth"
	// RunLocationUkwest ...
	RunLocationUkwest RunLocation = "ukwest"
	// RunLocationWestcentralus ...
	RunLocationWestcentralus RunLocation = "westcentralus"
	// RunLocationWesteurope ...
	RunLocationWesteurope RunLocation = "westeurope"
	// RunLocationWestindia ...
	RunLocationWestindia RunLocation = "westindia"
	// RunLocationWestus ...
	RunLocationWestus RunLocation = "westus"
	// RunLocationWestus2 ...
	RunLocationWestus2 RunLocation = "westus2"
)

// PossibleRunLocationValues returns an array of possible values for the RunLocation const type.
func PossibleRunLocationValues() []RunLocation {
	return []RunLocation{RunLocationAustraliaeast, RunLocationAustraliasoutheast, RunLocationBrazilsouth, RunLocationCanadacentral, RunLocationCanadaeast, RunLocationCentralindia, RunLocationCentralus, RunLocationEastasia, RunLocationEastus, RunLocationEastus2, RunLocationJapaneast, RunLocationJapanwest, RunLocationKoreacentral, RunLocationKoreasouth, RunLocationNone, RunLocationNorthcentralus, RunLocationNortheurope, RunLocationSouthcentralus, RunLocationSoutheastasia, RunLocationSouthindia, RunLocationUksouth, RunLocationUkwest, RunLocationWestcentralus, RunLocationWesteurope, RunLocationWestindia, RunLocationWestus, RunLocationWestus2}
}

// State enumerates the values for state.
type State string

const (
	// Disabled ...
	Disabled State = "Disabled"
	// Enabled ...
	Enabled State = "Enabled"
	// Supported ...
	Supported State = "Supported"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Disabled, Enabled, Supported}
}

// SupportedAlgorithm enumerates the values for supported algorithm.
type SupportedAlgorithm string

const (
	// SupportedAlgorithmNone ...
	SupportedAlgorithmNone SupportedAlgorithm = "None"
	// SupportedAlgorithmPlainText ...
	SupportedAlgorithmPlainText SupportedAlgorithm = "PlainText"
	// SupportedAlgorithmRSA15 ...
	SupportedAlgorithmRSA15 SupportedAlgorithm = "RSA1_5"
	// SupportedAlgorithmRSAOAEP ...
	SupportedAlgorithmRSAOAEP SupportedAlgorithm = "RSA_OAEP"
)

// PossibleSupportedAlgorithmValues returns an array of possible values for the SupportedAlgorithm const type.
func PossibleSupportedAlgorithmValues() []SupportedAlgorithm {
	return []SupportedAlgorithm{SupportedAlgorithmNone, SupportedAlgorithmPlainText, SupportedAlgorithmRSA15, SupportedAlgorithmRSAOAEP}
}

// UserConfirmation enumerates the values for user confirmation.
type UserConfirmation string

const (
	// NotRequired ...
	NotRequired UserConfirmation = "NotRequired"
	// Required ...
	Required UserConfirmation = "Required"
)

// PossibleUserConfirmationValues returns an array of possible values for the UserConfirmation const type.
func PossibleUserConfirmationValues() []UserConfirmation {
	return []UserConfirmation{NotRequired, Required}
}
