package catalog

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ACLType enumerates the values for acl type.
type ACLType string

const (
	// Group ...
	Group ACLType = "Group"
	// GroupObj ...
	GroupObj ACLType = "GroupObj"
	// Other ...
	Other ACLType = "Other"
	// User ...
	User ACLType = "User"
	// UserObj ...
	UserObj ACLType = "UserObj"
)

// PossibleACLTypeValues returns an array of possible values for the ACLType const type.
func PossibleACLTypeValues() []ACLType {
	return []ACLType{Group, GroupObj, Other, User, UserObj}
}

// FileType enumerates the values for file type.
type FileType string

const (
	// Assembly ...
	Assembly FileType = "Assembly"
	// Nodeploy ...
	Nodeploy FileType = "Nodeploy"
	// Resource ...
	Resource FileType = "Resource"
)

// PossibleFileTypeValues returns an array of possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{Assembly, Nodeploy, Resource}
}

// PermissionType enumerates the values for permission type.
type PermissionType string

const (
	// All ...
	All PermissionType = "All"
	// Alter ...
	Alter PermissionType = "Alter"
	// Create ...
	Create PermissionType = "Create"
	// Drop ...
	Drop PermissionType = "Drop"
	// None ...
	None PermissionType = "None"
	// Use ...
	Use PermissionType = "Use"
	// Write ...
	Write PermissionType = "Write"
)

// PossiblePermissionTypeValues returns an array of possible values for the PermissionType const type.
func PossiblePermissionTypeValues() []PermissionType {
	return []PermissionType{All, Alter, Create, Drop, None, Use, Write}
}
