package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlgorithmStepType enumerates the values for algorithm step type.
type AlgorithmStepType string

const (
	// ConnectorFilter ...
	ConnectorFilter AlgorithmStepType = "ConnectorFilter"
	// Deprovisioning ...
	Deprovisioning AlgorithmStepType = "Deprovisioning"
	// ExportFlow ...
	ExportFlow AlgorithmStepType = "ExportFlow"
	// ImportFlow ...
	ImportFlow AlgorithmStepType = "ImportFlow"
	// Join ...
	Join AlgorithmStepType = "Join"
	// MvDeletion ...
	MvDeletion AlgorithmStepType = "MvDeletion"
	// MvObjectTypeChange ...
	MvObjectTypeChange AlgorithmStepType = "MvObjectTypeChange"
	// Projection ...
	Projection AlgorithmStepType = "Projection"
	// Provisioning ...
	Provisioning AlgorithmStepType = "Provisioning"
	// Recall ...
	Recall AlgorithmStepType = "Recall"
	// Staging ...
	Staging AlgorithmStepType = "Staging"
	// Undefined ...
	Undefined AlgorithmStepType = "Undefined"
	// ValidateConnectorFilter ...
	ValidateConnectorFilter AlgorithmStepType = "ValidateConnectorFilter"
)

// PossibleAlgorithmStepTypeValues returns an array of possible values for the AlgorithmStepType const type.
func PossibleAlgorithmStepTypeValues() []AlgorithmStepType {
	return []AlgorithmStepType{ConnectorFilter, Deprovisioning, ExportFlow, ImportFlow, Join, MvDeletion, MvObjectTypeChange, Projection, Provisioning, Recall, Staging, Undefined, ValidateConnectorFilter}
}

// AttributeDeltaOperationType enumerates the values for attribute delta operation type.
type AttributeDeltaOperationType string

const (
	// AttributeDeltaOperationTypeAdd ...
	AttributeDeltaOperationTypeAdd AttributeDeltaOperationType = "Add"
	// AttributeDeltaOperationTypeDelete ...
	AttributeDeltaOperationTypeDelete AttributeDeltaOperationType = "Delete"
	// AttributeDeltaOperationTypeReplace ...
	AttributeDeltaOperationTypeReplace AttributeDeltaOperationType = "Replace"
	// AttributeDeltaOperationTypeUndefined ...
	AttributeDeltaOperationTypeUndefined AttributeDeltaOperationType = "Undefined"
	// AttributeDeltaOperationTypeUpdate ...
	AttributeDeltaOperationTypeUpdate AttributeDeltaOperationType = "Update"
)

// PossibleAttributeDeltaOperationTypeValues returns an array of possible values for the AttributeDeltaOperationType const type.
func PossibleAttributeDeltaOperationTypeValues() []AttributeDeltaOperationType {
	return []AttributeDeltaOperationType{AttributeDeltaOperationTypeAdd, AttributeDeltaOperationTypeDelete, AttributeDeltaOperationTypeReplace, AttributeDeltaOperationTypeUndefined, AttributeDeltaOperationTypeUpdate}
}

// AttributeMappingType enumerates the values for attribute mapping type.
type AttributeMappingType string

const (
	// Constant ...
	Constant AttributeMappingType = "Constant"
	// Direct ...
	Direct AttributeMappingType = "Direct"
	// DnPart ...
	DnPart AttributeMappingType = "DnPart"
	// Script ...
	Script AttributeMappingType = "Script"
)

// PossibleAttributeMappingTypeValues returns an array of possible values for the AttributeMappingType const type.
func PossibleAttributeMappingTypeValues() []AttributeMappingType {
	return []AttributeMappingType{Constant, Direct, DnPart, Script}
}

// DeltaOperationType enumerates the values for delta operation type.
type DeltaOperationType string

const (
	// DeltaOperationTypeAdd ...
	DeltaOperationTypeAdd DeltaOperationType = "Add"
	// DeltaOperationTypeDelete ...
	DeltaOperationTypeDelete DeltaOperationType = "Delete"
	// DeltaOperationTypeDeleteAdd ...
	DeltaOperationTypeDeleteAdd DeltaOperationType = "DeleteAdd"
	// DeltaOperationTypeNone ...
	DeltaOperationTypeNone DeltaOperationType = "None"
	// DeltaOperationTypeObsolete ...
	DeltaOperationTypeObsolete DeltaOperationType = "Obsolete"
	// DeltaOperationTypeReplace ...
	DeltaOperationTypeReplace DeltaOperationType = "Replace"
	// DeltaOperationTypeUndefined ...
	DeltaOperationTypeUndefined DeltaOperationType = "Undefined"
	// DeltaOperationTypeUpdate ...
	DeltaOperationTypeUpdate DeltaOperationType = "Update"
)

// PossibleDeltaOperationTypeValues returns an array of possible values for the DeltaOperationType const type.
func PossibleDeltaOperationTypeValues() []DeltaOperationType {
	return []DeltaOperationType{DeltaOperationTypeAdd, DeltaOperationTypeDelete, DeltaOperationTypeDeleteAdd, DeltaOperationTypeNone, DeltaOperationTypeObsolete, DeltaOperationTypeReplace, DeltaOperationTypeUndefined, DeltaOperationTypeUpdate}
}

// HealthStatus enumerates the values for health status.
type HealthStatus string

const (
	// Error ...
	Error HealthStatus = "Error"
	// Healthy ...
	Healthy HealthStatus = "Healthy"
	// Missing ...
	Missing HealthStatus = "Missing"
	// NotMonitored ...
	NotMonitored HealthStatus = "NotMonitored"
	// Warning ...
	Warning HealthStatus = "Warning"
)

// PossibleHealthStatusValues returns an array of possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{Error, Healthy, Missing, NotMonitored, Warning}
}

// Level enumerates the values for level.
type Level string

const (
	// LevelError ...
	LevelError Level = "Error"
	// LevelPreWarning ...
	LevelPreWarning Level = "PreWarning"
	// LevelWarning ...
	LevelWarning Level = "Warning"
)

// PossibleLevelValues returns an array of possible values for the Level const type.
func PossibleLevelValues() []Level {
	return []Level{LevelError, LevelPreWarning, LevelWarning}
}

// MonitoringLevel enumerates the values for monitoring level.
type MonitoringLevel string

const (
	// Full ...
	Full MonitoringLevel = "Full"
	// Off ...
	Off MonitoringLevel = "Off"
	// Partial ...
	Partial MonitoringLevel = "Partial"
)

// PossibleMonitoringLevelValues returns an array of possible values for the MonitoringLevel const type.
func PossibleMonitoringLevelValues() []MonitoringLevel {
	return []MonitoringLevel{Full, Off, Partial}
}

// PasswordOperationTypes enumerates the values for password operation types.
type PasswordOperationTypes string

const (
	// PasswordOperationTypesChange ...
	PasswordOperationTypesChange PasswordOperationTypes = "Change"
	// PasswordOperationTypesSet ...
	PasswordOperationTypesSet PasswordOperationTypes = "Set"
	// PasswordOperationTypesUndefined ...
	PasswordOperationTypesUndefined PasswordOperationTypes = "Undefined"
)

// PossiblePasswordOperationTypesValues returns an array of possible values for the PasswordOperationTypes const type.
func PossiblePasswordOperationTypesValues() []PasswordOperationTypes {
	return []PasswordOperationTypes{PasswordOperationTypesChange, PasswordOperationTypesSet, PasswordOperationTypesUndefined}
}

// State enumerates the values for state.
type State string

const (
	// Active ...
	Active State = "Active"
	// ResolvedByPositiveResult ...
	ResolvedByPositiveResult State = "ResolvedByPositiveResult"
	// ResolvedByStateChange ...
	ResolvedByStateChange State = "ResolvedByStateChange"
	// ResolvedByTimer ...
	ResolvedByTimer State = "ResolvedByTimer"
	// ResolvedManually ...
	ResolvedManually State = "ResolvedManually"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Active, ResolvedByPositiveResult, ResolvedByStateChange, ResolvedByTimer, ResolvedManually}
}

// ValueDeltaOperationType enumerates the values for value delta operation type.
type ValueDeltaOperationType string

const (
	// ValueDeltaOperationTypeAdd ...
	ValueDeltaOperationTypeAdd ValueDeltaOperationType = "Add"
	// ValueDeltaOperationTypeDelete ...
	ValueDeltaOperationTypeDelete ValueDeltaOperationType = "Delete"
	// ValueDeltaOperationTypeUndefined ...
	ValueDeltaOperationTypeUndefined ValueDeltaOperationType = "Undefined"
	// ValueDeltaOperationTypeUpdate ...
	ValueDeltaOperationTypeUpdate ValueDeltaOperationType = "Update"
)

// PossibleValueDeltaOperationTypeValues returns an array of possible values for the ValueDeltaOperationType const type.
func PossibleValueDeltaOperationTypeValues() []ValueDeltaOperationType {
	return []ValueDeltaOperationType{ValueDeltaOperationTypeAdd, ValueDeltaOperationTypeDelete, ValueDeltaOperationTypeUndefined, ValueDeltaOperationTypeUpdate}
}

// ValueType enumerates the values for value type.
type ValueType string

const (
	// ValueTypeBinary ...
	ValueTypeBinary ValueType = "Binary"
	// ValueTypeBoolean ...
	ValueTypeBoolean ValueType = "Boolean"
	// ValueTypeDn ...
	ValueTypeDn ValueType = "Dn"
	// ValueTypeInteger ...
	ValueTypeInteger ValueType = "Integer"
	// ValueTypeString ...
	ValueTypeString ValueType = "String"
	// ValueTypeUndefined ...
	ValueTypeUndefined ValueType = "Undefined"
)

// PossibleValueTypeValues returns an array of possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{ValueTypeBinary, ValueTypeBoolean, ValueTypeDn, ValueTypeInteger, ValueTypeString, ValueTypeUndefined}
}
