// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package networkfirewall provides the client and types for making API
// requests to AWS Network Firewall.
//
// This is the API Reference for AWS Network Firewall. This guide is for developers
// who need detailed information about the Network Firewall API actions, data
// types, and errors.
//
//    * The REST API requires you to handle connection details, such as calculating
//    signatures, handling request retries, and error handling. For general
//    information about using the AWS REST APIs, see AWS APIs (https://docs.aws.amazon.com/general/latest/gr/aws-apis.html).
//    To access Network Firewall using the REST API endpoint: https://network-firewall.<region>.amazonaws.com
//
//    * Alternatively, you can use one of the AWS SDKs to access an API that's
//    tailored to the programming language or platform that you're using. For
//    more information, see AWS SDKs (http://aws.amazon.com/tools/#SDKs).
//
//    * For descriptions of Network Firewall features, including and step-by-step
//    instructions on how to use them through the Network Firewall console,
//    see the Network Firewall Developer Guide (https://docs.aws.amazon.com/network-firewall/latest/developerguide/).
//
// Network Firewall is a stateful, managed, network firewall and intrusion detection
// and prevention service for Amazon Virtual Private Cloud (Amazon VPC). With
// Network Firewall, you can filter traffic at the perimeter of your VPC. This
// includes filtering traffic going to and coming from an internet gateway,
// NAT gateway, or over VPN or AWS Direct Connect. Network Firewall uses rules
// that are compatible with Suricata, a free, open source intrusion detection
// system (IDS) engine. For information about Suricata, see the Suricata website
// (https://suricata-ids.org/).
//
// You can use Network Firewall to monitor and protect your VPC traffic in a
// number of ways. The following are just a few examples:
//
//    * Allow domains or IP addresses for known AWS service endpoints, such
//    as Amazon S3, and block all other forms of traffic.
//
//    * Use custom lists of known bad domains to limit the types of domain names
//    that your applications can access.
//
//    * Perform deep packet inspection on traffic entering or leaving your VPC.
//
//    * Use stateful protocol detection to filter protocols like HTTPS, regardless
//    of the port used.
//
// To enable Network Firewall for your VPCs, you perform steps in both Amazon
// VPC and in Network Firewall. For information about using Amazon VPC, see
// Amazon VPC User Guide (https://docs.aws.amazon.com/vpc/latest/userguide/).
//
// To start using Network Firewall, do the following:
//
// (Optional) If you don't already have a VPC that you want to protect, create
// it in Amazon VPC.
//
// In Amazon VPC, in each Availability Zone where you want to have a firewall
// endpoint, create a subnet for the sole use of Network Firewall.
//
// In Network Firewall, create stateless and stateful rule groups, to define
// the components of the network traffic filtering behavior that you want your
// firewall to have.
//
// In Network Firewall, create a firewall policy that uses your rule groups
// and specifies additional default traffic filtering behavior.
//
// In Network Firewall, create a firewall and specify your new firewall policy
// and VPC subnets. Network Firewall creates a firewall endpoint in each subnet
// that you specify, with the behavior that's defined in the firewall policy.
//
// In Amazon VPC, use ingress routing enhancements to route traffic through
// the new firewall endpoints.
//
// See https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12 for more information on this service.
//
// See networkfirewall package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/networkfirewall/
//
// Using the Client
//
// To contact AWS Network Firewall with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS Network Firewall client NetworkFirewall for more
// information on creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/networkfirewall/#New
package networkfirewall
