// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddInstanceFleet = "AddInstanceFleet"

// AddInstanceFleetRequest generates a "aws/request.Request" representing the
// client's request for the AddInstanceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddInstanceFleet for more information on using the AddInstanceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddInstanceFleetRequest method.
//    req, resp := client.AddInstanceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet
func (c *EMR) AddInstanceFleetRequest(input *AddInstanceFleetInput) (req *request.Request, output *AddInstanceFleetOutput) {
	op := &request.Operation{
		Name:       opAddInstanceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddInstanceFleetInput{}
	}

	output = &AddInstanceFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddInstanceFleet API operation for Amazon Elastic MapReduce.
//
// Adds an instance fleet to a running cluster.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddInstanceFleet for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet
func (c *EMR) AddInstanceFleet(input *AddInstanceFleetInput) (*AddInstanceFleetOutput, error) {
	req, out := c.AddInstanceFleetRequest(input)
	return out, req.Send()
}

// AddInstanceFleetWithContext is the same as AddInstanceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See AddInstanceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) AddInstanceFleetWithContext(ctx aws.Context, input *AddInstanceFleetInput, opts ...request.Option) (*AddInstanceFleetOutput, error) {
	req, out := c.AddInstanceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddInstanceGroups = "AddInstanceGroups"

// AddInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AddInstanceGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddInstanceGroups for more information on using the AddInstanceGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddInstanceGroupsRequest method.
//    req, resp := client.AddInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups
func (c *EMR) AddInstanceGroupsRequest(input *AddInstanceGroupsInput) (req *request.Request, output *AddInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opAddInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddInstanceGroupsInput{}
	}

	output = &AddInstanceGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddInstanceGroups API operation for Amazon Elastic MapReduce.
//
// Adds one or more instance groups to a running cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddInstanceGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups
func (c *EMR) AddInstanceGroups(input *AddInstanceGroupsInput) (*AddInstanceGroupsOutput, error) {
	req, out := c.AddInstanceGroupsRequest(input)
	return out, req.Send()
}

// AddInstanceGroupsWithContext is the same as AddInstanceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AddInstanceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) AddInstanceGroupsWithContext(ctx aws.Context, input *AddInstanceGroupsInput, opts ...request.Option) (*AddInstanceGroupsOutput, error) {
	req, out := c.AddInstanceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddJobFlowSteps = "AddJobFlowSteps"

// AddJobFlowStepsRequest generates a "aws/request.Request" representing the
// client's request for the AddJobFlowSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddJobFlowSteps for more information on using the AddJobFlowSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddJobFlowStepsRequest method.
//    req, resp := client.AddJobFlowStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps
func (c *EMR) AddJobFlowStepsRequest(input *AddJobFlowStepsInput) (req *request.Request, output *AddJobFlowStepsOutput) {
	op := &request.Operation{
		Name:       opAddJobFlowSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddJobFlowStepsInput{}
	}

	output = &AddJobFlowStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddJobFlowSteps API operation for Amazon Elastic MapReduce.
//
// AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps
// are allowed in each job flow.
//
// If your cluster is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using SSH to connect to
// the master node and submitting queries directly to the software running on
// the master node, such as Hive and Hadoop. For more information on how to
// do this, see Add More than 256 Steps to a Cluster (https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html)
// in the Amazon EMR Management Guide.
//
// A step specifies the location of a JAR file stored either on the master node
// of the cluster or in Amazon S3. Each step is performed by the main function
// of the main class of the JAR file. The main class can be specified either
// in the manifest of the JAR or by using the MainFunction parameter of the
// step.
//
// Amazon EMR executes each step in the order listed. For a step to be considered
// complete, the main function must exit with a zero exit code and all Hadoop
// jobs started while the step was running must have completed and run successfully.
//
// You can only add steps to a cluster that is in one of the following states:
// STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddJobFlowSteps for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps
func (c *EMR) AddJobFlowSteps(input *AddJobFlowStepsInput) (*AddJobFlowStepsOutput, error) {
	req, out := c.AddJobFlowStepsRequest(input)
	return out, req.Send()
}

// AddJobFlowStepsWithContext is the same as AddJobFlowSteps with the addition of
// the ability to pass a context and additional request options.
//
// See AddJobFlowSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) AddJobFlowStepsWithContext(ctx aws.Context, input *AddJobFlowStepsInput, opts ...request.Option) (*AddJobFlowStepsOutput, error) {
	req, out := c.AddJobFlowStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags
func (c *EMR) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon Elastic MapReduce.
//
// Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters
// in various ways, such as grouping clusters to track your Amazon EMR resource
// allocation costs. For more information, see Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation AddTags for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags
func (c *EMR) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSteps = "CancelSteps"

// CancelStepsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSteps for more information on using the CancelSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelStepsRequest method.
//    req, resp := client.CancelStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps
func (c *EMR) CancelStepsRequest(input *CancelStepsInput) (req *request.Request, output *CancelStepsOutput) {
	op := &request.Operation{
		Name:       opCancelSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelStepsInput{}
	}

	output = &CancelStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSteps API operation for Amazon Elastic MapReduce.
//
// Cancels a pending step or steps in a running cluster. Available only in Amazon
// EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps
// are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous;
// it does not guarantee that a step will be canceled, even if the request is
// successfully submitted. You can only cancel steps that are in a PENDING state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation CancelSteps for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps
func (c *EMR) CancelSteps(input *CancelStepsInput) (*CancelStepsOutput, error) {
	req, out := c.CancelStepsRequest(input)
	return out, req.Send()
}

// CancelStepsWithContext is the same as CancelSteps with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CancelStepsWithContext(ctx aws.Context, input *CancelStepsInput, opts ...request.Option) (*CancelStepsOutput, error) {
	req, out := c.CancelStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityConfiguration = "CreateSecurityConfiguration"

// CreateSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityConfiguration for more information on using the CreateSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSecurityConfigurationRequest method.
//    req, resp := client.CreateSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration
func (c *EMR) CreateSecurityConfigurationRequest(input *CreateSecurityConfigurationInput) (req *request.Request, output *CreateSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityConfigurationInput{}
	}

	output = &CreateSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Creates a security configuration, which is stored in the service and can
// be specified when a cluster is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation CreateSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration
func (c *EMR) CreateSecurityConfiguration(input *CreateSecurityConfigurationInput) (*CreateSecurityConfigurationOutput, error) {
	req, out := c.CreateSecurityConfigurationRequest(input)
	return out, req.Send()
}

// CreateSecurityConfigurationWithContext is the same as CreateSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateSecurityConfigurationWithContext(ctx aws.Context, input *CreateSecurityConfigurationInput, opts ...request.Option) (*CreateSecurityConfigurationOutput, error) {
	req, out := c.CreateSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStudio = "CreateStudio"

// CreateStudioRequest generates a "aws/request.Request" representing the
// client's request for the CreateStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStudio for more information on using the CreateStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStudioRequest method.
//    req, resp := client.CreateStudioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio
func (c *EMR) CreateStudioRequest(input *CreateStudioInput) (req *request.Request, output *CreateStudioOutput) {
	op := &request.Operation{
		Name:       opCreateStudio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStudioInput{}
	}

	output = &CreateStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStudio API operation for Amazon Elastic MapReduce.
//
// Creates a new Amazon EMR Studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation CreateStudio for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio
func (c *EMR) CreateStudio(input *CreateStudioInput) (*CreateStudioOutput, error) {
	req, out := c.CreateStudioRequest(input)
	return out, req.Send()
}

// CreateStudioWithContext is the same as CreateStudio with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateStudioWithContext(ctx aws.Context, input *CreateStudioInput, opts ...request.Option) (*CreateStudioOutput, error) {
	req, out := c.CreateStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStudioSessionMapping = "CreateStudioSessionMapping"

// CreateStudioSessionMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateStudioSessionMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStudioSessionMapping for more information on using the CreateStudioSessionMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStudioSessionMappingRequest method.
//    req, resp := client.CreateStudioSessionMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping
func (c *EMR) CreateStudioSessionMappingRequest(input *CreateStudioSessionMappingInput) (req *request.Request, output *CreateStudioSessionMappingOutput) {
	op := &request.Operation{
		Name:       opCreateStudioSessionMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStudioSessionMappingInput{}
	}

	output = &CreateStudioSessionMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateStudioSessionMapping API operation for Amazon Elastic MapReduce.
//
// Maps a user or group to the Amazon EMR Studio specified by StudioId, and
// applies a session policy to refine Studio permissions for that user or group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation CreateStudioSessionMapping for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping
func (c *EMR) CreateStudioSessionMapping(input *CreateStudioSessionMappingInput) (*CreateStudioSessionMappingOutput, error) {
	req, out := c.CreateStudioSessionMappingRequest(input)
	return out, req.Send()
}

// CreateStudioSessionMappingWithContext is the same as CreateStudioSessionMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStudioSessionMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateStudioSessionMappingWithContext(ctx aws.Context, input *CreateStudioSessionMappingInput, opts ...request.Option) (*CreateStudioSessionMappingOutput, error) {
	req, out := c.CreateStudioSessionMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityConfiguration = "DeleteSecurityConfiguration"

// DeleteSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityConfiguration for more information on using the DeleteSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSecurityConfigurationRequest method.
//    req, resp := client.DeleteSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration
func (c *EMR) DeleteSecurityConfigurationRequest(input *DeleteSecurityConfigurationInput) (req *request.Request, output *DeleteSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityConfigurationInput{}
	}

	output = &DeleteSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Deletes a security configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DeleteSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration
func (c *EMR) DeleteSecurityConfiguration(input *DeleteSecurityConfigurationInput) (*DeleteSecurityConfigurationOutput, error) {
	req, out := c.DeleteSecurityConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSecurityConfigurationWithContext is the same as DeleteSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DeleteSecurityConfigurationWithContext(ctx aws.Context, input *DeleteSecurityConfigurationInput, opts ...request.Option) (*DeleteSecurityConfigurationOutput, error) {
	req, out := c.DeleteSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStudio = "DeleteStudio"

// DeleteStudioRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStudio for more information on using the DeleteStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStudioRequest method.
//    req, resp := client.DeleteStudioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio
func (c *EMR) DeleteStudioRequest(input *DeleteStudioInput) (req *request.Request, output *DeleteStudioOutput) {
	op := &request.Operation{
		Name:       opDeleteStudio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStudioInput{}
	}

	output = &DeleteStudioOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStudio API operation for Amazon Elastic MapReduce.
//
// Removes an Amazon EMR Studio from the Studio metadata store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DeleteStudio for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio
func (c *EMR) DeleteStudio(input *DeleteStudioInput) (*DeleteStudioOutput, error) {
	req, out := c.DeleteStudioRequest(input)
	return out, req.Send()
}

// DeleteStudioWithContext is the same as DeleteStudio with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DeleteStudioWithContext(ctx aws.Context, input *DeleteStudioInput, opts ...request.Option) (*DeleteStudioOutput, error) {
	req, out := c.DeleteStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStudioSessionMapping = "DeleteStudioSessionMapping"

// DeleteStudioSessionMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStudioSessionMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStudioSessionMapping for more information on using the DeleteStudioSessionMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStudioSessionMappingRequest method.
//    req, resp := client.DeleteStudioSessionMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping
func (c *EMR) DeleteStudioSessionMappingRequest(input *DeleteStudioSessionMappingInput) (req *request.Request, output *DeleteStudioSessionMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteStudioSessionMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStudioSessionMappingInput{}
	}

	output = &DeleteStudioSessionMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStudioSessionMapping API operation for Amazon Elastic MapReduce.
//
// Removes a user or group from an Amazon EMR Studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DeleteStudioSessionMapping for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping
func (c *EMR) DeleteStudioSessionMapping(input *DeleteStudioSessionMappingInput) (*DeleteStudioSessionMappingOutput, error) {
	req, out := c.DeleteStudioSessionMappingRequest(input)
	return out, req.Send()
}

// DeleteStudioSessionMappingWithContext is the same as DeleteStudioSessionMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStudioSessionMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DeleteStudioSessionMappingWithContext(ctx aws.Context, input *DeleteStudioSessionMappingInput, opts ...request.Option) (*DeleteStudioSessionMappingOutput, error) {
	req, out := c.DeleteStudioSessionMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster
func (c *EMR) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Elastic MapReduce.
//
// Provides cluster-level details including status, hardware and software configuration,
// VPC settings, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster
func (c *EMR) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobFlows = "DescribeJobFlows"

// DescribeJobFlowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobFlows for more information on using the DescribeJobFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobFlowsRequest method.
//    req, resp := client.DescribeJobFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeJobFlows
//
// Deprecated: DescribeJobFlows has been deprecated
func (c *EMR) DescribeJobFlowsRequest(input *DescribeJobFlowsInput) (req *request.Request, output *DescribeJobFlowsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeJobFlows, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobFlowsInput{}
	}

	output = &DescribeJobFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobFlows API operation for Amazon Elastic MapReduce.
//
// This API is no longer supported and will eventually be removed. We recommend
// you use ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and
// ListBootstrapActions instead.
//
// DescribeJobFlows returns a list of job flows that match all of the supplied
// parameters. The parameters can include a list of job flow IDs, job flow states,
// and restrictions on job flow creation date and time.
//
// Regardless of supplied parameters, only job flows created within the last
// two months are returned.
//
// If no parameters are supplied, then job flows matching either of the following
// criteria are returned:
//
//    * Job flows created and completed in the last two weeks
//
//    * Job flows created within the last two months that are in one of the
//    following states: RUNNING, WAITING, SHUTTING_DOWN, STARTING
//
// Amazon EMR can return a maximum of 512 job flow descriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeJobFlows for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeJobFlows
//
// Deprecated: DescribeJobFlows has been deprecated
func (c *EMR) DescribeJobFlows(input *DescribeJobFlowsInput) (*DescribeJobFlowsOutput, error) {
	req, out := c.DescribeJobFlowsRequest(input)
	return out, req.Send()
}

// DescribeJobFlowsWithContext is the same as DescribeJobFlows with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: DescribeJobFlowsWithContext has been deprecated
func (c *EMR) DescribeJobFlowsWithContext(ctx aws.Context, input *DescribeJobFlowsInput, opts ...request.Option) (*DescribeJobFlowsOutput, error) {
	req, out := c.DescribeJobFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookExecution = "DescribeNotebookExecution"

// DescribeNotebookExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookExecution for more information on using the DescribeNotebookExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookExecutionRequest method.
//    req, resp := client.DescribeNotebookExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution
func (c *EMR) DescribeNotebookExecutionRequest(input *DescribeNotebookExecutionInput) (req *request.Request, output *DescribeNotebookExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookExecutionInput{}
	}

	output = &DescribeNotebookExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookExecution API operation for Amazon Elastic MapReduce.
//
// Provides details of a notebook execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeNotebookExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution
func (c *EMR) DescribeNotebookExecution(input *DescribeNotebookExecutionInput) (*DescribeNotebookExecutionOutput, error) {
	req, out := c.DescribeNotebookExecutionRequest(input)
	return out, req.Send()
}

// DescribeNotebookExecutionWithContext is the same as DescribeNotebookExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DescribeNotebookExecutionWithContext(ctx aws.Context, input *DescribeNotebookExecutionInput, opts ...request.Option) (*DescribeNotebookExecutionOutput, error) {
	req, out := c.DescribeNotebookExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityConfiguration = "DescribeSecurityConfiguration"

// DescribeSecurityConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityConfiguration for more information on using the DescribeSecurityConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSecurityConfigurationRequest method.
//    req, resp := client.DescribeSecurityConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration
func (c *EMR) DescribeSecurityConfigurationRequest(input *DescribeSecurityConfigurationInput) (req *request.Request, output *DescribeSecurityConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecurityConfigurationInput{}
	}

	output = &DescribeSecurityConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityConfiguration API operation for Amazon Elastic MapReduce.
//
// Provides the details of a security configuration by returning the configuration
// JSON.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeSecurityConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration
func (c *EMR) DescribeSecurityConfiguration(input *DescribeSecurityConfigurationInput) (*DescribeSecurityConfigurationOutput, error) {
	req, out := c.DescribeSecurityConfigurationRequest(input)
	return out, req.Send()
}

// DescribeSecurityConfigurationWithContext is the same as DescribeSecurityConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DescribeSecurityConfigurationWithContext(ctx aws.Context, input *DescribeSecurityConfigurationInput, opts ...request.Option) (*DescribeSecurityConfigurationOutput, error) {
	req, out := c.DescribeSecurityConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStep = "DescribeStep"

// DescribeStepRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStep for more information on using the DescribeStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStepRequest method.
//    req, resp := client.DescribeStepRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep
func (c *EMR) DescribeStepRequest(input *DescribeStepInput) (req *request.Request, output *DescribeStepOutput) {
	op := &request.Operation{
		Name:       opDescribeStep,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStepInput{}
	}

	output = &DescribeStepOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStep API operation for Amazon Elastic MapReduce.
//
// Provides more detail about the cluster step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeStep for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep
func (c *EMR) DescribeStep(input *DescribeStepInput) (*DescribeStepOutput, error) {
	req, out := c.DescribeStepRequest(input)
	return out, req.Send()
}

// DescribeStepWithContext is the same as DescribeStep with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DescribeStepWithContext(ctx aws.Context, input *DescribeStepInput, opts ...request.Option) (*DescribeStepOutput, error) {
	req, out := c.DescribeStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStudio = "DescribeStudio"

// DescribeStudioRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStudio for more information on using the DescribeStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStudioRequest method.
//    req, resp := client.DescribeStudioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio
func (c *EMR) DescribeStudioRequest(input *DescribeStudioInput) (req *request.Request, output *DescribeStudioOutput) {
	op := &request.Operation{
		Name:       opDescribeStudio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStudioInput{}
	}

	output = &DescribeStudioOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStudio API operation for Amazon Elastic MapReduce.
//
// Returns details for the specified Amazon EMR Studio including ID, Name, VPC,
// Studio access URL, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation DescribeStudio for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio
func (c *EMR) DescribeStudio(input *DescribeStudioInput) (*DescribeStudioOutput, error) {
	req, out := c.DescribeStudioRequest(input)
	return out, req.Send()
}

// DescribeStudioWithContext is the same as DescribeStudio with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) DescribeStudioWithContext(ctx aws.Context, input *DescribeStudioInput, opts ...request.Option) (*DescribeStudioOutput, error) {
	req, out := c.DescribeStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlockPublicAccessConfiguration = "GetBlockPublicAccessConfiguration"

// GetBlockPublicAccessConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBlockPublicAccessConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlockPublicAccessConfiguration for more information on using the GetBlockPublicAccessConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlockPublicAccessConfigurationRequest method.
//    req, resp := client.GetBlockPublicAccessConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration
func (c *EMR) GetBlockPublicAccessConfigurationRequest(input *GetBlockPublicAccessConfigurationInput) (req *request.Request, output *GetBlockPublicAccessConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBlockPublicAccessConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlockPublicAccessConfigurationInput{}
	}

	output = &GetBlockPublicAccessConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlockPublicAccessConfiguration API operation for Amazon Elastic MapReduce.
//
// Returns the Amazon EMR block public access configuration for your AWS account
// in the current Region. For more information see Configure Block Public Access
// for Amazon EMR (https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
// in the Amazon EMR Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation GetBlockPublicAccessConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration
func (c *EMR) GetBlockPublicAccessConfiguration(input *GetBlockPublicAccessConfigurationInput) (*GetBlockPublicAccessConfigurationOutput, error) {
	req, out := c.GetBlockPublicAccessConfigurationRequest(input)
	return out, req.Send()
}

// GetBlockPublicAccessConfigurationWithContext is the same as GetBlockPublicAccessConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlockPublicAccessConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) GetBlockPublicAccessConfigurationWithContext(ctx aws.Context, input *GetBlockPublicAccessConfigurationInput, opts ...request.Option) (*GetBlockPublicAccessConfigurationOutput, error) {
	req, out := c.GetBlockPublicAccessConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetManagedScalingPolicy = "GetManagedScalingPolicy"

// GetManagedScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetManagedScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetManagedScalingPolicy for more information on using the GetManagedScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetManagedScalingPolicyRequest method.
//    req, resp := client.GetManagedScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy
func (c *EMR) GetManagedScalingPolicyRequest(input *GetManagedScalingPolicyInput) (req *request.Request, output *GetManagedScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opGetManagedScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetManagedScalingPolicyInput{}
	}

	output = &GetManagedScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetManagedScalingPolicy API operation for Amazon Elastic MapReduce.
//
// Fetches the attached managed scaling policy for an Amazon EMR cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation GetManagedScalingPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy
func (c *EMR) GetManagedScalingPolicy(input *GetManagedScalingPolicyInput) (*GetManagedScalingPolicyOutput, error) {
	req, out := c.GetManagedScalingPolicyRequest(input)
	return out, req.Send()
}

// GetManagedScalingPolicyWithContext is the same as GetManagedScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetManagedScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) GetManagedScalingPolicyWithContext(ctx aws.Context, input *GetManagedScalingPolicyInput, opts ...request.Option) (*GetManagedScalingPolicyOutput, error) {
	req, out := c.GetManagedScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStudioSessionMapping = "GetStudioSessionMapping"

// GetStudioSessionMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetStudioSessionMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStudioSessionMapping for more information on using the GetStudioSessionMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStudioSessionMappingRequest method.
//    req, resp := client.GetStudioSessionMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping
func (c *EMR) GetStudioSessionMappingRequest(input *GetStudioSessionMappingInput) (req *request.Request, output *GetStudioSessionMappingOutput) {
	op := &request.Operation{
		Name:       opGetStudioSessionMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStudioSessionMappingInput{}
	}

	output = &GetStudioSessionMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStudioSessionMapping API operation for Amazon Elastic MapReduce.
//
// Fetches mapping details for the specified Amazon EMR Studio and identity
// (user or group).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation GetStudioSessionMapping for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping
func (c *EMR) GetStudioSessionMapping(input *GetStudioSessionMappingInput) (*GetStudioSessionMappingOutput, error) {
	req, out := c.GetStudioSessionMappingRequest(input)
	return out, req.Send()
}

// GetStudioSessionMappingWithContext is the same as GetStudioSessionMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetStudioSessionMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) GetStudioSessionMappingWithContext(ctx aws.Context, input *GetStudioSessionMappingInput, opts ...request.Option) (*GetStudioSessionMappingOutput, error) {
	req, out := c.GetStudioSessionMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBootstrapActions = "ListBootstrapActions"

// ListBootstrapActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBootstrapActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBootstrapActions for more information on using the ListBootstrapActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBootstrapActionsRequest method.
//    req, resp := client.ListBootstrapActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions
func (c *EMR) ListBootstrapActionsRequest(input *ListBootstrapActionsInput) (req *request.Request, output *ListBootstrapActionsOutput) {
	op := &request.Operation{
		Name:       opListBootstrapActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBootstrapActionsInput{}
	}

	output = &ListBootstrapActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBootstrapActions API operation for Amazon Elastic MapReduce.
//
// Provides information about the bootstrap actions associated with a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListBootstrapActions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions
func (c *EMR) ListBootstrapActions(input *ListBootstrapActionsInput) (*ListBootstrapActionsOutput, error) {
	req, out := c.ListBootstrapActionsRequest(input)
	return out, req.Send()
}

// ListBootstrapActionsWithContext is the same as ListBootstrapActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBootstrapActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListBootstrapActionsWithContext(ctx aws.Context, input *ListBootstrapActionsInput, opts ...request.Option) (*ListBootstrapActionsOutput, error) {
	req, out := c.ListBootstrapActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBootstrapActionsPages iterates over the pages of a ListBootstrapActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBootstrapActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBootstrapActions operation.
//    pageNum := 0
//    err := client.ListBootstrapActionsPages(params,
//        func(page *emr.ListBootstrapActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListBootstrapActionsPages(input *ListBootstrapActionsInput, fn func(*ListBootstrapActionsOutput, bool) bool) error {
	return c.ListBootstrapActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBootstrapActionsPagesWithContext same as ListBootstrapActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListBootstrapActionsPagesWithContext(ctx aws.Context, input *ListBootstrapActionsInput, fn func(*ListBootstrapActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBootstrapActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBootstrapActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBootstrapActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters
func (c *EMR) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Elastic MapReduce.
//
// Provides the status of all clusters visible to this AWS account. Allows you
// to filter the list of clusters based on certain criteria; for example, filtering
// by cluster creation date and time or by status. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListClusters calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters
func (c *EMR) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *emr.ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceFleets = "ListInstanceFleets"

// ListInstanceFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceFleets for more information on using the ListInstanceFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstanceFleetsRequest method.
//    req, resp := client.ListInstanceFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets
func (c *EMR) ListInstanceFleetsRequest(input *ListInstanceFleetsInput) (req *request.Request, output *ListInstanceFleetsOutput) {
	op := &request.Operation{
		Name:       opListInstanceFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceFleetsInput{}
	}

	output = &ListInstanceFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceFleets API operation for Amazon Elastic MapReduce.
//
// Lists all available details about the instance fleets in a cluster.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListInstanceFleets for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets
func (c *EMR) ListInstanceFleets(input *ListInstanceFleetsInput) (*ListInstanceFleetsOutput, error) {
	req, out := c.ListInstanceFleetsRequest(input)
	return out, req.Send()
}

// ListInstanceFleetsWithContext is the same as ListInstanceFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstanceFleetsWithContext(ctx aws.Context, input *ListInstanceFleetsInput, opts ...request.Option) (*ListInstanceFleetsOutput, error) {
	req, out := c.ListInstanceFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceFleetsPages iterates over the pages of a ListInstanceFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceFleets operation.
//    pageNum := 0
//    err := client.ListInstanceFleetsPages(params,
//        func(page *emr.ListInstanceFleetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListInstanceFleetsPages(input *ListInstanceFleetsInput, fn func(*ListInstanceFleetsOutput, bool) bool) error {
	return c.ListInstanceFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceFleetsPagesWithContext same as ListInstanceFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstanceFleetsPagesWithContext(ctx aws.Context, input *ListInstanceFleetsInput, fn func(*ListInstanceFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceGroups = "ListInstanceGroups"

// ListInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceGroups for more information on using the ListInstanceGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstanceGroupsRequest method.
//    req, resp := client.ListInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups
func (c *EMR) ListInstanceGroupsRequest(input *ListInstanceGroupsInput) (req *request.Request, output *ListInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opListInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceGroupsInput{}
	}

	output = &ListInstanceGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceGroups API operation for Amazon Elastic MapReduce.
//
// Provides all available details about the instance groups in a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListInstanceGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups
func (c *EMR) ListInstanceGroups(input *ListInstanceGroupsInput) (*ListInstanceGroupsOutput, error) {
	req, out := c.ListInstanceGroupsRequest(input)
	return out, req.Send()
}

// ListInstanceGroupsWithContext is the same as ListInstanceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstanceGroupsWithContext(ctx aws.Context, input *ListInstanceGroupsInput, opts ...request.Option) (*ListInstanceGroupsOutput, error) {
	req, out := c.ListInstanceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceGroupsPages iterates over the pages of a ListInstanceGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceGroups operation.
//    pageNum := 0
//    err := client.ListInstanceGroupsPages(params,
//        func(page *emr.ListInstanceGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListInstanceGroupsPages(input *ListInstanceGroupsInput, fn func(*ListInstanceGroupsOutput, bool) bool) error {
	return c.ListInstanceGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceGroupsPagesWithContext same as ListInstanceGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstanceGroupsPagesWithContext(ctx aws.Context, input *ListInstanceGroupsInput, fn func(*ListInstanceGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstancesRequest method.
//    req, resp := client.ListInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances
func (c *EMR) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for Amazon Elastic MapReduce.
//
// Provides information for all active EC2 instances and EC2 instances terminated
// in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the
// following states are considered active: AWAITING_FULFILLMENT, PROVISIONING,
// BOOTSTRAPPING, RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances
func (c *EMR) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstances operation.
//    pageNum := 0
//    err := client.ListInstancesPages(params,
//        func(page *emr.ListInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotebookExecutions = "ListNotebookExecutions"

// ListNotebookExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookExecutions for more information on using the ListNotebookExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookExecutionsRequest method.
//    req, resp := client.ListNotebookExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions
func (c *EMR) ListNotebookExecutionsRequest(input *ListNotebookExecutionsInput) (req *request.Request, output *ListNotebookExecutionsOutput) {
	op := &request.Operation{
		Name:       opListNotebookExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookExecutionsInput{}
	}

	output = &ListNotebookExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookExecutions API operation for Amazon Elastic MapReduce.
//
// Provides summaries of all notebook executions. You can filter the list based
// on multiple criteria such as status, time range, and editor id. Returns a
// maximum of 50 notebook executions and a marker to track the paging of a longer
// notebook execution list across multiple ListNotebookExecution calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListNotebookExecutions for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions
func (c *EMR) ListNotebookExecutions(input *ListNotebookExecutionsInput) (*ListNotebookExecutionsOutput, error) {
	req, out := c.ListNotebookExecutionsRequest(input)
	return out, req.Send()
}

// ListNotebookExecutionsWithContext is the same as ListNotebookExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListNotebookExecutionsWithContext(ctx aws.Context, input *ListNotebookExecutionsInput, opts ...request.Option) (*ListNotebookExecutionsOutput, error) {
	req, out := c.ListNotebookExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookExecutionsPages iterates over the pages of a ListNotebookExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookExecutions operation.
//    pageNum := 0
//    err := client.ListNotebookExecutionsPages(params,
//        func(page *emr.ListNotebookExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListNotebookExecutionsPages(input *ListNotebookExecutionsInput, fn func(*ListNotebookExecutionsOutput, bool) bool) error {
	return c.ListNotebookExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookExecutionsPagesWithContext same as ListNotebookExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListNotebookExecutionsPagesWithContext(ctx aws.Context, input *ListNotebookExecutionsInput, fn func(*ListNotebookExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotebookExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityConfigurations = "ListSecurityConfigurations"

// ListSecurityConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityConfigurations for more information on using the ListSecurityConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityConfigurationsRequest method.
//    req, resp := client.ListSecurityConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations
func (c *EMR) ListSecurityConfigurationsRequest(input *ListSecurityConfigurationsInput) (req *request.Request, output *ListSecurityConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSecurityConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityConfigurationsInput{}
	}

	output = &ListSecurityConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityConfigurations API operation for Amazon Elastic MapReduce.
//
// Lists all the security configurations visible to this account, providing
// their creation dates and times, and their names. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListSecurityConfigurations calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListSecurityConfigurations for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations
func (c *EMR) ListSecurityConfigurations(input *ListSecurityConfigurationsInput) (*ListSecurityConfigurationsOutput, error) {
	req, out := c.ListSecurityConfigurationsRequest(input)
	return out, req.Send()
}

// ListSecurityConfigurationsWithContext is the same as ListSecurityConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListSecurityConfigurationsWithContext(ctx aws.Context, input *ListSecurityConfigurationsInput, opts ...request.Option) (*ListSecurityConfigurationsOutput, error) {
	req, out := c.ListSecurityConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityConfigurationsPages iterates over the pages of a ListSecurityConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSecurityConfigurations operation.
//    pageNum := 0
//    err := client.ListSecurityConfigurationsPages(params,
//        func(page *emr.ListSecurityConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListSecurityConfigurationsPages(input *ListSecurityConfigurationsInput, fn func(*ListSecurityConfigurationsOutput, bool) bool) error {
	return c.ListSecurityConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityConfigurationsPagesWithContext same as ListSecurityConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListSecurityConfigurationsPagesWithContext(ctx aws.Context, input *ListSecurityConfigurationsInput, fn func(*ListSecurityConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSteps = "ListSteps"

// ListStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSteps for more information on using the ListSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStepsRequest method.
//    req, resp := client.ListStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps
func (c *EMR) ListStepsRequest(input *ListStepsInput) (req *request.Request, output *ListStepsOutput) {
	op := &request.Operation{
		Name:       opListSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepsInput{}
	}

	output = &ListStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSteps API operation for Amazon Elastic MapReduce.
//
// Provides a list of steps for the cluster in reverse order unless you specify
// stepIds with the request of filter by StepStates. You can specify a maximum
// of 10 stepIDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListSteps for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps
func (c *EMR) ListSteps(input *ListStepsInput) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	return out, req.Send()
}

// ListStepsWithContext is the same as ListSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStepsWithContext(ctx aws.Context, input *ListStepsInput, opts ...request.Option) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStepsPages iterates over the pages of a ListSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSteps operation.
//    pageNum := 0
//    err := client.ListStepsPages(params,
//        func(page *emr.ListStepsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListStepsPages(input *ListStepsInput, fn func(*ListStepsOutput, bool) bool) error {
	return c.ListStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStepsPagesWithContext same as ListStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStepsPagesWithContext(ctx aws.Context, input *ListStepsInput, fn func(*ListStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStudioSessionMappings = "ListStudioSessionMappings"

// ListStudioSessionMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListStudioSessionMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStudioSessionMappings for more information on using the ListStudioSessionMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStudioSessionMappingsRequest method.
//    req, resp := client.ListStudioSessionMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings
func (c *EMR) ListStudioSessionMappingsRequest(input *ListStudioSessionMappingsInput) (req *request.Request, output *ListStudioSessionMappingsOutput) {
	op := &request.Operation{
		Name:       opListStudioSessionMappings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStudioSessionMappingsInput{}
	}

	output = &ListStudioSessionMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStudioSessionMappings API operation for Amazon Elastic MapReduce.
//
// Returns a list of all user or group session mappings for the Amazon EMR Studio
// specified by StudioId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListStudioSessionMappings for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings
func (c *EMR) ListStudioSessionMappings(input *ListStudioSessionMappingsInput) (*ListStudioSessionMappingsOutput, error) {
	req, out := c.ListStudioSessionMappingsRequest(input)
	return out, req.Send()
}

// ListStudioSessionMappingsWithContext is the same as ListStudioSessionMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListStudioSessionMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStudioSessionMappingsWithContext(ctx aws.Context, input *ListStudioSessionMappingsInput, opts ...request.Option) (*ListStudioSessionMappingsOutput, error) {
	req, out := c.ListStudioSessionMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStudioSessionMappingsPages iterates over the pages of a ListStudioSessionMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStudioSessionMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStudioSessionMappings operation.
//    pageNum := 0
//    err := client.ListStudioSessionMappingsPages(params,
//        func(page *emr.ListStudioSessionMappingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListStudioSessionMappingsPages(input *ListStudioSessionMappingsInput, fn func(*ListStudioSessionMappingsOutput, bool) bool) error {
	return c.ListStudioSessionMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStudioSessionMappingsPagesWithContext same as ListStudioSessionMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStudioSessionMappingsPagesWithContext(ctx aws.Context, input *ListStudioSessionMappingsInput, fn func(*ListStudioSessionMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStudioSessionMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStudioSessionMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStudioSessionMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStudios = "ListStudios"

// ListStudiosRequest generates a "aws/request.Request" representing the
// client's request for the ListStudios operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStudios for more information on using the ListStudios
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStudiosRequest method.
//    req, resp := client.ListStudiosRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios
func (c *EMR) ListStudiosRequest(input *ListStudiosInput) (req *request.Request, output *ListStudiosOutput) {
	op := &request.Operation{
		Name:       opListStudios,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStudiosInput{}
	}

	output = &ListStudiosOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStudios API operation for Amazon Elastic MapReduce.
//
// Returns a list of all Amazon EMR Studios associated with the AWS account.
// The list includes details such as ID, Studio Access URL, and creation time
// for each Studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ListStudios for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios
func (c *EMR) ListStudios(input *ListStudiosInput) (*ListStudiosOutput, error) {
	req, out := c.ListStudiosRequest(input)
	return out, req.Send()
}

// ListStudiosWithContext is the same as ListStudios with the addition of
// the ability to pass a context and additional request options.
//
// See ListStudios for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStudiosWithContext(ctx aws.Context, input *ListStudiosInput, opts ...request.Option) (*ListStudiosOutput, error) {
	req, out := c.ListStudiosRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStudiosPages iterates over the pages of a ListStudios operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStudios method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStudios operation.
//    pageNum := 0
//    err := client.ListStudiosPages(params,
//        func(page *emr.ListStudiosOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EMR) ListStudiosPages(input *ListStudiosInput, fn func(*ListStudiosOutput, bool) bool) error {
	return c.ListStudiosPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStudiosPagesWithContext same as ListStudiosPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListStudiosPagesWithContext(ctx aws.Context, input *ListStudiosInput, fn func(*ListStudiosOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStudiosInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStudiosRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStudiosOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyCluster for more information on using the ModifyCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClusterRequest method.
//    req, resp := client.ModifyClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster
func (c *EMR) ModifyClusterRequest(input *ModifyClusterInput) (req *request.Request, output *ModifyClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	output = &ModifyClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCluster API operation for Amazon Elastic MapReduce.
//
// Modifies the number of steps that can be executed concurrently for the cluster
// specified using ClusterID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ModifyCluster for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster
func (c *EMR) ModifyCluster(input *ModifyClusterInput) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	return out, req.Send()
}

// ModifyClusterWithContext is the same as ModifyCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ModifyClusterWithContext(ctx aws.Context, input *ModifyClusterInput, opts ...request.Option) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyInstanceFleet = "ModifyInstanceFleet"

// ModifyInstanceFleetRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstanceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyInstanceFleet for more information on using the ModifyInstanceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyInstanceFleetRequest method.
//    req, resp := client.ModifyInstanceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet
func (c *EMR) ModifyInstanceFleetRequest(input *ModifyInstanceFleetInput) (req *request.Request, output *ModifyInstanceFleetOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceFleetInput{}
	}

	output = &ModifyInstanceFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyInstanceFleet API operation for Amazon Elastic MapReduce.
//
// Modifies the target On-Demand and target Spot capacities for the instance
// fleet with the specified InstanceFleetID within the cluster specified using
// ClusterID. The call either succeeds or fails atomically.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ModifyInstanceFleet for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet
func (c *EMR) ModifyInstanceFleet(input *ModifyInstanceFleetInput) (*ModifyInstanceFleetOutput, error) {
	req, out := c.ModifyInstanceFleetRequest(input)
	return out, req.Send()
}

// ModifyInstanceFleetWithContext is the same as ModifyInstanceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyInstanceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ModifyInstanceFleetWithContext(ctx aws.Context, input *ModifyInstanceFleetInput, opts ...request.Option) (*ModifyInstanceFleetOutput, error) {
	req, out := c.ModifyInstanceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyInstanceGroups = "ModifyInstanceGroups"

// ModifyInstanceGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ModifyInstanceGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyInstanceGroups for more information on using the ModifyInstanceGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyInstanceGroupsRequest method.
//    req, resp := client.ModifyInstanceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups
func (c *EMR) ModifyInstanceGroupsRequest(input *ModifyInstanceGroupsInput) (req *request.Request, output *ModifyInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceGroupsInput{}
	}

	output = &ModifyInstanceGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyInstanceGroups API operation for Amazon Elastic MapReduce.
//
// ModifyInstanceGroups modifies the number of nodes and configuration settings
// of an instance group. The input parameters include the new target instance
// count for the group and the instance group ID. The call will either succeed
// or fail atomically.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation ModifyInstanceGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups
func (c *EMR) ModifyInstanceGroups(input *ModifyInstanceGroupsInput) (*ModifyInstanceGroupsOutput, error) {
	req, out := c.ModifyInstanceGroupsRequest(input)
	return out, req.Send()
}

// ModifyInstanceGroupsWithContext is the same as ModifyInstanceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyInstanceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ModifyInstanceGroupsWithContext(ctx aws.Context, input *ModifyInstanceGroupsInput, opts ...request.Option) (*ModifyInstanceGroupsOutput, error) {
	req, out := c.ModifyInstanceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAutoScalingPolicy = "PutAutoScalingPolicy"

// PutAutoScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAutoScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAutoScalingPolicy for more information on using the PutAutoScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAutoScalingPolicyRequest method.
//    req, resp := client.PutAutoScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy
func (c *EMR) PutAutoScalingPolicyRequest(input *PutAutoScalingPolicyInput) (req *request.Request, output *PutAutoScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutAutoScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAutoScalingPolicyInput{}
	}

	output = &PutAutoScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAutoScalingPolicy API operation for Amazon Elastic MapReduce.
//
// Creates or updates an automatic scaling policy for a core instance group
// or task instance group in an Amazon EMR cluster. The automatic scaling policy
// defines how an instance group dynamically adds and terminates EC2 instances
// in response to the value of a CloudWatch metric.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation PutAutoScalingPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy
func (c *EMR) PutAutoScalingPolicy(input *PutAutoScalingPolicyInput) (*PutAutoScalingPolicyOutput, error) {
	req, out := c.PutAutoScalingPolicyRequest(input)
	return out, req.Send()
}

// PutAutoScalingPolicyWithContext is the same as PutAutoScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAutoScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) PutAutoScalingPolicyWithContext(ctx aws.Context, input *PutAutoScalingPolicyInput, opts ...request.Option) (*PutAutoScalingPolicyOutput, error) {
	req, out := c.PutAutoScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBlockPublicAccessConfiguration = "PutBlockPublicAccessConfiguration"

// PutBlockPublicAccessConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBlockPublicAccessConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBlockPublicAccessConfiguration for more information on using the PutBlockPublicAccessConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBlockPublicAccessConfigurationRequest method.
//    req, resp := client.PutBlockPublicAccessConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration
func (c *EMR) PutBlockPublicAccessConfigurationRequest(input *PutBlockPublicAccessConfigurationInput) (req *request.Request, output *PutBlockPublicAccessConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBlockPublicAccessConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutBlockPublicAccessConfigurationInput{}
	}

	output = &PutBlockPublicAccessConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBlockPublicAccessConfiguration API operation for Amazon Elastic MapReduce.
//
// Creates or updates an Amazon EMR block public access configuration for your
// AWS account in the current Region. For more information see Configure Block
// Public Access for Amazon EMR (https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html)
// in the Amazon EMR Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation PutBlockPublicAccessConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration
func (c *EMR) PutBlockPublicAccessConfiguration(input *PutBlockPublicAccessConfigurationInput) (*PutBlockPublicAccessConfigurationOutput, error) {
	req, out := c.PutBlockPublicAccessConfigurationRequest(input)
	return out, req.Send()
}

// PutBlockPublicAccessConfigurationWithContext is the same as PutBlockPublicAccessConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBlockPublicAccessConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) PutBlockPublicAccessConfigurationWithContext(ctx aws.Context, input *PutBlockPublicAccessConfigurationInput, opts ...request.Option) (*PutBlockPublicAccessConfigurationOutput, error) {
	req, out := c.PutBlockPublicAccessConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutManagedScalingPolicy = "PutManagedScalingPolicy"

// PutManagedScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutManagedScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutManagedScalingPolicy for more information on using the PutManagedScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutManagedScalingPolicyRequest method.
//    req, resp := client.PutManagedScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy
func (c *EMR) PutManagedScalingPolicyRequest(input *PutManagedScalingPolicyInput) (req *request.Request, output *PutManagedScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutManagedScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutManagedScalingPolicyInput{}
	}

	output = &PutManagedScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutManagedScalingPolicy API operation for Amazon Elastic MapReduce.
//
// Creates or updates a managed scaling policy for an Amazon EMR cluster. The
// managed scaling policy defines the limits for resources, such as EC2 instances
// that can be added or terminated from a cluster. The policy only applies to
// the core and task nodes. The master node cannot be scaled after initial configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation PutManagedScalingPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy
func (c *EMR) PutManagedScalingPolicy(input *PutManagedScalingPolicyInput) (*PutManagedScalingPolicyOutput, error) {
	req, out := c.PutManagedScalingPolicyRequest(input)
	return out, req.Send()
}

// PutManagedScalingPolicyWithContext is the same as PutManagedScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutManagedScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) PutManagedScalingPolicyWithContext(ctx aws.Context, input *PutManagedScalingPolicyInput, opts ...request.Option) (*PutManagedScalingPolicyOutput, error) {
	req, out := c.PutManagedScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAutoScalingPolicy = "RemoveAutoScalingPolicy"

// RemoveAutoScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAutoScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAutoScalingPolicy for more information on using the RemoveAutoScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAutoScalingPolicyRequest method.
//    req, resp := client.RemoveAutoScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy
func (c *EMR) RemoveAutoScalingPolicyRequest(input *RemoveAutoScalingPolicyInput) (req *request.Request, output *RemoveAutoScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opRemoveAutoScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveAutoScalingPolicyInput{}
	}

	output = &RemoveAutoScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveAutoScalingPolicy API operation for Amazon Elastic MapReduce.
//
// Removes an automatic scaling policy from a specified instance group within
// an EMR cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RemoveAutoScalingPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy
func (c *EMR) RemoveAutoScalingPolicy(input *RemoveAutoScalingPolicyInput) (*RemoveAutoScalingPolicyOutput, error) {
	req, out := c.RemoveAutoScalingPolicyRequest(input)
	return out, req.Send()
}

// RemoveAutoScalingPolicyWithContext is the same as RemoveAutoScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAutoScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RemoveAutoScalingPolicyWithContext(ctx aws.Context, input *RemoveAutoScalingPolicyInput, opts ...request.Option) (*RemoveAutoScalingPolicyOutput, error) {
	req, out := c.RemoveAutoScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveManagedScalingPolicy = "RemoveManagedScalingPolicy"

// RemoveManagedScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the RemoveManagedScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveManagedScalingPolicy for more information on using the RemoveManagedScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveManagedScalingPolicyRequest method.
//    req, resp := client.RemoveManagedScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy
func (c *EMR) RemoveManagedScalingPolicyRequest(input *RemoveManagedScalingPolicyInput) (req *request.Request, output *RemoveManagedScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opRemoveManagedScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveManagedScalingPolicyInput{}
	}

	output = &RemoveManagedScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveManagedScalingPolicy API operation for Amazon Elastic MapReduce.
//
// Removes a managed scaling policy from a specified EMR cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RemoveManagedScalingPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy
func (c *EMR) RemoveManagedScalingPolicy(input *RemoveManagedScalingPolicyInput) (*RemoveManagedScalingPolicyOutput, error) {
	req, out := c.RemoveManagedScalingPolicyRequest(input)
	return out, req.Send()
}

// RemoveManagedScalingPolicyWithContext is the same as RemoveManagedScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveManagedScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RemoveManagedScalingPolicyWithContext(ctx aws.Context, input *RemoveManagedScalingPolicyInput, opts ...request.Option) (*RemoveManagedScalingPolicyOutput, error) {
	req, out := c.RemoveManagedScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags
func (c *EMR) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon Elastic MapReduce.
//
// Removes tags from an Amazon EMR resource. Tags make it easier to associate
// clusters in various ways, such as grouping clusters to track your Amazon
// EMR resource allocation costs. For more information, see Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
//
// The following example removes the stack tag with value Prod from a cluster:
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RemoveTags for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags
func (c *EMR) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunJobFlow = "RunJobFlow"

// RunJobFlowRequest generates a "aws/request.Request" representing the
// client's request for the RunJobFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RunJobFlow for more information on using the RunJobFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RunJobFlowRequest method.
//    req, resp := client.RunJobFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow
func (c *EMR) RunJobFlowRequest(input *RunJobFlowInput) (req *request.Request, output *RunJobFlowOutput) {
	op := &request.Operation{
		Name:       opRunJobFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunJobFlowInput{}
	}

	output = &RunJobFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RunJobFlow API operation for Amazon Elastic MapReduce.
//
// RunJobFlow creates and starts running a new cluster (job flow). The cluster
// runs the steps specified. After the steps complete, the cluster stops and
// the HDFS partition is lost. To prevent loss of data, configure the last step
// of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig
// KeepJobFlowAliveWhenNoSteps parameter is set to TRUE, the cluster transitions
// to the WAITING state rather than shutting down after the steps have completed.
//
// For additional protection, you can set the JobFlowInstancesConfig TerminationProtected
// parameter to TRUE to lock the cluster and prevent it from being terminated
// by API call, user intervention, or in the event of a job flow error.
//
// A maximum of 256 steps are allowed in each job flow.
//
// If your cluster is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using the SSH shell to
// connect to the master node and submitting queries directly to the software
// running on the master node, such as Hive and Hadoop. For more information
// on how to do this, see Add More than 256 Steps to a Cluster (https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html)
// in the Amazon EMR Management Guide.
//
// For long running clusters, we recommend that you periodically store your
// results.
//
// The instance fleets configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain
// InstanceFleets parameters or InstanceGroups parameters, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation RunJobFlow for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow
func (c *EMR) RunJobFlow(input *RunJobFlowInput) (*RunJobFlowOutput, error) {
	req, out := c.RunJobFlowRequest(input)
	return out, req.Send()
}

// RunJobFlowWithContext is the same as RunJobFlow with the addition of
// the ability to pass a context and additional request options.
//
// See RunJobFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RunJobFlowWithContext(ctx aws.Context, input *RunJobFlowInput, opts ...request.Option) (*RunJobFlowOutput, error) {
	req, out := c.RunJobFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTerminationProtection = "SetTerminationProtection"

// SetTerminationProtectionRequest generates a "aws/request.Request" representing the
// client's request for the SetTerminationProtection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTerminationProtection for more information on using the SetTerminationProtection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetTerminationProtectionRequest method.
//    req, resp := client.SetTerminationProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection
func (c *EMR) SetTerminationProtectionRequest(input *SetTerminationProtectionInput) (req *request.Request, output *SetTerminationProtectionOutput) {
	op := &request.Operation{
		Name:       opSetTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTerminationProtectionInput{}
	}

	output = &SetTerminationProtectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetTerminationProtection API operation for Amazon Elastic MapReduce.
//
// SetTerminationProtection locks a cluster (job flow) so the EC2 instances
// in the cluster cannot be terminated by user intervention, an API call, or
// in the event of a job-flow error. The cluster still terminates upon successful
// completion of the job flow. Calling SetTerminationProtection on a cluster
// is similar to calling the Amazon EC2 DisableAPITermination API on all EC2
// instances in a cluster.
//
// SetTerminationProtection is used to prevent accidental termination of a cluster
// and to ensure that in the event of an error, the instances persist so that
// you can recover any data stored in their ephemeral instance storage.
//
// To terminate a cluster that has been locked by setting SetTerminationProtection
// to true, you must first unlock the job flow by a subsequent call to SetTerminationProtection
// in which you set the value to false.
//
// For more information, seeManaging Cluster Termination (https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html)
// in the Amazon EMR Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation SetTerminationProtection for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection
func (c *EMR) SetTerminationProtection(input *SetTerminationProtectionInput) (*SetTerminationProtectionOutput, error) {
	req, out := c.SetTerminationProtectionRequest(input)
	return out, req.Send()
}

// SetTerminationProtectionWithContext is the same as SetTerminationProtection with the addition of
// the ability to pass a context and additional request options.
//
// See SetTerminationProtection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) SetTerminationProtectionWithContext(ctx aws.Context, input *SetTerminationProtectionInput, opts ...request.Option) (*SetTerminationProtectionOutput, error) {
	req, out := c.SetTerminationProtectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetVisibleToAllUsers = "SetVisibleToAllUsers"

// SetVisibleToAllUsersRequest generates a "aws/request.Request" representing the
// client's request for the SetVisibleToAllUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetVisibleToAllUsers for more information on using the SetVisibleToAllUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetVisibleToAllUsersRequest method.
//    req, resp := client.SetVisibleToAllUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers
func (c *EMR) SetVisibleToAllUsersRequest(input *SetVisibleToAllUsersInput) (req *request.Request, output *SetVisibleToAllUsersOutput) {
	op := &request.Operation{
		Name:       opSetVisibleToAllUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetVisibleToAllUsersInput{}
	}

	output = &SetVisibleToAllUsersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetVisibleToAllUsers API operation for Amazon Elastic MapReduce.
//
// Sets the Cluster$VisibleToAllUsers value, which determines whether the cluster
// is visible to all IAM users of the AWS account associated with the cluster.
// Only the IAM user who created the cluster or the AWS account root user can
// call this action. The default value, true, indicates that all IAM users in
// the AWS account can perform cluster actions if they have the proper IAM policy
// permissions. If set to false, only the IAM user that created the cluster
// can perform actions. This action works on running clusters. You can override
// the default true setting when you create a cluster by using the VisibleToAllUsers
// parameter with RunJobFlow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation SetVisibleToAllUsers for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers
func (c *EMR) SetVisibleToAllUsers(input *SetVisibleToAllUsersInput) (*SetVisibleToAllUsersOutput, error) {
	req, out := c.SetVisibleToAllUsersRequest(input)
	return out, req.Send()
}

// SetVisibleToAllUsersWithContext is the same as SetVisibleToAllUsers with the addition of
// the ability to pass a context and additional request options.
//
// See SetVisibleToAllUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) SetVisibleToAllUsersWithContext(ctx aws.Context, input *SetVisibleToAllUsersInput, opts ...request.Option) (*SetVisibleToAllUsersOutput, error) {
	req, out := c.SetVisibleToAllUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartNotebookExecution = "StartNotebookExecution"

// StartNotebookExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartNotebookExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartNotebookExecution for more information on using the StartNotebookExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartNotebookExecutionRequest method.
//    req, resp := client.StartNotebookExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution
func (c *EMR) StartNotebookExecutionRequest(input *StartNotebookExecutionInput) (req *request.Request, output *StartNotebookExecutionOutput) {
	op := &request.Operation{
		Name:       opStartNotebookExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartNotebookExecutionInput{}
	}

	output = &StartNotebookExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartNotebookExecution API operation for Amazon Elastic MapReduce.
//
// Starts a notebook execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation StartNotebookExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution
func (c *EMR) StartNotebookExecution(input *StartNotebookExecutionInput) (*StartNotebookExecutionOutput, error) {
	req, out := c.StartNotebookExecutionRequest(input)
	return out, req.Send()
}

// StartNotebookExecutionWithContext is the same as StartNotebookExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartNotebookExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) StartNotebookExecutionWithContext(ctx aws.Context, input *StartNotebookExecutionInput, opts ...request.Option) (*StartNotebookExecutionOutput, error) {
	req, out := c.StartNotebookExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopNotebookExecution = "StopNotebookExecution"

// StopNotebookExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopNotebookExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopNotebookExecution for more information on using the StopNotebookExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopNotebookExecutionRequest method.
//    req, resp := client.StopNotebookExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution
func (c *EMR) StopNotebookExecutionRequest(input *StopNotebookExecutionInput) (req *request.Request, output *StopNotebookExecutionOutput) {
	op := &request.Operation{
		Name:       opStopNotebookExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopNotebookExecutionInput{}
	}

	output = &StopNotebookExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopNotebookExecution API operation for Amazon Elastic MapReduce.
//
// Stops a notebook execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation StopNotebookExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution
func (c *EMR) StopNotebookExecution(input *StopNotebookExecutionInput) (*StopNotebookExecutionOutput, error) {
	req, out := c.StopNotebookExecutionRequest(input)
	return out, req.Send()
}

// StopNotebookExecutionWithContext is the same as StopNotebookExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopNotebookExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) StopNotebookExecutionWithContext(ctx aws.Context, input *StopNotebookExecutionInput, opts ...request.Option) (*StopNotebookExecutionOutput, error) {
	req, out := c.StopNotebookExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateJobFlows = "TerminateJobFlows"

// TerminateJobFlowsRequest generates a "aws/request.Request" representing the
// client's request for the TerminateJobFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateJobFlows for more information on using the TerminateJobFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateJobFlowsRequest method.
//    req, resp := client.TerminateJobFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows
func (c *EMR) TerminateJobFlowsRequest(input *TerminateJobFlowsInput) (req *request.Request, output *TerminateJobFlowsOutput) {
	op := &request.Operation{
		Name:       opTerminateJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateJobFlowsInput{}
	}

	output = &TerminateJobFlowsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateJobFlows API operation for Amazon Elastic MapReduce.
//
// TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow
// is shut down, any step not yet completed is canceled and the EC2 instances
// on which the cluster is running are stopped. Any log files not already saved
// are uploaded to Amazon S3 if a LogUri was specified when the cluster was
// created.
//
// The maximum number of clusters allowed is 10. The call to TerminateJobFlows
// is asynchronous. Depending on the configuration of the cluster, it may take
// up to 1-5 minutes for the cluster to completely terminate and release allocated
// resources, such as Amazon EC2 instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation TerminateJobFlows for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows
func (c *EMR) TerminateJobFlows(input *TerminateJobFlowsInput) (*TerminateJobFlowsOutput, error) {
	req, out := c.TerminateJobFlowsRequest(input)
	return out, req.Send()
}

// TerminateJobFlowsWithContext is the same as TerminateJobFlows with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateJobFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) TerminateJobFlowsWithContext(ctx aws.Context, input *TerminateJobFlowsInput, opts ...request.Option) (*TerminateJobFlowsOutput, error) {
	req, out := c.TerminateJobFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStudio = "UpdateStudio"

// UpdateStudioRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStudio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStudio for more information on using the UpdateStudio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStudioRequest method.
//    req, resp := client.UpdateStudioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudio
func (c *EMR) UpdateStudioRequest(input *UpdateStudioInput) (req *request.Request, output *UpdateStudioOutput) {
	op := &request.Operation{
		Name:       opUpdateStudio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStudioInput{}
	}

	output = &UpdateStudioOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStudio API operation for Amazon Elastic MapReduce.
//
// Updates an Amazon EMR Studio configuration, including attributes such as
// name, description, and subnets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation UpdateStudio for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon EMR
//   service.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudio
func (c *EMR) UpdateStudio(input *UpdateStudioInput) (*UpdateStudioOutput, error) {
	req, out := c.UpdateStudioRequest(input)
	return out, req.Send()
}

// UpdateStudioWithContext is the same as UpdateStudio with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStudio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) UpdateStudioWithContext(ctx aws.Context, input *UpdateStudioInput, opts ...request.Option) (*UpdateStudioOutput, error) {
	req, out := c.UpdateStudioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStudioSessionMapping = "UpdateStudioSessionMapping"

// UpdateStudioSessionMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStudioSessionMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStudioSessionMapping for more information on using the UpdateStudioSessionMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStudioSessionMappingRequest method.
//    req, resp := client.UpdateStudioSessionMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping
func (c *EMR) UpdateStudioSessionMappingRequest(input *UpdateStudioSessionMappingInput) (req *request.Request, output *UpdateStudioSessionMappingOutput) {
	op := &request.Operation{
		Name:       opUpdateStudioSessionMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStudioSessionMappingInput{}
	}

	output = &UpdateStudioSessionMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStudioSessionMapping API operation for Amazon Elastic MapReduce.
//
// Updates the session policy attached to the user or group for the specified
// Amazon EMR Studio.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic MapReduce's
// API operation UpdateStudioSessionMapping for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Indicates that an error occurred while processing the request and that the
//   request was not completed.
//
//   * InvalidRequestException
//   This exception occurs when there is something wrong with user input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping
func (c *EMR) UpdateStudioSessionMapping(input *UpdateStudioSessionMappingInput) (*UpdateStudioSessionMappingOutput, error) {
	req, out := c.UpdateStudioSessionMappingRequest(input)
	return out, req.Send()
}

// UpdateStudioSessionMappingWithContext is the same as UpdateStudioSessionMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStudioSessionMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) UpdateStudioSessionMappingWithContext(ctx aws.Context, input *UpdateStudioSessionMappingInput, opts ...request.Option) (*UpdateStudioSessionMappingOutput, error) {
	req, out := c.UpdateStudioSessionMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddInstanceFleetInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// Specifies the configuration of the instance fleet.
	//
	// InstanceFleet is a required field
	InstanceFleet *InstanceFleetConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddInstanceFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddInstanceFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddInstanceFleetInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.InstanceFleet == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceFleet"))
	}
	if s.InstanceFleet != nil {
		if err := s.InstanceFleet.Validate(); err != nil {
			invalidParams.AddNested("InstanceFleet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *AddInstanceFleetInput) SetClusterId(v string) *AddInstanceFleetInput {
	s.ClusterId = &v
	return s
}

// SetInstanceFleet sets the InstanceFleet field's value.
func (s *AddInstanceFleetInput) SetInstanceFleet(v *InstanceFleetConfig) *AddInstanceFleetInput {
	s.InstanceFleet = v
	return s
}

type AddInstanceFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// The unique identifier of the cluster.
	ClusterId *string `type:"string"`

	// The unique identifier of the instance fleet.
	InstanceFleetId *string `type:"string"`
}

// String returns the string representation
func (s AddInstanceFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceFleetOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *AddInstanceFleetOutput) SetClusterArn(v string) *AddInstanceFleetOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *AddInstanceFleetOutput) SetClusterId(v string) *AddInstanceFleetOutput {
	s.ClusterId = &v
	return s
}

// SetInstanceFleetId sets the InstanceFleetId field's value.
func (s *AddInstanceFleetOutput) SetInstanceFleetId(v string) *AddInstanceFleetOutput {
	s.InstanceFleetId = &v
	return s
}

// Input to an AddInstanceGroups call.
type AddInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// Instance groups to add.
	//
	// InstanceGroups is a required field
	InstanceGroups []*InstanceGroupConfig `type:"list" required:"true"`

	// Job flow in which to add the instance groups.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddInstanceGroupsInput"}
	if s.InstanceGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroups"))
	}
	if s.JobFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowId"))
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *AddInstanceGroupsInput) SetInstanceGroups(v []*InstanceGroupConfig) *AddInstanceGroupsInput {
	s.InstanceGroups = v
	return s
}

// SetJobFlowId sets the JobFlowId field's value.
func (s *AddInstanceGroupsInput) SetJobFlowId(v string) *AddInstanceGroupsInput {
	s.JobFlowId = &v
	return s
}

// Output from an AddInstanceGroups call.
type AddInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// Instance group IDs of the newly created instance groups.
	InstanceGroupIds []*string `type:"list"`

	// The job flow ID in which the instance groups are added.
	JobFlowId *string `type:"string"`
}

// String returns the string representation
func (s AddInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *AddInstanceGroupsOutput) SetClusterArn(v string) *AddInstanceGroupsOutput {
	s.ClusterArn = &v
	return s
}

// SetInstanceGroupIds sets the InstanceGroupIds field's value.
func (s *AddInstanceGroupsOutput) SetInstanceGroupIds(v []*string) *AddInstanceGroupsOutput {
	s.InstanceGroupIds = v
	return s
}

// SetJobFlowId sets the JobFlowId field's value.
func (s *AddInstanceGroupsOutput) SetJobFlowId(v string) *AddInstanceGroupsOutput {
	s.JobFlowId = &v
	return s
}

// The input argument to the AddJobFlowSteps operation.
type AddJobFlowStepsInput struct {
	_ struct{} `type:"structure"`

	// A string that uniquely identifies the job flow. This identifier is returned
	// by RunJobFlow and can also be obtained from ListClusters.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`

	// A list of StepConfig to be executed by the job flow.
	//
	// Steps is a required field
	Steps []*StepConfig `type:"list" required:"true"`
}

// String returns the string representation
func (s AddJobFlowStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddJobFlowStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddJobFlowStepsInput"}
	if s.JobFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowId"))
	}
	if s.Steps == nil {
		invalidParams.Add(request.NewErrParamRequired("Steps"))
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobFlowId sets the JobFlowId field's value.
func (s *AddJobFlowStepsInput) SetJobFlowId(v string) *AddJobFlowStepsInput {
	s.JobFlowId = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *AddJobFlowStepsInput) SetSteps(v []*StepConfig) *AddJobFlowStepsInput {
	s.Steps = v
	return s
}

// The output for the AddJobFlowSteps operation.
type AddJobFlowStepsOutput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the list of steps added to the job flow.
	StepIds []*string `type:"list"`
}

// String returns the string representation
func (s AddJobFlowStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsOutput) GoString() string {
	return s.String()
}

// SetStepIds sets the StepIds field's value.
func (s *AddJobFlowStepsOutput) SetStepIds(v []*string) *AddJobFlowStepsOutput {
	s.StepIds = v
	return s
}

// This input identifies a cluster and a list of tags to attach.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR resource identifier to which tags will be added. This value
	// must be a cluster identifier.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of tags to associate with a cluster and propagate to EC2 instances.
	// Tags are user-defined key-value pairs that consist of a required key string
	// with a maximum of 128 characters, and an optional value string with a maximum
	// of 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsInput) SetResourceId(v string) *AddTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsInput) SetTags(v []*Tag) *AddTagsInput {
	s.Tags = v
	return s
}

// This output indicates the result of adding tags to a resource.
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// With Amazon EMR release version 4.0 and later, the only accepted parameter
// is the application name. To pass arguments to applications, you use configuration
// classifications specified using configuration JSON objects. For more information,
// see Configuring Applications (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
//
// With earlier Amazon EMR releases, the application is any Amazon or third-party
// software that you can add to the cluster. This structure contains a list
// of strings that indicates the software to use with the cluster and accepts
// a user argument list. Amazon EMR accepts and forwards the argument list to
// the corresponding installation script as bootstrap action argument.
type Application struct {
	_ struct{} `type:"structure"`

	// This option is for advanced users only. This is meta information about third-party
	// applications that third-party vendors use for testing purposes.
	AdditionalInfo map[string]*string `type:"map"`

	// Arguments for Amazon EMR to pass to the application.
	Args []*string `type:"list"`

	// The name of the application.
	Name *string `type:"string"`

	// The version of the application.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *Application) SetAdditionalInfo(v map[string]*string) *Application {
	s.AdditionalInfo = v
	return s
}

// SetArgs sets the Args field's value.
func (s *Application) SetArgs(v []*string) *Application {
	s.Args = v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Application) SetVersion(v string) *Application {
	s.Version = &v
	return s
}

// An automatic scaling policy for a core instance group or task instance group
// in an Amazon EMR cluster. An automatic scaling policy defines how an instance
// group dynamically adds and terminates EC2 instances in response to the value
// of a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The upper and lower EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above
	// or below these limits.
	//
	// Constraints is a required field
	Constraints *ScalingConstraints `type:"structure" required:"true"`

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	//
	// Rules is a required field
	Rules []*ScalingRule `type:"list" required:"true"`
}

// String returns the string representation
func (s AutoScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingPolicy"}
	if s.Constraints == nil {
		invalidParams.Add(request.NewErrParamRequired("Constraints"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Constraints != nil {
		if err := s.Constraints.Validate(); err != nil {
			invalidParams.AddNested("Constraints", err.(request.ErrInvalidParams))
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstraints sets the Constraints field's value.
func (s *AutoScalingPolicy) SetConstraints(v *ScalingConstraints) *AutoScalingPolicy {
	s.Constraints = v
	return s
}

// SetRules sets the Rules field's value.
func (s *AutoScalingPolicy) SetRules(v []*ScalingRule) *AutoScalingPolicy {
	s.Rules = v
	return s
}

// An automatic scaling policy for a core instance group or task instance group
// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
// group dynamically adds and terminates EC2 instances in response to the value
// of a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The upper and lower EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above
	// or below these limits.
	Constraints *ScalingConstraints `type:"structure"`

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	Rules []*ScalingRule `type:"list"`

	// The status of an automatic scaling policy.
	Status *AutoScalingPolicyStatus `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicyDescription) GoString() string {
	return s.String()
}

// SetConstraints sets the Constraints field's value.
func (s *AutoScalingPolicyDescription) SetConstraints(v *ScalingConstraints) *AutoScalingPolicyDescription {
	s.Constraints = v
	return s
}

// SetRules sets the Rules field's value.
func (s *AutoScalingPolicyDescription) SetRules(v []*ScalingRule) *AutoScalingPolicyDescription {
	s.Rules = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoScalingPolicyDescription) SetStatus(v *AutoScalingPolicyStatus) *AutoScalingPolicyDescription {
	s.Status = v
	return s
}

// The reason for an AutoScalingPolicyStatus change.
type AutoScalingPolicyStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The code indicating the reason for the change in status.USER_REQUEST indicates
	// that the scaling policy status was changed by a user. PROVISION_FAILURE indicates
	// that the status change was because the policy failed to provision. CLEANUP_FAILURE
	// indicates an error.
	Code *string `type:"string" enum:"AutoScalingPolicyStateChangeReasonCode"`

	// A friendly, more verbose message that accompanies an automatic scaling policy
	// state change.
	Message *string `type:"string"`
}

// String returns the string representation
func (s AutoScalingPolicyStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicyStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AutoScalingPolicyStateChangeReason) SetCode(v string) *AutoScalingPolicyStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AutoScalingPolicyStateChangeReason) SetMessage(v string) *AutoScalingPolicyStateChangeReason {
	s.Message = &v
	return s
}

// The status of an automatic scaling policy.
type AutoScalingPolicyStatus struct {
	_ struct{} `type:"structure"`

	// Indicates the status of the automatic scaling policy.
	State *string `type:"string" enum:"AutoScalingPolicyState"`

	// The reason for a change in status.
	StateChangeReason *AutoScalingPolicyStateChangeReason `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingPolicyStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AutoScalingPolicyStatus) SetState(v string) *AutoScalingPolicyStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *AutoScalingPolicyStatus) SetStateChangeReason(v *AutoScalingPolicyStateChangeReason) *AutoScalingPolicyStatus {
	s.StateChangeReason = v
	return s
}

// A configuration for Amazon EMR block public access. When BlockPublicSecurityGroupRules
// is set to true, Amazon EMR prevents cluster creation if one of the cluster's
// security groups has a rule that allows inbound traffic from 0.0.0.0/0 or
// ::/0 on a port, unless the port is specified as an exception using PermittedPublicSecurityGroupRuleRanges.
type BlockPublicAccessConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon EMR block public access is enabled (true) or disabled
	// (false). By default, the value is false for accounts that have created EMR
	// clusters before July 2019. For accounts created after this, the default is
	// true.
	//
	// BlockPublicSecurityGroupRules is a required field
	BlockPublicSecurityGroupRules *bool `type:"boolean" required:"true"`

	// Specifies ports and port ranges that are permitted to have security group
	// rules that allow inbound traffic from all public sources. For example, if
	// Port 23 (Telnet) is specified for PermittedPublicSecurityGroupRuleRanges,
	// Amazon EMR allows cluster creation if a security group associated with the
	// cluster has a rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0
	// or IPv6 port ::/0 as the source.
	//
	// By default, Port 22, which is used for SSH access to the cluster EC2 instances,
	// is in the list of PermittedPublicSecurityGroupRuleRanges.
	PermittedPublicSecurityGroupRuleRanges []*PortRange `type:"list"`
}

// String returns the string representation
func (s BlockPublicAccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockPublicAccessConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockPublicAccessConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockPublicAccessConfiguration"}
	if s.BlockPublicSecurityGroupRules == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockPublicSecurityGroupRules"))
	}
	if s.PermittedPublicSecurityGroupRuleRanges != nil {
		for i, v := range s.PermittedPublicSecurityGroupRuleRanges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PermittedPublicSecurityGroupRuleRanges", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockPublicSecurityGroupRules sets the BlockPublicSecurityGroupRules field's value.
func (s *BlockPublicAccessConfiguration) SetBlockPublicSecurityGroupRules(v bool) *BlockPublicAccessConfiguration {
	s.BlockPublicSecurityGroupRules = &v
	return s
}

// SetPermittedPublicSecurityGroupRuleRanges sets the PermittedPublicSecurityGroupRuleRanges field's value.
func (s *BlockPublicAccessConfiguration) SetPermittedPublicSecurityGroupRuleRanges(v []*PortRange) *BlockPublicAccessConfiguration {
	s.PermittedPublicSecurityGroupRuleRanges = v
	return s
}

// Properties that describe the AWS principal that created the BlockPublicAccessConfiguration
// using the PutBlockPublicAccessConfiguration action as well as the date and
// time that the configuration was created. Each time a configuration for block
// public access is updated, Amazon EMR updates this metadata.
type BlockPublicAccessConfigurationMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that created or last modified the configuration.
	//
	// CreatedByArn is a required field
	CreatedByArn *string `min:"20" type:"string" required:"true"`

	// The date and time that the configuration was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s BlockPublicAccessConfigurationMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockPublicAccessConfigurationMetadata) GoString() string {
	return s.String()
}

// SetCreatedByArn sets the CreatedByArn field's value.
func (s *BlockPublicAccessConfigurationMetadata) SetCreatedByArn(v string) *BlockPublicAccessConfigurationMetadata {
	s.CreatedByArn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BlockPublicAccessConfigurationMetadata) SetCreationDateTime(v time.Time) *BlockPublicAccessConfigurationMetadata {
	s.CreationDateTime = &v
	return s
}

// Configuration of a bootstrap action.
type BootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	// The name of the bootstrap action.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The script run by the bootstrap action.
	//
	// ScriptBootstrapAction is a required field
	ScriptBootstrapAction *ScriptBootstrapActionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s BootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BootstrapActionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BootstrapActionConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ScriptBootstrapAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptBootstrapAction"))
	}
	if s.ScriptBootstrapAction != nil {
		if err := s.ScriptBootstrapAction.Validate(); err != nil {
			invalidParams.AddNested("ScriptBootstrapAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BootstrapActionConfig) SetName(v string) *BootstrapActionConfig {
	s.Name = &v
	return s
}

// SetScriptBootstrapAction sets the ScriptBootstrapAction field's value.
func (s *BootstrapActionConfig) SetScriptBootstrapAction(v *ScriptBootstrapActionConfig) *BootstrapActionConfig {
	s.ScriptBootstrapAction = v
	return s
}

// Reports the configuration of a bootstrap action in a cluster (job flow).
type BootstrapActionDetail struct {
	_ struct{} `type:"structure"`

	// A description of the bootstrap action.
	BootstrapActionConfig *BootstrapActionConfig `type:"structure"`
}

// String returns the string representation
func (s BootstrapActionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionDetail) GoString() string {
	return s.String()
}

// SetBootstrapActionConfig sets the BootstrapActionConfig field's value.
func (s *BootstrapActionDetail) SetBootstrapActionConfig(v *BootstrapActionConfig) *BootstrapActionDetail {
	s.BootstrapActionConfig = v
	return s
}

// Specification of the status of a CancelSteps request. Available only in Amazon
// EMR version 4.8.0 and later, excluding version 5.0.0.
type CancelStepsInfo struct {
	_ struct{} `type:"structure"`

	// The reason for the failure if the CancelSteps request fails.
	Reason *string `type:"string"`

	// The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
	Status *string `type:"string" enum:"CancelStepsRequestStatus"`

	// The encrypted StepId of a step.
	StepId *string `type:"string"`
}

// String returns the string representation
func (s CancelStepsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelStepsInfo) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *CancelStepsInfo) SetReason(v string) *CancelStepsInfo {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelStepsInfo) SetStatus(v string) *CancelStepsInfo {
	s.Status = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *CancelStepsInfo) SetStepId(v string) *CancelStepsInfo {
	s.StepId = &v
	return s
}

// The input argument to the CancelSteps operation.
type CancelStepsInput struct {
	_ struct{} `type:"structure"`

	// The ClusterID for the specified steps that will be canceled. Use RunJobFlow
	// and ListClusters to get ClusterIDs.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The option to choose to cancel RUNNING steps. By default, the value is SEND_INTERRUPT.
	StepCancellationOption *string `type:"string" enum:"StepCancellationOption"`

	// The list of StepIDs to cancel. Use ListSteps to get steps and their states
	// for the specified cluster.
	//
	// StepIds is a required field
	StepIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CancelStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelStepsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.StepIds == nil {
		invalidParams.Add(request.NewErrParamRequired("StepIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *CancelStepsInput) SetClusterId(v string) *CancelStepsInput {
	s.ClusterId = &v
	return s
}

// SetStepCancellationOption sets the StepCancellationOption field's value.
func (s *CancelStepsInput) SetStepCancellationOption(v string) *CancelStepsInput {
	s.StepCancellationOption = &v
	return s
}

// SetStepIds sets the StepIds field's value.
func (s *CancelStepsInput) SetStepIds(v []*string) *CancelStepsInput {
	s.StepIds = v
	return s
}

// The output for the CancelSteps operation.
type CancelStepsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CancelStepsInfo, which shows the status of specified cancel requests
	// for each StepID specified.
	CancelStepsInfoList []*CancelStepsInfo `type:"list"`
}

// String returns the string representation
func (s CancelStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelStepsOutput) GoString() string {
	return s.String()
}

// SetCancelStepsInfoList sets the CancelStepsInfoList field's value.
func (s *CancelStepsOutput) SetCancelStepsInfoList(v []*CancelStepsInfo) *CancelStepsOutput {
	s.CancelStepsInfoList = v
	return s
}

// The definition of a CloudWatch metric alarm, which determines when an automatic
// scaling activity is triggered. When the defined alarm conditions are satisfied,
// scaling activity begins.
type CloudWatchAlarmDefinition struct {
	_ struct{} `type:"structure"`

	// Determines how the metric specified by MetricName is compared to the value
	// specified by Threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// A CloudWatch metric dimension.
	Dimensions []*MetricDimension `type:"list"`

	// The number of periods, in five-minute increments, during which the alarm
	// condition must exist before the alarm triggers automatic scaling activity.
	// The default value is 1.
	EvaluationPeriods *int64 `type:"integer"`

	// The name of the CloudWatch metric that is watched to determine an alarm condition.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace for the CloudWatch metric. The default is AWS/ElasticMapReduce.
	Namespace *string `type:"string"`

	// The period, in seconds, over which the statistic is applied. EMR CloudWatch
	// metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch
	// metric is specified, specify 300.
	//
	// Period is a required field
	Period *int64 `type:"integer" required:"true"`

	// The statistic to apply to the metric associated with the alarm. The default
	// is AVERAGE.
	Statistic *string `type:"string" enum:"Statistic"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// The unit of measure associated with the CloudWatch metric being watched.
	// The value specified for Unit must correspond to the units specified in the
	// CloudWatch metric.
	Unit *string `type:"string" enum:"Unit"`
}

// String returns the string representation
func (s CloudWatchAlarmDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchAlarmDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchAlarmDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchAlarmDefinition"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *CloudWatchAlarmDefinition) SetComparisonOperator(v string) *CloudWatchAlarmDefinition {
	s.ComparisonOperator = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *CloudWatchAlarmDefinition) SetDimensions(v []*MetricDimension) *CloudWatchAlarmDefinition {
	s.Dimensions = v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *CloudWatchAlarmDefinition) SetEvaluationPeriods(v int64) *CloudWatchAlarmDefinition {
	s.EvaluationPeriods = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchAlarmDefinition) SetMetricName(v string) *CloudWatchAlarmDefinition {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CloudWatchAlarmDefinition) SetNamespace(v string) *CloudWatchAlarmDefinition {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchAlarmDefinition) SetPeriod(v int64) *CloudWatchAlarmDefinition {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CloudWatchAlarmDefinition) SetStatistic(v string) *CloudWatchAlarmDefinition {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *CloudWatchAlarmDefinition) SetThreshold(v float64) *CloudWatchAlarmDefinition {
	s.Threshold = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CloudWatchAlarmDefinition) SetUnit(v string) *CloudWatchAlarmDefinition {
	s.Unit = &v
	return s
}

// The detailed description of the cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The applications installed on this cluster.
	Applications []*Application `type:"list"`

	// An IAM role for automatic scaling policies. The default role is EMR_AutoScaling_DefaultRole.
	// The IAM role provides permissions that the automatic scaling feature requires
	// to launch and terminate EC2 instances in an instance group.
	AutoScalingRole *string `type:"string"`

	// Specifies whether the cluster should terminate after completing all steps.
	AutoTerminate *bool `type:"boolean"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// Applies only to Amazon EMR releases 4.x and later. The list of Configurations
	// supplied to the EMR cluster.
	Configurations []*Configuration `type:"list"`

	// Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
	// Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
	CustomAmiId *string `type:"string"`

	// The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that
	// is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
	EbsRootVolumeSize *int64 `type:"integer"`

	// Provides information about the EC2 instances in a cluster grouped by category.
	// For example, key name, subnet ID, IAM instance profile, and so on.
	Ec2InstanceAttributes *Ec2InstanceAttributes `type:"structure"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	//
	// The instance group configuration of the cluster. A value of INSTANCE_GROUP
	// indicates a uniform instance group configuration. A value of INSTANCE_FLEET
	// indicates an instance fleets configuration.
	InstanceCollectionType *string `type:"string" enum:"InstanceCollectionType"`

	// Attributes for Kerberos configuration when Kerberos authentication is enabled
	// using a security configuration. For more information see Use Kerberos Authentication
	// (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
	// in the Amazon EMR Management Guide.
	KerberosAttributes *KerberosAttributes `type:"structure"`

	// The AWS KMS customer master key (CMK) used for encrypting log files. This
	// attribute is only available with EMR version 5.30.0 and later, excluding
	// EMR 6.0.0.
	LogEncryptionKmsKeyId *string `type:"string"`

	// The path to the Amazon S3 location where logs for this cluster are stored.
	LogUri *string `type:"string"`

	// The DNS name of the master node. If the cluster is on a private subnet, this
	// is the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string `type:"string"`

	// Placement group configured for an Amazon EMR cluster.
	PlacementGroups []*PlacementGroupConfig `type:"list"`

	// The Amazon EMR release label, which determines the version of open-source
	// application packages installed on the cluster. Release labels are in the
	// form emr-x.x.x, where x.x.x is an Amazon EMR release version such as emr-5.14.0.
	// For more information about Amazon EMR release versions and included application
	// versions and features, see https://docs.aws.amazon.com/emr/latest/ReleaseGuide/
	// (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/). The release label
	// applies only to Amazon EMR releases version 4.0 and later. Earlier versions
	// use AmiVersion.
	ReleaseLabel *string `type:"string"`

	// Applies only when CustomAmiID is used. Specifies the type of updates that
	// are applied from the Amazon Linux AMI package repositories when an instance
	// boots using the AMI.
	RepoUpgradeOnBoot *string `type:"string" enum:"RepoUpgradeOnBoot"`

	// The AMI version requested for this cluster.
	RequestedAmiVersion *string `type:"string"`

	// The AMI version running on this cluster.
	RunningAmiVersion *string `type:"string"`

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
	// indicates that Amazon EMR terminates nodes at the instance-hour boundary,
	// regardless of when the request to terminate the instance was submitted. This
	// option is only available with Amazon EMR 5.1.0 and later and is the default
	// for clusters created using that version. TERMINATE_AT_TASK_COMPLETION indicates
	// that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
	// terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
	// With either behavior, Amazon EMR removes the least active nodes first and
	// blocks instance termination if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION
	// is available only in Amazon EMR version 4.1.0 and later, and is the default
	// for versions of Amazon EMR earlier than 5.1.0.
	ScaleDownBehavior *string `type:"string" enum:"ScaleDownBehavior"`

	// The name of the security configuration applied to the cluster.
	SecurityConfiguration *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// The current status details about the cluster.
	Status *ClusterStatus `type:"structure"`

	// Specifies the number of steps that can be executed concurrently.
	StepConcurrencyLevel *int64 `type:"integer"`

	// A list of tags associated with a cluster.
	Tags []*Tag `type:"list"`

	// Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances
	// from being terminated by an API call or user intervention, or in the event
	// of a cluster error.
	TerminationProtected *bool `type:"boolean"`

	// Indicates whether the cluster is visible to all IAM users of the AWS account
	// associated with the cluster. The default value, true, indicates that all
	// IAM users in the AWS account can perform cluster actions if they have the
	// proper IAM policy permissions. If this value is false, only the IAM user
	// that created the cluster can perform actions. This value can be changed on
	// a running cluster by using the SetVisibleToAllUsers action. You can override
	// the default value of true when you create a cluster by using the VisibleToAllUsers
	// parameter of the RunJobFlow action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *Cluster) SetApplications(v []*Application) *Cluster {
	s.Applications = v
	return s
}

// SetAutoScalingRole sets the AutoScalingRole field's value.
func (s *Cluster) SetAutoScalingRole(v string) *Cluster {
	s.AutoScalingRole = &v
	return s
}

// SetAutoTerminate sets the AutoTerminate field's value.
func (s *Cluster) SetAutoTerminate(v bool) *Cluster {
	s.AutoTerminate = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *Cluster) SetConfigurations(v []*Configuration) *Cluster {
	s.Configurations = v
	return s
}

// SetCustomAmiId sets the CustomAmiId field's value.
func (s *Cluster) SetCustomAmiId(v string) *Cluster {
	s.CustomAmiId = &v
	return s
}

// SetEbsRootVolumeSize sets the EbsRootVolumeSize field's value.
func (s *Cluster) SetEbsRootVolumeSize(v int64) *Cluster {
	s.EbsRootVolumeSize = &v
	return s
}

// SetEc2InstanceAttributes sets the Ec2InstanceAttributes field's value.
func (s *Cluster) SetEc2InstanceAttributes(v *Ec2InstanceAttributes) *Cluster {
	s.Ec2InstanceAttributes = v
	return s
}

// SetId sets the Id field's value.
func (s *Cluster) SetId(v string) *Cluster {
	s.Id = &v
	return s
}

// SetInstanceCollectionType sets the InstanceCollectionType field's value.
func (s *Cluster) SetInstanceCollectionType(v string) *Cluster {
	s.InstanceCollectionType = &v
	return s
}

// SetKerberosAttributes sets the KerberosAttributes field's value.
func (s *Cluster) SetKerberosAttributes(v *KerberosAttributes) *Cluster {
	s.KerberosAttributes = v
	return s
}

// SetLogEncryptionKmsKeyId sets the LogEncryptionKmsKeyId field's value.
func (s *Cluster) SetLogEncryptionKmsKeyId(v string) *Cluster {
	s.LogEncryptionKmsKeyId = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *Cluster) SetLogUri(v string) *Cluster {
	s.LogUri = &v
	return s
}

// SetMasterPublicDnsName sets the MasterPublicDnsName field's value.
func (s *Cluster) SetMasterPublicDnsName(v string) *Cluster {
	s.MasterPublicDnsName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetNormalizedInstanceHours sets the NormalizedInstanceHours field's value.
func (s *Cluster) SetNormalizedInstanceHours(v int64) *Cluster {
	s.NormalizedInstanceHours = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *Cluster) SetOutpostArn(v string) *Cluster {
	s.OutpostArn = &v
	return s
}

// SetPlacementGroups sets the PlacementGroups field's value.
func (s *Cluster) SetPlacementGroups(v []*PlacementGroupConfig) *Cluster {
	s.PlacementGroups = v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *Cluster) SetReleaseLabel(v string) *Cluster {
	s.ReleaseLabel = &v
	return s
}

// SetRepoUpgradeOnBoot sets the RepoUpgradeOnBoot field's value.
func (s *Cluster) SetRepoUpgradeOnBoot(v string) *Cluster {
	s.RepoUpgradeOnBoot = &v
	return s
}

// SetRequestedAmiVersion sets the RequestedAmiVersion field's value.
func (s *Cluster) SetRequestedAmiVersion(v string) *Cluster {
	s.RequestedAmiVersion = &v
	return s
}

// SetRunningAmiVersion sets the RunningAmiVersion field's value.
func (s *Cluster) SetRunningAmiVersion(v string) *Cluster {
	s.RunningAmiVersion = &v
	return s
}

// SetScaleDownBehavior sets the ScaleDownBehavior field's value.
func (s *Cluster) SetScaleDownBehavior(v string) *Cluster {
	s.ScaleDownBehavior = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *Cluster) SetSecurityConfiguration(v string) *Cluster {
	s.SecurityConfiguration = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Cluster) SetServiceRole(v string) *Cluster {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v *ClusterStatus) *Cluster {
	s.Status = v
	return s
}

// SetStepConcurrencyLevel sets the StepConcurrencyLevel field's value.
func (s *Cluster) SetStepConcurrencyLevel(v int64) *Cluster {
	s.StepConcurrencyLevel = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v []*Tag) *Cluster {
	s.Tags = v
	return s
}

// SetTerminationProtected sets the TerminationProtected field's value.
func (s *Cluster) SetTerminationProtected(v bool) *Cluster {
	s.TerminationProtected = &v
	return s
}

// SetVisibleToAllUsers sets the VisibleToAllUsers field's value.
func (s *Cluster) SetVisibleToAllUsers(v bool) *Cluster {
	s.VisibleToAllUsers = &v
	return s
}

// The reason that the cluster changed to its current state.
type ClusterStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmatic code for the state change reason.
	Code *string `type:"string" enum:"ClusterStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s ClusterStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ClusterStateChangeReason) SetCode(v string) *ClusterStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ClusterStateChangeReason) SetMessage(v string) *ClusterStateChangeReason {
	s.Message = &v
	return s
}

// The detailed status of the cluster.
type ClusterStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the cluster.
	State *string `type:"string" enum:"ClusterState"`

	// The reason for the cluster status change.
	StateChangeReason *ClusterStateChangeReason `type:"structure"`

	// A timeline that represents the status of a cluster over the lifetime of the
	// cluster.
	Timeline *ClusterTimeline `type:"structure"`
}

// String returns the string representation
func (s ClusterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *ClusterStatus) SetState(v string) *ClusterStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *ClusterStatus) SetStateChangeReason(v *ClusterStateChangeReason) *ClusterStatus {
	s.StateChangeReason = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *ClusterStatus) SetTimeline(v *ClusterTimeline) *ClusterStatus {
	s.Timeline = v
	return s
}

// The summary description of the cluster.
type ClusterSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string `type:"string"`

	// The details about the current status of the cluster.
	Status *ClusterStatus `type:"structure"`
}

// String returns the string representation
func (s ClusterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSummary) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterSummary) SetClusterArn(v string) *ClusterSummary {
	s.ClusterArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ClusterSummary) SetId(v string) *ClusterSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ClusterSummary) SetName(v string) *ClusterSummary {
	s.Name = &v
	return s
}

// SetNormalizedInstanceHours sets the NormalizedInstanceHours field's value.
func (s *ClusterSummary) SetNormalizedInstanceHours(v int64) *ClusterSummary {
	s.NormalizedInstanceHours = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *ClusterSummary) SetOutpostArn(v string) *ClusterSummary {
	s.OutpostArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterSummary) SetStatus(v *ClusterStatus) *ClusterSummary {
	s.Status = v
	return s
}

// Represents the timeline of the cluster's lifecycle.
type ClusterTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the cluster.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster was ready to run steps.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ClusterTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterTimeline) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *ClusterTimeline) SetCreationDateTime(v time.Time) *ClusterTimeline {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *ClusterTimeline) SetEndDateTime(v time.Time) *ClusterTimeline {
	s.EndDateTime = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *ClusterTimeline) SetReadyDateTime(v time.Time) *ClusterTimeline {
	s.ReadyDateTime = &v
	return s
}

// An entity describing an executable that runs on a cluster.
type Command struct {
	_ struct{} `type:"structure"`

	// Arguments for Amazon EMR to pass to the command for execution.
	Args []*string `type:"list"`

	// The name of the command.
	Name *string `type:"string"`

	// The Amazon S3 location of the command script.
	ScriptPath *string `type:"string"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// SetArgs sets the Args field's value.
func (s *Command) SetArgs(v []*string) *Command {
	s.Args = v
	return s
}

// SetName sets the Name field's value.
func (s *Command) SetName(v string) *Command {
	s.Name = &v
	return s
}

// SetScriptPath sets the ScriptPath field's value.
func (s *Command) SetScriptPath(v string) *Command {
	s.ScriptPath = &v
	return s
}

// The EC2 unit limits for a managed scaling policy. The managed scaling activity
// of a cluster can not be above or below these limits. The limit only applies
// to the core and task nodes. The master node cannot be scaled after initial
// configuration.
type ComputeLimits struct {
	_ struct{} `type:"structure"`

	// The upper boundary of EC2 units. It is measured through vCPU cores or instances
	// for instance groups and measured through units for instance fleets. Managed
	// scaling activities are not allowed beyond this boundary. The limit only applies
	// to the core and task nodes. The master node cannot be scaled after initial
	// configuration.
	//
	// MaximumCapacityUnits is a required field
	MaximumCapacityUnits *int64 `type:"integer" required:"true"`

	// The upper boundary of EC2 units for core node type in a cluster. It is measured
	// through vCPU cores or instances for instance groups and measured through
	// units for instance fleets. The core units are not allowed to scale beyond
	// this boundary. The parameter is used to split capacity allocation between
	// core and task nodes.
	MaximumCoreCapacityUnits *int64 `type:"integer"`

	// The upper boundary of On-Demand EC2 units. It is measured through vCPU cores
	// or instances for instance groups and measured through units for instance
	// fleets. The On-Demand units are not allowed to scale beyond this boundary.
	// The parameter is used to split capacity allocation between On-Demand and
	// Spot Instances.
	MaximumOnDemandCapacityUnits *int64 `type:"integer"`

	// The lower boundary of EC2 units. It is measured through vCPU cores or instances
	// for instance groups and measured through units for instance fleets. Managed
	// scaling activities are not allowed beyond this boundary. The limit only applies
	// to the core and task nodes. The master node cannot be scaled after initial
	// configuration.
	//
	// MinimumCapacityUnits is a required field
	MinimumCapacityUnits *int64 `type:"integer" required:"true"`

	// The unit type used for specifying a managed scaling policy.
	//
	// UnitType is a required field
	UnitType *string `type:"string" required:"true" enum:"ComputeLimitsUnitType"`
}

// String returns the string representation
func (s ComputeLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeLimits) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeLimits) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeLimits"}
	if s.MaximumCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumCapacityUnits"))
	}
	if s.MinimumCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumCapacityUnits"))
	}
	if s.UnitType == nil {
		invalidParams.Add(request.NewErrParamRequired("UnitType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumCapacityUnits sets the MaximumCapacityUnits field's value.
func (s *ComputeLimits) SetMaximumCapacityUnits(v int64) *ComputeLimits {
	s.MaximumCapacityUnits = &v
	return s
}

// SetMaximumCoreCapacityUnits sets the MaximumCoreCapacityUnits field's value.
func (s *ComputeLimits) SetMaximumCoreCapacityUnits(v int64) *ComputeLimits {
	s.MaximumCoreCapacityUnits = &v
	return s
}

// SetMaximumOnDemandCapacityUnits sets the MaximumOnDemandCapacityUnits field's value.
func (s *ComputeLimits) SetMaximumOnDemandCapacityUnits(v int64) *ComputeLimits {
	s.MaximumOnDemandCapacityUnits = &v
	return s
}

// SetMinimumCapacityUnits sets the MinimumCapacityUnits field's value.
func (s *ComputeLimits) SetMinimumCapacityUnits(v int64) *ComputeLimits {
	s.MinimumCapacityUnits = &v
	return s
}

// SetUnitType sets the UnitType field's value.
func (s *ComputeLimits) SetUnitType(v string) *ComputeLimits {
	s.UnitType = &v
	return s
}

//
// Amazon EMR releases 4.x or later.
//
// An optional configuration specification to be used when provisioning cluster
// instances, which can include configurations for applications and software
// bundled with Amazon EMR. A configuration consists of a classification, properties,
// and optional nested configurations. A classification refers to an application-specific
// configuration file. Properties are the settings you want to change in that
// file. For more information, see Configuring Applications (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
type Configuration struct {
	_ struct{} `type:"structure"`

	// The classification within a configuration.
	Classification *string `type:"string"`

	// A list of additional configurations to apply within a configuration object.
	Configurations []*Configuration `type:"list"`

	// A set of properties specified within a configuration classification.
	Properties map[string]*string `type:"map"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// SetClassification sets the Classification field's value.
func (s *Configuration) SetClassification(v string) *Configuration {
	s.Classification = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *Configuration) SetConfigurations(v []*Configuration) *Configuration {
	s.Configurations = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Configuration) SetProperties(v map[string]*string) *Configuration {
	s.Properties = v
	return s
}

type CreateSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The security configuration details in JSON format. For JSON parameters and
	// examples, see Use Security Configurations to Set Up Cluster Security (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html)
	// in the Amazon EMR Management Guide.
	//
	// SecurityConfiguration is a required field
	SecurityConfiguration *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SecurityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSecurityConfigurationInput) SetName(v string) *CreateSecurityConfigurationInput {
	s.Name = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *CreateSecurityConfigurationInput) SetSecurityConfiguration(v string) *CreateSecurityConfigurationInput {
	s.SecurityConfiguration = &v
	return s
}

type CreateSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecurityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSecurityConfigurationOutput) SetCreationDateTime(v time.Time) *CreateSecurityConfigurationOutput {
	s.CreationDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecurityConfigurationOutput) SetName(v string) *CreateSecurityConfigurationOutput {
	s.Name = &v
	return s
}

type CreateStudioInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Studio authenticates users using single sign-on (SSO)
	// or IAM. Amazon EMR Studio currently only supports SSO authentication.
	//
	// AuthMode is a required field
	AuthMode *string `type:"string" required:"true" enum:"AuthMode"`

	// The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
	// files.
	//
	// DefaultS3Location is a required field
	DefaultS3Location *string `type:"string" required:"true"`

	// A detailed description of the Amazon EMR Studio.
	Description *string `type:"string"`

	// The ID of the Amazon EMR Studio Engine security group. The Engine security
	// group allows inbound network traffic from the Workspace security group, and
	// it must be in the same VPC specified by VpcId.
	//
	// EngineSecurityGroupId is a required field
	EngineSecurityGroupId *string `type:"string" required:"true"`

	// A descriptive name for the Amazon EMR Studio.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The IAM role that will be assumed by the Amazon EMR Studio. The service role
	// provides a way for Amazon EMR Studio to interoperate with other AWS services.
	//
	// ServiceRole is a required field
	ServiceRole *string `type:"string" required:"true"`

	// A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can
	// have a maximum of 5 subnets. The subnets must belong to the VPC specified
	// by VpcId. Studio users can create a Workspace in any of the specified subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// A list of tags to associate with the Amazon EMR Studio. Tags are user-defined
	// key-value pairs that consist of a required key string with a maximum of 128
	// characters, and an optional value string with a maximum of 256 characters.
	Tags []*Tag `type:"list"`

	// The IAM user role that will be assumed by users and groups logged in to an
	// Amazon EMR Studio. The permissions attached to this IAM role can be scoped
	// down for each user or group using session policies.
	//
	// UserRole is a required field
	UserRole *string `type:"string" required:"true"`

	// The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with
	// the Studio.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`

	// The ID of the Amazon EMR Studio Workspace security group. The Workspace security
	// group allows outbound network traffic to resources in the Engine security
	// group, and it must be in the same VPC specified by VpcId.
	//
	// WorkspaceSecurityGroupId is a required field
	WorkspaceSecurityGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStudioInput"}
	if s.AuthMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthMode"))
	}
	if s.DefaultS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultS3Location"))
	}
	if s.EngineSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineSecurityGroupId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRole"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.UserRole == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRole"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.WorkspaceSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceSecurityGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthMode sets the AuthMode field's value.
func (s *CreateStudioInput) SetAuthMode(v string) *CreateStudioInput {
	s.AuthMode = &v
	return s
}

// SetDefaultS3Location sets the DefaultS3Location field's value.
func (s *CreateStudioInput) SetDefaultS3Location(v string) *CreateStudioInput {
	s.DefaultS3Location = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStudioInput) SetDescription(v string) *CreateStudioInput {
	s.Description = &v
	return s
}

// SetEngineSecurityGroupId sets the EngineSecurityGroupId field's value.
func (s *CreateStudioInput) SetEngineSecurityGroupId(v string) *CreateStudioInput {
	s.EngineSecurityGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStudioInput) SetName(v string) *CreateStudioInput {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CreateStudioInput) SetServiceRole(v string) *CreateStudioInput {
	s.ServiceRole = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateStudioInput) SetSubnetIds(v []*string) *CreateStudioInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStudioInput) SetTags(v []*Tag) *CreateStudioInput {
	s.Tags = v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *CreateStudioInput) SetUserRole(v string) *CreateStudioInput {
	s.UserRole = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateStudioInput) SetVpcId(v string) *CreateStudioInput {
	s.VpcId = &v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *CreateStudioInput) SetWorkspaceSecurityGroupId(v string) *CreateStudioInput {
	s.WorkspaceSecurityGroupId = &v
	return s
}

type CreateStudioOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`

	// The unique Studio access URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s CreateStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStudioOutput) GoString() string {
	return s.String()
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStudioOutput) SetStudioId(v string) *CreateStudioOutput {
	s.StudioId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateStudioOutput) SetUrl(v string) *CreateStudioOutput {
	s.Url = &v
	return s
}

type CreateStudioSessionMappingInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier (GUID) of the user or group from the AWS SSO
	// Identity Store. For more information, see UserId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
	// and GroupId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityId *string `type:"string"`

	// The name of the user or group. For more information, see UserName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityName *string `type:"string"`

	// Specifies whether the identity to map to the Amazon EMR Studio is a user
	// or a group.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The Amazon Resource Name (ARN) for the session policy that will be applied
	// to the user or group. Session policies refine Studio user permissions without
	// the need to use multiple IAM user roles.
	//
	// SessionPolicyArn is a required field
	SessionPolicyArn *string `type:"string" required:"true"`

	// The ID of the Amazon EMR Studio to which the user or group will be mapped.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStudioSessionMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStudioSessionMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStudioSessionMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStudioSessionMappingInput"}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.SessionPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionPolicyArn"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *CreateStudioSessionMappingInput) SetIdentityId(v string) *CreateStudioSessionMappingInput {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *CreateStudioSessionMappingInput) SetIdentityName(v string) *CreateStudioSessionMappingInput {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *CreateStudioSessionMappingInput) SetIdentityType(v string) *CreateStudioSessionMappingInput {
	s.IdentityType = &v
	return s
}

// SetSessionPolicyArn sets the SessionPolicyArn field's value.
func (s *CreateStudioSessionMappingInput) SetSessionPolicyArn(v string) *CreateStudioSessionMappingInput {
	s.SessionPolicyArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *CreateStudioSessionMappingInput) SetStudioId(v string) *CreateStudioSessionMappingInput {
	s.StudioId = &v
	return s
}

type CreateStudioSessionMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateStudioSessionMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStudioSessionMappingOutput) GoString() string {
	return s.String()
}

type DeleteSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteSecurityConfigurationInput) SetName(v string) *DeleteSecurityConfigurationInput {
	s.Name = &v
	return s
}

type DeleteSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSecurityConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStudioInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon EMR Studio.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStudioInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStudioInput) SetStudioId(v string) *DeleteStudioInput {
	s.StudioId = &v
	return s
}

type DeleteStudioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStudioOutput) GoString() string {
	return s.String()
}

type DeleteStudioSessionMappingInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier (GUID) of the user or group to remove from
	// the Amazon EMR Studio. For more information, see UserId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
	// and GroupId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityId *string `type:"string"`

	// The name of the user name or group to remove from the Amazon EMR Studio.
	// For more information, see UserName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityName *string `type:"string"`

	// Specifies whether the identity to delete from the Amazon EMR Studio is a
	// user or a group.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The ID of the Amazon EMR Studio.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStudioSessionMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStudioSessionMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStudioSessionMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStudioSessionMappingInput"}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *DeleteStudioSessionMappingInput) SetIdentityId(v string) *DeleteStudioSessionMappingInput {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *DeleteStudioSessionMappingInput) SetIdentityName(v string) *DeleteStudioSessionMappingInput {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *DeleteStudioSessionMappingInput) SetIdentityType(v string) *DeleteStudioSessionMappingInput {
	s.IdentityType = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *DeleteStudioSessionMappingInput) SetStudioId(v string) *DeleteStudioSessionMappingInput {
	s.StudioId = &v
	return s
}

type DeleteStudioSessionMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStudioSessionMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStudioSessionMappingOutput) GoString() string {
	return s.String()
}

// This input determines which cluster to describe.
type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to describe.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DescribeClusterInput) SetClusterId(v string) *DescribeClusterInput {
	s.ClusterId = &v
	return s
}

// This output contains the description of the cluster.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// This output contains the details for the requested cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DescribeClusterOutput) SetCluster(v *Cluster) *DescribeClusterOutput {
	s.Cluster = v
	return s
}

// The input for the DescribeJobFlows operation.
type DescribeJobFlowsInput struct {
	_ struct{} `type:"structure"`

	// Return only job flows created after this date and time.
	CreatedAfter *time.Time `type:"timestamp"`

	// Return only job flows created before this date and time.
	CreatedBefore *time.Time `type:"timestamp"`

	// Return only job flows whose job flow ID is contained in this list.
	JobFlowIds []*string `type:"list"`

	// Return only job flows whose state is contained in this list.
	JobFlowStates []*string `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsInput) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *DescribeJobFlowsInput) SetCreatedAfter(v time.Time) *DescribeJobFlowsInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *DescribeJobFlowsInput) SetCreatedBefore(v time.Time) *DescribeJobFlowsInput {
	s.CreatedBefore = &v
	return s
}

// SetJobFlowIds sets the JobFlowIds field's value.
func (s *DescribeJobFlowsInput) SetJobFlowIds(v []*string) *DescribeJobFlowsInput {
	s.JobFlowIds = v
	return s
}

// SetJobFlowStates sets the JobFlowStates field's value.
func (s *DescribeJobFlowsInput) SetJobFlowStates(v []*string) *DescribeJobFlowsInput {
	s.JobFlowStates = v
	return s
}

// The output for the DescribeJobFlows operation.
type DescribeJobFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job flows matching the parameters supplied.
	JobFlows []*JobFlowDetail `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsOutput) GoString() string {
	return s.String()
}

// SetJobFlows sets the JobFlows field's value.
func (s *DescribeJobFlowsOutput) SetJobFlows(v []*JobFlowDetail) *DescribeJobFlowsOutput {
	s.JobFlows = v
	return s
}

type DescribeNotebookExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the notebook execution.
	//
	// NotebookExecutionId is a required field
	NotebookExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNotebookExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotebookExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNotebookExecutionInput"}
	if s.NotebookExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookExecutionId sets the NotebookExecutionId field's value.
func (s *DescribeNotebookExecutionInput) SetNotebookExecutionId(v string) *DescribeNotebookExecutionInput {
	s.NotebookExecutionId = &v
	return s
}

type DescribeNotebookExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Properties of the notebook execution.
	NotebookExecution *NotebookExecution `type:"structure"`
}

// String returns the string representation
func (s DescribeNotebookExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotebookExecutionOutput) GoString() string {
	return s.String()
}

// SetNotebookExecution sets the NotebookExecution field's value.
func (s *DescribeNotebookExecutionOutput) SetNotebookExecution(v *NotebookExecution) *DescribeNotebookExecutionOutput {
	s.NotebookExecution = v
	return s
}

type DescribeSecurityConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSecurityConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecurityConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecurityConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeSecurityConfigurationInput) SetName(v string) *DescribeSecurityConfigurationInput {
	s.Name = &v
	return s
}

type DescribeSecurityConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created
	CreationDateTime *time.Time `type:"timestamp"`

	// The name of the security configuration.
	Name *string `type:"string"`

	// The security configuration details in JSON format.
	SecurityConfiguration *string `type:"string"`
}

// String returns the string representation
func (s DescribeSecurityConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecurityConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeSecurityConfigurationOutput) SetCreationDateTime(v time.Time) *DescribeSecurityConfigurationOutput {
	s.CreationDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSecurityConfigurationOutput) SetName(v string) *DescribeSecurityConfigurationOutput {
	s.Name = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *DescribeSecurityConfigurationOutput) SetSecurityConfiguration(v string) *DescribeSecurityConfigurationOutput {
	s.SecurityConfiguration = &v
	return s
}

// This input determines which step to describe.
type DescribeStepInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster with steps to describe.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the step to describe.
	//
	// StepId is a required field
	StepId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStepInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DescribeStepInput) SetClusterId(v string) *DescribeStepInput {
	s.ClusterId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *DescribeStepInput) SetStepId(v string) *DescribeStepInput {
	s.StepId = &v
	return s
}

// This output contains the description of the cluster step.
type DescribeStepOutput struct {
	_ struct{} `type:"structure"`

	// The step details for the requested step identifier.
	Step *Step `type:"structure"`
}

// String returns the string representation
func (s DescribeStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepOutput) GoString() string {
	return s.String()
}

// SetStep sets the Step field's value.
func (s *DescribeStepOutput) SetStep(v *Step) *DescribeStepOutput {
	s.Step = v
	return s
}

type DescribeStudioInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR Studio ID.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStudioInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStudioId sets the StudioId field's value.
func (s *DescribeStudioInput) SetStudioId(v string) *DescribeStudioInput {
	s.StudioId = &v
	return s
}

type DescribeStudioOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR Studio details.
	Studio *Studio `type:"structure"`
}

// String returns the string representation
func (s DescribeStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStudioOutput) GoString() string {
	return s.String()
}

// SetStudio sets the Studio field's value.
func (s *DescribeStudioOutput) SetStudio(v *Studio) *DescribeStudioOutput {
	s.Studio = v
	return s
}

// Configuration of requested EBS block device associated with the instance
// group.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// EBS volume specifications such as volume type, IOPS, and size (GiB) that
	// will be requested for the EBS volume attached to an EC2 instance in the cluster.
	VolumeSpecification *VolumeSpecification `type:"structure"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDevice) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *EbsBlockDevice) SetDevice(v string) *EbsBlockDevice {
	s.Device = &v
	return s
}

// SetVolumeSpecification sets the VolumeSpecification field's value.
func (s *EbsBlockDevice) SetVolumeSpecification(v *VolumeSpecification) *EbsBlockDevice {
	s.VolumeSpecification = v
	return s
}

// Configuration of requested EBS block device associated with the instance
// group with count of volumes that will be associated to every instance.
type EbsBlockDeviceConfig struct {
	_ struct{} `type:"structure"`

	// EBS volume specifications such as volume type, IOPS, and size (GiB) that
	// will be requested for the EBS volume attached to an EC2 instance in the cluster.
	//
	// VolumeSpecification is a required field
	VolumeSpecification *VolumeSpecification `type:"structure" required:"true"`

	// Number of EBS volumes with a specific volume configuration that will be associated
	// with every instance in the instance group
	VolumesPerInstance *int64 `type:"integer"`
}

// String returns the string representation
func (s EbsBlockDeviceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDeviceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsBlockDeviceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EbsBlockDeviceConfig"}
	if s.VolumeSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSpecification"))
	}
	if s.VolumeSpecification != nil {
		if err := s.VolumeSpecification.Validate(); err != nil {
			invalidParams.AddNested("VolumeSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeSpecification sets the VolumeSpecification field's value.
func (s *EbsBlockDeviceConfig) SetVolumeSpecification(v *VolumeSpecification) *EbsBlockDeviceConfig {
	s.VolumeSpecification = v
	return s
}

// SetVolumesPerInstance sets the VolumesPerInstance field's value.
func (s *EbsBlockDeviceConfig) SetVolumesPerInstance(v int64) *EbsBlockDeviceConfig {
	s.VolumesPerInstance = &v
	return s
}

// The Amazon EBS configuration of a cluster instance.
type EbsConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of Amazon EBS volume specifications attached to a cluster instance.
	EbsBlockDeviceConfigs []*EbsBlockDeviceConfig `type:"list"`

	// Indicates whether an Amazon EBS volume is EBS-optimized.
	EbsOptimized *bool `type:"boolean"`
}

// String returns the string representation
func (s EbsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EbsConfiguration"}
	if s.EbsBlockDeviceConfigs != nil {
		for i, v := range s.EbsBlockDeviceConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EbsBlockDeviceConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEbsBlockDeviceConfigs sets the EbsBlockDeviceConfigs field's value.
func (s *EbsConfiguration) SetEbsBlockDeviceConfigs(v []*EbsBlockDeviceConfig) *EbsConfiguration {
	s.EbsBlockDeviceConfigs = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *EbsConfiguration) SetEbsOptimized(v bool) *EbsConfiguration {
	s.EbsOptimized = &v
	return s
}

// EBS block device that's attached to an EC2 instance.
type EbsVolume struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// The volume identifier of the EBS volume.
	VolumeId *string `type:"string"`
}

// String returns the string representation
func (s EbsVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsVolume) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *EbsVolume) SetDevice(v string) *EbsVolume {
	s.Device = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *EbsVolume) SetVolumeId(v string) *EbsVolume {
	s.VolumeId = &v
	return s
}

// Provides information about the EC2 instances in a cluster grouped by category.
// For example, key name, subnet ID, IAM instance profile, and so on.
type Ec2InstanceAttributes struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the core and task
	// nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The Availability Zone in which the cluster will run.
	Ec2AvailabilityZone *string `type:"string"`

	// The name of the Amazon EC2 key pair to use when connecting with SSH into
	// the master node as a user named "hadoop".
	Ec2KeyName *string `type:"string"`

	// Set this parameter to the identifier of the Amazon VPC subnet where you want
	// the cluster to launch. If you do not specify this value, and your account
	// supports EC2-Classic, the cluster launches in EC2-Classic.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the core and task nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The IAM role that was specified when the cluster was launched. The EC2 instances
	// of the cluster assume this role.
	IamInstanceProfile *string `type:"string"`

	// Applies to clusters configured with the instance fleets option. Specifies
	// one or more Availability Zones in which to launch EC2 cluster instances when
	// the EC2-Classic network configuration is supported. Amazon EMR chooses the
	// Availability Zone with the best fit from among the list of RequestedEc2AvailabilityZones,
	// and then launches all cluster instances within that Availability Zone. If
	// you do not specify this value, Amazon EMR chooses the Availability Zone for
	// you. RequestedEc2SubnetIDs and RequestedEc2AvailabilityZones cannot be specified
	// together.
	RequestedEc2AvailabilityZones []*string `type:"list"`

	// Applies to clusters configured with the instance fleets option. Specifies
	// the unique identifier of one or more Amazon EC2 subnets in which to launch
	// EC2 cluster instances. Subnets must exist within the same VPC. Amazon EMR
	// chooses the EC2 subnet with the best fit from among the list of RequestedEc2SubnetIds,
	// and then launches all cluster instances within that Subnet. If this value
	// is not specified, and the account and Region support EC2-Classic networks,
	// the cluster launches instances in the EC2-Classic network and uses RequestedEc2AvailabilityZones
	// instead of this setting. If EC2-Classic is not supported, and no Subnet is
	// specified, Amazon EMR chooses the subnet for you. RequestedEc2SubnetIDs and
	// RequestedEc2AvailabilityZones cannot be specified together.
	RequestedEc2SubnetIds []*string `type:"list"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`
}

// String returns the string representation
func (s Ec2InstanceAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2InstanceAttributes) GoString() string {
	return s.String()
}

// SetAdditionalMasterSecurityGroups sets the AdditionalMasterSecurityGroups field's value.
func (s *Ec2InstanceAttributes) SetAdditionalMasterSecurityGroups(v []*string) *Ec2InstanceAttributes {
	s.AdditionalMasterSecurityGroups = v
	return s
}

// SetAdditionalSlaveSecurityGroups sets the AdditionalSlaveSecurityGroups field's value.
func (s *Ec2InstanceAttributes) SetAdditionalSlaveSecurityGroups(v []*string) *Ec2InstanceAttributes {
	s.AdditionalSlaveSecurityGroups = v
	return s
}

// SetEc2AvailabilityZone sets the Ec2AvailabilityZone field's value.
func (s *Ec2InstanceAttributes) SetEc2AvailabilityZone(v string) *Ec2InstanceAttributes {
	s.Ec2AvailabilityZone = &v
	return s
}

// SetEc2KeyName sets the Ec2KeyName field's value.
func (s *Ec2InstanceAttributes) SetEc2KeyName(v string) *Ec2InstanceAttributes {
	s.Ec2KeyName = &v
	return s
}

// SetEc2SubnetId sets the Ec2SubnetId field's value.
func (s *Ec2InstanceAttributes) SetEc2SubnetId(v string) *Ec2InstanceAttributes {
	s.Ec2SubnetId = &v
	return s
}

// SetEmrManagedMasterSecurityGroup sets the EmrManagedMasterSecurityGroup field's value.
func (s *Ec2InstanceAttributes) SetEmrManagedMasterSecurityGroup(v string) *Ec2InstanceAttributes {
	s.EmrManagedMasterSecurityGroup = &v
	return s
}

// SetEmrManagedSlaveSecurityGroup sets the EmrManagedSlaveSecurityGroup field's value.
func (s *Ec2InstanceAttributes) SetEmrManagedSlaveSecurityGroup(v string) *Ec2InstanceAttributes {
	s.EmrManagedSlaveSecurityGroup = &v
	return s
}

// SetIamInstanceProfile sets the IamInstanceProfile field's value.
func (s *Ec2InstanceAttributes) SetIamInstanceProfile(v string) *Ec2InstanceAttributes {
	s.IamInstanceProfile = &v
	return s
}

// SetRequestedEc2AvailabilityZones sets the RequestedEc2AvailabilityZones field's value.
func (s *Ec2InstanceAttributes) SetRequestedEc2AvailabilityZones(v []*string) *Ec2InstanceAttributes {
	s.RequestedEc2AvailabilityZones = v
	return s
}

// SetRequestedEc2SubnetIds sets the RequestedEc2SubnetIds field's value.
func (s *Ec2InstanceAttributes) SetRequestedEc2SubnetIds(v []*string) *Ec2InstanceAttributes {
	s.RequestedEc2SubnetIds = v
	return s
}

// SetServiceAccessSecurityGroup sets the ServiceAccessSecurityGroup field's value.
func (s *Ec2InstanceAttributes) SetServiceAccessSecurityGroup(v string) *Ec2InstanceAttributes {
	s.ServiceAccessSecurityGroup = &v
	return s
}

// Specifies the execution engine (cluster) to run the notebook and perform
// the notebook execution, for example, an EMR cluster.
type ExecutionEngineConfig struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the execution engine. For an EMR cluster, this is
	// the cluster ID.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An optional unique ID of an EC2 security group to associate with the master
	// instance of the EMR cluster for this notebook execution. For more information
	// see Specifying EC2 Security Groups for EMR Notebooks (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html)
	// in the EMR Management Guide.
	MasterInstanceSecurityGroupId *string `type:"string"`

	// The type of execution engine. A value of EMR specifies an EMR cluster.
	Type *string `type:"string" enum:"ExecutionEngineType"`
}

// String returns the string representation
func (s ExecutionEngineConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionEngineConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionEngineConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionEngineConfig"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ExecutionEngineConfig) SetId(v string) *ExecutionEngineConfig {
	s.Id = &v
	return s
}

// SetMasterInstanceSecurityGroupId sets the MasterInstanceSecurityGroupId field's value.
func (s *ExecutionEngineConfig) SetMasterInstanceSecurityGroupId(v string) *ExecutionEngineConfig {
	s.MasterInstanceSecurityGroupId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExecutionEngineConfig) SetType(v string) *ExecutionEngineConfig {
	s.Type = &v
	return s
}

// The details of the step failure. The service attempts to detect the root
// cause for many common failures.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The path to the log file where the step failure root cause was originally
	// recorded.
	LogFile *string `type:"string"`

	// The descriptive message including the error the Amazon EMR service has identified
	// as the cause of step failure. This is text from an error log that describes
	// the root cause of the failure.
	Message *string `type:"string"`

	// The reason for the step failure. In the case where the service cannot successfully
	// determine the root cause of the failure, it returns "Unknown Error" as a
	// reason.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureDetails) GoString() string {
	return s.String()
}

// SetLogFile sets the LogFile field's value.
func (s *FailureDetails) SetLogFile(v string) *FailureDetails {
	s.LogFile = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FailureDetails) SetMessage(v string) *FailureDetails {
	s.Message = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *FailureDetails) SetReason(v string) *FailureDetails {
	s.Reason = &v
	return s
}

type GetBlockPublicAccessConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetBlockPublicAccessConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlockPublicAccessConfigurationInput) GoString() string {
	return s.String()
}

type GetBlockPublicAccessConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// A configuration for Amazon EMR block public access. The configuration applies
	// to all clusters created in your account for the current Region. The configuration
	// specifies whether block public access is enabled. If block public access
	// is enabled, security groups associated with the cluster cannot have rules
	// that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port
	// is specified as an exception using PermittedPublicSecurityGroupRuleRanges
	// in the BlockPublicAccessConfiguration. By default, Port 22 (SSH) is an exception,
	// and public access is allowed on this port. You can change this by updating
	// the block public access configuration to remove the exception.
	//
	// For accounts that created clusters in a Region before November 25, 2019,
	// block public access is disabled by default in that Region. To use this feature,
	// you must manually enable and configure it. For accounts that did not create
	// an EMR cluster in a Region before this date, block public access is enabled
	// by default in that Region.
	//
	// BlockPublicAccessConfiguration is a required field
	BlockPublicAccessConfiguration *BlockPublicAccessConfiguration `type:"structure" required:"true"`

	// Properties that describe the AWS principal that created the BlockPublicAccessConfiguration
	// using the PutBlockPublicAccessConfiguration action as well as the date and
	// time that the configuration was created. Each time a configuration for block
	// public access is updated, Amazon EMR updates this metadata.
	//
	// BlockPublicAccessConfigurationMetadata is a required field
	BlockPublicAccessConfigurationMetadata *BlockPublicAccessConfigurationMetadata `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBlockPublicAccessConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlockPublicAccessConfigurationOutput) GoString() string {
	return s.String()
}

// SetBlockPublicAccessConfiguration sets the BlockPublicAccessConfiguration field's value.
func (s *GetBlockPublicAccessConfigurationOutput) SetBlockPublicAccessConfiguration(v *BlockPublicAccessConfiguration) *GetBlockPublicAccessConfigurationOutput {
	s.BlockPublicAccessConfiguration = v
	return s
}

// SetBlockPublicAccessConfigurationMetadata sets the BlockPublicAccessConfigurationMetadata field's value.
func (s *GetBlockPublicAccessConfigurationOutput) SetBlockPublicAccessConfigurationMetadata(v *BlockPublicAccessConfigurationMetadata) *GetBlockPublicAccessConfigurationOutput {
	s.BlockPublicAccessConfigurationMetadata = v
	return s
}

type GetManagedScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the cluster for which the managed scaling policy will
	// be fetched.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetManagedScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetManagedScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetManagedScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetManagedScalingPolicyInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *GetManagedScalingPolicyInput) SetClusterId(v string) *GetManagedScalingPolicyInput {
	s.ClusterId = &v
	return s
}

type GetManagedScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the managed scaling policy that is attached to an Amazon EMR cluster.
	ManagedScalingPolicy *ManagedScalingPolicy `type:"structure"`
}

// String returns the string representation
func (s GetManagedScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetManagedScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetManagedScalingPolicy sets the ManagedScalingPolicy field's value.
func (s *GetManagedScalingPolicyOutput) SetManagedScalingPolicy(v *ManagedScalingPolicy) *GetManagedScalingPolicyOutput {
	s.ManagedScalingPolicy = v
	return s
}

type GetStudioSessionMappingInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier (GUID) of the user or group. For more information,
	// see UserId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
	// and GroupId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityId *string `type:"string"`

	// The name of the user or group to fetch. For more information, see UserName
	// (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityName *string `type:"string"`

	// Specifies whether the identity to fetch is a user or a group.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The ID of the Amazon EMR Studio.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStudioSessionMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStudioSessionMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStudioSessionMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStudioSessionMappingInput"}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *GetStudioSessionMappingInput) SetIdentityId(v string) *GetStudioSessionMappingInput {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *GetStudioSessionMappingInput) SetIdentityName(v string) *GetStudioSessionMappingInput {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetStudioSessionMappingInput) SetIdentityType(v string) *GetStudioSessionMappingInput {
	s.IdentityType = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *GetStudioSessionMappingInput) SetStudioId(v string) *GetStudioSessionMappingInput {
	s.StudioId = &v
	return s
}

type GetStudioSessionMappingOutput struct {
	_ struct{} `type:"structure"`

	// The session mapping details for the specified Amazon EMR Studio and identity,
	// including session policy ARN and creation time.
	SessionMapping *SessionMappingDetail `type:"structure"`
}

// String returns the string representation
func (s GetStudioSessionMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStudioSessionMappingOutput) GoString() string {
	return s.String()
}

// SetSessionMapping sets the SessionMapping field's value.
func (s *GetStudioSessionMappingOutput) SetSessionMapping(v *SessionMappingDetail) *GetStudioSessionMappingOutput {
	s.SessionMapping = v
	return s
}

// A job flow step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopJarStepConfig struct {
	_ struct{} `type:"structure"`

	// A list of command line arguments passed to the JAR file's main function when
	// executed.
	Args []*string `type:"list"`

	// A path to a JAR file run during the step.
	//
	// Jar is a required field
	Jar *string `type:"string" required:"true"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a Main-Class in its manifest file.
	MainClass *string `type:"string"`

	// A list of Java properties that are set when the step runs. You can use these
	// properties to pass key-value pairs to your main function.
	Properties []*KeyValue `type:"list"`
}

// String returns the string representation
func (s HadoopJarStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopJarStepConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HadoopJarStepConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HadoopJarStepConfig"}
	if s.Jar == nil {
		invalidParams.Add(request.NewErrParamRequired("Jar"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *HadoopJarStepConfig) SetArgs(v []*string) *HadoopJarStepConfig {
	s.Args = v
	return s
}

// SetJar sets the Jar field's value.
func (s *HadoopJarStepConfig) SetJar(v string) *HadoopJarStepConfig {
	s.Jar = &v
	return s
}

// SetMainClass sets the MainClass field's value.
func (s *HadoopJarStepConfig) SetMainClass(v string) *HadoopJarStepConfig {
	s.MainClass = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *HadoopJarStepConfig) SetProperties(v []*KeyValue) *HadoopJarStepConfig {
	s.Properties = v
	return s
}

// A cluster step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopStepConfig struct {
	_ struct{} `type:"structure"`

	// The list of command line arguments to pass to the JAR file's main function
	// for execution.
	Args []*string `type:"list"`

	// The path to the JAR file that runs during the step.
	Jar *string `type:"string"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a main class in its manifest file.
	MainClass *string `type:"string"`

	// The list of Java properties that are set when the step runs. You can use
	// these properties to pass key-value pairs to your main function.
	Properties map[string]*string `type:"map"`
}

// String returns the string representation
func (s HadoopStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopStepConfig) GoString() string {
	return s.String()
}

// SetArgs sets the Args field's value.
func (s *HadoopStepConfig) SetArgs(v []*string) *HadoopStepConfig {
	s.Args = v
	return s
}

// SetJar sets the Jar field's value.
func (s *HadoopStepConfig) SetJar(v string) *HadoopStepConfig {
	s.Jar = &v
	return s
}

// SetMainClass sets the MainClass field's value.
func (s *HadoopStepConfig) SetMainClass(v string) *HadoopStepConfig {
	s.MainClass = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *HadoopStepConfig) SetProperties(v map[string]*string) *HadoopStepConfig {
	s.Properties = v
	return s
}

// Represents an EC2 instance provisioned as part of cluster.
type Instance struct {
	_ struct{} `type:"structure"`

	// The list of EBS volumes that are attached to this instance.
	EbsVolumes []*EbsVolume `type:"list"`

	// The unique identifier of the instance in Amazon EC2.
	Ec2InstanceId *string `type:"string"`

	// The unique identifier for the instance in Amazon EMR.
	Id *string `type:"string"`

	// The unique identifier of the instance fleet to which an EC2 instance belongs.
	InstanceFleetId *string `type:"string"`

	// The identifier of the instance group to which this instance belongs.
	InstanceGroupId *string `type:"string"`

	// The EC2 instance type, for example m3.xlarge.
	InstanceType *string `min:"1" type:"string"`

	// The instance purchasing option. Valid values are ON_DEMAND or SPOT.
	Market *string `type:"string" enum:"MarketType"`

	// The private DNS name of the instance.
	PrivateDnsName *string `type:"string"`

	// The private IP address of the instance.
	PrivateIpAddress *string `type:"string"`

	// The public DNS name of the instance.
	PublicDnsName *string `type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `type:"string"`

	// The current status of the instance.
	Status *InstanceStatus `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetEbsVolumes sets the EbsVolumes field's value.
func (s *Instance) SetEbsVolumes(v []*EbsVolume) *Instance {
	s.EbsVolumes = v
	return s
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *Instance) SetEc2InstanceId(v string) *Instance {
	s.Ec2InstanceId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Instance) SetId(v string) *Instance {
	s.Id = &v
	return s
}

// SetInstanceFleetId sets the InstanceFleetId field's value.
func (s *Instance) SetInstanceFleetId(v string) *Instance {
	s.InstanceFleetId = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *Instance) SetInstanceGroupId(v string) *Instance {
	s.InstanceGroupId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Instance) SetInstanceType(v string) *Instance {
	s.InstanceType = &v
	return s
}

// SetMarket sets the Market field's value.
func (s *Instance) SetMarket(v string) *Instance {
	s.Market = &v
	return s
}

// SetPrivateDnsName sets the PrivateDnsName field's value.
func (s *Instance) SetPrivateDnsName(v string) *Instance {
	s.PrivateDnsName = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *Instance) SetPrivateIpAddress(v string) *Instance {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicDnsName sets the PublicDnsName field's value.
func (s *Instance) SetPublicDnsName(v string) *Instance {
	s.PublicDnsName = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *Instance) SetPublicIpAddress(v string) *Instance {
	s.PublicIpAddress = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Instance) SetStatus(v *InstanceStatus) *Instance {
	s.Status = v
	return s
}

// Describes an instance fleet, which is a group of EC2 instances that host
// a particular node type (master, core, or task) in an Amazon EMR cluster.
// Instance fleets can consist of a mix of instance types and On-Demand and
// Spot Instances, which are provisioned to meet a defined target capacity.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleet struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the instance fleet.
	Id *string `type:"string"`

	// The node type that the instance fleet hosts. Valid values are MASTER, CORE,
	// or TASK.
	InstanceFleetType *string `type:"string" enum:"InstanceFleetType"`

	// The specification for the instance types that comprise an instance fleet.
	// Up to five unique instance specifications may be defined for each instance
	// fleet.
	InstanceTypeSpecifications []*InstanceTypeSpecification `type:"list"`

	// Describes the launch specification for an instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications `type:"structure"`

	// A friendly name for the instance fleet.
	Name *string `type:"string"`

	// The number of On-Demand units that have been provisioned for the instance
	// fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might
	// be less than or greater than TargetOnDemandCapacity.
	ProvisionedOnDemandCapacity *int64 `type:"integer"`

	// The number of Spot units that have been provisioned for this instance fleet
	// to fulfill TargetSpotCapacity. This provisioned capacity might be less than
	// or greater than TargetSpotCapacity.
	ProvisionedSpotCapacity *int64 `type:"integer"`

	// The current status of the instance fleet.
	Status *InstanceFleetStatus `type:"structure"`

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand Instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When an On-Demand
	// Instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedOnDemandCapacity
	// to determine the Spot capacity units that have been provisioned for the instance
	// fleet.
	//
	// If not specified or set to 0, only Spot Instances are provisioned for the
	// instance fleet using TargetSpotCapacity. At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be specified,
	// and its value must be 1.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet, which determines
	// how many Spot Instances to provision. When the instance fleet launches, Amazon
	// EMR tries to provision Spot Instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When a Spot
	// instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedSpotCapacity
	// to determine the Spot capacity units that have been provisioned for the instance
	// fleet.
	//
	// If not specified or set to 0, only On-Demand Instances are provisioned for
	// the instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of TargetSpotCapacity
	// and TargetOnDemandCapacity can be specified, and its value must be 1.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleet) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InstanceFleet) SetId(v string) *InstanceFleet {
	s.Id = &v
	return s
}

// SetInstanceFleetType sets the InstanceFleetType field's value.
func (s *InstanceFleet) SetInstanceFleetType(v string) *InstanceFleet {
	s.InstanceFleetType = &v
	return s
}

// SetInstanceTypeSpecifications sets the InstanceTypeSpecifications field's value.
func (s *InstanceFleet) SetInstanceTypeSpecifications(v []*InstanceTypeSpecification) *InstanceFleet {
	s.InstanceTypeSpecifications = v
	return s
}

// SetLaunchSpecifications sets the LaunchSpecifications field's value.
func (s *InstanceFleet) SetLaunchSpecifications(v *InstanceFleetProvisioningSpecifications) *InstanceFleet {
	s.LaunchSpecifications = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceFleet) SetName(v string) *InstanceFleet {
	s.Name = &v
	return s
}

// SetProvisionedOnDemandCapacity sets the ProvisionedOnDemandCapacity field's value.
func (s *InstanceFleet) SetProvisionedOnDemandCapacity(v int64) *InstanceFleet {
	s.ProvisionedOnDemandCapacity = &v
	return s
}

// SetProvisionedSpotCapacity sets the ProvisionedSpotCapacity field's value.
func (s *InstanceFleet) SetProvisionedSpotCapacity(v int64) *InstanceFleet {
	s.ProvisionedSpotCapacity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceFleet) SetStatus(v *InstanceFleetStatus) *InstanceFleet {
	s.Status = v
	return s
}

// SetTargetOnDemandCapacity sets the TargetOnDemandCapacity field's value.
func (s *InstanceFleet) SetTargetOnDemandCapacity(v int64) *InstanceFleet {
	s.TargetOnDemandCapacity = &v
	return s
}

// SetTargetSpotCapacity sets the TargetSpotCapacity field's value.
func (s *InstanceFleet) SetTargetSpotCapacity(v int64) *InstanceFleet {
	s.TargetSpotCapacity = &v
	return s
}

// The configuration that defines an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetConfig struct {
	_ struct{} `type:"structure"`

	// The node type that the instance fleet hosts. Valid values are MASTER, CORE,
	// and TASK.
	//
	// InstanceFleetType is a required field
	InstanceFleetType *string `type:"string" required:"true" enum:"InstanceFleetType"`

	// The instance type configurations that define the EC2 instances in the instance
	// fleet.
	InstanceTypeConfigs []*InstanceTypeConfig `type:"list"`

	// The launch specification for the instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications `type:"structure"`

	// The friendly name of the instance fleet.
	Name *string `type:"string"`

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand Instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand Instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When an On-Demand
	// Instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units.
	//
	// If not specified or set to 0, only Spot Instances are provisioned for the
	// instance fleet using TargetSpotCapacity. At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be specified,
	// and its value must be 1.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet, which determines
	// how many Spot Instances to provision. When the instance fleet launches, Amazon
	// EMR tries to provision Spot Instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When a Spot
	// Instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units.
	//
	// If not specified or set to 0, only On-Demand Instances are provisioned for
	// the instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of TargetSpotCapacity
	// and TargetOnDemandCapacity can be specified, and its value must be 1.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleetConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceFleetConfig"}
	if s.InstanceFleetType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceFleetType"))
	}
	if s.InstanceTypeConfigs != nil {
		for i, v := range s.InstanceTypeConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceTypeConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LaunchSpecifications != nil {
		if err := s.LaunchSpecifications.Validate(); err != nil {
			invalidParams.AddNested("LaunchSpecifications", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceFleetType sets the InstanceFleetType field's value.
func (s *InstanceFleetConfig) SetInstanceFleetType(v string) *InstanceFleetConfig {
	s.InstanceFleetType = &v
	return s
}

// SetInstanceTypeConfigs sets the InstanceTypeConfigs field's value.
func (s *InstanceFleetConfig) SetInstanceTypeConfigs(v []*InstanceTypeConfig) *InstanceFleetConfig {
	s.InstanceTypeConfigs = v
	return s
}

// SetLaunchSpecifications sets the LaunchSpecifications field's value.
func (s *InstanceFleetConfig) SetLaunchSpecifications(v *InstanceFleetProvisioningSpecifications) *InstanceFleetConfig {
	s.LaunchSpecifications = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceFleetConfig) SetName(v string) *InstanceFleetConfig {
	s.Name = &v
	return s
}

// SetTargetOnDemandCapacity sets the TargetOnDemandCapacity field's value.
func (s *InstanceFleetConfig) SetTargetOnDemandCapacity(v int64) *InstanceFleetConfig {
	s.TargetOnDemandCapacity = &v
	return s
}

// SetTargetSpotCapacity sets the TargetSpotCapacity field's value.
func (s *InstanceFleetConfig) SetTargetSpotCapacity(v int64) *InstanceFleetConfig {
	s.TargetSpotCapacity = &v
	return s
}

// Configuration parameters for an instance fleet modification request.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetModifyConfig struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the instance fleet.
	//
	// InstanceFleetId is a required field
	InstanceFleetId *string `type:"string" required:"true"`

	// The target capacity of On-Demand units for the instance fleet. For more information
	// see InstanceFleetConfig$TargetOnDemandCapacity.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet. For more information,
	// see InstanceFleetConfig$TargetSpotCapacity.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleetModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetModifyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetModifyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceFleetModifyConfig"}
	if s.InstanceFleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceFleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceFleetId sets the InstanceFleetId field's value.
func (s *InstanceFleetModifyConfig) SetInstanceFleetId(v string) *InstanceFleetModifyConfig {
	s.InstanceFleetId = &v
	return s
}

// SetTargetOnDemandCapacity sets the TargetOnDemandCapacity field's value.
func (s *InstanceFleetModifyConfig) SetTargetOnDemandCapacity(v int64) *InstanceFleetModifyConfig {
	s.TargetOnDemandCapacity = &v
	return s
}

// SetTargetSpotCapacity sets the TargetSpotCapacity field's value.
func (s *InstanceFleetModifyConfig) SetTargetSpotCapacity(v int64) *InstanceFleetModifyConfig {
	s.TargetSpotCapacity = &v
	return s
}

// The launch specification for Spot Instances in the fleet, which determines
// the defined duration, provisioning timeout behavior, and allocation strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. On-Demand and Spot Instance allocation
// strategies are available in Amazon EMR version 5.12.1 and later.
type InstanceFleetProvisioningSpecifications struct {
	_ struct{} `type:"structure"`

	// The launch specification for On-Demand Instances in the instance fleet, which
	// determines the allocation strategy.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation
	// strategy is available in Amazon EMR version 5.12.1 and later.
	OnDemandSpecification *OnDemandProvisioningSpecification `type:"structure"`

	// The launch specification for Spot Instances in the fleet, which determines
	// the defined duration, provisioning timeout behavior, and allocation strategy.
	SpotSpecification *SpotProvisioningSpecification `type:"structure"`
}

// String returns the string representation
func (s InstanceFleetProvisioningSpecifications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetProvisioningSpecifications) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetProvisioningSpecifications) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceFleetProvisioningSpecifications"}
	if s.OnDemandSpecification != nil {
		if err := s.OnDemandSpecification.Validate(); err != nil {
			invalidParams.AddNested("OnDemandSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.SpotSpecification != nil {
		if err := s.SpotSpecification.Validate(); err != nil {
			invalidParams.AddNested("SpotSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOnDemandSpecification sets the OnDemandSpecification field's value.
func (s *InstanceFleetProvisioningSpecifications) SetOnDemandSpecification(v *OnDemandProvisioningSpecification) *InstanceFleetProvisioningSpecifications {
	s.OnDemandSpecification = v
	return s
}

// SetSpotSpecification sets the SpotSpecification field's value.
func (s *InstanceFleetProvisioningSpecifications) SetSpotSpecification(v *SpotProvisioningSpecification) *InstanceFleetProvisioningSpecifications {
	s.SpotSpecification = v
	return s
}

// Provides status change reason details for the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetStateChangeReason struct {
	_ struct{} `type:"structure"`

	// A code corresponding to the reason the state change occurred.
	Code *string `type:"string" enum:"InstanceFleetStateChangeReasonCode"`

	// An explanatory message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceFleetStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceFleetStateChangeReason) SetCode(v string) *InstanceFleetStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *InstanceFleetStateChangeReason) SetMessage(v string) *InstanceFleetStateChangeReason {
	s.Message = &v
	return s
}

// The status of the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetStatus struct {
	_ struct{} `type:"structure"`

	// A code representing the instance fleet status.
	//
	//    * PROVISIONING—The instance fleet is provisioning EC2 resources and
	//    is not yet ready to run jobs.
	//
	//    * BOOTSTRAPPING—EC2 instances and other resources have been provisioned
	//    and the bootstrap actions specified for the instances are underway.
	//
	//    * RUNNING—EC2 instances and other resources are running. They are either
	//    executing jobs or waiting to execute jobs.
	//
	//    * RESIZING—A resize operation is underway. EC2 instances are either
	//    being added or removed.
	//
	//    * SUSPENDED—A resize operation could not complete. Existing EC2 instances
	//    are running, but instances can't be added or removed.
	//
	//    * TERMINATING—The instance fleet is terminating EC2 instances.
	//
	//    * TERMINATED—The instance fleet is no longer active, and all EC2 instances
	//    have been terminated.
	State *string `type:"string" enum:"InstanceFleetState"`

	// Provides status change reason details for the instance fleet.
	StateChangeReason *InstanceFleetStateChangeReason `type:"structure"`

	// Provides historical timestamps for the instance fleet, including the time
	// of creation, the time it became ready to run jobs, and the time of termination.
	Timeline *InstanceFleetTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceFleetStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *InstanceFleetStatus) SetState(v string) *InstanceFleetStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *InstanceFleetStatus) SetStateChangeReason(v *InstanceFleetStateChangeReason) *InstanceFleetStatus {
	s.StateChangeReason = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *InstanceFleetStatus) SetTimeline(v *InstanceFleetTimeline) *InstanceFleetStatus {
	s.Timeline = v
	return s
}

// Provides historical timestamps for the instance fleet, including the time
// of creation, the time it became ready to run jobs, and the time of termination.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetTimeline struct {
	_ struct{} `type:"structure"`

	// The time and date the instance fleet was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The time and date the instance fleet terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The time and date the instance fleet was ready to run jobs.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceFleetTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceFleetTimeline) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *InstanceFleetTimeline) SetCreationDateTime(v time.Time) *InstanceFleetTimeline {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *InstanceFleetTimeline) SetEndDateTime(v time.Time) *InstanceFleetTimeline {
	s.EndDateTime = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *InstanceFleetTimeline) SetReadyDateTime(v time.Time) *InstanceFleetTimeline {
	s.ReadyDateTime = &v
	return s
}

// This entity represents an instance group, which is a group of instances that
// have common purpose. For example, CORE instance group is used for HDFS.
type InstanceGroup struct {
	_ struct{} `type:"structure"`

	// An automatic scaling policy for a core instance group or task instance group
	// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates EC2 instances in response to the value
	// of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicyDescription `type:"structure"`

	// If specified, indicates that the instance group uses Spot Instances. This
	// is the maximum price you are willing to pay for Spot Instances. Specify OnDemandPrice
	// to set the amount equal to the On-Demand price, or specify an amount in USD.
	BidPrice *string `type:"string"`

	//
	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// The version number of the requested configuration specification for this
	// instance group.
	ConfigurationsVersion *int64 `type:"long"`

	// The EBS block devices that are mapped to this instance group.
	EbsBlockDevices []*EbsBlockDevice `type:"list"`

	// If the instance group is EBS-optimized. An Amazon EBS-optimized instance
	// uses an optimized configuration stack and provides additional, dedicated
	// capacity for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// The identifier of the instance group.
	Id *string `type:"string"`

	// The type of the instance group. Valid values are MASTER, CORE or TASK.
	InstanceGroupType *string `type:"string" enum:"InstanceGroupType"`

	// The EC2 instance type for all instances in the instance group.
	InstanceType *string `min:"1" type:"string"`

	// A list of configurations that were successfully applied for an instance group
	// last time.
	LastSuccessfullyAppliedConfigurations []*Configuration `type:"list"`

	// The version number of a configuration specification that was successfully
	// applied for an instance group last time.
	LastSuccessfullyAppliedConfigurationsVersion *int64 `type:"long"`

	// The marketplace to provision instances for this group. Valid values are ON_DEMAND
	// or SPOT.
	Market *string `type:"string" enum:"MarketType"`

	// The name of the instance group.
	Name *string `type:"string"`

	// The target number of instances for the instance group.
	RequestedInstanceCount *int64 `type:"integer"`

	// The number of instances currently running in this instance group.
	RunningInstanceCount *int64 `type:"integer"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`

	// The current status of the instance group.
	Status *InstanceGroupStatus `type:"structure"`
}

// String returns the string representation
func (s InstanceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroup) GoString() string {
	return s.String()
}

// SetAutoScalingPolicy sets the AutoScalingPolicy field's value.
func (s *InstanceGroup) SetAutoScalingPolicy(v *AutoScalingPolicyDescription) *InstanceGroup {
	s.AutoScalingPolicy = v
	return s
}

// SetBidPrice sets the BidPrice field's value.
func (s *InstanceGroup) SetBidPrice(v string) *InstanceGroup {
	s.BidPrice = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *InstanceGroup) SetConfigurations(v []*Configuration) *InstanceGroup {
	s.Configurations = v
	return s
}

// SetConfigurationsVersion sets the ConfigurationsVersion field's value.
func (s *InstanceGroup) SetConfigurationsVersion(v int64) *InstanceGroup {
	s.ConfigurationsVersion = &v
	return s
}

// SetEbsBlockDevices sets the EbsBlockDevices field's value.
func (s *InstanceGroup) SetEbsBlockDevices(v []*EbsBlockDevice) *InstanceGroup {
	s.EbsBlockDevices = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *InstanceGroup) SetEbsOptimized(v bool) *InstanceGroup {
	s.EbsOptimized = &v
	return s
}

// SetId sets the Id field's value.
func (s *InstanceGroup) SetId(v string) *InstanceGroup {
	s.Id = &v
	return s
}

// SetInstanceGroupType sets the InstanceGroupType field's value.
func (s *InstanceGroup) SetInstanceGroupType(v string) *InstanceGroup {
	s.InstanceGroupType = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceGroup) SetInstanceType(v string) *InstanceGroup {
	s.InstanceType = &v
	return s
}

// SetLastSuccessfullyAppliedConfigurations sets the LastSuccessfullyAppliedConfigurations field's value.
func (s *InstanceGroup) SetLastSuccessfullyAppliedConfigurations(v []*Configuration) *InstanceGroup {
	s.LastSuccessfullyAppliedConfigurations = v
	return s
}

// SetLastSuccessfullyAppliedConfigurationsVersion sets the LastSuccessfullyAppliedConfigurationsVersion field's value.
func (s *InstanceGroup) SetLastSuccessfullyAppliedConfigurationsVersion(v int64) *InstanceGroup {
	s.LastSuccessfullyAppliedConfigurationsVersion = &v
	return s
}

// SetMarket sets the Market field's value.
func (s *InstanceGroup) SetMarket(v string) *InstanceGroup {
	s.Market = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceGroup) SetName(v string) *InstanceGroup {
	s.Name = &v
	return s
}

// SetRequestedInstanceCount sets the RequestedInstanceCount field's value.
func (s *InstanceGroup) SetRequestedInstanceCount(v int64) *InstanceGroup {
	s.RequestedInstanceCount = &v
	return s
}

// SetRunningInstanceCount sets the RunningInstanceCount field's value.
func (s *InstanceGroup) SetRunningInstanceCount(v int64) *InstanceGroup {
	s.RunningInstanceCount = &v
	return s
}

// SetShrinkPolicy sets the ShrinkPolicy field's value.
func (s *InstanceGroup) SetShrinkPolicy(v *ShrinkPolicy) *InstanceGroup {
	s.ShrinkPolicy = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceGroup) SetStatus(v *InstanceGroupStatus) *InstanceGroup {
	s.Status = v
	return s
}

// Configuration defining a new instance group.
type InstanceGroupConfig struct {
	_ struct{} `type:"structure"`

	// An automatic scaling policy for a core instance group or task instance group
	// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates EC2 instances in response to the value
	// of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicy `type:"structure"`

	// If specified, indicates that the instance group uses Spot Instances. This
	// is the maximum price you are willing to pay for Spot Instances. Specify OnDemandPrice
	// to set the amount equal to the On-Demand price, or specify an amount in USD.
	BidPrice *string `type:"string"`

	//
	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// EBS configurations that will be attached to each EC2 instance in the instance
	// group.
	EbsConfiguration *EbsConfiguration `type:"structure"`

	// Target number of instances for the instance group.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// The role of the instance group in the cluster.
	//
	// InstanceRole is a required field
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// The EC2 instance type for all instances in the instance group.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Market type of the EC2 instances used to create a cluster node.
	Market *string `type:"string" enum:"MarketType"`

	// Friendly name given to the instance group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceGroupConfig"}
	if s.InstanceCount == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceCount"))
	}
	if s.InstanceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceRole"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.AutoScalingPolicy != nil {
		if err := s.AutoScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.EbsConfiguration != nil {
		if err := s.EbsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingPolicy sets the AutoScalingPolicy field's value.
func (s *InstanceGroupConfig) SetAutoScalingPolicy(v *AutoScalingPolicy) *InstanceGroupConfig {
	s.AutoScalingPolicy = v
	return s
}

// SetBidPrice sets the BidPrice field's value.
func (s *InstanceGroupConfig) SetBidPrice(v string) *InstanceGroupConfig {
	s.BidPrice = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *InstanceGroupConfig) SetConfigurations(v []*Configuration) *InstanceGroupConfig {
	s.Configurations = v
	return s
}

// SetEbsConfiguration sets the EbsConfiguration field's value.
func (s *InstanceGroupConfig) SetEbsConfiguration(v *EbsConfiguration) *InstanceGroupConfig {
	s.EbsConfiguration = v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *InstanceGroupConfig) SetInstanceCount(v int64) *InstanceGroupConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *InstanceGroupConfig) SetInstanceRole(v string) *InstanceGroupConfig {
	s.InstanceRole = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceGroupConfig) SetInstanceType(v string) *InstanceGroupConfig {
	s.InstanceType = &v
	return s
}

// SetMarket sets the Market field's value.
func (s *InstanceGroupConfig) SetMarket(v string) *InstanceGroupConfig {
	s.Market = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceGroupConfig) SetName(v string) *InstanceGroupConfig {
	s.Name = &v
	return s
}

// Detailed information about an instance group.
type InstanceGroupDetail struct {
	_ struct{} `type:"structure"`

	// If specified, indicates that the instance group uses Spot Instances. This
	// is the maximum price you are willing to pay for Spot Instances. Specify OnDemandPrice
	// to set the amount equal to the On-Demand price, or specify an amount in USD.
	BidPrice *string `type:"string"`

	// The date/time the instance group was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The date/time the instance group was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// Unique identifier for the instance group.
	InstanceGroupId *string `type:"string"`

	// Target number of instances to run in the instance group.
	//
	// InstanceRequestCount is a required field
	InstanceRequestCount *int64 `type:"integer" required:"true"`

	// Instance group role in the cluster
	//
	// InstanceRole is a required field
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// Actual count of running instances.
	//
	// InstanceRunningCount is a required field
	InstanceRunningCount *int64 `type:"integer" required:"true"`

	// EC2 instance type.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Details regarding the state of the instance group.
	LastStateChangeReason *string `type:"string"`

	// Market type of the EC2 instances used to create a cluster node.
	//
	// Market is a required field
	Market *string `type:"string" required:"true" enum:"MarketType"`

	// Friendly name for the instance group.
	Name *string `type:"string"`

	// The date/time the instance group was available to the cluster.
	ReadyDateTime *time.Time `type:"timestamp"`

	// The date/time the instance group was started.
	StartDateTime *time.Time `type:"timestamp"`

	// State of instance group. The following values are deprecated: STARTING, TERMINATED,
	// and FAILED.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"InstanceGroupState"`
}

// String returns the string representation
func (s InstanceGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupDetail) GoString() string {
	return s.String()
}

// SetBidPrice sets the BidPrice field's value.
func (s *InstanceGroupDetail) SetBidPrice(v string) *InstanceGroupDetail {
	s.BidPrice = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *InstanceGroupDetail) SetCreationDateTime(v time.Time) *InstanceGroupDetail {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *InstanceGroupDetail) SetEndDateTime(v time.Time) *InstanceGroupDetail {
	s.EndDateTime = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *InstanceGroupDetail) SetInstanceGroupId(v string) *InstanceGroupDetail {
	s.InstanceGroupId = &v
	return s
}

// SetInstanceRequestCount sets the InstanceRequestCount field's value.
func (s *InstanceGroupDetail) SetInstanceRequestCount(v int64) *InstanceGroupDetail {
	s.InstanceRequestCount = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *InstanceGroupDetail) SetInstanceRole(v string) *InstanceGroupDetail {
	s.InstanceRole = &v
	return s
}

// SetInstanceRunningCount sets the InstanceRunningCount field's value.
func (s *InstanceGroupDetail) SetInstanceRunningCount(v int64) *InstanceGroupDetail {
	s.InstanceRunningCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceGroupDetail) SetInstanceType(v string) *InstanceGroupDetail {
	s.InstanceType = &v
	return s
}

// SetLastStateChangeReason sets the LastStateChangeReason field's value.
func (s *InstanceGroupDetail) SetLastStateChangeReason(v string) *InstanceGroupDetail {
	s.LastStateChangeReason = &v
	return s
}

// SetMarket sets the Market field's value.
func (s *InstanceGroupDetail) SetMarket(v string) *InstanceGroupDetail {
	s.Market = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceGroupDetail) SetName(v string) *InstanceGroupDetail {
	s.Name = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *InstanceGroupDetail) SetReadyDateTime(v time.Time) *InstanceGroupDetail {
	s.ReadyDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *InstanceGroupDetail) SetStartDateTime(v time.Time) *InstanceGroupDetail {
	s.StartDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *InstanceGroupDetail) SetState(v string) *InstanceGroupDetail {
	s.State = &v
	return s
}

// Modify the size or configurations of an instance group.
type InstanceGroupModifyConfig struct {
	_ struct{} `type:"structure"`

	// A list of new or modified configurations to apply for an instance group.
	Configurations []*Configuration `type:"list"`

	// The EC2 InstanceIds to terminate. After you terminate the instances, the
	// instance group will not return to its original requested size.
	EC2InstanceIdsToTerminate []*string `type:"list"`

	// Target size for the instance group.
	InstanceCount *int64 `type:"integer"`

	// Unique ID of the instance group to modify.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupModifyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupModifyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceGroupModifyConfig"}
	if s.InstanceGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurations sets the Configurations field's value.
func (s *InstanceGroupModifyConfig) SetConfigurations(v []*Configuration) *InstanceGroupModifyConfig {
	s.Configurations = v
	return s
}

// SetEC2InstanceIdsToTerminate sets the EC2InstanceIdsToTerminate field's value.
func (s *InstanceGroupModifyConfig) SetEC2InstanceIdsToTerminate(v []*string) *InstanceGroupModifyConfig {
	s.EC2InstanceIdsToTerminate = v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *InstanceGroupModifyConfig) SetInstanceCount(v int64) *InstanceGroupModifyConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *InstanceGroupModifyConfig) SetInstanceGroupId(v string) *InstanceGroupModifyConfig {
	s.InstanceGroupId = &v
	return s
}

// SetShrinkPolicy sets the ShrinkPolicy field's value.
func (s *InstanceGroupModifyConfig) SetShrinkPolicy(v *ShrinkPolicy) *InstanceGroupModifyConfig {
	s.ShrinkPolicy = v
	return s
}

// The status change reason details for the instance group.
type InstanceGroupStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceGroupStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceGroupStateChangeReason) SetCode(v string) *InstanceGroupStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *InstanceGroupStateChangeReason) SetMessage(v string) *InstanceGroupStateChangeReason {
	s.Message = &v
	return s
}

// The details of the instance group status.
type InstanceGroupStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance group.
	State *string `type:"string" enum:"InstanceGroupState"`

	// The status change reason details for the instance group.
	StateChangeReason *InstanceGroupStateChangeReason `type:"structure"`

	// The timeline of the instance group status over time.
	Timeline *InstanceGroupTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *InstanceGroupStatus) SetState(v string) *InstanceGroupStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *InstanceGroupStatus) SetStateChangeReason(v *InstanceGroupStateChangeReason) *InstanceGroupStatus {
	s.StateChangeReason = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *InstanceGroupStatus) SetTimeline(v *InstanceGroupTimeline) *InstanceGroupStatus {
	s.Timeline = v
	return s
}

// The timeline of the instance group lifecycle.
type InstanceGroupTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance group.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance group terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance group became ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceGroupTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupTimeline) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *InstanceGroupTimeline) SetCreationDateTime(v time.Time) *InstanceGroupTimeline {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *InstanceGroupTimeline) SetEndDateTime(v time.Time) *InstanceGroupTimeline {
	s.EndDateTime = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *InstanceGroupTimeline) SetReadyDateTime(v time.Time) *InstanceGroupTimeline {
	s.ReadyDateTime = &v
	return s
}

// Custom policy for requesting termination protection or termination of specific
// instances when shrinking an instance group.
type InstanceResizePolicy struct {
	_ struct{} `type:"structure"`

	// Decommissioning timeout override for the specific list of instances to be
	// terminated.
	InstanceTerminationTimeout *int64 `type:"integer"`

	// Specific list of instances to be protected when shrinking an instance group.
	InstancesToProtect []*string `type:"list"`

	// Specific list of instances to be terminated when shrinking an instance group.
	InstancesToTerminate []*string `type:"list"`
}

// String returns the string representation
func (s InstanceResizePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceResizePolicy) GoString() string {
	return s.String()
}

// SetInstanceTerminationTimeout sets the InstanceTerminationTimeout field's value.
func (s *InstanceResizePolicy) SetInstanceTerminationTimeout(v int64) *InstanceResizePolicy {
	s.InstanceTerminationTimeout = &v
	return s
}

// SetInstancesToProtect sets the InstancesToProtect field's value.
func (s *InstanceResizePolicy) SetInstancesToProtect(v []*string) *InstanceResizePolicy {
	s.InstancesToProtect = v
	return s
}

// SetInstancesToTerminate sets the InstancesToTerminate field's value.
func (s *InstanceResizePolicy) SetInstancesToTerminate(v []*string) *InstanceResizePolicy {
	s.InstancesToTerminate = v
	return s
}

// The details of the status change reason for the instance.
type InstanceStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceStateChangeReason) SetCode(v string) *InstanceStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *InstanceStateChangeReason) SetMessage(v string) *InstanceStateChangeReason {
	s.Message = &v
	return s
}

// The instance status details.
type InstanceStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance.
	State *string `type:"string" enum:"InstanceState"`

	// The details of the status change reason for the instance.
	StateChangeReason *InstanceStateChangeReason `type:"structure"`

	// The timeline of the instance status over time.
	Timeline *InstanceTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *InstanceStatus) SetState(v string) *InstanceStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *InstanceStatus) SetStateChangeReason(v *InstanceStateChangeReason) *InstanceStatus {
	s.StateChangeReason = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *InstanceStatus) SetTimeline(v *InstanceTimeline) *InstanceStatus {
	s.Timeline = v
	return s
}

// The timeline of the instance lifecycle.
type InstanceTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance was ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTimeline) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *InstanceTimeline) SetCreationDateTime(v time.Time) *InstanceTimeline {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *InstanceTimeline) SetEndDateTime(v time.Time) *InstanceTimeline {
	s.EndDateTime = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *InstanceTimeline) SetReadyDateTime(v time.Time) *InstanceTimeline {
	s.ReadyDateTime = &v
	return s
}

// An instance type configuration for each instance type in an instance fleet,
// which determines the EC2 instances Amazon EMR attempts to provision to fulfill
// On-Demand and Spot target capacities. There can be a maximum of five instance
// type configurations in a fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceTypeConfig struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 Spot Instance type as defined by InstanceType.
	// Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string `type:"string"`

	// The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance
	// as defined by InstanceType. Expressed as a number (for example, 20 specifies
	// 20%). If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice is provided,
	// BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPriceAsPercentageOfOnDemandPrice *float64 `type:"double"`

	// A configuration classification that applies when provisioning cluster instances,
	// which can include configurations for applications and software that run on
	// the cluster.
	Configurations []*Configuration `type:"list"`

	// The configuration of Amazon Elastic Block Storage (Amazon EBS) attached to
	// each instance as defined by InstanceType.
	EbsConfiguration *EbsConfiguration `type:"structure"`

	// An EC2 instance type, such as m3.xlarge.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. This value
	// is 1 for a master instance fleet, and must be 1 or greater for core and task
	// instance fleets. Defaults to 1 if not specified.
	WeightedCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceTypeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTypeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceTypeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceTypeConfig"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.EbsConfiguration != nil {
		if err := s.EbsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBidPrice sets the BidPrice field's value.
func (s *InstanceTypeConfig) SetBidPrice(v string) *InstanceTypeConfig {
	s.BidPrice = &v
	return s
}

// SetBidPriceAsPercentageOfOnDemandPrice sets the BidPriceAsPercentageOfOnDemandPrice field's value.
func (s *InstanceTypeConfig) SetBidPriceAsPercentageOfOnDemandPrice(v float64) *InstanceTypeConfig {
	s.BidPriceAsPercentageOfOnDemandPrice = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *InstanceTypeConfig) SetConfigurations(v []*Configuration) *InstanceTypeConfig {
	s.Configurations = v
	return s
}

// SetEbsConfiguration sets the EbsConfiguration field's value.
func (s *InstanceTypeConfig) SetEbsConfiguration(v *EbsConfiguration) *InstanceTypeConfig {
	s.EbsConfiguration = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeConfig) SetInstanceType(v string) *InstanceTypeConfig {
	s.InstanceType = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *InstanceTypeConfig) SetWeightedCapacity(v int64) *InstanceTypeConfig {
	s.WeightedCapacity = &v
	return s
}

// The configuration specification for each instance type in an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceTypeSpecification struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 Spot Instance type as defined by InstanceType.
	// Expressed in USD.
	BidPrice *string `type:"string"`

	// The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance
	// as defined by InstanceType. Expressed as a number (for example, 20 specifies
	// 20%).
	BidPriceAsPercentageOfOnDemandPrice *float64 `type:"double"`

	// A configuration classification that applies when provisioning cluster instances,
	// which can include configurations for applications and software bundled with
	// Amazon EMR.
	Configurations []*Configuration `type:"list"`

	// The configuration of Amazon Elastic Block Storage (Amazon EBS) attached to
	// each instance as defined by InstanceType.
	EbsBlockDevices []*EbsBlockDevice `type:"list"`

	// Evaluates to TRUE when the specified InstanceType is EBS-optimized.
	EbsOptimized *bool `type:"boolean"`

	// The EC2 instance type, for example m3.xlarge.
	InstanceType *string `min:"1" type:"string"`

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. Capacity
	// values represent performance characteristics such as vCPUs, memory, or I/O.
	// If not specified, the default value is 1.
	WeightedCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceTypeSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTypeSpecification) GoString() string {
	return s.String()
}

// SetBidPrice sets the BidPrice field's value.
func (s *InstanceTypeSpecification) SetBidPrice(v string) *InstanceTypeSpecification {
	s.BidPrice = &v
	return s
}

// SetBidPriceAsPercentageOfOnDemandPrice sets the BidPriceAsPercentageOfOnDemandPrice field's value.
func (s *InstanceTypeSpecification) SetBidPriceAsPercentageOfOnDemandPrice(v float64) *InstanceTypeSpecification {
	s.BidPriceAsPercentageOfOnDemandPrice = &v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *InstanceTypeSpecification) SetConfigurations(v []*Configuration) *InstanceTypeSpecification {
	s.Configurations = v
	return s
}

// SetEbsBlockDevices sets the EbsBlockDevices field's value.
func (s *InstanceTypeSpecification) SetEbsBlockDevices(v []*EbsBlockDevice) *InstanceTypeSpecification {
	s.EbsBlockDevices = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *InstanceTypeSpecification) SetEbsOptimized(v bool) *InstanceTypeSpecification {
	s.EbsOptimized = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeSpecification) SetInstanceType(v string) *InstanceTypeSpecification {
	s.InstanceType = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *InstanceTypeSpecification) SetWeightedCapacity(v int64) *InstanceTypeSpecification {
	s.WeightedCapacity = &v
	return s
}

// Indicates that an error occurred while processing the request and that the
// request was not completed.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception occurs when there is an internal failure in the Amazon EMR
// service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message associated with the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This exception occurs when there is something wrong with user input.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code associated with the exception.
	ErrorCode *string `min:"1" type:"string"`

	// The message associated with the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A description of a cluster (job flow).
type JobFlowDetail struct {
	_ struct{} `type:"structure"`

	// Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases
	// 4.0 and later, ReleaseLabel is used. To specify a custom AMI, use CustomAmiID.
	AmiVersion *string `type:"string"`

	// An IAM role for automatic scaling policies. The default role is EMR_AutoScaling_DefaultRole.
	// The IAM role provides a way for the automatic scaling feature to get the
	// required permissions it needs to launch and terminate EC2 instances in an
	// instance group.
	AutoScalingRole *string `type:"string"`

	// A list of the bootstrap actions run by the job flow.
	BootstrapActions []*BootstrapActionDetail `type:"list"`

	// Describes the execution status of the job flow.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *JobFlowExecutionStatusDetail `type:"structure" required:"true"`

	// Describes the Amazon EC2 instances of the job flow.
	//
	// Instances is a required field
	Instances *JobFlowInstancesDetail `type:"structure" required:"true"`

	// The job flow identifier.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	JobFlowRole *string `type:"string"`

	// The AWS KMS customer master key (CMK) used for encrypting log files. This
	// attribute is only available with EMR version 5.30.0 and later, excluding
	// EMR 6.0.0.
	LogEncryptionKmsKeyId *string `type:"string"`

	// The location in Amazon S3 where log files for the job are stored.
	LogUri *string `type:"string"`

	// The name of the job flow.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
	// indicates that Amazon EMR terminates nodes at the instance-hour boundary,
	// regardless of when the request to terminate the instance was submitted. This
	// option is only available with Amazon EMR 5.1.0 and later and is the default
	// for clusters created using that version. TERMINATE_AT_TASK_COMPLETION indicates
	// that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
	// terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
	// With either behavior, Amazon EMR removes the least active nodes first and
	// blocks instance termination if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION
	// available only in Amazon EMR version 4.1.0 and later, and is the default
	// for versions of Amazon EMR earlier than 5.1.0.
	ScaleDownBehavior *string `type:"string" enum:"ScaleDownBehavior"`

	// The IAM role that is assumed by the Amazon EMR service to access AWS resources
	// on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps run by the job flow.
	Steps []*StepDetail `type:"list"`

	// A list of strings set by third-party software when the job flow is launched.
	// If you are not using third-party software to manage the job flow, this value
	// is empty.
	SupportedProducts []*string `type:"list"`

	// Indicates whether the cluster is visible to all IAM users of the AWS account
	// associated with the cluster. The default value, true, indicates that all
	// IAM users in the AWS account can perform cluster actions if they have the
	// proper IAM policy permissions. If this value is false, only the IAM user
	// that created the cluster can perform actions. This value can be changed on
	// a running cluster by using the SetVisibleToAllUsers action. You can override
	// the default value of true when you create a cluster by using the VisibleToAllUsers
	// parameter of the RunJobFlow action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowDetail) GoString() string {
	return s.String()
}

// SetAmiVersion sets the AmiVersion field's value.
func (s *JobFlowDetail) SetAmiVersion(v string) *JobFlowDetail {
	s.AmiVersion = &v
	return s
}

// SetAutoScalingRole sets the AutoScalingRole field's value.
func (s *JobFlowDetail) SetAutoScalingRole(v string) *JobFlowDetail {
	s.AutoScalingRole = &v
	return s
}

// SetBootstrapActions sets the BootstrapActions field's value.
func (s *JobFlowDetail) SetBootstrapActions(v []*BootstrapActionDetail) *JobFlowDetail {
	s.BootstrapActions = v
	return s
}

// SetExecutionStatusDetail sets the ExecutionStatusDetail field's value.
func (s *JobFlowDetail) SetExecutionStatusDetail(v *JobFlowExecutionStatusDetail) *JobFlowDetail {
	s.ExecutionStatusDetail = v
	return s
}

// SetInstances sets the Instances field's value.
func (s *JobFlowDetail) SetInstances(v *JobFlowInstancesDetail) *JobFlowDetail {
	s.Instances = v
	return s
}

// SetJobFlowId sets the JobFlowId field's value.
func (s *JobFlowDetail) SetJobFlowId(v string) *JobFlowDetail {
	s.JobFlowId = &v
	return s
}

// SetJobFlowRole sets the JobFlowRole field's value.
func (s *JobFlowDetail) SetJobFlowRole(v string) *JobFlowDetail {
	s.JobFlowRole = &v
	return s
}

// SetLogEncryptionKmsKeyId sets the LogEncryptionKmsKeyId field's value.
func (s *JobFlowDetail) SetLogEncryptionKmsKeyId(v string) *JobFlowDetail {
	s.LogEncryptionKmsKeyId = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *JobFlowDetail) SetLogUri(v string) *JobFlowDetail {
	s.LogUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobFlowDetail) SetName(v string) *JobFlowDetail {
	s.Name = &v
	return s
}

// SetScaleDownBehavior sets the ScaleDownBehavior field's value.
func (s *JobFlowDetail) SetScaleDownBehavior(v string) *JobFlowDetail {
	s.ScaleDownBehavior = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *JobFlowDetail) SetServiceRole(v string) *JobFlowDetail {
	s.ServiceRole = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *JobFlowDetail) SetSteps(v []*StepDetail) *JobFlowDetail {
	s.Steps = v
	return s
}

// SetSupportedProducts sets the SupportedProducts field's value.
func (s *JobFlowDetail) SetSupportedProducts(v []*string) *JobFlowDetail {
	s.SupportedProducts = v
	return s
}

// SetVisibleToAllUsers sets the VisibleToAllUsers field's value.
func (s *JobFlowDetail) SetVisibleToAllUsers(v bool) *JobFlowDetail {
	s.VisibleToAllUsers = &v
	return s
}

// Describes the status of the cluster (job flow).
type JobFlowExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the job flow.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The completion date and time of the job flow.
	EndDateTime *time.Time `type:"timestamp"`

	// Description of the job flow last changed state.
	LastStateChangeReason *string `type:"string"`

	// The date and time when the job flow was ready to start running bootstrap
	// actions.
	ReadyDateTime *time.Time `type:"timestamp"`

	// The start date and time of the job flow.
	StartDateTime *time.Time `type:"timestamp"`

	// The state of the job flow.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"JobFlowExecutionState"`
}

// String returns the string representation
func (s JobFlowExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowExecutionStatusDetail) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *JobFlowExecutionStatusDetail) SetCreationDateTime(v time.Time) *JobFlowExecutionStatusDetail {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *JobFlowExecutionStatusDetail) SetEndDateTime(v time.Time) *JobFlowExecutionStatusDetail {
	s.EndDateTime = &v
	return s
}

// SetLastStateChangeReason sets the LastStateChangeReason field's value.
func (s *JobFlowExecutionStatusDetail) SetLastStateChangeReason(v string) *JobFlowExecutionStatusDetail {
	s.LastStateChangeReason = &v
	return s
}

// SetReadyDateTime sets the ReadyDateTime field's value.
func (s *JobFlowExecutionStatusDetail) SetReadyDateTime(v time.Time) *JobFlowExecutionStatusDetail {
	s.ReadyDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *JobFlowExecutionStatusDetail) SetStartDateTime(v time.Time) *JobFlowExecutionStatusDetail {
	s.StartDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *JobFlowExecutionStatusDetail) SetState(v string) *JobFlowExecutionStatusDetail {
	s.State = &v
	return s
}

// A description of the Amazon EC2 instance on which the cluster (job flow)
// runs. A valid JobFlowInstancesConfig must contain either InstanceGroups or
// InstanceFleets. They cannot be used together. You may also have MasterInstanceType,
// SlaveInstanceType, and InstanceCount (all three must be present), but we
// don't recommend this configuration.
type JobFlowInstancesConfig struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the core and task
	// nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The name of the EC2 key pair that can be used to connect to the master node
	// using SSH as the user called "hadoop."
	Ec2KeyName *string `type:"string"`

	// Applies to clusters that use the uniform instance group configuration. To
	// launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this
	// parameter to the identifier of the Amazon VPC subnet where you want the cluster
	// to launch. If you do not specify this value and your account supports EC2-Classic,
	// the cluster launches in EC2-Classic.
	Ec2SubnetId *string `type:"string"`

	// Applies to clusters that use the instance fleet configuration. When multiple
	// EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances
	// in the optimal subnet.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	Ec2SubnetIds []*string `type:"list"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the core and task nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop
	// version for the cluster. Valid inputs are "0.18" (no longer maintained),
	// "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3",
	// "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is
	// used, unless the AmiVersion parameter is set in the RunJobFlow call, in which
	// case the default version of Hadoop for that AMI version is used.
	HadoopVersion *string `type:"string"`

	// The number of EC2 instances in the cluster.
	InstanceCount *int64 `type:"integer"`

	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	//
	// Describes the EC2 instances and instance configurations for clusters that
	// use the instance fleet configuration.
	InstanceFleets []*InstanceFleetConfig `type:"list"`

	// Configuration for the instance groups in a cluster.
	InstanceGroups []*InstanceGroupConfig `type:"list"`

	// Specifies whether the cluster should remain available after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The EC2 instance type of the master node.
	MasterInstanceType *string `min:"1" type:"string"`

	// The Availability Zone in which the cluster runs.
	Placement *PlacementType `type:"structure"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`

	// The EC2 instance type of the core and task nodes.
	SlaveInstanceType *string `min:"1" type:"string"`

	// Specifies whether to lock the cluster to prevent the Amazon EC2 instances
	// from being terminated by API call, user intervention, or in the event of
	// a job-flow error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobFlowInstancesConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobFlowInstancesConfig"}
	if s.MasterInstanceType != nil && len(*s.MasterInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MasterInstanceType", 1))
	}
	if s.SlaveInstanceType != nil && len(*s.SlaveInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlaveInstanceType", 1))
	}
	if s.InstanceFleets != nil {
		for i, v := range s.InstanceFleets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceFleets", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalMasterSecurityGroups sets the AdditionalMasterSecurityGroups field's value.
func (s *JobFlowInstancesConfig) SetAdditionalMasterSecurityGroups(v []*string) *JobFlowInstancesConfig {
	s.AdditionalMasterSecurityGroups = v
	return s
}

// SetAdditionalSlaveSecurityGroups sets the AdditionalSlaveSecurityGroups field's value.
func (s *JobFlowInstancesConfig) SetAdditionalSlaveSecurityGroups(v []*string) *JobFlowInstancesConfig {
	s.AdditionalSlaveSecurityGroups = v
	return s
}

// SetEc2KeyName sets the Ec2KeyName field's value.
func (s *JobFlowInstancesConfig) SetEc2KeyName(v string) *JobFlowInstancesConfig {
	s.Ec2KeyName = &v
	return s
}

// SetEc2SubnetId sets the Ec2SubnetId field's value.
func (s *JobFlowInstancesConfig) SetEc2SubnetId(v string) *JobFlowInstancesConfig {
	s.Ec2SubnetId = &v
	return s
}

// SetEc2SubnetIds sets the Ec2SubnetIds field's value.
func (s *JobFlowInstancesConfig) SetEc2SubnetIds(v []*string) *JobFlowInstancesConfig {
	s.Ec2SubnetIds = v
	return s
}

// SetEmrManagedMasterSecurityGroup sets the EmrManagedMasterSecurityGroup field's value.
func (s *JobFlowInstancesConfig) SetEmrManagedMasterSecurityGroup(v string) *JobFlowInstancesConfig {
	s.EmrManagedMasterSecurityGroup = &v
	return s
}

// SetEmrManagedSlaveSecurityGroup sets the EmrManagedSlaveSecurityGroup field's value.
func (s *JobFlowInstancesConfig) SetEmrManagedSlaveSecurityGroup(v string) *JobFlowInstancesConfig {
	s.EmrManagedSlaveSecurityGroup = &v
	return s
}

// SetHadoopVersion sets the HadoopVersion field's value.
func (s *JobFlowInstancesConfig) SetHadoopVersion(v string) *JobFlowInstancesConfig {
	s.HadoopVersion = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *JobFlowInstancesConfig) SetInstanceCount(v int64) *JobFlowInstancesConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceFleets sets the InstanceFleets field's value.
func (s *JobFlowInstancesConfig) SetInstanceFleets(v []*InstanceFleetConfig) *JobFlowInstancesConfig {
	s.InstanceFleets = v
	return s
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *JobFlowInstancesConfig) SetInstanceGroups(v []*InstanceGroupConfig) *JobFlowInstancesConfig {
	s.InstanceGroups = v
	return s
}

// SetKeepJobFlowAliveWhenNoSteps sets the KeepJobFlowAliveWhenNoSteps field's value.
func (s *JobFlowInstancesConfig) SetKeepJobFlowAliveWhenNoSteps(v bool) *JobFlowInstancesConfig {
	s.KeepJobFlowAliveWhenNoSteps = &v
	return s
}

// SetMasterInstanceType sets the MasterInstanceType field's value.
func (s *JobFlowInstancesConfig) SetMasterInstanceType(v string) *JobFlowInstancesConfig {
	s.MasterInstanceType = &v
	return s
}

// SetPlacement sets the Placement field's value.
func (s *JobFlowInstancesConfig) SetPlacement(v *PlacementType) *JobFlowInstancesConfig {
	s.Placement = v
	return s
}

// SetServiceAccessSecurityGroup sets the ServiceAccessSecurityGroup field's value.
func (s *JobFlowInstancesConfig) SetServiceAccessSecurityGroup(v string) *JobFlowInstancesConfig {
	s.ServiceAccessSecurityGroup = &v
	return s
}

// SetSlaveInstanceType sets the SlaveInstanceType field's value.
func (s *JobFlowInstancesConfig) SetSlaveInstanceType(v string) *JobFlowInstancesConfig {
	s.SlaveInstanceType = &v
	return s
}

// SetTerminationProtected sets the TerminationProtected field's value.
func (s *JobFlowInstancesConfig) SetTerminationProtected(v bool) *JobFlowInstancesConfig {
	s.TerminationProtected = &v
	return s
}

// Specify the type of Amazon EC2 instances that the cluster (job flow) runs
// on.
type JobFlowInstancesDetail struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon EC2 key pair that can be used to connect to the master
	// node using SSH.
	Ec2KeyName *string `type:"string"`

	// For clusters launched within Amazon Virtual Private Cloud, this is the identifier
	// of the subnet where the cluster was launched.
	Ec2SubnetId *string `type:"string"`

	// The Hadoop version for the cluster.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances in the cluster. If the value is 1, the
	// same instance serves as both the master and core and task node. If the value
	// is greater than 1, one instance is the master node and all others are core
	// and task nodes.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// Details about the instance groups in a cluster.
	InstanceGroups []*InstanceGroupDetail `type:"list"`

	// Specifies whether the cluster should remain available after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The Amazon EC2 instance identifier of the master node.
	MasterInstanceId *string `type:"string"`

	// The Amazon EC2 master node instance type.
	//
	// MasterInstanceType is a required field
	MasterInstanceType *string `min:"1" type:"string" required:"true"`

	// The DNS name of the master node. If the cluster is on a private subnet, this
	// is the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is increased one time for every hour that an m1.small instance
	// runs. Larger instances are weighted more heavily, so an Amazon EC2 instance
	// that is roughly four times more expensive would result in the normalized
	// instance hours being increased incrementally four times. This result is only
	// an approximation and does not reflect the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone for the cluster.
	Placement *PlacementType `type:"structure"`

	// The Amazon EC2 core and task node instance type.
	//
	// SlaveInstanceType is a required field
	SlaveInstanceType *string `min:"1" type:"string" required:"true"`

	// Specifies whether the Amazon EC2 instances in the cluster are protected from
	// termination by API calls, user intervention, or in the event of a job-flow
	// error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesDetail) GoString() string {
	return s.String()
}

// SetEc2KeyName sets the Ec2KeyName field's value.
func (s *JobFlowInstancesDetail) SetEc2KeyName(v string) *JobFlowInstancesDetail {
	s.Ec2KeyName = &v
	return s
}

// SetEc2SubnetId sets the Ec2SubnetId field's value.
func (s *JobFlowInstancesDetail) SetEc2SubnetId(v string) *JobFlowInstancesDetail {
	s.Ec2SubnetId = &v
	return s
}

// SetHadoopVersion sets the HadoopVersion field's value.
func (s *JobFlowInstancesDetail) SetHadoopVersion(v string) *JobFlowInstancesDetail {
	s.HadoopVersion = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *JobFlowInstancesDetail) SetInstanceCount(v int64) *JobFlowInstancesDetail {
	s.InstanceCount = &v
	return s
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *JobFlowInstancesDetail) SetInstanceGroups(v []*InstanceGroupDetail) *JobFlowInstancesDetail {
	s.InstanceGroups = v
	return s
}

// SetKeepJobFlowAliveWhenNoSteps sets the KeepJobFlowAliveWhenNoSteps field's value.
func (s *JobFlowInstancesDetail) SetKeepJobFlowAliveWhenNoSteps(v bool) *JobFlowInstancesDetail {
	s.KeepJobFlowAliveWhenNoSteps = &v
	return s
}

// SetMasterInstanceId sets the MasterInstanceId field's value.
func (s *JobFlowInstancesDetail) SetMasterInstanceId(v string) *JobFlowInstancesDetail {
	s.MasterInstanceId = &v
	return s
}

// SetMasterInstanceType sets the MasterInstanceType field's value.
func (s *JobFlowInstancesDetail) SetMasterInstanceType(v string) *JobFlowInstancesDetail {
	s.MasterInstanceType = &v
	return s
}

// SetMasterPublicDnsName sets the MasterPublicDnsName field's value.
func (s *JobFlowInstancesDetail) SetMasterPublicDnsName(v string) *JobFlowInstancesDetail {
	s.MasterPublicDnsName = &v
	return s
}

// SetNormalizedInstanceHours sets the NormalizedInstanceHours field's value.
func (s *JobFlowInstancesDetail) SetNormalizedInstanceHours(v int64) *JobFlowInstancesDetail {
	s.NormalizedInstanceHours = &v
	return s
}

// SetPlacement sets the Placement field's value.
func (s *JobFlowInstancesDetail) SetPlacement(v *PlacementType) *JobFlowInstancesDetail {
	s.Placement = v
	return s
}

// SetSlaveInstanceType sets the SlaveInstanceType field's value.
func (s *JobFlowInstancesDetail) SetSlaveInstanceType(v string) *JobFlowInstancesDetail {
	s.SlaveInstanceType = &v
	return s
}

// SetTerminationProtected sets the TerminationProtected field's value.
func (s *JobFlowInstancesDetail) SetTerminationProtected(v bool) *JobFlowInstancesDetail {
	s.TerminationProtected = &v
	return s
}

// Attributes for Kerberos configuration when Kerberos authentication is enabled
// using a security configuration. For more information see Use Kerberos Authentication
// (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
// in the Amazon EMR Management Guide.
type KerberosAttributes struct {
	_ struct{} `type:"structure"`

	// The Active Directory password for ADDomainJoinUser.
	ADDomainJoinPassword *string `type:"string"`

	// Required only when establishing a cross-realm trust with an Active Directory
	// domain. A user with sufficient privileges to join resources to the domain.
	ADDomainJoinUser *string `type:"string"`

	// Required only when establishing a cross-realm trust with a KDC in a different
	// realm. The cross-realm principal password, which must be identical across
	// realms.
	CrossRealmTrustPrincipalPassword *string `type:"string"`

	// The password used within the cluster for the kadmin service on the cluster-dedicated
	// KDC, which maintains Kerberos principals, password policies, and keytabs
	// for the cluster.
	//
	// KdcAdminPassword is a required field
	KdcAdminPassword *string `type:"string" required:"true"`

	// The name of the Kerberos realm to which all nodes in a cluster belong. For
	// example, EC2.INTERNAL.
	//
	// Realm is a required field
	Realm *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KerberosAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KerberosAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KerberosAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KerberosAttributes"}
	if s.KdcAdminPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("KdcAdminPassword"))
	}
	if s.Realm == nil {
		invalidParams.Add(request.NewErrParamRequired("Realm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetADDomainJoinPassword sets the ADDomainJoinPassword field's value.
func (s *KerberosAttributes) SetADDomainJoinPassword(v string) *KerberosAttributes {
	s.ADDomainJoinPassword = &v
	return s
}

// SetADDomainJoinUser sets the ADDomainJoinUser field's value.
func (s *KerberosAttributes) SetADDomainJoinUser(v string) *KerberosAttributes {
	s.ADDomainJoinUser = &v
	return s
}

// SetCrossRealmTrustPrincipalPassword sets the CrossRealmTrustPrincipalPassword field's value.
func (s *KerberosAttributes) SetCrossRealmTrustPrincipalPassword(v string) *KerberosAttributes {
	s.CrossRealmTrustPrincipalPassword = &v
	return s
}

// SetKdcAdminPassword sets the KdcAdminPassword field's value.
func (s *KerberosAttributes) SetKdcAdminPassword(v string) *KerberosAttributes {
	s.KdcAdminPassword = &v
	return s
}

// SetRealm sets the Realm field's value.
func (s *KerberosAttributes) SetRealm(v string) *KerberosAttributes {
	s.Realm = &v
	return s
}

// A key-value pair.
type KeyValue struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a key-value pair.
	Key *string `type:"string"`

	// The value part of the identified key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValue) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *KeyValue) SetKey(v string) *KeyValue {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValue) SetValue(v string) *KeyValue {
	s.Value = &v
	return s
}

// This input determines which bootstrap actions to retrieve.
type ListBootstrapActionsInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for the bootstrap actions to list.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListBootstrapActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBootstrapActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBootstrapActionsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListBootstrapActionsInput) SetClusterId(v string) *ListBootstrapActionsInput {
	s.ClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListBootstrapActionsInput) SetMarker(v string) *ListBootstrapActionsInput {
	s.Marker = &v
	return s
}

// This output contains the bootstrap actions detail.
type ListBootstrapActionsOutput struct {
	_ struct{} `type:"structure"`

	// The bootstrap actions associated with the cluster.
	BootstrapActions []*Command `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListBootstrapActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsOutput) GoString() string {
	return s.String()
}

// SetBootstrapActions sets the BootstrapActions field's value.
func (s *ListBootstrapActionsOutput) SetBootstrapActions(v []*Command) *ListBootstrapActionsOutput {
	s.BootstrapActions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListBootstrapActionsOutput) SetMarker(v string) *ListBootstrapActionsOutput {
	s.Marker = &v
	return s
}

// This input determines how the ListClusters action filters the list of clusters
// that it returns.
type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The cluster state filters to apply when listing clusters.
	ClusterStates []*string `type:"list"`

	// The creation date and time beginning value filter for listing clusters.
	CreatedAfter *time.Time `type:"timestamp"`

	// The creation date and time end value filter for listing clusters.
	CreatedBefore *time.Time `type:"timestamp"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// SetClusterStates sets the ClusterStates field's value.
func (s *ListClustersInput) SetClusterStates(v []*string) *ListClustersInput {
	s.ClusterStates = v
	return s
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *ListClustersInput) SetCreatedAfter(v time.Time) *ListClustersInput {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *ListClustersInput) SetCreatedBefore(v time.Time) *ListClustersInput {
	s.CreatedBefore = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListClustersInput) SetMarker(v string) *ListClustersInput {
	s.Marker = &v
	return s
}

// This contains a ClusterSummaryList with the cluster details; for example,
// the cluster IDs, names, and status.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// The list of clusters for the account based on the given filters.
	Clusters []*ClusterSummary `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*ClusterSummary) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListClustersOutput) SetMarker(v string) *ListClustersOutput {
	s.Marker = &v
	return s
}

type ListInstanceFleetsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceFleetsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListInstanceFleetsInput) SetClusterId(v string) *ListInstanceFleetsInput {
	s.ClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceFleetsInput) SetMarker(v string) *ListInstanceFleetsInput {
	s.Marker = &v
	return s
}

type ListInstanceFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of instance fleets for the cluster and given filters.
	InstanceFleets []*InstanceFleet `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceFleetsOutput) GoString() string {
	return s.String()
}

// SetInstanceFleets sets the InstanceFleets field's value.
func (s *ListInstanceFleetsOutput) SetInstanceFleets(v []*InstanceFleet) *ListInstanceFleetsOutput {
	s.InstanceFleets = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceFleetsOutput) SetMarker(v string) *ListInstanceFleetsOutput {
	s.Marker = &v
	return s
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the instance groups.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceGroupsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListInstanceGroupsInput) SetClusterId(v string) *ListInstanceGroupsInput {
	s.ClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceGroupsInput) SetMarker(v string) *ListInstanceGroupsInput {
	s.Marker = &v
	return s
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The list of instance groups for the cluster and given filters.
	InstanceGroups []*InstanceGroup `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsOutput) GoString() string {
	return s.String()
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *ListInstanceGroupsOutput) SetInstanceGroups(v []*InstanceGroup) *ListInstanceGroupsOutput {
	s.InstanceGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceGroupsOutput) SetMarker(v string) *ListInstanceGroupsOutput {
	s.Marker = &v
	return s
}

// This input determines which instances to list.
type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the instances.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The unique identifier of the instance fleet.
	InstanceFleetId *string `type:"string"`

	// The node type of the instance fleet. For example MASTER, CORE, or TASK.
	InstanceFleetType *string `type:"string" enum:"InstanceFleetType"`

	// The identifier of the instance group for which to list the instances.
	InstanceGroupId *string `type:"string"`

	// The type of instance group for which to list the instances.
	InstanceGroupTypes []*string `type:"list"`

	// A list of instance states that will filter the instances returned with this
	// request.
	InstanceStates []*string `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListInstancesInput) SetClusterId(v string) *ListInstancesInput {
	s.ClusterId = &v
	return s
}

// SetInstanceFleetId sets the InstanceFleetId field's value.
func (s *ListInstancesInput) SetInstanceFleetId(v string) *ListInstancesInput {
	s.InstanceFleetId = &v
	return s
}

// SetInstanceFleetType sets the InstanceFleetType field's value.
func (s *ListInstancesInput) SetInstanceFleetType(v string) *ListInstancesInput {
	s.InstanceFleetType = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *ListInstancesInput) SetInstanceGroupId(v string) *ListInstancesInput {
	s.InstanceGroupId = &v
	return s
}

// SetInstanceGroupTypes sets the InstanceGroupTypes field's value.
func (s *ListInstancesInput) SetInstanceGroupTypes(v []*string) *ListInstancesInput {
	s.InstanceGroupTypes = v
	return s
}

// SetInstanceStates sets the InstanceStates field's value.
func (s *ListInstancesInput) SetInstanceStates(v []*string) *ListInstancesInput {
	s.InstanceStates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstancesInput) SetMarker(v string) *ListInstancesInput {
	s.Marker = &v
	return s
}

// This output contains the list of instances.
type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of instances for the cluster and given filters.
	Instances []*Instance `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListInstancesOutput) SetInstances(v []*Instance) *ListInstancesOutput {
	s.Instances = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstancesOutput) SetMarker(v string) *ListInstancesOutput {
	s.Marker = &v
	return s
}

type ListNotebookExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the editor associated with the notebook execution.
	EditorId *string `type:"string"`

	// The beginning of time range filter for listing notebook executions. The default
	// is the timestamp of 30 days ago.
	From *time.Time `type:"timestamp"`

	// The pagination token, returned by a previous ListNotebookExecutions call,
	// that indicates the start of the list for this ListNotebookExecutions call.
	Marker *string `type:"string"`

	// The status filter for listing notebook executions.
	//
	//    * START_PENDING indicates that the cluster has received the execution
	//    request but execution has not begun.
	//
	//    * STARTING indicates that the execution is starting on the cluster.
	//
	//    * RUNNING indicates that the execution is being processed by the cluster.
	//
	//    * FINISHING indicates that execution processing is in the final stages.
	//
	//    * FINISHED indicates that the execution has completed without error.
	//
	//    * FAILING indicates that the execution is failing and will not finish
	//    successfully.
	//
	//    * FAILED indicates that the execution failed.
	//
	//    * STOP_PENDING indicates that the cluster has received a StopNotebookExecution
	//    request and the stop is pending.
	//
	//    * STOPPING indicates that the cluster is in the process of stopping the
	//    execution as a result of a StopNotebookExecution request.
	//
	//    * STOPPED indicates that the execution stopped because of a StopNotebookExecution
	//    request.
	Status *string `type:"string" enum:"NotebookExecutionStatus"`

	// The end of time range filter for listing notebook executions. The default
	// is the current timestamp.
	To *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListNotebookExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookExecutionsInput) GoString() string {
	return s.String()
}

// SetEditorId sets the EditorId field's value.
func (s *ListNotebookExecutionsInput) SetEditorId(v string) *ListNotebookExecutionsInput {
	s.EditorId = &v
	return s
}

// SetFrom sets the From field's value.
func (s *ListNotebookExecutionsInput) SetFrom(v time.Time) *ListNotebookExecutionsInput {
	s.From = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListNotebookExecutionsInput) SetMarker(v string) *ListNotebookExecutionsInput {
	s.Marker = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListNotebookExecutionsInput) SetStatus(v string) *ListNotebookExecutionsInput {
	s.Status = &v
	return s
}

// SetTo sets the To field's value.
func (s *ListNotebookExecutionsInput) SetTo(v time.Time) *ListNotebookExecutionsInput {
	s.To = &v
	return s
}

type ListNotebookExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that a subsequent ListNotebookExecutions can use to determine
	// the next set of results to retrieve.
	Marker *string `type:"string"`

	// A list of notebook executions.
	NotebookExecutions []*NotebookExecutionSummary `type:"list"`
}

// String returns the string representation
func (s ListNotebookExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotebookExecutionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListNotebookExecutionsOutput) SetMarker(v string) *ListNotebookExecutionsOutput {
	s.Marker = &v
	return s
}

// SetNotebookExecutions sets the NotebookExecutions field's value.
func (s *ListNotebookExecutionsOutput) SetNotebookExecutions(v []*NotebookExecutionSummary) *ListNotebookExecutionsOutput {
	s.NotebookExecutions = v
	return s
}

type ListSecurityConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListSecurityConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityConfigurationsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListSecurityConfigurationsInput) SetMarker(v string) *ListSecurityConfigurationsInput {
	s.Marker = &v
	return s
}

type ListSecurityConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that indicates the next set of results to retrieve. Include
	// the marker in the next ListSecurityConfiguration call to retrieve the next
	// page of results, if required.
	Marker *string `type:"string"`

	// The creation date and time, and name, of each security configuration.
	SecurityConfigurations []*SecurityConfigurationSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityConfigurationsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListSecurityConfigurationsOutput) SetMarker(v string) *ListSecurityConfigurationsOutput {
	s.Marker = &v
	return s
}

// SetSecurityConfigurations sets the SecurityConfigurations field's value.
func (s *ListSecurityConfigurationsOutput) SetSecurityConfigurations(v []*SecurityConfigurationSummary) *ListSecurityConfigurationsOutput {
	s.SecurityConfigurations = v
	return s
}

// This input determines which steps to list.
type ListStepsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the steps.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filter to limit the step list based on the identifier of the steps. You
	// can specify a maximum of ten Step IDs. The character constraint applies to
	// the overall length of the array.
	StepIds []*string `type:"list"`

	// The filter to limit the step list based on certain states.
	StepStates []*string `type:"list"`
}

// String returns the string representation
func (s ListStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStepsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListStepsInput) SetClusterId(v string) *ListStepsInput {
	s.ClusterId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListStepsInput) SetMarker(v string) *ListStepsInput {
	s.Marker = &v
	return s
}

// SetStepIds sets the StepIds field's value.
func (s *ListStepsInput) SetStepIds(v []*string) *ListStepsInput {
	s.StepIds = v
	return s
}

// SetStepStates sets the StepStates field's value.
func (s *ListStepsInput) SetStepStates(v []*string) *ListStepsInput {
	s.StepStates = v
	return s
}

// This output contains the list of steps returned in reverse order. This means
// that the last step is the first element in the list.
type ListStepsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filtered list of steps for the cluster.
	Steps []*StepSummary `type:"list"`
}

// String returns the string representation
func (s ListStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStepsOutput) SetMarker(v string) *ListStepsOutput {
	s.Marker = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *ListStepsOutput) SetSteps(v []*StepSummary) *ListStepsOutput {
	s.Steps = v
	return s
}

type ListStudioSessionMappingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to return session mappings for users or groups. If not
	// specified, the results include session mapping details for both users and
	// groups.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The pagination token that indicates the set of results to retrieve.
	Marker *string `type:"string"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`
}

// String returns the string representation
func (s ListStudioSessionMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStudioSessionMappingsInput) GoString() string {
	return s.String()
}

// SetIdentityType sets the IdentityType field's value.
func (s *ListStudioSessionMappingsInput) SetIdentityType(v string) *ListStudioSessionMappingsInput {
	s.IdentityType = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListStudioSessionMappingsInput) SetMarker(v string) *ListStudioSessionMappingsInput {
	s.Marker = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *ListStudioSessionMappingsInput) SetStudioId(v string) *ListStudioSessionMappingsInput {
	s.StudioId = &v
	return s
}

type ListStudioSessionMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// A list of session mapping summary objects. Each object includes session mapping
	// details such as creation time, identity type (user or group), and Amazon
	// EMR Studio ID.
	SessionMappings []*SessionMappingSummary `type:"list"`
}

// String returns the string representation
func (s ListStudioSessionMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStudioSessionMappingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStudioSessionMappingsOutput) SetMarker(v string) *ListStudioSessionMappingsOutput {
	s.Marker = &v
	return s
}

// SetSessionMappings sets the SessionMappings field's value.
func (s *ListStudioSessionMappingsOutput) SetSessionMappings(v []*SessionMappingSummary) *ListStudioSessionMappingsOutput {
	s.SessionMappings = v
	return s
}

type ListStudiosInput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListStudiosInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStudiosInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStudiosInput) SetMarker(v string) *ListStudiosInput {
	s.Marker = &v
	return s
}

type ListStudiosOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The list of Studio summary objects.
	Studios []*StudioSummary `type:"list"`
}

// String returns the string representation
func (s ListStudiosOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStudiosOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStudiosOutput) SetMarker(v string) *ListStudiosOutput {
	s.Marker = &v
	return s
}

// SetStudios sets the Studios field's value.
func (s *ListStudiosOutput) SetStudios(v []*StudioSummary) *ListStudiosOutput {
	s.Studios = v
	return s
}

// Managed scaling policy for an Amazon EMR cluster. The policy specifies the
// limits for resources that can be added or terminated from a cluster. The
// policy only applies to the core and task nodes. The master node cannot be
// scaled after initial configuration.
type ManagedScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The EC2 unit limits for a managed scaling policy. The managed scaling activity
	// of a cluster is not allowed to go above or below these limits. The limit
	// only applies to the core and task nodes. The master node cannot be scaled
	// after initial configuration.
	ComputeLimits *ComputeLimits `type:"structure"`
}

// String returns the string representation
func (s ManagedScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedScalingPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedScalingPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManagedScalingPolicy"}
	if s.ComputeLimits != nil {
		if err := s.ComputeLimits.Validate(); err != nil {
			invalidParams.AddNested("ComputeLimits", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeLimits sets the ComputeLimits field's value.
func (s *ManagedScalingPolicy) SetComputeLimits(v *ComputeLimits) *ManagedScalingPolicy {
	s.ComputeLimits = v
	return s
}

// A CloudWatch dimension, which is specified using a Key (known as a Name in
// CloudWatch), Value pair. By default, Amazon EMR uses one dimension whose
// Key is JobFlowID and Value is a variable representing the cluster ID, which
// is ${emr.clusterId}. This enables the rule to bootstrap when the cluster
// ID becomes available.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The dimension name.
	Key *string `type:"string"`

	// The dimension value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *MetricDimension) SetKey(v string) *MetricDimension {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The number of steps that can be executed concurrently. You can specify a
	// minimum of 1 step and a maximum of 256 steps.
	StepConcurrencyLevel *int64 `type:"integer"`
}

// String returns the string representation
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ModifyClusterInput) SetClusterId(v string) *ModifyClusterInput {
	s.ClusterId = &v
	return s
}

// SetStepConcurrencyLevel sets the StepConcurrencyLevel field's value.
func (s *ModifyClusterInput) SetStepConcurrencyLevel(v int64) *ModifyClusterInput {
	s.StepConcurrencyLevel = &v
	return s
}

type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// The number of steps that can be executed concurrently.
	StepConcurrencyLevel *int64 `type:"integer"`
}

// String returns the string representation
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterOutput) GoString() string {
	return s.String()
}

// SetStepConcurrencyLevel sets the StepConcurrencyLevel field's value.
func (s *ModifyClusterOutput) SetStepConcurrencyLevel(v int64) *ModifyClusterOutput {
	s.StepConcurrencyLevel = &v
	return s
}

type ModifyInstanceFleetInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The unique identifier of the instance fleet.
	//
	// InstanceFleet is a required field
	InstanceFleet *InstanceFleetModifyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyInstanceFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyInstanceFleetInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.InstanceFleet == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceFleet"))
	}
	if s.InstanceFleet != nil {
		if err := s.InstanceFleet.Validate(); err != nil {
			invalidParams.AddNested("InstanceFleet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ModifyInstanceFleetInput) SetClusterId(v string) *ModifyInstanceFleetInput {
	s.ClusterId = &v
	return s
}

// SetInstanceFleet sets the InstanceFleet field's value.
func (s *ModifyInstanceFleetInput) SetInstanceFleet(v *InstanceFleetModifyConfig) *ModifyInstanceFleetInput {
	s.InstanceFleet = v
	return s
}

type ModifyInstanceFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceFleetOutput) GoString() string {
	return s.String()
}

// Change the size of some instance groups.
type ModifyInstanceGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the cluster to which the instance group belongs.
	ClusterId *string `type:"string"`

	// Instance groups to change.
	InstanceGroups []*InstanceGroupModifyConfig `type:"list"`
}

// String returns the string representation
func (s ModifyInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyInstanceGroupsInput"}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ModifyInstanceGroupsInput) SetClusterId(v string) *ModifyInstanceGroupsInput {
	s.ClusterId = &v
	return s
}

// SetInstanceGroups sets the InstanceGroups field's value.
func (s *ModifyInstanceGroupsInput) SetInstanceGroups(v []*InstanceGroupModifyConfig) *ModifyInstanceGroupsInput {
	s.InstanceGroups = v
	return s
}

type ModifyInstanceGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsOutput) GoString() string {
	return s.String()
}

// A notebook execution. An execution is a specific instance that an EMR Notebook
// is run using the StartNotebookExecution action.
type NotebookExecution struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the notebook execution.
	Arn *string `type:"string"`

	// The unique identifier of the EMR Notebook that is used for the notebook execution.
	EditorId *string `type:"string"`

	// The timestamp when notebook execution ended.
	EndTime *time.Time `type:"timestamp"`

	// The execution engine, such as an EMR cluster, used to run the EMR notebook
	// and perform the notebook execution.
	ExecutionEngine *ExecutionEngineConfig `type:"structure"`

	// The reason for the latest status change of the notebook execution.
	LastStateChangeReason *string `type:"string"`

	// The unique identifier of a notebook execution.
	NotebookExecutionId *string `type:"string"`

	// A name for the notebook execution.
	NotebookExecutionName *string `type:"string"`

	// The unique identifier of the EC2 security group associated with the EMR Notebook
	// instance. For more information see Specifying EC2 Security Groups for EMR
	// Notebooks (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html)
	// in the EMR Management Guide.
	NotebookInstanceSecurityGroupId *string `type:"string"`

	// Input parameters in JSON format passed to the EMR Notebook at runtime for
	// execution.
	NotebookParams *string `type:"string"`

	// The location of the notebook execution's output file in Amazon S3.
	OutputNotebookURI *string `type:"string"`

	// The timestamp when notebook execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the notebook execution.
	//
	//    * START_PENDING indicates that the cluster has received the execution
	//    request but execution has not begun.
	//
	//    * STARTING indicates that the execution is starting on the cluster.
	//
	//    * RUNNING indicates that the execution is being processed by the cluster.
	//
	//    * FINISHING indicates that execution processing is in the final stages.
	//
	//    * FINISHED indicates that the execution has completed without error.
	//
	//    * FAILING indicates that the execution is failing and will not finish
	//    successfully.
	//
	//    * FAILED indicates that the execution failed.
	//
	//    * STOP_PENDING indicates that the cluster has received a StopNotebookExecution
	//    request and the stop is pending.
	//
	//    * STOPPING indicates that the cluster is in the process of stopping the
	//    execution as a result of a StopNotebookExecution request.
	//
	//    * STOPPED indicates that the execution stopped because of a StopNotebookExecution
	//    request.
	Status *string `type:"string" enum:"NotebookExecutionStatus"`

	// A list of tags associated with a notebook execution. Tags are user-defined
	// key-value pairs that consist of a required key string with a maximum of 128
	// characters and an optional value string with a maximum of 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s NotebookExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotebookExecution) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NotebookExecution) SetArn(v string) *NotebookExecution {
	s.Arn = &v
	return s
}

// SetEditorId sets the EditorId field's value.
func (s *NotebookExecution) SetEditorId(v string) *NotebookExecution {
	s.EditorId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *NotebookExecution) SetEndTime(v time.Time) *NotebookExecution {
	s.EndTime = &v
	return s
}

// SetExecutionEngine sets the ExecutionEngine field's value.
func (s *NotebookExecution) SetExecutionEngine(v *ExecutionEngineConfig) *NotebookExecution {
	s.ExecutionEngine = v
	return s
}

// SetLastStateChangeReason sets the LastStateChangeReason field's value.
func (s *NotebookExecution) SetLastStateChangeReason(v string) *NotebookExecution {
	s.LastStateChangeReason = &v
	return s
}

// SetNotebookExecutionId sets the NotebookExecutionId field's value.
func (s *NotebookExecution) SetNotebookExecutionId(v string) *NotebookExecution {
	s.NotebookExecutionId = &v
	return s
}

// SetNotebookExecutionName sets the NotebookExecutionName field's value.
func (s *NotebookExecution) SetNotebookExecutionName(v string) *NotebookExecution {
	s.NotebookExecutionName = &v
	return s
}

// SetNotebookInstanceSecurityGroupId sets the NotebookInstanceSecurityGroupId field's value.
func (s *NotebookExecution) SetNotebookInstanceSecurityGroupId(v string) *NotebookExecution {
	s.NotebookInstanceSecurityGroupId = &v
	return s
}

// SetNotebookParams sets the NotebookParams field's value.
func (s *NotebookExecution) SetNotebookParams(v string) *NotebookExecution {
	s.NotebookParams = &v
	return s
}

// SetOutputNotebookURI sets the OutputNotebookURI field's value.
func (s *NotebookExecution) SetOutputNotebookURI(v string) *NotebookExecution {
	s.OutputNotebookURI = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *NotebookExecution) SetStartTime(v time.Time) *NotebookExecution {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NotebookExecution) SetStatus(v string) *NotebookExecution {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *NotebookExecution) SetTags(v []*Tag) *NotebookExecution {
	s.Tags = v
	return s
}

type NotebookExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the editor associated with the notebook execution.
	EditorId *string `type:"string"`

	// The timestamp when notebook execution started.
	EndTime *time.Time `type:"timestamp"`

	// The unique identifier of the notebook execution.
	NotebookExecutionId *string `type:"string"`

	// The name of the notebook execution.
	NotebookExecutionName *string `type:"string"`

	// The timestamp when notebook execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the notebook execution.
	//
	//    * START_PENDING indicates that the cluster has received the execution
	//    request but execution has not begun.
	//
	//    * STARTING indicates that the execution is starting on the cluster.
	//
	//    * RUNNING indicates that the execution is being processed by the cluster.
	//
	//    * FINISHING indicates that execution processing is in the final stages.
	//
	//    * FINISHED indicates that the execution has completed without error.
	//
	//    * FAILING indicates that the execution is failing and will not finish
	//    successfully.
	//
	//    * FAILED indicates that the execution failed.
	//
	//    * STOP_PENDING indicates that the cluster has received a StopNotebookExecution
	//    request and the stop is pending.
	//
	//    * STOPPING indicates that the cluster is in the process of stopping the
	//    execution as a result of a StopNotebookExecution request.
	//
	//    * STOPPED indicates that the execution stopped because of a StopNotebookExecution
	//    request.
	Status *string `type:"string" enum:"NotebookExecutionStatus"`
}

// String returns the string representation
func (s NotebookExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotebookExecutionSummary) GoString() string {
	return s.String()
}

// SetEditorId sets the EditorId field's value.
func (s *NotebookExecutionSummary) SetEditorId(v string) *NotebookExecutionSummary {
	s.EditorId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *NotebookExecutionSummary) SetEndTime(v time.Time) *NotebookExecutionSummary {
	s.EndTime = &v
	return s
}

// SetNotebookExecutionId sets the NotebookExecutionId field's value.
func (s *NotebookExecutionSummary) SetNotebookExecutionId(v string) *NotebookExecutionSummary {
	s.NotebookExecutionId = &v
	return s
}

// SetNotebookExecutionName sets the NotebookExecutionName field's value.
func (s *NotebookExecutionSummary) SetNotebookExecutionName(v string) *NotebookExecutionSummary {
	s.NotebookExecutionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *NotebookExecutionSummary) SetStartTime(v time.Time) *NotebookExecutionSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NotebookExecutionSummary) SetStatus(v string) *NotebookExecutionSummary {
	s.Status = &v
	return s
}

// Describes the strategy for using unused Capacity Reservations for fulfilling
// On-Demand capacity.
type OnDemandCapacityReservationOptions struct {
	_ struct{} `type:"structure"`

	// Indicates the instance's Capacity Reservation preferences. Possible preferences
	// include:
	//
	//    * open - The instance can run in any open Capacity Reservation that has
	//    matching attributes (instance type, platform, Availability Zone).
	//
	//    * none - The instance avoids running in a Capacity Reservation even if
	//    one is available. The instance runs as an On-Demand Instance.
	CapacityReservationPreference *string `type:"string" enum:"OnDemandCapacityReservationPreference"`

	// The ARN of the Capacity Reservation resource group in which to run the instance.
	CapacityReservationResourceGroupArn *string `type:"string"`

	// Indicates whether to use unused Capacity Reservations for fulfilling On-Demand
	// capacity.
	//
	// If you specify use-capacity-reservations-first, the fleet uses unused Capacity
	// Reservations to fulfill On-Demand capacity up to the target On-Demand capacity.
	// If multiple instance pools have unused Capacity Reservations, the On-Demand
	// allocation strategy (lowest-price) is applied. If the number of unused Capacity
	// Reservations is less than the On-Demand target capacity, the remaining On-Demand
	// target capacity is launched according to the On-Demand allocation strategy
	// (lowest-price).
	//
	// If you do not specify a value, the fleet fulfils the On-Demand capacity according
	// to the chosen On-Demand allocation strategy.
	UsageStrategy *string `type:"string" enum:"OnDemandCapacityReservationUsageStrategy"`
}

// String returns the string representation
func (s OnDemandCapacityReservationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnDemandCapacityReservationOptions) GoString() string {
	return s.String()
}

// SetCapacityReservationPreference sets the CapacityReservationPreference field's value.
func (s *OnDemandCapacityReservationOptions) SetCapacityReservationPreference(v string) *OnDemandCapacityReservationOptions {
	s.CapacityReservationPreference = &v
	return s
}

// SetCapacityReservationResourceGroupArn sets the CapacityReservationResourceGroupArn field's value.
func (s *OnDemandCapacityReservationOptions) SetCapacityReservationResourceGroupArn(v string) *OnDemandCapacityReservationOptions {
	s.CapacityReservationResourceGroupArn = &v
	return s
}

// SetUsageStrategy sets the UsageStrategy field's value.
func (s *OnDemandCapacityReservationOptions) SetUsageStrategy(v string) *OnDemandCapacityReservationOptions {
	s.UsageStrategy = &v
	return s
}

// The launch specification for On-Demand Instances in the instance fleet, which
// determines the allocation strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation
// strategy is available in Amazon EMR version 5.12.1 and later.
type OnDemandProvisioningSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the strategy to use in launching On-Demand instance fleets. Currently,
	// the only option is lowest-price (the default), which launches the lowest
	// price first.
	//
	// AllocationStrategy is a required field
	AllocationStrategy *string `type:"string" required:"true" enum:"OnDemandProvisioningAllocationStrategy"`

	// The launch specification for On-Demand instances in the instance fleet, which
	// determines the allocation strategy.
	CapacityReservationOptions *OnDemandCapacityReservationOptions `type:"structure"`
}

// String returns the string representation
func (s OnDemandProvisioningSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnDemandProvisioningSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnDemandProvisioningSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OnDemandProvisioningSpecification"}
	if s.AllocationStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("AllocationStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationStrategy sets the AllocationStrategy field's value.
func (s *OnDemandProvisioningSpecification) SetAllocationStrategy(v string) *OnDemandProvisioningSpecification {
	s.AllocationStrategy = &v
	return s
}

// SetCapacityReservationOptions sets the CapacityReservationOptions field's value.
func (s *OnDemandProvisioningSpecification) SetCapacityReservationOptions(v *OnDemandCapacityReservationOptions) *OnDemandProvisioningSpecification {
	s.CapacityReservationOptions = v
	return s
}

// Placement group configuration for an Amazon EMR cluster. The configuration
// specifies the placement strategy that can be applied to instance roles during
// cluster creation.
//
// To use this configuration, consider attaching managed policy AmazonElasticMapReducePlacementGroupPolicy
// to the EMR role.
type PlacementGroupConfig struct {
	_ struct{} `type:"structure"`

	// Role of the instance in the cluster.
	//
	// Starting with Amazon EMR version 5.23.0, the only supported instance role
	// is MASTER.
	//
	// InstanceRole is a required field
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// EC2 Placement Group strategy associated with instance role.
	//
	// Starting with Amazon EMR version 5.23.0, the only supported placement strategy
	// is SPREAD for the MASTER instance role.
	PlacementStrategy *string `type:"string" enum:"PlacementGroupStrategy"`
}

// String returns the string representation
func (s PlacementGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementGroupConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlacementGroupConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlacementGroupConfig"}
	if s.InstanceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceRole"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *PlacementGroupConfig) SetInstanceRole(v string) *PlacementGroupConfig {
	s.InstanceRole = &v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *PlacementGroupConfig) SetPlacementStrategy(v string) *PlacementGroupConfig {
	s.PlacementStrategy = &v
	return s
}

// The Amazon EC2 Availability Zone configuration of the cluster (job flow).
type PlacementType struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 Availability Zone for the cluster. AvailabilityZone is used
	// for uniform instance groups, while AvailabilityZones (plural) is used for
	// instance fleets.
	AvailabilityZone *string `type:"string"`

	// When multiple Availability Zones are specified, Amazon EMR evaluates them
	// and launches instances in the optimal Availability Zone. AvailabilityZones
	// is used for instance fleets, while AvailabilityZone (singular) is used for
	// uniform instance groups.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	AvailabilityZones []*string `type:"list"`
}

// String returns the string representation
func (s PlacementType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementType) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *PlacementType) SetAvailabilityZone(v string) *PlacementType {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *PlacementType) SetAvailabilityZones(v []*string) *PlacementType {
	s.AvailabilityZones = v
	return s
}

// A list of port ranges that are permitted to allow inbound traffic from all
// public IP addresses. To specify a single port, use the same value for MinRange
// and MaxRange.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The smallest port number in a specified range of port numbers.
	MaxRange *int64 `type:"integer"`

	// The smallest port number in a specified range of port numbers.
	//
	// MinRange is a required field
	MinRange *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortRange"}
	if s.MaxRange != nil && *s.MaxRange < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRange", -1))
	}
	if s.MinRange == nil {
		invalidParams.Add(request.NewErrParamRequired("MinRange"))
	}
	if s.MinRange != nil && *s.MinRange < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MinRange", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxRange sets the MaxRange field's value.
func (s *PortRange) SetMaxRange(v int64) *PortRange {
	s.MaxRange = &v
	return s
}

// SetMinRange sets the MinRange field's value.
func (s *PortRange) SetMinRange(v int64) *PortRange {
	s.MinRange = &v
	return s
}

type PutAutoScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the definition of the automatic scaling policy.
	//
	// AutoScalingPolicy is a required field
	AutoScalingPolicy *AutoScalingPolicy `type:"structure" required:"true"`

	// Specifies the ID of a cluster. The instance group to which the automatic
	// scaling policy is applied is within this cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// Specifies the ID of the instance group to which the automatic scaling policy
	// is applied.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAutoScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAutoScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAutoScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAutoScalingPolicyInput"}
	if s.AutoScalingPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingPolicy"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.InstanceGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroupId"))
	}
	if s.AutoScalingPolicy != nil {
		if err := s.AutoScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingPolicy sets the AutoScalingPolicy field's value.
func (s *PutAutoScalingPolicyInput) SetAutoScalingPolicy(v *AutoScalingPolicy) *PutAutoScalingPolicyInput {
	s.AutoScalingPolicy = v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *PutAutoScalingPolicyInput) SetClusterId(v string) *PutAutoScalingPolicyInput {
	s.ClusterId = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *PutAutoScalingPolicyInput) SetInstanceGroupId(v string) *PutAutoScalingPolicyInput {
	s.InstanceGroupId = &v
	return s
}

type PutAutoScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The automatic scaling policy definition.
	AutoScalingPolicy *AutoScalingPolicyDescription `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// Specifies the ID of a cluster. The instance group to which the automatic
	// scaling policy is applied is within this cluster.
	ClusterId *string `type:"string"`

	// Specifies the ID of the instance group to which the scaling policy is applied.
	InstanceGroupId *string `type:"string"`
}

// String returns the string representation
func (s PutAutoScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAutoScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetAutoScalingPolicy sets the AutoScalingPolicy field's value.
func (s *PutAutoScalingPolicyOutput) SetAutoScalingPolicy(v *AutoScalingPolicyDescription) *PutAutoScalingPolicyOutput {
	s.AutoScalingPolicy = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *PutAutoScalingPolicyOutput) SetClusterArn(v string) *PutAutoScalingPolicyOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *PutAutoScalingPolicyOutput) SetClusterId(v string) *PutAutoScalingPolicyOutput {
	s.ClusterId = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *PutAutoScalingPolicyOutput) SetInstanceGroupId(v string) *PutAutoScalingPolicyOutput {
	s.InstanceGroupId = &v
	return s
}

type PutBlockPublicAccessConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A configuration for Amazon EMR block public access. The configuration applies
	// to all clusters created in your account for the current Region. The configuration
	// specifies whether block public access is enabled. If block public access
	// is enabled, security groups associated with the cluster cannot have rules
	// that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port
	// is specified as an exception using PermittedPublicSecurityGroupRuleRanges
	// in the BlockPublicAccessConfiguration. By default, Port 22 (SSH) is an exception,
	// and public access is allowed on this port. You can change this by updating
	// BlockPublicSecurityGroupRules to remove the exception.
	//
	// For accounts that created clusters in a Region before November 25, 2019,
	// block public access is disabled by default in that Region. To use this feature,
	// you must manually enable and configure it. For accounts that did not create
	// an EMR cluster in a Region before this date, block public access is enabled
	// by default in that Region.
	//
	// BlockPublicAccessConfiguration is a required field
	BlockPublicAccessConfiguration *BlockPublicAccessConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBlockPublicAccessConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBlockPublicAccessConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBlockPublicAccessConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBlockPublicAccessConfigurationInput"}
	if s.BlockPublicAccessConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("BlockPublicAccessConfiguration"))
	}
	if s.BlockPublicAccessConfiguration != nil {
		if err := s.BlockPublicAccessConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BlockPublicAccessConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockPublicAccessConfiguration sets the BlockPublicAccessConfiguration field's value.
func (s *PutBlockPublicAccessConfigurationInput) SetBlockPublicAccessConfiguration(v *BlockPublicAccessConfiguration) *PutBlockPublicAccessConfigurationInput {
	s.BlockPublicAccessConfiguration = v
	return s
}

type PutBlockPublicAccessConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBlockPublicAccessConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBlockPublicAccessConfigurationOutput) GoString() string {
	return s.String()
}

type PutManagedScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of an EMR cluster where the managed scaling policy is attached.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// Specifies the constraints for the managed scaling policy.
	//
	// ManagedScalingPolicy is a required field
	ManagedScalingPolicy *ManagedScalingPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutManagedScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutManagedScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutManagedScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutManagedScalingPolicyInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ManagedScalingPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedScalingPolicy"))
	}
	if s.ManagedScalingPolicy != nil {
		if err := s.ManagedScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("ManagedScalingPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *PutManagedScalingPolicyInput) SetClusterId(v string) *PutManagedScalingPolicyInput {
	s.ClusterId = &v
	return s
}

// SetManagedScalingPolicy sets the ManagedScalingPolicy field's value.
func (s *PutManagedScalingPolicyInput) SetManagedScalingPolicy(v *ManagedScalingPolicy) *PutManagedScalingPolicyInput {
	s.ManagedScalingPolicy = v
	return s
}

type PutManagedScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutManagedScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutManagedScalingPolicyOutput) GoString() string {
	return s.String()
}

type RemoveAutoScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of a cluster. The instance group to which the automatic
	// scaling policy is applied is within this cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// Specifies the ID of the instance group to which the scaling policy is applied.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAutoScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAutoScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAutoScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAutoScalingPolicyInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.InstanceGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *RemoveAutoScalingPolicyInput) SetClusterId(v string) *RemoveAutoScalingPolicyInput {
	s.ClusterId = &v
	return s
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *RemoveAutoScalingPolicyInput) SetInstanceGroupId(v string) *RemoveAutoScalingPolicyInput {
	s.InstanceGroupId = &v
	return s
}

type RemoveAutoScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveAutoScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAutoScalingPolicyOutput) GoString() string {
	return s.String()
}

type RemoveManagedScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the cluster from which the managed scaling policy will
	// be removed.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveManagedScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveManagedScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveManagedScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveManagedScalingPolicyInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *RemoveManagedScalingPolicyInput) SetClusterId(v string) *RemoveManagedScalingPolicyInput {
	s.ClusterId = &v
	return s
}

type RemoveManagedScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveManagedScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveManagedScalingPolicyOutput) GoString() string {
	return s.String()
}

// This input identifies a cluster and a list of tags to remove.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EMR resource identifier from which tags will be removed. This
	// value must be a cluster identifier.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// A list of tag keys to remove from a resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveTagsInput) SetResourceId(v string) *RemoveTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

// This output indicates the result of removing tags from a resource.
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Input to the RunJobFlow operation.
type RunJobFlowInput struct {
	_ struct{} `type:"structure"`

	// A JSON string for selecting additional features.
	AdditionalInfo *string `type:"string"`

	// Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases
	// 4.0 and later, ReleaseLabel is used. To specify a custom AMI, use CustomAmiID.
	AmiVersion *string `type:"string"`

	// Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of
	// applications for Amazon EMR to install and configure when launching the cluster.
	// For a list of applications available for each Amazon EMR release version,
	// see the Amazon EMR Release Guide (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/).
	Applications []*Application `type:"list"`

	// An IAM role for automatic scaling policies. The default role is EMR_AutoScaling_DefaultRole.
	// The IAM role provides permissions that the automatic scaling feature requires
	// to launch and terminate EC2 instances in an instance group.
	AutoScalingRole *string `type:"string"`

	// A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
	BootstrapActions []*BootstrapActionConfig `type:"list"`

	// For Amazon EMR releases 4.0 and later. The list of configurations supplied
	// for the EMR cluster you are creating.
	Configurations []*Configuration `type:"list"`

	// Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
	// Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when
	// it launches cluster EC2 instances. For more information about custom AMIs
	// in Amazon EMR, see Using a Custom AMI (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html)
	// in the Amazon EMR Management Guide. If omitted, the cluster uses the base
	// Linux AMI for the ReleaseLabel specified. For Amazon EMR versions 2.x and
	// 3.x, use AmiVersion instead.
	//
	// For information about creating a custom AMI, see Creating an Amazon EBS-Backed
	// Linux AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Linux Instances. For information
	// about finding an AMI ID, see Finding a Linux AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html).
	CustomAmiId *string `type:"string"`

	// The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that
	// is used for each EC2 instance. Available in Amazon EMR version 4.x and later.
	EbsRootVolumeSize *int64 `type:"integer"`

	// A specification of the number and type of Amazon EC2 instances.
	//
	// Instances is a required field
	Instances *JobFlowInstancesConfig `type:"structure" required:"true"`

	// Also called instance profile and EC2 role. An IAM role for an EMR cluster.
	// The EC2 instances of the cluster assume this role. The default role is EMR_EC2_DefaultRole.
	// In order to use the default role, you must have already created it using
	// the CLI or console.
	JobFlowRole *string `type:"string"`

	// Attributes for Kerberos configuration when Kerberos authentication is enabled
	// using a security configuration. For more information see Use Kerberos Authentication
	// (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
	// in the Amazon EMR Management Guide.
	KerberosAttributes *KerberosAttributes `type:"structure"`

	// The AWS KMS customer master key (CMK) used for encrypting log files. If a
	// value is not provided, the logs remain encrypted by AES-256. This attribute
	// is only available with Amazon EMR version 5.30.0 and later, excluding Amazon
	// EMR 6.0.0.
	LogEncryptionKmsKeyId *string `type:"string"`

	// The location in Amazon S3 to write the log files of the job flow. If a value
	// is not provided, logs are not created.
	LogUri *string `type:"string"`

	// The specified managed scaling policy for an Amazon EMR cluster.
	ManagedScalingPolicy *ManagedScalingPolicy `type:"structure"`

	// The name of the job flow.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	//
	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use with the job
	// flow that accepts a user argument list. EMR accepts and forwards the argument
	// list to the corresponding installation script as bootstrap action arguments.
	// For more information, see "Launch a Job Flow on the MapR Distribution for
	// Hadoop" in the Amazon EMR Developer Guide (https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf).
	// Supported values are:
	//
	//    * "mapr-m3" - launch the cluster using MapR M3 Edition.
	//
	//    * "mapr-m5" - launch the cluster using MapR M5 Edition.
	//
	//    * "mapr" with the user arguments specifying "--edition,m3" or "--edition,m5"
	//    - launch the job flow using MapR M3 or M5 Edition respectively.
	//
	//    * "mapr-m7" - launch the cluster using MapR M7 Edition.
	//
	//    * "hunk" - launch the cluster with the Hunk Big Data Analytics Platform.
	//
	//    * "hue"- launch the cluster with Hue installed.
	//
	//    * "spark" - launch the cluster with Apache Spark installed.
	//
	//    * "ganglia" - launch the cluster with the Ganglia Monitoring System installed.
	NewSupportedProducts []*SupportedProductConfig `type:"list"`

	// The specified placement group configuration for an Amazon EMR cluster.
	PlacementGroupConfigs []*PlacementGroupConfig `type:"list"`

	// The Amazon EMR release label, which determines the version of open-source
	// application packages installed on the cluster. Release labels are in the
	// form emr-x.x.x, where x.x.x is an Amazon EMR release version such as emr-5.14.0.
	// For more information about Amazon EMR release versions and included application
	// versions and features, see https://docs.aws.amazon.com/emr/latest/ReleaseGuide/
	// (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/). The release label
	// applies only to Amazon EMR releases version 4.0 and later. Earlier versions
	// use AmiVersion.
	ReleaseLabel *string `type:"string"`

	// Applies only when CustomAmiID is used. Specifies which updates from the Amazon
	// Linux AMI package repositories to apply automatically when the instance boots
	// using the AMI. If omitted, the default is SECURITY, which indicates that
	// only security updates are applied. If NONE is specified, no updates are applied,
	// and all updates must be applied manually.
	RepoUpgradeOnBoot *string `type:"string" enum:"RepoUpgradeOnBoot"`

	// Specifies the way that individual Amazon EC2 instances terminate when an
	// automatic scale-in activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
	// indicates that Amazon EMR terminates nodes at the instance-hour boundary,
	// regardless of when the request to terminate the instance was submitted. This
	// option is only available with Amazon EMR 5.1.0 and later and is the default
	// for clusters created using that version. TERMINATE_AT_TASK_COMPLETION indicates
	// that Amazon EMR adds nodes to a deny list and drains tasks from nodes before
	// terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
	// With either behavior, Amazon EMR removes the least active nodes first and
	// blocks instance termination if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION
	// available only in Amazon EMR version 4.1.0 and later, and is the default
	// for versions of Amazon EMR earlier than 5.1.0.
	ScaleDownBehavior *string `type:"string" enum:"ScaleDownBehavior"`

	// The name of a security configuration to apply to the cluster.
	SecurityConfiguration *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// Specifies the number of steps that can be executed concurrently. The default
	// value is 1. The maximum value is 256.
	StepConcurrencyLevel *int64 `type:"integer"`

	// A list of steps to run.
	Steps []*StepConfig `type:"list"`

	//
	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use. For more information,
	// see the Amazon EMR Developer Guide (https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf).
	// Currently supported values are:
	//
	//    * "mapr-m3" - launch the job flow using MapR M3 Edition.
	//
	//    * "mapr-m5" - launch the job flow using MapR M5 Edition.
	SupportedProducts []*string `type:"list"`

	// A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
	Tags []*Tag `type:"list"`

	// A value of true indicates that all IAM users in the AWS account can perform
	// cluster actions if they have the proper IAM policy permissions. This is the
	// default. A value of false indicates that only the IAM user who created the
	// cluster can perform actions.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s RunJobFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunJobFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunJobFlowInput"}
	if s.Instances == nil {
		invalidParams.Add(request.NewErrParamRequired("Instances"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.BootstrapActions != nil {
		for i, v := range s.BootstrapActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BootstrapActions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Instances != nil {
		if err := s.Instances.Validate(); err != nil {
			invalidParams.AddNested("Instances", err.(request.ErrInvalidParams))
		}
	}
	if s.KerberosAttributes != nil {
		if err := s.KerberosAttributes.Validate(); err != nil {
			invalidParams.AddNested("KerberosAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.ManagedScalingPolicy != nil {
		if err := s.ManagedScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("ManagedScalingPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.PlacementGroupConfigs != nil {
		for i, v := range s.PlacementGroupConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlacementGroupConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Steps != nil {
		for i, v := range s.Steps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Steps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *RunJobFlowInput) SetAdditionalInfo(v string) *RunJobFlowInput {
	s.AdditionalInfo = &v
	return s
}

// SetAmiVersion sets the AmiVersion field's value.
func (s *RunJobFlowInput) SetAmiVersion(v string) *RunJobFlowInput {
	s.AmiVersion = &v
	return s
}

// SetApplications sets the Applications field's value.
func (s *RunJobFlowInput) SetApplications(v []*Application) *RunJobFlowInput {
	s.Applications = v
	return s
}

// SetAutoScalingRole sets the AutoScalingRole field's value.
func (s *RunJobFlowInput) SetAutoScalingRole(v string) *RunJobFlowInput {
	s.AutoScalingRole = &v
	return s
}

// SetBootstrapActions sets the BootstrapActions field's value.
func (s *RunJobFlowInput) SetBootstrapActions(v []*BootstrapActionConfig) *RunJobFlowInput {
	s.BootstrapActions = v
	return s
}

// SetConfigurations sets the Configurations field's value.
func (s *RunJobFlowInput) SetConfigurations(v []*Configuration) *RunJobFlowInput {
	s.Configurations = v
	return s
}

// SetCustomAmiId sets the CustomAmiId field's value.
func (s *RunJobFlowInput) SetCustomAmiId(v string) *RunJobFlowInput {
	s.CustomAmiId = &v
	return s
}

// SetEbsRootVolumeSize sets the EbsRootVolumeSize field's value.
func (s *RunJobFlowInput) SetEbsRootVolumeSize(v int64) *RunJobFlowInput {
	s.EbsRootVolumeSize = &v
	return s
}

// SetInstances sets the Instances field's value.
func (s *RunJobFlowInput) SetInstances(v *JobFlowInstancesConfig) *RunJobFlowInput {
	s.Instances = v
	return s
}

// SetJobFlowRole sets the JobFlowRole field's value.
func (s *RunJobFlowInput) SetJobFlowRole(v string) *RunJobFlowInput {
	s.JobFlowRole = &v
	return s
}

// SetKerberosAttributes sets the KerberosAttributes field's value.
func (s *RunJobFlowInput) SetKerberosAttributes(v *KerberosAttributes) *RunJobFlowInput {
	s.KerberosAttributes = v
	return s
}

// SetLogEncryptionKmsKeyId sets the LogEncryptionKmsKeyId field's value.
func (s *RunJobFlowInput) SetLogEncryptionKmsKeyId(v string) *RunJobFlowInput {
	s.LogEncryptionKmsKeyId = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *RunJobFlowInput) SetLogUri(v string) *RunJobFlowInput {
	s.LogUri = &v
	return s
}

// SetManagedScalingPolicy sets the ManagedScalingPolicy field's value.
func (s *RunJobFlowInput) SetManagedScalingPolicy(v *ManagedScalingPolicy) *RunJobFlowInput {
	s.ManagedScalingPolicy = v
	return s
}

// SetName sets the Name field's value.
func (s *RunJobFlowInput) SetName(v string) *RunJobFlowInput {
	s.Name = &v
	return s
}

// SetNewSupportedProducts sets the NewSupportedProducts field's value.
func (s *RunJobFlowInput) SetNewSupportedProducts(v []*SupportedProductConfig) *RunJobFlowInput {
	s.NewSupportedProducts = v
	return s
}

// SetPlacementGroupConfigs sets the PlacementGroupConfigs field's value.
func (s *RunJobFlowInput) SetPlacementGroupConfigs(v []*PlacementGroupConfig) *RunJobFlowInput {
	s.PlacementGroupConfigs = v
	return s
}

// SetReleaseLabel sets the ReleaseLabel field's value.
func (s *RunJobFlowInput) SetReleaseLabel(v string) *RunJobFlowInput {
	s.ReleaseLabel = &v
	return s
}

// SetRepoUpgradeOnBoot sets the RepoUpgradeOnBoot field's value.
func (s *RunJobFlowInput) SetRepoUpgradeOnBoot(v string) *RunJobFlowInput {
	s.RepoUpgradeOnBoot = &v
	return s
}

// SetScaleDownBehavior sets the ScaleDownBehavior field's value.
func (s *RunJobFlowInput) SetScaleDownBehavior(v string) *RunJobFlowInput {
	s.ScaleDownBehavior = &v
	return s
}

// SetSecurityConfiguration sets the SecurityConfiguration field's value.
func (s *RunJobFlowInput) SetSecurityConfiguration(v string) *RunJobFlowInput {
	s.SecurityConfiguration = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *RunJobFlowInput) SetServiceRole(v string) *RunJobFlowInput {
	s.ServiceRole = &v
	return s
}

// SetStepConcurrencyLevel sets the StepConcurrencyLevel field's value.
func (s *RunJobFlowInput) SetStepConcurrencyLevel(v int64) *RunJobFlowInput {
	s.StepConcurrencyLevel = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *RunJobFlowInput) SetSteps(v []*StepConfig) *RunJobFlowInput {
	s.Steps = v
	return s
}

// SetSupportedProducts sets the SupportedProducts field's value.
func (s *RunJobFlowInput) SetSupportedProducts(v []*string) *RunJobFlowInput {
	s.SupportedProducts = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RunJobFlowInput) SetTags(v []*Tag) *RunJobFlowInput {
	s.Tags = v
	return s
}

// SetVisibleToAllUsers sets the VisibleToAllUsers field's value.
func (s *RunJobFlowInput) SetVisibleToAllUsers(v bool) *RunJobFlowInput {
	s.VisibleToAllUsers = &v
	return s
}

// The result of the RunJobFlow operation.
type RunJobFlowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// A unique identifier for the job flow.
	JobFlowId *string `type:"string"`
}

// String returns the string representation
func (s RunJobFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *RunJobFlowOutput) SetClusterArn(v string) *RunJobFlowOutput {
	s.ClusterArn = &v
	return s
}

// SetJobFlowId sets the JobFlowId field's value.
func (s *RunJobFlowOutput) SetJobFlowId(v string) *RunJobFlowOutput {
	s.JobFlowId = &v
	return s
}

// The type of adjustment the automatic scaling activity makes when triggered,
// and the periodicity of the adjustment.
type ScalingAction struct {
	_ struct{} `type:"structure"`

	// Not available for instance groups. Instance groups use the market type specified
	// for the group.
	Market *string `type:"string" enum:"MarketType"`

	// The type of adjustment the automatic scaling activity makes when triggered,
	// and the periodicity of the adjustment.
	//
	// SimpleScalingPolicyConfiguration is a required field
	SimpleScalingPolicyConfiguration *SimpleScalingPolicyConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingAction"}
	if s.SimpleScalingPolicyConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SimpleScalingPolicyConfiguration"))
	}
	if s.SimpleScalingPolicyConfiguration != nil {
		if err := s.SimpleScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SimpleScalingPolicyConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarket sets the Market field's value.
func (s *ScalingAction) SetMarket(v string) *ScalingAction {
	s.Market = &v
	return s
}

// SetSimpleScalingPolicyConfiguration sets the SimpleScalingPolicyConfiguration field's value.
func (s *ScalingAction) SetSimpleScalingPolicyConfiguration(v *SimpleScalingPolicyConfiguration) *ScalingAction {
	s.SimpleScalingPolicyConfiguration = v
	return s
}

// The upper and lower EC2 instance limits for an automatic scaling policy.
// Automatic scaling activities triggered by automatic scaling rules will not
// cause an instance group to grow above or below these limits.
type ScalingConstraints struct {
	_ struct{} `type:"structure"`

	// The upper boundary of EC2 instances in an instance group beyond which scaling
	// activities are not allowed to grow. Scale-out activities will not add instances
	// beyond this boundary.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The lower boundary of EC2 instances in an instance group below which scaling
	// activities are not allowed to shrink. Scale-in activities will not terminate
	// instances below this boundary.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ScalingConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingConstraints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingConstraints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingConstraints"}
	if s.MaxCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxCapacity"))
	}
	if s.MinCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MinCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalingConstraints) SetMaxCapacity(v int64) *ScalingConstraints {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalingConstraints) SetMinCapacity(v int64) *ScalingConstraints {
	s.MinCapacity = &v
	return s
}

// A scale-in or scale-out rule that defines scaling activity, including the
// CloudWatch metric alarm that triggers activity, how EC2 instances are added
// or removed, and the periodicity of adjustments. The automatic scaling policy
// for an instance group can comprise one or more automatic scaling rules.
type ScalingRule struct {
	_ struct{} `type:"structure"`

	// The conditions that trigger an automatic scaling activity.
	//
	// Action is a required field
	Action *ScalingAction `type:"structure" required:"true"`

	// A friendly, more verbose description of the automatic scaling rule.
	Description *string `type:"string"`

	// The name used to identify an automatic scaling rule. Rule names must be unique
	// within a scaling policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The CloudWatch alarm definition that determines when automatic scaling activity
	// is triggered.
	//
	// Trigger is a required field
	Trigger *ScalingTrigger `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingRule"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Trigger == nil {
		invalidParams.Add(request.NewErrParamRequired("Trigger"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.Trigger != nil {
		if err := s.Trigger.Validate(); err != nil {
			invalidParams.AddNested("Trigger", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ScalingRule) SetAction(v *ScalingAction) *ScalingRule {
	s.Action = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ScalingRule) SetDescription(v string) *ScalingRule {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScalingRule) SetName(v string) *ScalingRule {
	s.Name = &v
	return s
}

// SetTrigger sets the Trigger field's value.
func (s *ScalingRule) SetTrigger(v *ScalingTrigger) *ScalingRule {
	s.Trigger = v
	return s
}

// The conditions that trigger an automatic scaling activity.
type ScalingTrigger struct {
	_ struct{} `type:"structure"`

	// The definition of a CloudWatch metric alarm. When the defined alarm conditions
	// are met along with other trigger parameters, scaling activity begins.
	//
	// CloudWatchAlarmDefinition is a required field
	CloudWatchAlarmDefinition *CloudWatchAlarmDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingTrigger"}
	if s.CloudWatchAlarmDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchAlarmDefinition"))
	}
	if s.CloudWatchAlarmDefinition != nil {
		if err := s.CloudWatchAlarmDefinition.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchAlarmDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchAlarmDefinition sets the CloudWatchAlarmDefinition field's value.
func (s *ScalingTrigger) SetCloudWatchAlarmDefinition(v *CloudWatchAlarmDefinition) *ScalingTrigger {
	s.CloudWatchAlarmDefinition = v
	return s
}

// Configuration of the script to run during a bootstrap action.
type ScriptBootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	// A list of command line arguments to pass to the bootstrap action script.
	Args []*string `type:"list"`

	// Location of the script to run during a bootstrap action. Can be either a
	// location in Amazon S3 or on a local file system.
	//
	// Path is a required field
	Path *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ScriptBootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScriptBootstrapActionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScriptBootstrapActionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScriptBootstrapActionConfig"}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *ScriptBootstrapActionConfig) SetArgs(v []*string) *ScriptBootstrapActionConfig {
	s.Args = v
	return s
}

// SetPath sets the Path field's value.
func (s *ScriptBootstrapActionConfig) SetPath(v string) *ScriptBootstrapActionConfig {
	s.Path = &v
	return s
}

// The creation date and time, and name, of a security configuration.
type SecurityConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The name of the security configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityConfigurationSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *SecurityConfigurationSummary) SetCreationDateTime(v time.Time) *SecurityConfigurationSummary {
	s.CreationDateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecurityConfigurationSummary) SetName(v string) *SecurityConfigurationSummary {
	s.Name = &v
	return s
}

// Details for an Amazon EMR Studio session mapping including creation time,
// user or group ID, Studio ID, and so on.
type SessionMappingDetail struct {
	_ struct{} `type:"structure"`

	// The time the session mapping was created.
	CreationTime *time.Time `type:"timestamp"`

	// The globally unique identifier (GUID) of the user or group.
	IdentityId *string `type:"string"`

	// The name of the user or group. For more information, see UserName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference.
	IdentityName *string `type:"string"`

	// Specifies whether the identity mapped to the Amazon EMR Studio is a user
	// or a group.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The time the session mapping was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the session policy associated with the
	// user or group.
	SessionPolicyArn *string `type:"string"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`
}

// String returns the string representation
func (s SessionMappingDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionMappingDetail) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *SessionMappingDetail) SetCreationTime(v time.Time) *SessionMappingDetail {
	s.CreationTime = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *SessionMappingDetail) SetIdentityId(v string) *SessionMappingDetail {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *SessionMappingDetail) SetIdentityName(v string) *SessionMappingDetail {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *SessionMappingDetail) SetIdentityType(v string) *SessionMappingDetail {
	s.IdentityType = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *SessionMappingDetail) SetLastModifiedTime(v time.Time) *SessionMappingDetail {
	s.LastModifiedTime = &v
	return s
}

// SetSessionPolicyArn sets the SessionPolicyArn field's value.
func (s *SessionMappingDetail) SetSessionPolicyArn(v string) *SessionMappingDetail {
	s.SessionPolicyArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *SessionMappingDetail) SetStudioId(v string) *SessionMappingDetail {
	s.StudioId = &v
	return s
}

// Details for an Amazon EMR Studio session mapping. The details do not include
// the time the session mapping was last modified.
type SessionMappingSummary struct {
	_ struct{} `type:"structure"`

	// The time the session mapping was created.
	CreationTime *time.Time `type:"timestamp"`

	// The globally unique identifier (GUID) of the user or group from the AWS SSO
	// Identity Store.
	IdentityId *string `type:"string"`

	// The name of the user or group. For more information, see UserName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference.
	IdentityName *string `type:"string"`

	// Specifies whether the identity mapped to the Amazon EMR Studio is a user
	// or a group.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The Amazon Resource Name (ARN) of the session policy associated with the
	// user or group.
	SessionPolicyArn *string `type:"string"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`
}

// String returns the string representation
func (s SessionMappingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SessionMappingSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *SessionMappingSummary) SetCreationTime(v time.Time) *SessionMappingSummary {
	s.CreationTime = &v
	return s
}

// SetIdentityId sets the IdentityId field's value.
func (s *SessionMappingSummary) SetIdentityId(v string) *SessionMappingSummary {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *SessionMappingSummary) SetIdentityName(v string) *SessionMappingSummary {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *SessionMappingSummary) SetIdentityType(v string) *SessionMappingSummary {
	s.IdentityType = &v
	return s
}

// SetSessionPolicyArn sets the SessionPolicyArn field's value.
func (s *SessionMappingSummary) SetSessionPolicyArn(v string) *SessionMappingSummary {
	s.SessionPolicyArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *SessionMappingSummary) SetStudioId(v string) *SessionMappingSummary {
	s.StudioId = &v
	return s
}

// The input argument to the TerminationProtection operation.
type SetTerminationProtectionInput struct {
	_ struct{} `type:"structure"`

	// A list of strings that uniquely identify the clusters to protect. This identifier
	// is returned by RunJobFlow and can also be obtained from DescribeJobFlows .
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`

	// A Boolean that indicates whether to protect the cluster and prevent the Amazon
	// EC2 instances in the cluster from shutting down due to API calls, user intervention,
	// or job-flow error.
	//
	// TerminationProtected is a required field
	TerminationProtected *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetTerminationProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTerminationProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTerminationProtectionInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}
	if s.TerminationProtected == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminationProtected"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobFlowIds sets the JobFlowIds field's value.
func (s *SetTerminationProtectionInput) SetJobFlowIds(v []*string) *SetTerminationProtectionInput {
	s.JobFlowIds = v
	return s
}

// SetTerminationProtected sets the TerminationProtected field's value.
func (s *SetTerminationProtectionInput) SetTerminationProtected(v bool) *SetTerminationProtectionInput {
	s.TerminationProtected = &v
	return s
}

type SetTerminationProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTerminationProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionOutput) GoString() string {
	return s.String()
}

// The input to the SetVisibleToAllUsers action.
type SetVisibleToAllUsersInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the job flow (cluster).
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`

	// A value of true indicates that all IAM users in the AWS account can perform
	// cluster actions if they have the proper IAM policy permissions. This is the
	// default. A value of false indicates that only the IAM user who created the
	// cluster can perform actions.
	//
	// VisibleToAllUsers is a required field
	VisibleToAllUsers *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetVisibleToAllUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVisibleToAllUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVisibleToAllUsersInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}
	if s.VisibleToAllUsers == nil {
		invalidParams.Add(request.NewErrParamRequired("VisibleToAllUsers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobFlowIds sets the JobFlowIds field's value.
func (s *SetVisibleToAllUsersInput) SetJobFlowIds(v []*string) *SetVisibleToAllUsersInput {
	s.JobFlowIds = v
	return s
}

// SetVisibleToAllUsers sets the VisibleToAllUsers field's value.
func (s *SetVisibleToAllUsersInput) SetVisibleToAllUsers(v bool) *SetVisibleToAllUsersInput {
	s.VisibleToAllUsers = &v
	return s
}

type SetVisibleToAllUsersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetVisibleToAllUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersOutput) GoString() string {
	return s.String()
}

// Policy for customizing shrink operations. Allows configuration of decommissioning
// timeout and targeted instance shrinking.
type ShrinkPolicy struct {
	_ struct{} `type:"structure"`

	// The desired timeout for decommissioning an instance. Overrides the default
	// YARN decommissioning timeout.
	DecommissionTimeout *int64 `type:"integer"`

	// Custom policy for requesting termination protection or termination of specific
	// instances when shrinking an instance group.
	InstanceResizePolicy *InstanceResizePolicy `type:"structure"`
}

// String returns the string representation
func (s ShrinkPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShrinkPolicy) GoString() string {
	return s.String()
}

// SetDecommissionTimeout sets the DecommissionTimeout field's value.
func (s *ShrinkPolicy) SetDecommissionTimeout(v int64) *ShrinkPolicy {
	s.DecommissionTimeout = &v
	return s
}

// SetInstanceResizePolicy sets the InstanceResizePolicy field's value.
func (s *ShrinkPolicy) SetInstanceResizePolicy(v *InstanceResizePolicy) *ShrinkPolicy {
	s.InstanceResizePolicy = v
	return s
}

// An automatic scaling configuration, which describes how the policy adds or
// removes instances, the cooldown period, and the number of EC2 instances that
// will be added each time the CloudWatch metric alarm condition is satisfied.
type SimpleScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// The way in which EC2 instances are added (if ScalingAdjustment is a positive
	// number) or terminated (if ScalingAdjustment is a negative number) each time
	// the scaling activity is triggered. CHANGE_IN_CAPACITY is the default. CHANGE_IN_CAPACITY
	// indicates that the EC2 instance count increments or decrements by ScalingAdjustment,
	// which should be expressed as an integer. PERCENT_CHANGE_IN_CAPACITY indicates
	// the instance count increments or decrements by the percentage specified by
	// ScalingAdjustment, which should be expressed as an integer. For example,
	// 20 indicates an increase in 20% increments of cluster capacity. EXACT_CAPACITY
	// indicates the scaling activity results in an instance group with the number
	// of EC2 instances specified by ScalingAdjustment, which should be expressed
	// as a positive integer.
	AdjustmentType *string `type:"string" enum:"AdjustmentType"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further trigger-related scaling activities can start. The default value
	// is 0.
	CoolDown *int64 `type:"integer"`

	// The amount by which to scale in or scale out, based on the specified AdjustmentType.
	// A positive value adds to the instance group's EC2 instance count while a
	// negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY,
	// the number should only be a positive integer. If AdjustmentType is set to
	// PERCENT_CHANGE_IN_CAPACITY, the value should express the percentage as an
	// integer. For example, -20 indicates a decrease in 20% increments of cluster
	// capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SimpleScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimpleScalingPolicyConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimpleScalingPolicyConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SimpleScalingPolicyConfiguration"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdjustmentType sets the AdjustmentType field's value.
func (s *SimpleScalingPolicyConfiguration) SetAdjustmentType(v string) *SimpleScalingPolicyConfiguration {
	s.AdjustmentType = &v
	return s
}

// SetCoolDown sets the CoolDown field's value.
func (s *SimpleScalingPolicyConfiguration) SetCoolDown(v int64) *SimpleScalingPolicyConfiguration {
	s.CoolDown = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *SimpleScalingPolicyConfiguration) SetScalingAdjustment(v int64) *SimpleScalingPolicyConfiguration {
	s.ScalingAdjustment = &v
	return s
}

// The launch specification for Spot Instances in the instance fleet, which
// determines the defined duration, provisioning timeout behavior, and allocation
// strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. Spot Instance allocation strategy
// is available in Amazon EMR version 5.12.1 and later.
type SpotProvisioningSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the strategy to use in launching Spot Instance fleets. Currently,
	// the only option is capacity-optimized (the default), which launches instances
	// from Spot Instance pools with optimal capacity for the number of instances
	// that are launching.
	AllocationStrategy *string `type:"string" enum:"SpotProvisioningAllocationStrategy"`

	// The defined duration for Spot Instances (also known as Spot blocks) in minutes.
	// When specified, the Spot Instance does not terminate before the defined duration
	// expires, and defined duration pricing for Spot Instances applies. Valid values
	// are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as
	// a Spot Instance receives its instance ID. At the end of the duration, Amazon
	// EC2 marks the Spot Instance for termination and provides a Spot Instance
	// termination notice, which gives the instance a two-minute warning before
	// it terminates.
	BlockDurationMinutes *int64 `type:"integer"`

	// The action to take when TargetSpotCapacity has not been fulfilled when the
	// TimeoutDurationMinutes has expired; that is, when all Spot Instances could
	// not be provisioned within the Spot provisioning timeout. Valid values are
	// TERMINATE_CLUSTER and SWITCH_TO_ON_DEMAND. SWITCH_TO_ON_DEMAND specifies
	// that if no Spot Instances are available, On-Demand Instances should be provisioned
	// to fulfill any remaining Spot capacity.
	//
	// TimeoutAction is a required field
	TimeoutAction *string `type:"string" required:"true" enum:"SpotProvisioningTimeoutAction"`

	// The spot provisioning timeout period in minutes. If Spot Instances are not
	// provisioned within this time period, the TimeOutAction is taken. Minimum
	// value is 5 and maximum value is 1440. The timeout applies only during initial
	// provisioning, when the cluster is first created.
	//
	// TimeoutDurationMinutes is a required field
	TimeoutDurationMinutes *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SpotProvisioningSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpotProvisioningSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpotProvisioningSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpotProvisioningSpecification"}
	if s.TimeoutAction == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutAction"))
	}
	if s.TimeoutDurationMinutes == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutDurationMinutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocationStrategy sets the AllocationStrategy field's value.
func (s *SpotProvisioningSpecification) SetAllocationStrategy(v string) *SpotProvisioningSpecification {
	s.AllocationStrategy = &v
	return s
}

// SetBlockDurationMinutes sets the BlockDurationMinutes field's value.
func (s *SpotProvisioningSpecification) SetBlockDurationMinutes(v int64) *SpotProvisioningSpecification {
	s.BlockDurationMinutes = &v
	return s
}

// SetTimeoutAction sets the TimeoutAction field's value.
func (s *SpotProvisioningSpecification) SetTimeoutAction(v string) *SpotProvisioningSpecification {
	s.TimeoutAction = &v
	return s
}

// SetTimeoutDurationMinutes sets the TimeoutDurationMinutes field's value.
func (s *SpotProvisioningSpecification) SetTimeoutDurationMinutes(v int64) *SpotProvisioningSpecification {
	s.TimeoutDurationMinutes = &v
	return s
}

type StartNotebookExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the EMR Notebook to use for notebook execution.
	//
	// EditorId is a required field
	EditorId *string `type:"string" required:"true"`

	// Specifies the execution engine (cluster) that runs the notebook execution.
	//
	// ExecutionEngine is a required field
	ExecutionEngine *ExecutionEngineConfig `type:"structure" required:"true"`

	// An optional name for the notebook execution.
	NotebookExecutionName *string `type:"string"`

	// The unique identifier of the Amazon EC2 security group to associate with
	// the EMR Notebook for this notebook execution.
	NotebookInstanceSecurityGroupId *string `type:"string"`

	// Input parameters in JSON format passed to the EMR Notebook at runtime for
	// execution.
	NotebookParams *string `type:"string"`

	// The path and file name of the notebook file for this execution, relative
	// to the path specified for the EMR Notebook. For example, if you specify a
	// path of s3://MyBucket/MyNotebooks when you create an EMR Notebook for a notebook
	// with an ID of e-ABCDEFGHIJK1234567890ABCD (the EditorID of this request),
	// and you specify a RelativePath of my_notebook_executions/notebook_execution.ipynb,
	// the location of the file for the notebook execution is s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb.
	//
	// RelativePath is a required field
	RelativePath *string `type:"string" required:"true"`

	// The name or ARN of the IAM role that is used as the service role for Amazon
	// EMR (the EMR role) for the notebook execution.
	//
	// ServiceRole is a required field
	ServiceRole *string `type:"string" required:"true"`

	// A list of tags associated with a notebook execution. Tags are user-defined
	// key-value pairs that consist of a required key string with a maximum of 128
	// characters and an optional value string with a maximum of 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s StartNotebookExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartNotebookExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartNotebookExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartNotebookExecutionInput"}
	if s.EditorId == nil {
		invalidParams.Add(request.NewErrParamRequired("EditorId"))
	}
	if s.ExecutionEngine == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionEngine"))
	}
	if s.RelativePath == nil {
		invalidParams.Add(request.NewErrParamRequired("RelativePath"))
	}
	if s.ServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRole"))
	}
	if s.ExecutionEngine != nil {
		if err := s.ExecutionEngine.Validate(); err != nil {
			invalidParams.AddNested("ExecutionEngine", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEditorId sets the EditorId field's value.
func (s *StartNotebookExecutionInput) SetEditorId(v string) *StartNotebookExecutionInput {
	s.EditorId = &v
	return s
}

// SetExecutionEngine sets the ExecutionEngine field's value.
func (s *StartNotebookExecutionInput) SetExecutionEngine(v *ExecutionEngineConfig) *StartNotebookExecutionInput {
	s.ExecutionEngine = v
	return s
}

// SetNotebookExecutionName sets the NotebookExecutionName field's value.
func (s *StartNotebookExecutionInput) SetNotebookExecutionName(v string) *StartNotebookExecutionInput {
	s.NotebookExecutionName = &v
	return s
}

// SetNotebookInstanceSecurityGroupId sets the NotebookInstanceSecurityGroupId field's value.
func (s *StartNotebookExecutionInput) SetNotebookInstanceSecurityGroupId(v string) *StartNotebookExecutionInput {
	s.NotebookInstanceSecurityGroupId = &v
	return s
}

// SetNotebookParams sets the NotebookParams field's value.
func (s *StartNotebookExecutionInput) SetNotebookParams(v string) *StartNotebookExecutionInput {
	s.NotebookParams = &v
	return s
}

// SetRelativePath sets the RelativePath field's value.
func (s *StartNotebookExecutionInput) SetRelativePath(v string) *StartNotebookExecutionInput {
	s.RelativePath = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *StartNotebookExecutionInput) SetServiceRole(v string) *StartNotebookExecutionInput {
	s.ServiceRole = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartNotebookExecutionInput) SetTags(v []*Tag) *StartNotebookExecutionInput {
	s.Tags = v
	return s
}

type StartNotebookExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the notebook execution.
	NotebookExecutionId *string `type:"string"`
}

// String returns the string representation
func (s StartNotebookExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartNotebookExecutionOutput) GoString() string {
	return s.String()
}

// SetNotebookExecutionId sets the NotebookExecutionId field's value.
func (s *StartNotebookExecutionOutput) SetNotebookExecutionId(v string) *StartNotebookExecutionOutput {
	s.NotebookExecutionId = &v
	return s
}

// This represents a step in a cluster.
type Step struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Step) GoString() string {
	return s.String()
}

// SetActionOnFailure sets the ActionOnFailure field's value.
func (s *Step) SetActionOnFailure(v string) *Step {
	s.ActionOnFailure = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *Step) SetConfig(v *HadoopStepConfig) *Step {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *Step) SetId(v string) *Step {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Step) SetName(v string) *Step {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Step) SetStatus(v *StepStatus) *Step {
	s.Status = v
	return s
}

// Specification of a cluster (job flow) step.
type StepConfig struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The JAR file used for the step.
	//
	// HadoopJarStep is a required field
	HadoopJarStep *HadoopJarStepConfig `type:"structure" required:"true"`

	// The name of the step.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepConfig"}
	if s.HadoopJarStep == nil {
		invalidParams.Add(request.NewErrParamRequired("HadoopJarStep"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.HadoopJarStep != nil {
		if err := s.HadoopJarStep.Validate(); err != nil {
			invalidParams.AddNested("HadoopJarStep", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionOnFailure sets the ActionOnFailure field's value.
func (s *StepConfig) SetActionOnFailure(v string) *StepConfig {
	s.ActionOnFailure = &v
	return s
}

// SetHadoopJarStep sets the HadoopJarStep field's value.
func (s *StepConfig) SetHadoopJarStep(v *HadoopJarStepConfig) *StepConfig {
	s.HadoopJarStep = v
	return s
}

// SetName sets the Name field's value.
func (s *StepConfig) SetName(v string) *StepConfig {
	s.Name = &v
	return s
}

// Combines the execution state and configuration of a step.
type StepDetail struct {
	_ struct{} `type:"structure"`

	// The description of the step status.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *StepExecutionStatusDetail `type:"structure" required:"true"`

	// The step configuration.
	//
	// StepConfig is a required field
	StepConfig *StepConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StepDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepDetail) GoString() string {
	return s.String()
}

// SetExecutionStatusDetail sets the ExecutionStatusDetail field's value.
func (s *StepDetail) SetExecutionStatusDetail(v *StepExecutionStatusDetail) *StepDetail {
	s.ExecutionStatusDetail = v
	return s
}

// SetStepConfig sets the StepConfig field's value.
func (s *StepDetail) SetStepConfig(v *StepConfig) *StepDetail {
	s.StepConfig = v
	return s
}

// The execution state of a step.
type StepExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the step.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The completion date and time of the step.
	EndDateTime *time.Time `type:"timestamp"`

	// A description of the step's current state.
	LastStateChangeReason *string `type:"string"`

	// The start date and time of the step.
	StartDateTime *time.Time `type:"timestamp"`

	// The state of the step.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"StepExecutionState"`
}

// String returns the string representation
func (s StepExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepExecutionStatusDetail) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *StepExecutionStatusDetail) SetCreationDateTime(v time.Time) *StepExecutionStatusDetail {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *StepExecutionStatusDetail) SetEndDateTime(v time.Time) *StepExecutionStatusDetail {
	s.EndDateTime = &v
	return s
}

// SetLastStateChangeReason sets the LastStateChangeReason field's value.
func (s *StepExecutionStatusDetail) SetLastStateChangeReason(v string) *StepExecutionStatusDetail {
	s.LastStateChangeReason = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *StepExecutionStatusDetail) SetStartDateTime(v time.Time) *StepExecutionStatusDetail {
	s.StartDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StepExecutionStatusDetail) SetState(v string) *StepExecutionStatusDetail {
	s.State = &v
	return s
}

// The details of the step state change reason.
type StepStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason. Note: Currently, the service
	// provides no code for the state change.
	Code *string `type:"string" enum:"StepStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s StepStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *StepStateChangeReason) SetCode(v string) *StepStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StepStateChangeReason) SetMessage(v string) *StepStateChangeReason {
	s.Message = &v
	return s
}

// The execution status details of the cluster step.
type StepStatus struct {
	_ struct{} `type:"structure"`

	// The details for the step failure including reason, message, and log file
	// path where the root cause was identified.
	FailureDetails *FailureDetails `type:"structure"`

	// The execution state of the cluster step.
	State *string `type:"string" enum:"StepState"`

	// The reason for the step execution status change.
	StateChangeReason *StepStateChangeReason `type:"structure"`

	// The timeline of the cluster step status over time.
	Timeline *StepTimeline `type:"structure"`
}

// String returns the string representation
func (s StepStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStatus) GoString() string {
	return s.String()
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *StepStatus) SetFailureDetails(v *FailureDetails) *StepStatus {
	s.FailureDetails = v
	return s
}

// SetState sets the State field's value.
func (s *StepStatus) SetState(v string) *StepStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *StepStatus) SetStateChangeReason(v *StepStateChangeReason) *StepStatus {
	s.StateChangeReason = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *StepStatus) SetTimeline(v *StepTimeline) *StepStatus {
	s.Timeline = v
	return s
}

// The summary of the cluster step.
type StepSummary struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s StepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepSummary) GoString() string {
	return s.String()
}

// SetActionOnFailure sets the ActionOnFailure field's value.
func (s *StepSummary) SetActionOnFailure(v string) *StepSummary {
	s.ActionOnFailure = &v
	return s
}

// SetConfig sets the Config field's value.
func (s *StepSummary) SetConfig(v *HadoopStepConfig) *StepSummary {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *StepSummary) SetId(v string) *StepSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *StepSummary) SetName(v string) *StepSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StepSummary) SetStatus(v *StepStatus) *StepSummary {
	s.Status = v
	return s
}

// The timeline of the cluster step lifecycle.
type StepTimeline struct {
	_ struct{} `type:"structure"`

	// The date and time when the cluster step was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster step execution completed or failed.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster step execution started.
	StartDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s StepTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepTimeline) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *StepTimeline) SetCreationDateTime(v time.Time) *StepTimeline {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *StepTimeline) SetEndDateTime(v time.Time) *StepTimeline {
	s.EndDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *StepTimeline) SetStartDateTime(v time.Time) *StepTimeline {
	s.StartDateTime = &v
	return s
}

type StopNotebookExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the notebook execution.
	//
	// NotebookExecutionId is a required field
	NotebookExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopNotebookExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopNotebookExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopNotebookExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopNotebookExecutionInput"}
	if s.NotebookExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("NotebookExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotebookExecutionId sets the NotebookExecutionId field's value.
func (s *StopNotebookExecutionInput) SetNotebookExecutionId(v string) *StopNotebookExecutionInput {
	s.NotebookExecutionId = &v
	return s
}

type StopNotebookExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopNotebookExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopNotebookExecutionOutput) GoString() string {
	return s.String()
}

// Details for an Amazon EMR Studio including ID, creation time, name, and so
// on.
type Studio struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Amazon EMR Studio authenticates users using single
	// sign-on (SSO) or IAM.
	AuthMode *string `type:"string" enum:"AuthMode"`

	// The time the Amazon EMR Studio was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook
	// files.
	DefaultS3Location *string `type:"string"`

	// The detailed description of the Amazon EMR Studio.
	Description *string `type:"string"`

	// The ID of the Engine security group associated with the Amazon EMR Studio.
	// The Engine security group allows inbound network traffic from resources in
	// the Workspace security group.
	EngineSecurityGroupId *string `type:"string"`

	// The name of the Amazon EMR Studio.
	Name *string `type:"string"`

	// The name of the IAM role assumed by the Amazon EMR Studio.
	ServiceRole *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon EMR Studio.
	StudioArn *string `type:"string"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`

	// The list of IDs of the subnets associated with the Amazon EMR Studio.
	SubnetIds []*string `type:"list"`

	// A list of tags associated with the Amazon EMR Studio.
	Tags []*Tag `type:"list"`

	// The unique access URL of the Amazon EMR Studio.
	Url *string `type:"string"`

	// The name of the IAM role assumed by users logged in to the Amazon EMR Studio.
	UserRole *string `type:"string"`

	// The ID of the VPC associated with the Amazon EMR Studio.
	VpcId *string `type:"string"`

	// The ID of the Workspace security group associated with the Amazon EMR Studio.
	// The Workspace security group allows outbound network traffic to resources
	// in the Engine security group and to the internet.
	WorkspaceSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s Studio) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Studio) GoString() string {
	return s.String()
}

// SetAuthMode sets the AuthMode field's value.
func (s *Studio) SetAuthMode(v string) *Studio {
	s.AuthMode = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Studio) SetCreationTime(v time.Time) *Studio {
	s.CreationTime = &v
	return s
}

// SetDefaultS3Location sets the DefaultS3Location field's value.
func (s *Studio) SetDefaultS3Location(v string) *Studio {
	s.DefaultS3Location = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Studio) SetDescription(v string) *Studio {
	s.Description = &v
	return s
}

// SetEngineSecurityGroupId sets the EngineSecurityGroupId field's value.
func (s *Studio) SetEngineSecurityGroupId(v string) *Studio {
	s.EngineSecurityGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Studio) SetName(v string) *Studio {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Studio) SetServiceRole(v string) *Studio {
	s.ServiceRole = &v
	return s
}

// SetStudioArn sets the StudioArn field's value.
func (s *Studio) SetStudioArn(v string) *Studio {
	s.StudioArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *Studio) SetStudioId(v string) *Studio {
	s.StudioId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Studio) SetSubnetIds(v []*string) *Studio {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Studio) SetTags(v []*Tag) *Studio {
	s.Tags = v
	return s
}

// SetUrl sets the Url field's value.
func (s *Studio) SetUrl(v string) *Studio {
	s.Url = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *Studio) SetUserRole(v string) *Studio {
	s.UserRole = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Studio) SetVpcId(v string) *Studio {
	s.VpcId = &v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *Studio) SetWorkspaceSecurityGroupId(v string) *Studio {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// Details for an Amazon EMR Studio, including ID, Name, VPC, and Description.
// The details do not include subnets, IAM roles, security groups, or tags associated
// with the Studio.
type StudioSummary struct {
	_ struct{} `type:"structure"`

	// The time when the Amazon EMR Studio was created.
	CreationTime *time.Time `type:"timestamp"`

	// The detailed description of the Amazon EMR Studio.
	Description *string `type:"string"`

	// The name of the Amazon EMR Studio.
	Name *string `type:"string"`

	// The ID of the Amazon EMR Studio.
	StudioId *string `type:"string"`

	// The unique access URL of the Amazon EMR Studio.
	Url *string `type:"string"`

	// The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon
	// EMR Studio.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s StudioSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StudioSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StudioSummary) SetCreationTime(v time.Time) *StudioSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StudioSummary) SetDescription(v string) *StudioSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *StudioSummary) SetName(v string) *StudioSummary {
	s.Name = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *StudioSummary) SetStudioId(v string) *StudioSummary {
	s.StudioId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *StudioSummary) SetUrl(v string) *StudioSummary {
	s.Url = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *StudioSummary) SetVpcId(v string) *StudioSummary {
	s.VpcId = &v
	return s
}

// The list of supported product configurations that allow user-supplied arguments.
// EMR accepts these arguments and forwards them to the corresponding installation
// script as bootstrap action arguments.
type SupportedProductConfig struct {
	_ struct{} `type:"structure"`

	// The list of user-supplied arguments.
	Args []*string `type:"list"`

	// The name of the product configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SupportedProductConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedProductConfig) GoString() string {
	return s.String()
}

// SetArgs sets the Args field's value.
func (s *SupportedProductConfig) SetArgs(v []*string) *SupportedProductConfig {
	s.Args = v
	return s
}

// SetName sets the Name field's value.
func (s *SupportedProductConfig) SetName(v string) *SupportedProductConfig {
	s.Name = &v
	return s
}

// A key-value pair containing user-defined metadata that you can associate
// with an Amazon EMR resource. Tags make it easier to associate clusters in
// various ways, such as grouping clusters to track your Amazon EMR resource
// allocation costs. For more information, see Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// A user-defined key, which is the minimum required information for a valid
	// tag. For more information, see Tag (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
	Key *string `type:"string"`

	// A user-defined value, which is optional in a tag. For more information, see
	// Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Input to the TerminateJobFlows operation.
type TerminateJobFlowsInput struct {
	_ struct{} `type:"structure"`

	// A list of job flows to be shut down.
	//
	// JobFlowIds is a required field
	JobFlowIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateJobFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateJobFlowsInput"}
	if s.JobFlowIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobFlowIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobFlowIds sets the JobFlowIds field's value.
func (s *TerminateJobFlowsInput) SetJobFlowIds(v []*string) *TerminateJobFlowsInput {
	s.JobFlowIds = v
	return s
}

type TerminateJobFlowsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsOutput) GoString() string {
	return s.String()
}

type UpdateStudioInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location to back up Workspaces and notebook files for the Amazon
	// EMR Studio.
	DefaultS3Location *string `type:"string"`

	// A detailed description to assign to the Amazon EMR Studio.
	Description *string `type:"string"`

	// A descriptive name for the Amazon EMR Studio.
	Name *string `type:"string"`

	// The ID of the Amazon EMR Studio to update.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`

	// A list of subnet IDs to associate with the Amazon EMR Studio. The list can
	// include new subnet IDs, but must also include all of the subnet IDs previously
	// associated with the Studio. The list order does not matter. A Studio can
	// have a maximum of 5 subnets. The subnets must belong to the same VPC as the
	// Studio.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s UpdateStudioInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStudioInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStudioInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStudioInput"}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultS3Location sets the DefaultS3Location field's value.
func (s *UpdateStudioInput) SetDefaultS3Location(v string) *UpdateStudioInput {
	s.DefaultS3Location = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStudioInput) SetDescription(v string) *UpdateStudioInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStudioInput) SetName(v string) *UpdateStudioInput {
	s.Name = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateStudioInput) SetStudioId(v string) *UpdateStudioInput {
	s.StudioId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateStudioInput) SetSubnetIds(v []*string) *UpdateStudioInput {
	s.SubnetIds = v
	return s
}

type UpdateStudioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStudioOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStudioOutput) GoString() string {
	return s.String()
}

type UpdateStudioSessionMappingInput struct {
	_ struct{} `type:"structure"`

	// The globally unique identifier (GUID) of the user or group. For more information,
	// see UserId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
	// and GroupId (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityId *string `type:"string"`

	// The name of the user or group to update. For more information, see UserName
	// (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
	// and DisplayName (https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
	// in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId
	// must be specified.
	IdentityName *string `type:"string"`

	// Specifies whether the identity to update is a user or a group.
	//
	// IdentityType is a required field
	IdentityType *string `type:"string" required:"true" enum:"IdentityType"`

	// The Amazon Resource Name (ARN) of the session policy to associate with the
	// specified user or group.
	//
	// SessionPolicyArn is a required field
	SessionPolicyArn *string `type:"string" required:"true"`

	// The ID of the Amazon EMR Studio.
	//
	// StudioId is a required field
	StudioId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStudioSessionMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStudioSessionMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStudioSessionMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStudioSessionMappingInput"}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.SessionPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionPolicyArn"))
	}
	if s.StudioId == nil {
		invalidParams.Add(request.NewErrParamRequired("StudioId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityId sets the IdentityId field's value.
func (s *UpdateStudioSessionMappingInput) SetIdentityId(v string) *UpdateStudioSessionMappingInput {
	s.IdentityId = &v
	return s
}

// SetIdentityName sets the IdentityName field's value.
func (s *UpdateStudioSessionMappingInput) SetIdentityName(v string) *UpdateStudioSessionMappingInput {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *UpdateStudioSessionMappingInput) SetIdentityType(v string) *UpdateStudioSessionMappingInput {
	s.IdentityType = &v
	return s
}

// SetSessionPolicyArn sets the SessionPolicyArn field's value.
func (s *UpdateStudioSessionMappingInput) SetSessionPolicyArn(v string) *UpdateStudioSessionMappingInput {
	s.SessionPolicyArn = &v
	return s
}

// SetStudioId sets the StudioId field's value.
func (s *UpdateStudioSessionMappingInput) SetStudioId(v string) *UpdateStudioSessionMappingInput {
	s.StudioId = &v
	return s
}

type UpdateStudioSessionMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStudioSessionMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStudioSessionMappingOutput) GoString() string {
	return s.String()
}

// EBS volume specifications such as volume type, IOPS, and size (GiB) that
// will be requested for the EBS volume attached to an EC2 instance in the cluster.
type VolumeSpecification struct {
	_ struct{} `type:"structure"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	Iops *int64 `type:"integer"`

	// The volume size, in gibibytes (GiB). This can be a number from 1 - 1024.
	// If the volume type is EBS-optimized, the minimum value is 10.
	//
	// SizeInGB is a required field
	SizeInGB *int64 `type:"integer" required:"true"`

	// The volume type. Volume types supported are gp2, io1, standard.
	//
	// VolumeType is a required field
	VolumeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VolumeSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VolumeSpecification"}
	if s.SizeInGB == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGB"))
	}
	if s.VolumeType == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIops sets the Iops field's value.
func (s *VolumeSpecification) SetIops(v int64) *VolumeSpecification {
	s.Iops = &v
	return s
}

// SetSizeInGB sets the SizeInGB field's value.
func (s *VolumeSpecification) SetSizeInGB(v int64) *VolumeSpecification {
	s.SizeInGB = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeSpecification) SetVolumeType(v string) *VolumeSpecification {
	s.VolumeType = &v
	return s
}

const (
	// ActionOnFailureTerminateJobFlow is a ActionOnFailure enum value
	ActionOnFailureTerminateJobFlow = "TERMINATE_JOB_FLOW"

	// ActionOnFailureTerminateCluster is a ActionOnFailure enum value
	ActionOnFailureTerminateCluster = "TERMINATE_CLUSTER"

	// ActionOnFailureCancelAndWait is a ActionOnFailure enum value
	ActionOnFailureCancelAndWait = "CANCEL_AND_WAIT"

	// ActionOnFailureContinue is a ActionOnFailure enum value
	ActionOnFailureContinue = "CONTINUE"
)

// ActionOnFailure_Values returns all elements of the ActionOnFailure enum
func ActionOnFailure_Values() []string {
	return []string{
		ActionOnFailureTerminateJobFlow,
		ActionOnFailureTerminateCluster,
		ActionOnFailureCancelAndWait,
		ActionOnFailureContinue,
	}
}

const (
	// AdjustmentTypeChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypeChangeInCapacity = "CHANGE_IN_CAPACITY"

	// AdjustmentTypePercentChangeInCapacity is a AdjustmentType enum value
	AdjustmentTypePercentChangeInCapacity = "PERCENT_CHANGE_IN_CAPACITY"

	// AdjustmentTypeExactCapacity is a AdjustmentType enum value
	AdjustmentTypeExactCapacity = "EXACT_CAPACITY"
)

// AdjustmentType_Values returns all elements of the AdjustmentType enum
func AdjustmentType_Values() []string {
	return []string{
		AdjustmentTypeChangeInCapacity,
		AdjustmentTypePercentChangeInCapacity,
		AdjustmentTypeExactCapacity,
	}
}

const (
	// AuthModeSso is a AuthMode enum value
	AuthModeSso = "SSO"

	// AuthModeIam is a AuthMode enum value
	AuthModeIam = "IAM"
)

// AuthMode_Values returns all elements of the AuthMode enum
func AuthMode_Values() []string {
	return []string{
		AuthModeSso,
		AuthModeIam,
	}
}

const (
	// AutoScalingPolicyStatePending is a AutoScalingPolicyState enum value
	AutoScalingPolicyStatePending = "PENDING"

	// AutoScalingPolicyStateAttaching is a AutoScalingPolicyState enum value
	AutoScalingPolicyStateAttaching = "ATTACHING"

	// AutoScalingPolicyStateAttached is a AutoScalingPolicyState enum value
	AutoScalingPolicyStateAttached = "ATTACHED"

	// AutoScalingPolicyStateDetaching is a AutoScalingPolicyState enum value
	AutoScalingPolicyStateDetaching = "DETACHING"

	// AutoScalingPolicyStateDetached is a AutoScalingPolicyState enum value
	AutoScalingPolicyStateDetached = "DETACHED"

	// AutoScalingPolicyStateFailed is a AutoScalingPolicyState enum value
	AutoScalingPolicyStateFailed = "FAILED"
)

// AutoScalingPolicyState_Values returns all elements of the AutoScalingPolicyState enum
func AutoScalingPolicyState_Values() []string {
	return []string{
		AutoScalingPolicyStatePending,
		AutoScalingPolicyStateAttaching,
		AutoScalingPolicyStateAttached,
		AutoScalingPolicyStateDetaching,
		AutoScalingPolicyStateDetached,
		AutoScalingPolicyStateFailed,
	}
}

const (
	// AutoScalingPolicyStateChangeReasonCodeUserRequest is a AutoScalingPolicyStateChangeReasonCode enum value
	AutoScalingPolicyStateChangeReasonCodeUserRequest = "USER_REQUEST"

	// AutoScalingPolicyStateChangeReasonCodeProvisionFailure is a AutoScalingPolicyStateChangeReasonCode enum value
	AutoScalingPolicyStateChangeReasonCodeProvisionFailure = "PROVISION_FAILURE"

	// AutoScalingPolicyStateChangeReasonCodeCleanupFailure is a AutoScalingPolicyStateChangeReasonCode enum value
	AutoScalingPolicyStateChangeReasonCodeCleanupFailure = "CLEANUP_FAILURE"
)

// AutoScalingPolicyStateChangeReasonCode_Values returns all elements of the AutoScalingPolicyStateChangeReasonCode enum
func AutoScalingPolicyStateChangeReasonCode_Values() []string {
	return []string{
		AutoScalingPolicyStateChangeReasonCodeUserRequest,
		AutoScalingPolicyStateChangeReasonCodeProvisionFailure,
		AutoScalingPolicyStateChangeReasonCodeCleanupFailure,
	}
}

const (
	// CancelStepsRequestStatusSubmitted is a CancelStepsRequestStatus enum value
	CancelStepsRequestStatusSubmitted = "SUBMITTED"

	// CancelStepsRequestStatusFailed is a CancelStepsRequestStatus enum value
	CancelStepsRequestStatusFailed = "FAILED"
)

// CancelStepsRequestStatus_Values returns all elements of the CancelStepsRequestStatus enum
func CancelStepsRequestStatus_Values() []string {
	return []string{
		CancelStepsRequestStatusSubmitted,
		CancelStepsRequestStatusFailed,
	}
}

const (
	// ClusterStateStarting is a ClusterState enum value
	ClusterStateStarting = "STARTING"

	// ClusterStateBootstrapping is a ClusterState enum value
	ClusterStateBootstrapping = "BOOTSTRAPPING"

	// ClusterStateRunning is a ClusterState enum value
	ClusterStateRunning = "RUNNING"

	// ClusterStateWaiting is a ClusterState enum value
	ClusterStateWaiting = "WAITING"

	// ClusterStateTerminating is a ClusterState enum value
	ClusterStateTerminating = "TERMINATING"

	// ClusterStateTerminated is a ClusterState enum value
	ClusterStateTerminated = "TERMINATED"

	// ClusterStateTerminatedWithErrors is a ClusterState enum value
	ClusterStateTerminatedWithErrors = "TERMINATED_WITH_ERRORS"
)

// ClusterState_Values returns all elements of the ClusterState enum
func ClusterState_Values() []string {
	return []string{
		ClusterStateStarting,
		ClusterStateBootstrapping,
		ClusterStateRunning,
		ClusterStateWaiting,
		ClusterStateTerminating,
		ClusterStateTerminated,
		ClusterStateTerminatedWithErrors,
	}
}

const (
	// ClusterStateChangeReasonCodeInternalError is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ClusterStateChangeReasonCodeValidationError is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// ClusterStateChangeReasonCodeInstanceFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// ClusterStateChangeReasonCodeInstanceFleetTimeout is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeInstanceFleetTimeout = "INSTANCE_FLEET_TIMEOUT"

	// ClusterStateChangeReasonCodeBootstrapFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"

	// ClusterStateChangeReasonCodeUserRequest is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeUserRequest = "USER_REQUEST"

	// ClusterStateChangeReasonCodeStepFailure is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeStepFailure = "STEP_FAILURE"

	// ClusterStateChangeReasonCodeAllStepsCompleted is a ClusterStateChangeReasonCode enum value
	ClusterStateChangeReasonCodeAllStepsCompleted = "ALL_STEPS_COMPLETED"
)

// ClusterStateChangeReasonCode_Values returns all elements of the ClusterStateChangeReasonCode enum
func ClusterStateChangeReasonCode_Values() []string {
	return []string{
		ClusterStateChangeReasonCodeInternalError,
		ClusterStateChangeReasonCodeValidationError,
		ClusterStateChangeReasonCodeInstanceFailure,
		ClusterStateChangeReasonCodeInstanceFleetTimeout,
		ClusterStateChangeReasonCodeBootstrapFailure,
		ClusterStateChangeReasonCodeUserRequest,
		ClusterStateChangeReasonCodeStepFailure,
		ClusterStateChangeReasonCodeAllStepsCompleted,
	}
}

const (
	// ComparisonOperatorGreaterThanOrEqual is a ComparisonOperator enum value
	ComparisonOperatorGreaterThanOrEqual = "GREATER_THAN_OR_EQUAL"

	// ComparisonOperatorGreaterThan is a ComparisonOperator enum value
	ComparisonOperatorGreaterThan = "GREATER_THAN"

	// ComparisonOperatorLessThan is a ComparisonOperator enum value
	ComparisonOperatorLessThan = "LESS_THAN"

	// ComparisonOperatorLessThanOrEqual is a ComparisonOperator enum value
	ComparisonOperatorLessThanOrEqual = "LESS_THAN_OR_EQUAL"
)

// ComparisonOperator_Values returns all elements of the ComparisonOperator enum
func ComparisonOperator_Values() []string {
	return []string{
		ComparisonOperatorGreaterThanOrEqual,
		ComparisonOperatorGreaterThan,
		ComparisonOperatorLessThan,
		ComparisonOperatorLessThanOrEqual,
	}
}

const (
	// ComputeLimitsUnitTypeInstanceFleetUnits is a ComputeLimitsUnitType enum value
	ComputeLimitsUnitTypeInstanceFleetUnits = "InstanceFleetUnits"

	// ComputeLimitsUnitTypeInstances is a ComputeLimitsUnitType enum value
	ComputeLimitsUnitTypeInstances = "Instances"

	// ComputeLimitsUnitTypeVcpu is a ComputeLimitsUnitType enum value
	ComputeLimitsUnitTypeVcpu = "VCPU"
)

// ComputeLimitsUnitType_Values returns all elements of the ComputeLimitsUnitType enum
func ComputeLimitsUnitType_Values() []string {
	return []string{
		ComputeLimitsUnitTypeInstanceFleetUnits,
		ComputeLimitsUnitTypeInstances,
		ComputeLimitsUnitTypeVcpu,
	}
}

const (
	// ExecutionEngineTypeEmr is a ExecutionEngineType enum value
	ExecutionEngineTypeEmr = "EMR"
)

// ExecutionEngineType_Values returns all elements of the ExecutionEngineType enum
func ExecutionEngineType_Values() []string {
	return []string{
		ExecutionEngineTypeEmr,
	}
}

const (
	// IdentityTypeUser is a IdentityType enum value
	IdentityTypeUser = "USER"

	// IdentityTypeGroup is a IdentityType enum value
	IdentityTypeGroup = "GROUP"
)

// IdentityType_Values returns all elements of the IdentityType enum
func IdentityType_Values() []string {
	return []string{
		IdentityTypeUser,
		IdentityTypeGroup,
	}
}

const (
	// InstanceCollectionTypeInstanceFleet is a InstanceCollectionType enum value
	InstanceCollectionTypeInstanceFleet = "INSTANCE_FLEET"

	// InstanceCollectionTypeInstanceGroup is a InstanceCollectionType enum value
	InstanceCollectionTypeInstanceGroup = "INSTANCE_GROUP"
)

// InstanceCollectionType_Values returns all elements of the InstanceCollectionType enum
func InstanceCollectionType_Values() []string {
	return []string{
		InstanceCollectionTypeInstanceFleet,
		InstanceCollectionTypeInstanceGroup,
	}
}

const (
	// InstanceFleetStateProvisioning is a InstanceFleetState enum value
	InstanceFleetStateProvisioning = "PROVISIONING"

	// InstanceFleetStateBootstrapping is a InstanceFleetState enum value
	InstanceFleetStateBootstrapping = "BOOTSTRAPPING"

	// InstanceFleetStateRunning is a InstanceFleetState enum value
	InstanceFleetStateRunning = "RUNNING"

	// InstanceFleetStateResizing is a InstanceFleetState enum value
	InstanceFleetStateResizing = "RESIZING"

	// InstanceFleetStateSuspended is a InstanceFleetState enum value
	InstanceFleetStateSuspended = "SUSPENDED"

	// InstanceFleetStateTerminating is a InstanceFleetState enum value
	InstanceFleetStateTerminating = "TERMINATING"

	// InstanceFleetStateTerminated is a InstanceFleetState enum value
	InstanceFleetStateTerminated = "TERMINATED"
)

// InstanceFleetState_Values returns all elements of the InstanceFleetState enum
func InstanceFleetState_Values() []string {
	return []string{
		InstanceFleetStateProvisioning,
		InstanceFleetStateBootstrapping,
		InstanceFleetStateRunning,
		InstanceFleetStateResizing,
		InstanceFleetStateSuspended,
		InstanceFleetStateTerminating,
		InstanceFleetStateTerminated,
	}
}

const (
	// InstanceFleetStateChangeReasonCodeInternalError is a InstanceFleetStateChangeReasonCode enum value
	InstanceFleetStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// InstanceFleetStateChangeReasonCodeValidationError is a InstanceFleetStateChangeReasonCode enum value
	InstanceFleetStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// InstanceFleetStateChangeReasonCodeInstanceFailure is a InstanceFleetStateChangeReasonCode enum value
	InstanceFleetStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// InstanceFleetStateChangeReasonCodeClusterTerminated is a InstanceFleetStateChangeReasonCode enum value
	InstanceFleetStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

// InstanceFleetStateChangeReasonCode_Values returns all elements of the InstanceFleetStateChangeReasonCode enum
func InstanceFleetStateChangeReasonCode_Values() []string {
	return []string{
		InstanceFleetStateChangeReasonCodeInternalError,
		InstanceFleetStateChangeReasonCodeValidationError,
		InstanceFleetStateChangeReasonCodeInstanceFailure,
		InstanceFleetStateChangeReasonCodeClusterTerminated,
	}
}

const (
	// InstanceFleetTypeMaster is a InstanceFleetType enum value
	InstanceFleetTypeMaster = "MASTER"

	// InstanceFleetTypeCore is a InstanceFleetType enum value
	InstanceFleetTypeCore = "CORE"

	// InstanceFleetTypeTask is a InstanceFleetType enum value
	InstanceFleetTypeTask = "TASK"
)

// InstanceFleetType_Values returns all elements of the InstanceFleetType enum
func InstanceFleetType_Values() []string {
	return []string{
		InstanceFleetTypeMaster,
		InstanceFleetTypeCore,
		InstanceFleetTypeTask,
	}
}

const (
	// InstanceGroupStateProvisioning is a InstanceGroupState enum value
	InstanceGroupStateProvisioning = "PROVISIONING"

	// InstanceGroupStateBootstrapping is a InstanceGroupState enum value
	InstanceGroupStateBootstrapping = "BOOTSTRAPPING"

	// InstanceGroupStateRunning is a InstanceGroupState enum value
	InstanceGroupStateRunning = "RUNNING"

	// InstanceGroupStateReconfiguring is a InstanceGroupState enum value
	InstanceGroupStateReconfiguring = "RECONFIGURING"

	// InstanceGroupStateResizing is a InstanceGroupState enum value
	InstanceGroupStateResizing = "RESIZING"

	// InstanceGroupStateSuspended is a InstanceGroupState enum value
	InstanceGroupStateSuspended = "SUSPENDED"

	// InstanceGroupStateTerminating is a InstanceGroupState enum value
	InstanceGroupStateTerminating = "TERMINATING"

	// InstanceGroupStateTerminated is a InstanceGroupState enum value
	InstanceGroupStateTerminated = "TERMINATED"

	// InstanceGroupStateArrested is a InstanceGroupState enum value
	InstanceGroupStateArrested = "ARRESTED"

	// InstanceGroupStateShuttingDown is a InstanceGroupState enum value
	InstanceGroupStateShuttingDown = "SHUTTING_DOWN"

	// InstanceGroupStateEnded is a InstanceGroupState enum value
	InstanceGroupStateEnded = "ENDED"
)

// InstanceGroupState_Values returns all elements of the InstanceGroupState enum
func InstanceGroupState_Values() []string {
	return []string{
		InstanceGroupStateProvisioning,
		InstanceGroupStateBootstrapping,
		InstanceGroupStateRunning,
		InstanceGroupStateReconfiguring,
		InstanceGroupStateResizing,
		InstanceGroupStateSuspended,
		InstanceGroupStateTerminating,
		InstanceGroupStateTerminated,
		InstanceGroupStateArrested,
		InstanceGroupStateShuttingDown,
		InstanceGroupStateEnded,
	}
}

const (
	// InstanceGroupStateChangeReasonCodeInternalError is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// InstanceGroupStateChangeReasonCodeValidationError is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// InstanceGroupStateChangeReasonCodeInstanceFailure is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// InstanceGroupStateChangeReasonCodeClusterTerminated is a InstanceGroupStateChangeReasonCode enum value
	InstanceGroupStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

// InstanceGroupStateChangeReasonCode_Values returns all elements of the InstanceGroupStateChangeReasonCode enum
func InstanceGroupStateChangeReasonCode_Values() []string {
	return []string{
		InstanceGroupStateChangeReasonCodeInternalError,
		InstanceGroupStateChangeReasonCodeValidationError,
		InstanceGroupStateChangeReasonCodeInstanceFailure,
		InstanceGroupStateChangeReasonCodeClusterTerminated,
	}
}

const (
	// InstanceGroupTypeMaster is a InstanceGroupType enum value
	InstanceGroupTypeMaster = "MASTER"

	// InstanceGroupTypeCore is a InstanceGroupType enum value
	InstanceGroupTypeCore = "CORE"

	// InstanceGroupTypeTask is a InstanceGroupType enum value
	InstanceGroupTypeTask = "TASK"
)

// InstanceGroupType_Values returns all elements of the InstanceGroupType enum
func InstanceGroupType_Values() []string {
	return []string{
		InstanceGroupTypeMaster,
		InstanceGroupTypeCore,
		InstanceGroupTypeTask,
	}
}

const (
	// InstanceRoleTypeMaster is a InstanceRoleType enum value
	InstanceRoleTypeMaster = "MASTER"

	// InstanceRoleTypeCore is a InstanceRoleType enum value
	InstanceRoleTypeCore = "CORE"

	// InstanceRoleTypeTask is a InstanceRoleType enum value
	InstanceRoleTypeTask = "TASK"
)

// InstanceRoleType_Values returns all elements of the InstanceRoleType enum
func InstanceRoleType_Values() []string {
	return []string{
		InstanceRoleTypeMaster,
		InstanceRoleTypeCore,
		InstanceRoleTypeTask,
	}
}

const (
	// InstanceStateAwaitingFulfillment is a InstanceState enum value
	InstanceStateAwaitingFulfillment = "AWAITING_FULFILLMENT"

	// InstanceStateProvisioning is a InstanceState enum value
	InstanceStateProvisioning = "PROVISIONING"

	// InstanceStateBootstrapping is a InstanceState enum value
	InstanceStateBootstrapping = "BOOTSTRAPPING"

	// InstanceStateRunning is a InstanceState enum value
	InstanceStateRunning = "RUNNING"

	// InstanceStateTerminated is a InstanceState enum value
	InstanceStateTerminated = "TERMINATED"
)

// InstanceState_Values returns all elements of the InstanceState enum
func InstanceState_Values() []string {
	return []string{
		InstanceStateAwaitingFulfillment,
		InstanceStateProvisioning,
		InstanceStateBootstrapping,
		InstanceStateRunning,
		InstanceStateTerminated,
	}
}

const (
	// InstanceStateChangeReasonCodeInternalError is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// InstanceStateChangeReasonCodeValidationError is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeValidationError = "VALIDATION_ERROR"

	// InstanceStateChangeReasonCodeInstanceFailure is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"

	// InstanceStateChangeReasonCodeBootstrapFailure is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"

	// InstanceStateChangeReasonCodeClusterTerminated is a InstanceStateChangeReasonCode enum value
	InstanceStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

// InstanceStateChangeReasonCode_Values returns all elements of the InstanceStateChangeReasonCode enum
func InstanceStateChangeReasonCode_Values() []string {
	return []string{
		InstanceStateChangeReasonCodeInternalError,
		InstanceStateChangeReasonCodeValidationError,
		InstanceStateChangeReasonCodeInstanceFailure,
		InstanceStateChangeReasonCodeBootstrapFailure,
		InstanceStateChangeReasonCodeClusterTerminated,
	}
}

// The type of instance.
const (
	// JobFlowExecutionStateStarting is a JobFlowExecutionState enum value
	JobFlowExecutionStateStarting = "STARTING"

	// JobFlowExecutionStateBootstrapping is a JobFlowExecutionState enum value
	JobFlowExecutionStateBootstrapping = "BOOTSTRAPPING"

	// JobFlowExecutionStateRunning is a JobFlowExecutionState enum value
	JobFlowExecutionStateRunning = "RUNNING"

	// JobFlowExecutionStateWaiting is a JobFlowExecutionState enum value
	JobFlowExecutionStateWaiting = "WAITING"

	// JobFlowExecutionStateShuttingDown is a JobFlowExecutionState enum value
	JobFlowExecutionStateShuttingDown = "SHUTTING_DOWN"

	// JobFlowExecutionStateTerminated is a JobFlowExecutionState enum value
	JobFlowExecutionStateTerminated = "TERMINATED"

	// JobFlowExecutionStateCompleted is a JobFlowExecutionState enum value
	JobFlowExecutionStateCompleted = "COMPLETED"

	// JobFlowExecutionStateFailed is a JobFlowExecutionState enum value
	JobFlowExecutionStateFailed = "FAILED"
)

// JobFlowExecutionState_Values returns all elements of the JobFlowExecutionState enum
func JobFlowExecutionState_Values() []string {
	return []string{
		JobFlowExecutionStateStarting,
		JobFlowExecutionStateBootstrapping,
		JobFlowExecutionStateRunning,
		JobFlowExecutionStateWaiting,
		JobFlowExecutionStateShuttingDown,
		JobFlowExecutionStateTerminated,
		JobFlowExecutionStateCompleted,
		JobFlowExecutionStateFailed,
	}
}

const (
	// MarketTypeOnDemand is a MarketType enum value
	MarketTypeOnDemand = "ON_DEMAND"

	// MarketTypeSpot is a MarketType enum value
	MarketTypeSpot = "SPOT"
)

// MarketType_Values returns all elements of the MarketType enum
func MarketType_Values() []string {
	return []string{
		MarketTypeOnDemand,
		MarketTypeSpot,
	}
}

const (
	// NotebookExecutionStatusStartPending is a NotebookExecutionStatus enum value
	NotebookExecutionStatusStartPending = "START_PENDING"

	// NotebookExecutionStatusStarting is a NotebookExecutionStatus enum value
	NotebookExecutionStatusStarting = "STARTING"

	// NotebookExecutionStatusRunning is a NotebookExecutionStatus enum value
	NotebookExecutionStatusRunning = "RUNNING"

	// NotebookExecutionStatusFinishing is a NotebookExecutionStatus enum value
	NotebookExecutionStatusFinishing = "FINISHING"

	// NotebookExecutionStatusFinished is a NotebookExecutionStatus enum value
	NotebookExecutionStatusFinished = "FINISHED"

	// NotebookExecutionStatusFailing is a NotebookExecutionStatus enum value
	NotebookExecutionStatusFailing = "FAILING"

	// NotebookExecutionStatusFailed is a NotebookExecutionStatus enum value
	NotebookExecutionStatusFailed = "FAILED"

	// NotebookExecutionStatusStopPending is a NotebookExecutionStatus enum value
	NotebookExecutionStatusStopPending = "STOP_PENDING"

	// NotebookExecutionStatusStopping is a NotebookExecutionStatus enum value
	NotebookExecutionStatusStopping = "STOPPING"

	// NotebookExecutionStatusStopped is a NotebookExecutionStatus enum value
	NotebookExecutionStatusStopped = "STOPPED"
)

// NotebookExecutionStatus_Values returns all elements of the NotebookExecutionStatus enum
func NotebookExecutionStatus_Values() []string {
	return []string{
		NotebookExecutionStatusStartPending,
		NotebookExecutionStatusStarting,
		NotebookExecutionStatusRunning,
		NotebookExecutionStatusFinishing,
		NotebookExecutionStatusFinished,
		NotebookExecutionStatusFailing,
		NotebookExecutionStatusFailed,
		NotebookExecutionStatusStopPending,
		NotebookExecutionStatusStopping,
		NotebookExecutionStatusStopped,
	}
}

const (
	// OnDemandCapacityReservationPreferenceOpen is a OnDemandCapacityReservationPreference enum value
	OnDemandCapacityReservationPreferenceOpen = "open"

	// OnDemandCapacityReservationPreferenceNone is a OnDemandCapacityReservationPreference enum value
	OnDemandCapacityReservationPreferenceNone = "none"
)

// OnDemandCapacityReservationPreference_Values returns all elements of the OnDemandCapacityReservationPreference enum
func OnDemandCapacityReservationPreference_Values() []string {
	return []string{
		OnDemandCapacityReservationPreferenceOpen,
		OnDemandCapacityReservationPreferenceNone,
	}
}

const (
	// OnDemandCapacityReservationUsageStrategyUseCapacityReservationsFirst is a OnDemandCapacityReservationUsageStrategy enum value
	OnDemandCapacityReservationUsageStrategyUseCapacityReservationsFirst = "use-capacity-reservations-first"
)

// OnDemandCapacityReservationUsageStrategy_Values returns all elements of the OnDemandCapacityReservationUsageStrategy enum
func OnDemandCapacityReservationUsageStrategy_Values() []string {
	return []string{
		OnDemandCapacityReservationUsageStrategyUseCapacityReservationsFirst,
	}
}

const (
	// OnDemandProvisioningAllocationStrategyLowestPrice is a OnDemandProvisioningAllocationStrategy enum value
	OnDemandProvisioningAllocationStrategyLowestPrice = "lowest-price"
)

// OnDemandProvisioningAllocationStrategy_Values returns all elements of the OnDemandProvisioningAllocationStrategy enum
func OnDemandProvisioningAllocationStrategy_Values() []string {
	return []string{
		OnDemandProvisioningAllocationStrategyLowestPrice,
	}
}

const (
	// PlacementGroupStrategySpread is a PlacementGroupStrategy enum value
	PlacementGroupStrategySpread = "SPREAD"

	// PlacementGroupStrategyPartition is a PlacementGroupStrategy enum value
	PlacementGroupStrategyPartition = "PARTITION"

	// PlacementGroupStrategyCluster is a PlacementGroupStrategy enum value
	PlacementGroupStrategyCluster = "CLUSTER"

	// PlacementGroupStrategyNone is a PlacementGroupStrategy enum value
	PlacementGroupStrategyNone = "NONE"
)

// PlacementGroupStrategy_Values returns all elements of the PlacementGroupStrategy enum
func PlacementGroupStrategy_Values() []string {
	return []string{
		PlacementGroupStrategySpread,
		PlacementGroupStrategyPartition,
		PlacementGroupStrategyCluster,
		PlacementGroupStrategyNone,
	}
}

const (
	// RepoUpgradeOnBootSecurity is a RepoUpgradeOnBoot enum value
	RepoUpgradeOnBootSecurity = "SECURITY"

	// RepoUpgradeOnBootNone is a RepoUpgradeOnBoot enum value
	RepoUpgradeOnBootNone = "NONE"
)

// RepoUpgradeOnBoot_Values returns all elements of the RepoUpgradeOnBoot enum
func RepoUpgradeOnBoot_Values() []string {
	return []string{
		RepoUpgradeOnBootSecurity,
		RepoUpgradeOnBootNone,
	}
}

const (
	// ScaleDownBehaviorTerminateAtInstanceHour is a ScaleDownBehavior enum value
	ScaleDownBehaviorTerminateAtInstanceHour = "TERMINATE_AT_INSTANCE_HOUR"

	// ScaleDownBehaviorTerminateAtTaskCompletion is a ScaleDownBehavior enum value
	ScaleDownBehaviorTerminateAtTaskCompletion = "TERMINATE_AT_TASK_COMPLETION"
)

// ScaleDownBehavior_Values returns all elements of the ScaleDownBehavior enum
func ScaleDownBehavior_Values() []string {
	return []string{
		ScaleDownBehaviorTerminateAtInstanceHour,
		ScaleDownBehaviorTerminateAtTaskCompletion,
	}
}

const (
	// SpotProvisioningAllocationStrategyCapacityOptimized is a SpotProvisioningAllocationStrategy enum value
	SpotProvisioningAllocationStrategyCapacityOptimized = "capacity-optimized"
)

// SpotProvisioningAllocationStrategy_Values returns all elements of the SpotProvisioningAllocationStrategy enum
func SpotProvisioningAllocationStrategy_Values() []string {
	return []string{
		SpotProvisioningAllocationStrategyCapacityOptimized,
	}
}

const (
	// SpotProvisioningTimeoutActionSwitchToOnDemand is a SpotProvisioningTimeoutAction enum value
	SpotProvisioningTimeoutActionSwitchToOnDemand = "SWITCH_TO_ON_DEMAND"

	// SpotProvisioningTimeoutActionTerminateCluster is a SpotProvisioningTimeoutAction enum value
	SpotProvisioningTimeoutActionTerminateCluster = "TERMINATE_CLUSTER"
)

// SpotProvisioningTimeoutAction_Values returns all elements of the SpotProvisioningTimeoutAction enum
func SpotProvisioningTimeoutAction_Values() []string {
	return []string{
		SpotProvisioningTimeoutActionSwitchToOnDemand,
		SpotProvisioningTimeoutActionTerminateCluster,
	}
}

const (
	// StatisticSampleCount is a Statistic enum value
	StatisticSampleCount = "SAMPLE_COUNT"

	// StatisticAverage is a Statistic enum value
	StatisticAverage = "AVERAGE"

	// StatisticSum is a Statistic enum value
	StatisticSum = "SUM"

	// StatisticMinimum is a Statistic enum value
	StatisticMinimum = "MINIMUM"

	// StatisticMaximum is a Statistic enum value
	StatisticMaximum = "MAXIMUM"
)

// Statistic_Values returns all elements of the Statistic enum
func Statistic_Values() []string {
	return []string{
		StatisticSampleCount,
		StatisticAverage,
		StatisticSum,
		StatisticMinimum,
		StatisticMaximum,
	}
}

const (
	// StepCancellationOptionSendInterrupt is a StepCancellationOption enum value
	StepCancellationOptionSendInterrupt = "SEND_INTERRUPT"

	// StepCancellationOptionTerminateProcess is a StepCancellationOption enum value
	StepCancellationOptionTerminateProcess = "TERMINATE_PROCESS"
)

// StepCancellationOption_Values returns all elements of the StepCancellationOption enum
func StepCancellationOption_Values() []string {
	return []string{
		StepCancellationOptionSendInterrupt,
		StepCancellationOptionTerminateProcess,
	}
}

const (
	// StepExecutionStatePending is a StepExecutionState enum value
	StepExecutionStatePending = "PENDING"

	// StepExecutionStateRunning is a StepExecutionState enum value
	StepExecutionStateRunning = "RUNNING"

	// StepExecutionStateContinue is a StepExecutionState enum value
	StepExecutionStateContinue = "CONTINUE"

	// StepExecutionStateCompleted is a StepExecutionState enum value
	StepExecutionStateCompleted = "COMPLETED"

	// StepExecutionStateCancelled is a StepExecutionState enum value
	StepExecutionStateCancelled = "CANCELLED"

	// StepExecutionStateFailed is a StepExecutionState enum value
	StepExecutionStateFailed = "FAILED"

	// StepExecutionStateInterrupted is a StepExecutionState enum value
	StepExecutionStateInterrupted = "INTERRUPTED"
)

// StepExecutionState_Values returns all elements of the StepExecutionState enum
func StepExecutionState_Values() []string {
	return []string{
		StepExecutionStatePending,
		StepExecutionStateRunning,
		StepExecutionStateContinue,
		StepExecutionStateCompleted,
		StepExecutionStateCancelled,
		StepExecutionStateFailed,
		StepExecutionStateInterrupted,
	}
}

const (
	// StepStatePending is a StepState enum value
	StepStatePending = "PENDING"

	// StepStateCancelPending is a StepState enum value
	StepStateCancelPending = "CANCEL_PENDING"

	// StepStateRunning is a StepState enum value
	StepStateRunning = "RUNNING"

	// StepStateCompleted is a StepState enum value
	StepStateCompleted = "COMPLETED"

	// StepStateCancelled is a StepState enum value
	StepStateCancelled = "CANCELLED"

	// StepStateFailed is a StepState enum value
	StepStateFailed = "FAILED"

	// StepStateInterrupted is a StepState enum value
	StepStateInterrupted = "INTERRUPTED"
)

// StepState_Values returns all elements of the StepState enum
func StepState_Values() []string {
	return []string{
		StepStatePending,
		StepStateCancelPending,
		StepStateRunning,
		StepStateCompleted,
		StepStateCancelled,
		StepStateFailed,
		StepStateInterrupted,
	}
}

const (
	// StepStateChangeReasonCodeNone is a StepStateChangeReasonCode enum value
	StepStateChangeReasonCodeNone = "NONE"
)

// StepStateChangeReasonCode_Values returns all elements of the StepStateChangeReasonCode enum
func StepStateChangeReasonCode_Values() []string {
	return []string{
		StepStateChangeReasonCodeNone,
	}
}

const (
	// UnitNone is a Unit enum value
	UnitNone = "NONE"

	// UnitSeconds is a Unit enum value
	UnitSeconds = "SECONDS"

	// UnitMicroSeconds is a Unit enum value
	UnitMicroSeconds = "MICRO_SECONDS"

	// UnitMilliSeconds is a Unit enum value
	UnitMilliSeconds = "MILLI_SECONDS"

	// UnitBytes is a Unit enum value
	UnitBytes = "BYTES"

	// UnitKiloBytes is a Unit enum value
	UnitKiloBytes = "KILO_BYTES"

	// UnitMegaBytes is a Unit enum value
	UnitMegaBytes = "MEGA_BYTES"

	// UnitGigaBytes is a Unit enum value
	UnitGigaBytes = "GIGA_BYTES"

	// UnitTeraBytes is a Unit enum value
	UnitTeraBytes = "TERA_BYTES"

	// UnitBits is a Unit enum value
	UnitBits = "BITS"

	// UnitKiloBits is a Unit enum value
	UnitKiloBits = "KILO_BITS"

	// UnitMegaBits is a Unit enum value
	UnitMegaBits = "MEGA_BITS"

	// UnitGigaBits is a Unit enum value
	UnitGigaBits = "GIGA_BITS"

	// UnitTeraBits is a Unit enum value
	UnitTeraBits = "TERA_BITS"

	// UnitPercent is a Unit enum value
	UnitPercent = "PERCENT"

	// UnitCount is a Unit enum value
	UnitCount = "COUNT"

	// UnitBytesPerSecond is a Unit enum value
	UnitBytesPerSecond = "BYTES_PER_SECOND"

	// UnitKiloBytesPerSecond is a Unit enum value
	UnitKiloBytesPerSecond = "KILO_BYTES_PER_SECOND"

	// UnitMegaBytesPerSecond is a Unit enum value
	UnitMegaBytesPerSecond = "MEGA_BYTES_PER_SECOND"

	// UnitGigaBytesPerSecond is a Unit enum value
	UnitGigaBytesPerSecond = "GIGA_BYTES_PER_SECOND"

	// UnitTeraBytesPerSecond is a Unit enum value
	UnitTeraBytesPerSecond = "TERA_BYTES_PER_SECOND"

	// UnitBitsPerSecond is a Unit enum value
	UnitBitsPerSecond = "BITS_PER_SECOND"

	// UnitKiloBitsPerSecond is a Unit enum value
	UnitKiloBitsPerSecond = "KILO_BITS_PER_SECOND"

	// UnitMegaBitsPerSecond is a Unit enum value
	UnitMegaBitsPerSecond = "MEGA_BITS_PER_SECOND"

	// UnitGigaBitsPerSecond is a Unit enum value
	UnitGigaBitsPerSecond = "GIGA_BITS_PER_SECOND"

	// UnitTeraBitsPerSecond is a Unit enum value
	UnitTeraBitsPerSecond = "TERA_BITS_PER_SECOND"

	// UnitCountPerSecond is a Unit enum value
	UnitCountPerSecond = "COUNT_PER_SECOND"
)

// Unit_Values returns all elements of the Unit enum
func Unit_Values() []string {
	return []string{
		UnitNone,
		UnitSeconds,
		UnitMicroSeconds,
		UnitMilliSeconds,
		UnitBytes,
		UnitKiloBytes,
		UnitMegaBytes,
		UnitGigaBytes,
		UnitTeraBytes,
		UnitBits,
		UnitKiloBits,
		UnitMegaBits,
		UnitGigaBits,
		UnitTeraBits,
		UnitPercent,
		UnitCount,
		UnitBytesPerSecond,
		UnitKiloBytesPerSecond,
		UnitMegaBytesPerSecond,
		UnitGigaBytesPerSecond,
		UnitTeraBytesPerSecond,
		UnitBitsPerSecond,
		UnitKiloBitsPerSecond,
		UnitMegaBitsPerSecond,
		UnitGigaBitsPerSecond,
		UnitTeraBitsPerSecond,
		UnitCountPerSecond,
	}
}
