/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "sigs.k8s.io/gateway-api/apis/v1alpha1"
)

// FakeBackendPolicies implements BackendPolicyInterface
type FakeBackendPolicies struct {
	Fake *FakeNetworkingV1alpha1
	ns   string
}

var backendpoliciesResource = schema.GroupVersionResource{Group: "networking.x-k8s.io", Version: "v1alpha1", Resource: "backendpolicies"}

var backendpoliciesKind = schema.GroupVersionKind{Group: "networking.x-k8s.io", Version: "v1alpha1", Kind: "BackendPolicy"}

// Get takes name of the backendPolicy, and returns the corresponding backendPolicy object, and an error if there is any.
func (c *FakeBackendPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.BackendPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(backendpoliciesResource, c.ns, name), &v1alpha1.BackendPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackendPolicy), err
}

// List takes label and field selectors, and returns the list of BackendPolicies that match those selectors.
func (c *FakeBackendPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.BackendPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(backendpoliciesResource, backendpoliciesKind, c.ns, opts), &v1alpha1.BackendPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.BackendPolicyList{ListMeta: obj.(*v1alpha1.BackendPolicyList).ListMeta}
	for _, item := range obj.(*v1alpha1.BackendPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested backendPolicies.
func (c *FakeBackendPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(backendpoliciesResource, c.ns, opts))

}

// Create takes the representation of a backendPolicy and creates it.  Returns the server's representation of the backendPolicy, and an error, if there is any.
func (c *FakeBackendPolicies) Create(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.CreateOptions) (result *v1alpha1.BackendPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(backendpoliciesResource, c.ns, backendPolicy), &v1alpha1.BackendPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackendPolicy), err
}

// Update takes the representation of a backendPolicy and updates it. Returns the server's representation of the backendPolicy, and an error, if there is any.
func (c *FakeBackendPolicies) Update(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (result *v1alpha1.BackendPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(backendpoliciesResource, c.ns, backendPolicy), &v1alpha1.BackendPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackendPolicy), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeBackendPolicies) UpdateStatus(ctx context.Context, backendPolicy *v1alpha1.BackendPolicy, opts v1.UpdateOptions) (*v1alpha1.BackendPolicy, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(backendpoliciesResource, "status", c.ns, backendPolicy), &v1alpha1.BackendPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackendPolicy), err
}

// Delete takes name of the backendPolicy and deletes it. Returns an error if one occurs.
func (c *FakeBackendPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(backendpoliciesResource, c.ns, name), &v1alpha1.BackendPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeBackendPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(backendpoliciesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.BackendPolicyList{})
	return err
}

// Patch applies the patch and returns the patched backendPolicy.
func (c *FakeBackendPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.BackendPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(backendpoliciesResource, c.ns, name, pt, data, subresources...), &v1alpha1.BackendPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.BackendPolicy), err
}
