/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/serving-operator/pkg/apis/serving/v1alpha1"
	scheme "knative.dev/serving-operator/pkg/client/clientset/versioned/scheme"
)

// KnativeServingsGetter has a method to return a KnativeServingInterface.
// A group's client should implement this interface.
type KnativeServingsGetter interface {
	KnativeServings(namespace string) KnativeServingInterface
}

// KnativeServingInterface has methods to work with KnativeServing resources.
type KnativeServingInterface interface {
	Create(*v1alpha1.KnativeServing) (*v1alpha1.KnativeServing, error)
	Update(*v1alpha1.KnativeServing) (*v1alpha1.KnativeServing, error)
	UpdateStatus(*v1alpha1.KnativeServing) (*v1alpha1.KnativeServing, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.KnativeServing, error)
	List(opts v1.ListOptions) (*v1alpha1.KnativeServingList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.KnativeServing, err error)
	KnativeServingExpansion
}

// knativeServings implements KnativeServingInterface
type knativeServings struct {
	client rest.Interface
	ns     string
}

// newKnativeServings returns a KnativeServings
func newKnativeServings(c *OperatorV1alpha1Client, namespace string) *knativeServings {
	return &knativeServings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the knativeServing, and returns the corresponding knativeServing object, and an error if there is any.
func (c *knativeServings) Get(name string, options v1.GetOptions) (result *v1alpha1.KnativeServing, err error) {
	result = &v1alpha1.KnativeServing{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("knativeservings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KnativeServings that match those selectors.
func (c *knativeServings) List(opts v1.ListOptions) (result *v1alpha1.KnativeServingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KnativeServingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("knativeservings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested knativeServings.
func (c *knativeServings) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("knativeservings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a knativeServing and creates it.  Returns the server's representation of the knativeServing, and an error, if there is any.
func (c *knativeServings) Create(knativeServing *v1alpha1.KnativeServing) (result *v1alpha1.KnativeServing, err error) {
	result = &v1alpha1.KnativeServing{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("knativeservings").
		Body(knativeServing).
		Do().
		Into(result)
	return
}

// Update takes the representation of a knativeServing and updates it. Returns the server's representation of the knativeServing, and an error, if there is any.
func (c *knativeServings) Update(knativeServing *v1alpha1.KnativeServing) (result *v1alpha1.KnativeServing, err error) {
	result = &v1alpha1.KnativeServing{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("knativeservings").
		Name(knativeServing.Name).
		Body(knativeServing).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *knativeServings) UpdateStatus(knativeServing *v1alpha1.KnativeServing) (result *v1alpha1.KnativeServing, err error) {
	result = &v1alpha1.KnativeServing{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("knativeservings").
		Name(knativeServing.Name).
		SubResource("status").
		Body(knativeServing).
		Do().
		Into(result)
	return
}

// Delete takes name of the knativeServing and deletes it. Returns an error if one occurs.
func (c *knativeServings) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("knativeservings").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *knativeServings) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("knativeservings").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched knativeServing.
func (c *knativeServings) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.KnativeServing, err error) {
	result = &v1alpha1.KnativeServing{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("knativeservings").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
