// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/envoy_filter.proto

// `EnvoyFilter` describes Envoy proxy-specific filters that can be used to
// customize the Envoy proxy configuration generated by Istio networking
// subsystem (Pilot). This feature must be used with care, as incorrect
// configurations could potentially destabilize the entire mesh.
//
// NOTE 1: Since this is break glass configuration, there will not be any
// backward compatibility across different Istio releases. In other words,
// this configuration is subject to change based on internal implementation
// of Istio networking subsystem.
//
// NOTE 2: When multiple EnvoyFilters are bound to the same workload, all filter
// configurations will be processed sequentially in order of creation time.
// The behavior is undefined if multiple EnvoyFilter configurations conflict
// with each other.
//
// NOTE 3: For filters of `filterType: HTTP` you must include a `listenerMatch` section
// with a `listenerProtocol: HTTP` or the filter have no effect.
//
// The following example for Kubernetes enables Envoy's Lua filter for all
// inbound HTTP calls arriving at service port 8080 of the reviews service pod with
// labels "app: reviews".
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: EnvoyFilter
// metadata:
//   name: reviews-lua
// spec:
//   workloadLabels:
//     app: reviews
//   filters:
//   - listenerMatch:
//       portNumber: 8080
//       listenerType: SIDECAR_INBOUND # will match with the inbound listener for reviews:8080
//       listenerProtocol: HTTP
//     filterName: envoy.lua
//     filterType: HTTP
//     filterConfig:
//       inlineCode: |
//         ... lua code ...
// ```

package v1alpha3

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type EnvoyFilter_ListenerMatch_ListenerType int32

const (
	// All listeners
	EnvoyFilter_ListenerMatch_ANY EnvoyFilter_ListenerMatch_ListenerType = 0
	// Inbound listener in sidecar
	EnvoyFilter_ListenerMatch_SIDECAR_INBOUND EnvoyFilter_ListenerMatch_ListenerType = 1
	// Outbound listener in sidecar
	EnvoyFilter_ListenerMatch_SIDECAR_OUTBOUND EnvoyFilter_ListenerMatch_ListenerType = 2
	// Gateway listener
	EnvoyFilter_ListenerMatch_GATEWAY EnvoyFilter_ListenerMatch_ListenerType = 3
)

var EnvoyFilter_ListenerMatch_ListenerType_name = map[int32]string{
	0: "ANY",
	1: "SIDECAR_INBOUND",
	2: "SIDECAR_OUTBOUND",
	3: "GATEWAY",
}

var EnvoyFilter_ListenerMatch_ListenerType_value = map[string]int32{
	"ANY":              0,
	"SIDECAR_INBOUND":  1,
	"SIDECAR_OUTBOUND": 2,
	"GATEWAY":          3,
}

func (x EnvoyFilter_ListenerMatch_ListenerType) String() string {
	return proto.EnumName(EnvoyFilter_ListenerMatch_ListenerType_name, int32(x))
}

func (EnvoyFilter_ListenerMatch_ListenerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1, 0}
}

type EnvoyFilter_ListenerMatch_ListenerProtocol int32

const (
	// All protocols
	EnvoyFilter_ListenerMatch_ALL EnvoyFilter_ListenerMatch_ListenerProtocol = 0
	// HTTP or HTTPS (with termination) / HTTP2/gRPC
	EnvoyFilter_ListenerMatch_HTTP EnvoyFilter_ListenerMatch_ListenerProtocol = 1
	// Any non-HTTP listener
	EnvoyFilter_ListenerMatch_TCP EnvoyFilter_ListenerMatch_ListenerProtocol = 2
)

var EnvoyFilter_ListenerMatch_ListenerProtocol_name = map[int32]string{
	0: "ALL",
	1: "HTTP",
	2: "TCP",
}

var EnvoyFilter_ListenerMatch_ListenerProtocol_value = map[string]int32{
	"ALL":  0,
	"HTTP": 1,
	"TCP":  2,
}

func (x EnvoyFilter_ListenerMatch_ListenerProtocol) String() string {
	return proto.EnumName(EnvoyFilter_ListenerMatch_ListenerProtocol_name, int32(x))
}

func (EnvoyFilter_ListenerMatch_ListenerProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1, 1}
}

// Index/position in the filter chain.
type EnvoyFilter_InsertPosition_Index int32

const (
	// Insert first
	EnvoyFilter_InsertPosition_FIRST EnvoyFilter_InsertPosition_Index = 0
	// Insert last
	EnvoyFilter_InsertPosition_LAST EnvoyFilter_InsertPosition_Index = 1
	// Insert before the named filter.
	EnvoyFilter_InsertPosition_BEFORE EnvoyFilter_InsertPosition_Index = 2
	// Insert after the named filter.
	EnvoyFilter_InsertPosition_AFTER EnvoyFilter_InsertPosition_Index = 3
)

var EnvoyFilter_InsertPosition_Index_name = map[int32]string{
	0: "FIRST",
	1: "LAST",
	2: "BEFORE",
	3: "AFTER",
}

var EnvoyFilter_InsertPosition_Index_value = map[string]int32{
	"FIRST":  0,
	"LAST":   1,
	"BEFORE": 2,
	"AFTER":  3,
}

func (x EnvoyFilter_InsertPosition_Index) String() string {
	return proto.EnumName(EnvoyFilter_InsertPosition_Index_name, int32(x))
}

func (EnvoyFilter_InsertPosition_Index) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2, 0}
}

type EnvoyFilter_Filter_FilterType int32

const (
	// placeholder
	EnvoyFilter_Filter_INVALID EnvoyFilter_Filter_FilterType = 0
	// Http filter
	EnvoyFilter_Filter_HTTP EnvoyFilter_Filter_FilterType = 1
	// Network filter
	EnvoyFilter_Filter_NETWORK EnvoyFilter_Filter_FilterType = 2
)

var EnvoyFilter_Filter_FilterType_name = map[int32]string{
	0: "INVALID",
	1: "HTTP",
	2: "NETWORK",
}

var EnvoyFilter_Filter_FilterType_value = map[string]int32{
	"INVALID": 0,
	"HTTP":    1,
	"NETWORK": 2,
}

func (x EnvoyFilter_Filter_FilterType) String() string {
	return proto.EnumName(EnvoyFilter_Filter_FilterType_name, int32(x))
}

func (EnvoyFilter_Filter_FilterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3, 0}
}

type EnvoyFilter struct {
	// Zero or more labels that indicate a specific set of pods/VMs whose
	// proxies should be configured to use these additional filters.  The
	// scope of label search is platform dependent. On Kubernetes, for
	// example, the scope includes pods running in all reachable
	// namespaces. Omitting the selector applies the filter to all proxies in
	// the mesh.
	WorkloadLabels map[string]string `protobuf:"bytes,1,rep,name=workload_labels,json=workloadLabels,proto3" json:"workload_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// REQUIRED: Envoy network filters/http filters to be added to matching
	// listeners.  When adding network filters to http connections, care
	// should be taken to ensure that the filter is added before
	// envoy.http_connection_manager.
	Filters              []*EnvoyFilter_Filter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *EnvoyFilter) Reset()         { *m = EnvoyFilter{} }
func (m *EnvoyFilter) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter) ProtoMessage()    {}
func (*EnvoyFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0}
}
func (m *EnvoyFilter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter.Merge(m, src)
}
func (m *EnvoyFilter) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter proto.InternalMessageInfo

func (m *EnvoyFilter) GetWorkloadLabels() map[string]string {
	if m != nil {
		return m.WorkloadLabels
	}
	return nil
}

func (m *EnvoyFilter) GetFilters() []*EnvoyFilter_Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// Select a listener to add the filter to based on the match conditions.
// All conditions specified in the ListenerMatch must be met for the filter
// to be applied to a listener.
type EnvoyFilter_ListenerMatch struct {
	// The service port/gateway port to which traffic is being
	// sent/received. If not specified, matches all listeners. Even though
	// inbound listeners are generated for the instance/pod ports, only
	// service ports should be used to match listeners.
	PortNumber uint32 `protobuf:"varint,1,opt,name=port_number,json=portNumber,proto3" json:"port_number,omitempty"`
	// Instead of using specific port numbers, a set of ports matching a
	// given port name prefix can be selected. E.g., "mongo" selects ports
	// named mongo-port, mongo, mongoDB, MONGO, etc. Matching is case
	// insensitive.
	PortNamePrefix string `protobuf:"bytes,2,opt,name=port_name_prefix,json=portNamePrefix,proto3" json:"port_name_prefix,omitempty"`
	// Inbound vs outbound sidecar listener or gateway listener. If not specified,
	// matches all listeners.
	ListenerType EnvoyFilter_ListenerMatch_ListenerType `protobuf:"varint,3,opt,name=listener_type,json=listenerType,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_ListenerMatch_ListenerType" json:"listener_type,omitempty"`
	// Selects a class of listeners for the same protocol. Use the protocol
	// selection to select all HTTP listeners (includes HTTP2/gRPC/HTTPS
	// where Envoy terminates TLS) or all TCP listeners (includes HTTPS
	// passthrough using SNI). When adding a HTTP filter, the listenerProtocol
	// should be set to HTTP.
	ListenerProtocol EnvoyFilter_ListenerMatch_ListenerProtocol `protobuf:"varint,4,opt,name=listener_protocol,json=listenerProtocol,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_ListenerMatch_ListenerProtocol" json:"listener_protocol,omitempty"`
	// One or more IP addresses to which the listener is bound. If
	// specified, should match at least one address in the list.
	Address              []string `protobuf:"bytes,5,rep,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_ListenerMatch) Reset()         { *m = EnvoyFilter_ListenerMatch{} }
func (m *EnvoyFilter_ListenerMatch) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_ListenerMatch) ProtoMessage()    {}
func (*EnvoyFilter_ListenerMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 1}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_ListenerMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_ListenerMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.Merge(m, src)
}
func (m *EnvoyFilter_ListenerMatch) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_ListenerMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_ListenerMatch.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_ListenerMatch proto.InternalMessageInfo

func (m *EnvoyFilter_ListenerMatch) GetPortNumber() uint32 {
	if m != nil {
		return m.PortNumber
	}
	return 0
}

func (m *EnvoyFilter_ListenerMatch) GetPortNamePrefix() string {
	if m != nil {
		return m.PortNamePrefix
	}
	return ""
}

func (m *EnvoyFilter_ListenerMatch) GetListenerType() EnvoyFilter_ListenerMatch_ListenerType {
	if m != nil {
		return m.ListenerType
	}
	return EnvoyFilter_ListenerMatch_ANY
}

func (m *EnvoyFilter_ListenerMatch) GetListenerProtocol() EnvoyFilter_ListenerMatch_ListenerProtocol {
	if m != nil {
		return m.ListenerProtocol
	}
	return EnvoyFilter_ListenerMatch_ALL
}

func (m *EnvoyFilter_ListenerMatch) GetAddress() []string {
	if m != nil {
		return m.Address
	}
	return nil
}

// Indicates the relative index in the filter chain where the filter should be inserted.
type EnvoyFilter_InsertPosition struct {
	// Position of this filter in the filter chain.
	Index EnvoyFilter_InsertPosition_Index `protobuf:"varint,1,opt,name=index,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_InsertPosition_Index" json:"index,omitempty"`
	// If BEFORE or AFTER position is specified, specify the name of the
	// filter relative to which this filter should be inserted.
	RelativeTo           string   `protobuf:"bytes,2,opt,name=relative_to,json=relativeTo,proto3" json:"relative_to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvoyFilter_InsertPosition) Reset()         { *m = EnvoyFilter_InsertPosition{} }
func (m *EnvoyFilter_InsertPosition) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_InsertPosition) ProtoMessage()    {}
func (*EnvoyFilter_InsertPosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 2}
}
func (m *EnvoyFilter_InsertPosition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_InsertPosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_InsertPosition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_InsertPosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_InsertPosition.Merge(m, src)
}
func (m *EnvoyFilter_InsertPosition) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_InsertPosition) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_InsertPosition.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_InsertPosition proto.InternalMessageInfo

func (m *EnvoyFilter_InsertPosition) GetIndex() EnvoyFilter_InsertPosition_Index {
	if m != nil {
		return m.Index
	}
	return EnvoyFilter_InsertPosition_FIRST
}

func (m *EnvoyFilter_InsertPosition) GetRelativeTo() string {
	if m != nil {
		return m.RelativeTo
	}
	return ""
}

// Envoy filters to be added to a network or http filter chain.
type EnvoyFilter_Filter struct {
	// Filter will be added to the listener only if the match
	// conditions are true.  If not specified, the filters will be
	// applied to all listeners where possible, potentially resulting
	// in invalid configurations. It is recommended to specify the
	// listener match criteria for all filter insertions.
	ListenerMatch *EnvoyFilter_ListenerMatch `protobuf:"bytes,1,opt,name=listener_match,json=listenerMatch,proto3" json:"listener_match,omitempty"`
	// Insert position in the filter chain. Defaults to FIRST
	InsertPosition *EnvoyFilter_InsertPosition `protobuf:"bytes,2,opt,name=insert_position,json=insertPosition,proto3" json:"insert_position,omitempty"`
	// REQUIRED: The type of filter to instantiate.
	FilterType EnvoyFilter_Filter_FilterType `protobuf:"varint,3,opt,name=filter_type,json=filterType,proto3,enum=istio.networking.v1alpha3.EnvoyFilter_Filter_FilterType" json:"filter_type,omitempty"`
	// REQUIRED: The name of the filter to instantiate. The name must match a supported
	// filter _compiled into_ Envoy.
	FilterName string `protobuf:"bytes,4,opt,name=filter_name,json=filterName,proto3" json:"filter_name,omitempty"`
	// REQUIRED: Filter specific configuration which depends on the filter being
	// instantiated.
	FilterConfig         *types.Struct `protobuf:"bytes,5,opt,name=filter_config,json=filterConfig,proto3" json:"filter_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EnvoyFilter_Filter) Reset()         { *m = EnvoyFilter_Filter{} }
func (m *EnvoyFilter_Filter) String() string { return proto.CompactTextString(m) }
func (*EnvoyFilter_Filter) ProtoMessage()    {}
func (*EnvoyFilter_Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_16d9b2922bd3e4a9, []int{0, 3}
}
func (m *EnvoyFilter_Filter) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvoyFilter_Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvoyFilter_Filter.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvoyFilter_Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvoyFilter_Filter.Merge(m, src)
}
func (m *EnvoyFilter_Filter) XXX_Size() int {
	return m.Size()
}
func (m *EnvoyFilter_Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvoyFilter_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_EnvoyFilter_Filter proto.InternalMessageInfo

func (m *EnvoyFilter_Filter) GetListenerMatch() *EnvoyFilter_ListenerMatch {
	if m != nil {
		return m.ListenerMatch
	}
	return nil
}

func (m *EnvoyFilter_Filter) GetInsertPosition() *EnvoyFilter_InsertPosition {
	if m != nil {
		return m.InsertPosition
	}
	return nil
}

func (m *EnvoyFilter_Filter) GetFilterType() EnvoyFilter_Filter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return EnvoyFilter_Filter_INVALID
}

func (m *EnvoyFilter_Filter) GetFilterName() string {
	if m != nil {
		return m.FilterName
	}
	return ""
}

func (m *EnvoyFilter_Filter) GetFilterConfig() *types.Struct {
	if m != nil {
		return m.FilterConfig
	}
	return nil
}

func init() {
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_ListenerMatch_ListenerType", EnvoyFilter_ListenerMatch_ListenerType_name, EnvoyFilter_ListenerMatch_ListenerType_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_ListenerMatch_ListenerProtocol", EnvoyFilter_ListenerMatch_ListenerProtocol_name, EnvoyFilter_ListenerMatch_ListenerProtocol_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_InsertPosition_Index", EnvoyFilter_InsertPosition_Index_name, EnvoyFilter_InsertPosition_Index_value)
	proto.RegisterEnum("istio.networking.v1alpha3.EnvoyFilter_Filter_FilterType", EnvoyFilter_Filter_FilterType_name, EnvoyFilter_Filter_FilterType_value)
	proto.RegisterType((*EnvoyFilter)(nil), "istio.networking.v1alpha3.EnvoyFilter")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.EnvoyFilter.WorkloadLabelsEntry")
	proto.RegisterType((*EnvoyFilter_ListenerMatch)(nil), "istio.networking.v1alpha3.EnvoyFilter.ListenerMatch")
	proto.RegisterType((*EnvoyFilter_InsertPosition)(nil), "istio.networking.v1alpha3.EnvoyFilter.InsertPosition")
	proto.RegisterType((*EnvoyFilter_Filter)(nil), "istio.networking.v1alpha3.EnvoyFilter.Filter")
}

func init() {
	proto.RegisterFile("networking/v1alpha3/envoy_filter.proto", fileDescriptor_16d9b2922bd3e4a9)
}

var fileDescriptor_16d9b2922bd3e4a9 = []byte{
	// 706 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x41, 0x6f, 0xda, 0x4c,
	0x10, 0x8d, 0x71, 0x08, 0x1f, 0xe3, 0x40, 0xfc, 0x6d, 0x22, 0xd5, 0x45, 0x55, 0x8a, 0x38, 0x54,
	0x5c, 0x6a, 0x5a, 0xd2, 0x4a, 0x51, 0xda, 0x8b, 0x93, 0x98, 0x14, 0x95, 0x02, 0x5d, 0x9c, 0x46,
	0x69, 0xa5, 0x5a, 0x06, 0x16, 0xb2, 0x8a, 0xf1, 0x5a, 0xf6, 0x42, 0xc2, 0xcf, 0xea, 0xb1, 0xd7,
	0x9e, 0x7a, 0x6c, 0xff, 0x41, 0x95, 0x5f, 0x52, 0x79, 0x6d, 0x08, 0x44, 0xa9, 0x94, 0xa6, 0x27,
	0x7b, 0x9f, 0xde, 0xbc, 0x99, 0xd9, 0x79, 0xb3, 0xf0, 0xc4, 0x23, 0xfc, 0x82, 0x05, 0xe7, 0xd4,
	0x1b, 0x56, 0x26, 0xcf, 0x1d, 0xd7, 0x3f, 0x73, 0x76, 0x2a, 0xc4, 0x9b, 0xb0, 0xa9, 0x3d, 0xa0,
	0x2e, 0x27, 0x81, 0xee, 0x07, 0x8c, 0x33, 0xf4, 0x90, 0x86, 0x9c, 0x32, 0xfd, 0x9a, 0xad, 0xcf,
	0xd8, 0x85, 0x47, 0x43, 0xc6, 0x86, 0x2e, 0xa9, 0x08, 0x62, 0x77, 0x3c, 0xa8, 0x84, 0x3c, 0x18,
	0xf7, 0x78, 0x1c, 0x58, 0xfa, 0x06, 0xa0, 0x98, 0x91, 0x5e, 0x4d, 0xc8, 0xa1, 0x1e, 0x6c, 0x44,
	0x0a, 0x2e, 0x73, 0xfa, 0xb6, 0xeb, 0x74, 0x89, 0x1b, 0x6a, 0x52, 0x51, 0x2e, 0x2b, 0xd5, 0x3d,
	0xfd, 0x8f, 0x29, 0xf4, 0x05, 0x01, 0xfd, 0x24, 0x89, 0x6e, 0x88, 0x60, 0xd3, 0xe3, 0xc1, 0x14,
	0xe7, 0x2f, 0x96, 0x40, 0x74, 0x04, 0x99, 0xb8, 0xfa, 0x50, 0x4b, 0x09, 0xf1, 0xa7, 0x77, 0x14,
	0x8f, 0x3f, 0x78, 0x16, 0x5d, 0x30, 0x60, 0xf3, 0x96, 0x7c, 0x48, 0x05, 0xf9, 0x9c, 0x4c, 0x35,
	0xa9, 0x28, 0x95, 0xb3, 0x38, 0xfa, 0x45, 0x5b, 0x90, 0x9e, 0x38, 0xee, 0x98, 0x68, 0x29, 0x81,
	0xc5, 0x87, 0xbd, 0xd4, 0xae, 0x54, 0xf8, 0x29, 0x43, 0xae, 0x41, 0x43, 0x4e, 0x3c, 0x12, 0xbc,
	0x73, 0x78, 0xef, 0x0c, 0x3d, 0x06, 0xc5, 0x67, 0x01, 0xb7, 0xbd, 0xf1, 0xa8, 0x4b, 0x02, 0xa1,
	0x92, 0xc3, 0x10, 0x41, 0x4d, 0x81, 0xa0, 0x32, 0xa8, 0x31, 0xc1, 0x19, 0x11, 0xdb, 0x0f, 0xc8,
	0x80, 0x5e, 0x26, 0xba, 0x79, 0xc1, 0x72, 0x46, 0xa4, 0x2d, 0x50, 0x34, 0x80, 0x9c, 0x9b, 0x68,
	0xdb, 0x7c, 0xea, 0x13, 0x4d, 0x2e, 0x4a, 0xe5, 0x7c, 0xd5, 0xb8, 0x63, 0xbb, 0x4b, 0x75, 0xcd,
	0x4f, 0xd6, 0xd4, 0x27, 0x78, 0xdd, 0x5d, 0x38, 0xa1, 0x00, 0xfe, 0x9f, 0xe7, 0x11, 0x73, 0xed,
	0x31, 0x57, 0x5b, 0x15, 0xb9, 0xcc, 0x7f, 0xca, 0xd5, 0x4e, 0xc4, 0xb0, 0xea, 0xde, 0x40, 0x90,
	0x06, 0x19, 0xa7, 0xdf, 0x0f, 0x48, 0x18, 0x6a, 0xe9, 0xa2, 0x5c, 0xce, 0xe2, 0xd9, 0xb1, 0xd4,
	0x82, 0xf5, 0xc5, 0x5a, 0x51, 0x06, 0x64, 0xa3, 0x79, 0xaa, 0xae, 0xa0, 0x4d, 0xd8, 0xe8, 0xd4,
	0x0f, 0xcd, 0x03, 0x03, 0xdb, 0xf5, 0xe6, 0x7e, 0xeb, 0xb8, 0x79, 0xa8, 0x4a, 0x68, 0x0b, 0xd4,
	0x19, 0xd8, 0x3a, 0xb6, 0x62, 0x34, 0x85, 0x14, 0xc8, 0x1c, 0x19, 0x96, 0x79, 0x62, 0x9c, 0xaa,
	0x72, 0x49, 0x07, 0xf5, 0x66, 0x41, 0x42, 0xb4, 0xd1, 0x50, 0x57, 0xd0, 0x7f, 0xb0, 0xfa, 0xc6,
	0xb2, 0xda, 0xaa, 0x14, 0x41, 0xd6, 0x41, 0x5b, 0x4d, 0x15, 0xbe, 0x4a, 0x90, 0xaf, 0x7b, 0x21,
	0x09, 0x78, 0x9b, 0x85, 0x94, 0x53, 0xe6, 0xa1, 0xf7, 0x90, 0xa6, 0x5e, 0x9f, 0x5c, 0x8a, 0x71,
	0xe6, 0xab, 0xaf, 0xee, 0x78, 0x2b, 0xcb, 0x2a, 0x7a, 0x3d, 0x92, 0xc0, 0xb1, 0x52, 0xe4, 0x93,
	0x80, 0xb8, 0x0e, 0xa7, 0x13, 0x62, 0x73, 0x96, 0x38, 0x00, 0x66, 0x90, 0xc5, 0x4a, 0x3b, 0x90,
	0x16, 0x01, 0x28, 0x0b, 0xe9, 0x5a, 0x1d, 0x77, 0xac, 0xb8, 0xda, 0x86, 0xd1, 0xb1, 0x54, 0x09,
	0x01, 0xac, 0xed, 0x9b, 0xb5, 0x16, 0x36, 0xd5, 0x54, 0x44, 0x30, 0x6a, 0x96, 0x89, 0x55, 0xb9,
	0xf0, 0x45, 0x86, 0xb5, 0x64, 0x17, 0x3f, 0x41, 0x7e, 0x3e, 0xd5, 0x51, 0x34, 0x16, 0x51, 0xbc,
	0x52, 0x7d, 0x71, 0x9f, 0x91, 0xe2, 0xb9, 0x13, 0x63, 0x97, 0x7f, 0x86, 0x0d, 0x2a, 0x9a, 0xb3,
	0xfd, 0xa4, 0x3b, 0xd1, 0x81, 0x52, 0x7d, 0x79, 0xaf, 0xab, 0xc1, 0x79, 0xba, 0x7c, 0xe1, 0xa7,
	0xa0, 0xc4, 0x5b, 0xba, 0x68, 0xfc, 0xdd, 0xbf, 0xda, 0xf3, 0xe4, 0x23, 0xfc, 0x0e, 0x83, 0xf9,
	0x7f, 0x74, 0xf1, 0x89, 0x74, 0xb4, 0x81, 0xc2, 0xe7, 0xd9, 0x19, 0x21, 0x5a, 0x3e, 0xf4, 0x1a,
	0x72, 0x09, 0xa1, 0xc7, 0xbc, 0x01, 0x1d, 0x6a, 0x69, 0xd1, 0xd9, 0x03, 0x3d, 0x7e, 0x0a, 0xf5,
	0xd9, 0x53, 0xa8, 0x77, 0xc4, 0x53, 0x88, 0xd7, 0x63, 0xf6, 0x81, 0x20, 0x97, 0x9e, 0x01, 0x5c,
	0x27, 0x8e, 0x8c, 0x58, 0x6f, 0x7e, 0x30, 0x1a, 0xf5, 0xc3, 0x25, 0xaf, 0x29, 0x90, 0x69, 0x9a,
	0xd6, 0x49, 0x0b, 0xbf, 0x55, 0x53, 0xfb, 0xfa, 0xf7, 0xab, 0x6d, 0xe9, 0xc7, 0xd5, 0xb6, 0xf4,
	0xeb, 0x6a, 0x5b, 0xfa, 0x58, 0x8c, 0x7b, 0xa4, 0xac, 0xe2, 0xf8, 0xb4, 0x72, 0xcb, 0x03, 0xde,
	0x5d, 0x13, 0x05, 0xec, 0xfc, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x26, 0x48, 0xc9, 0xfc, 0xde, 0x05,
	0x00, 0x00,
}

func (m *EnvoyFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.WorkloadLabels) > 0 {
		for k, _ := range m.WorkloadLabels {
			dAtA[i] = 0xa
			i++
			v := m.WorkloadLabels[k]
			mapSize := 1 + len(k) + sovEnvoyFilter(uint64(len(k))) + 1 + len(v) + sovEnvoyFilter(uint64(len(v)))
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintEnvoyFilter(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvoyFilter_ListenerMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_ListenerMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PortNumber != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.PortNumber))
	}
	if len(m.PortNamePrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.PortNamePrefix)))
		i += copy(dAtA[i:], m.PortNamePrefix)
	}
	if m.ListenerType != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ListenerType))
	}
	if m.ListenerProtocol != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ListenerProtocol))
	}
	if len(m.Address) > 0 {
		for _, s := range m.Address {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvoyFilter_InsertPosition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_InsertPosition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Index != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.Index))
	}
	if len(m.RelativeTo) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.RelativeTo)))
		i += copy(dAtA[i:], m.RelativeTo)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EnvoyFilter_Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvoyFilter_Filter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ListenerMatch != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.ListenerMatch.Size()))
		n1, err := m.ListenerMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.InsertPosition != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.InsertPosition.Size()))
		n2, err := m.InsertPosition.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.FilterType != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.FilterType))
	}
	if len(m.FilterName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(len(m.FilterName)))
		i += copy(dAtA[i:], m.FilterName)
	}
	if m.FilterConfig != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintEnvoyFilter(dAtA, i, uint64(m.FilterConfig.Size()))
		n3, err := m.FilterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintEnvoyFilter(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *EnvoyFilter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.WorkloadLabels) > 0 {
		for k, v := range m.WorkloadLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovEnvoyFilter(uint64(len(k))) + 1 + len(v) + sovEnvoyFilter(uint64(len(v)))
			n += mapEntrySize + 1 + sovEnvoyFilter(uint64(mapEntrySize))
		}
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_ListenerMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PortNumber != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.PortNumber))
	}
	l = len(m.PortNamePrefix)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.ListenerType != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ListenerType))
	}
	if m.ListenerProtocol != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.ListenerProtocol))
	}
	if len(m.Address) > 0 {
		for _, s := range m.Address {
			l = len(s)
			n += 1 + l + sovEnvoyFilter(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_InsertPosition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.Index))
	}
	l = len(m.RelativeTo)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvoyFilter_Filter) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ListenerMatch != nil {
		l = m.ListenerMatch.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.InsertPosition != nil {
		l = m.InsertPosition.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterType != 0 {
		n += 1 + sovEnvoyFilter(uint64(m.FilterType))
	}
	l = len(m.FilterName)
	if l > 0 {
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.FilterConfig != nil {
		l = m.FilterConfig.Size()
		n += 1 + l + sovEnvoyFilter(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEnvoyFilter(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozEnvoyFilter(x uint64) (n int) {
	return sovEnvoyFilter(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EnvoyFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkloadLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WorkloadLabels == nil {
				m.WorkloadLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEnvoyFilter
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEnvoyFilter
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.WorkloadLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &EnvoyFilter_Filter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_ListenerMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenerMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenerMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNumber", wireType)
			}
			m.PortNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PortNumber |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortNamePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortNamePrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerType", wireType)
			}
			m.ListenerType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ListenerType |= EnvoyFilter_ListenerMatch_ListenerType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerProtocol", wireType)
			}
			m.ListenerProtocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ListenerProtocol |= EnvoyFilter_ListenerMatch_ListenerProtocol(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = append(m.Address, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_InsertPosition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InsertPosition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InsertPosition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= EnvoyFilter_InsertPosition_Index(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelativeTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RelativeTo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvoyFilter_Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListenerMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ListenerMatch == nil {
				m.ListenerMatch = &EnvoyFilter_ListenerMatch{}
			}
			if err := m.ListenerMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InsertPosition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InsertPosition == nil {
				m.InsertPosition = &EnvoyFilter_InsertPosition{}
			}
			if err := m.InsertPosition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterType", wireType)
			}
			m.FilterType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilterType |= EnvoyFilter_Filter_FilterType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterConfig == nil {
				m.FilterConfig = &types.Struct{}
			}
			if err := m.FilterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEnvoyFilter(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEnvoyFilter
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEnvoyFilter(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEnvoyFilter
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEnvoyFilter
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthEnvoyFilter
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowEnvoyFilter
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipEnvoyFilter(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthEnvoyFilter
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthEnvoyFilter = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEnvoyFilter   = fmt.Errorf("proto: integer overflow")
)
