package v1

import (
	"encoding/json"

	meshv1alpha1 "istio.io/api/mesh/v1alpha1"
)

// DeepCopyInto is a custom deepcopy function for MeshNetworksType, copying the receiver, writing into out. in must be non-nil.
func (in MeshNetworksType) DeepCopyInto(out *MeshNetworksType) {
	{
		in := &in
		*out = make(MeshNetworksType, len(*in))
		for key, val := range *in {
			(*out)[key] = deepCopyMeshNetwork(val)
		}
		return
	}
}

func deepCopyMeshNetwork(in meshv1alpha1.Network) meshv1alpha1.Network {
	data, err := in.Marshal()
	if err != nil {
		// panic???
		return meshv1alpha1.Network{}
	}
	out := meshv1alpha1.Network{}
	err = out.Unmarshal(data)
	if err != nil {
		// panic???
		return out
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in HelmValuesType) DeepCopyInto(out *HelmValuesType) {
    *out = HelmValuesType{}
    data, err := json.Marshal(in)
    if err != nil {
        // panic ???
        return
    }
    err = json.Unmarshal(data, out)
    if err != nil {
        // panic ???
        return
    }
    return
}

