/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	configsv1alpha1 "knative.dev/eventing/pkg/apis/configs/v1alpha1"
	versioned "knative.dev/eventing/pkg/client/clientset/versioned"
	internalinterfaces "knative.dev/eventing/pkg/client/informers/externalversions/internalinterfaces"
	v1alpha1 "knative.dev/eventing/pkg/client/listers/configs/v1alpha1"
)

// ConfigMapPropagationInformer provides access to a shared informer and lister for
// ConfigMapPropagations.
type ConfigMapPropagationInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ConfigMapPropagationLister
}

type configMapPropagationInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewConfigMapPropagationInformer constructs a new informer for ConfigMapPropagation type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewConfigMapPropagationInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredConfigMapPropagationInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredConfigMapPropagationInformer constructs a new informer for ConfigMapPropagation type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredConfigMapPropagationInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ConfigsV1alpha1().ConfigMapPropagations(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ConfigsV1alpha1().ConfigMapPropagations(namespace).Watch(options)
			},
		},
		&configsv1alpha1.ConfigMapPropagation{},
		resyncPeriod,
		indexers,
	)
}

func (f *configMapPropagationInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredConfigMapPropagationInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *configMapPropagationInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&configsv1alpha1.ConfigMapPropagation{}, f.defaultInformer)
}

func (f *configMapPropagationInformer) Lister() v1alpha1.ConfigMapPropagationLister {
	return v1alpha1.NewConfigMapPropagationLister(f.Informer().GetIndexer())
}
