/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IntegrationLister helps list Integrations.
type IntegrationLister interface {
	// List lists all Integrations in the indexer.
	List(selector labels.Selector) (ret []*v1.Integration, err error)
	// Integrations returns an object that can list and get Integrations.
	Integrations(namespace string) IntegrationNamespaceLister
	IntegrationListerExpansion
}

// integrationLister implements the IntegrationLister interface.
type integrationLister struct {
	indexer cache.Indexer
}

// NewIntegrationLister returns a new IntegrationLister.
func NewIntegrationLister(indexer cache.Indexer) IntegrationLister {
	return &integrationLister{indexer: indexer}
}

// List lists all Integrations in the indexer.
func (s *integrationLister) List(selector labels.Selector) (ret []*v1.Integration, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Integration))
	})
	return ret, err
}

// Integrations returns an object that can list and get Integrations.
func (s *integrationLister) Integrations(namespace string) IntegrationNamespaceLister {
	return integrationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// IntegrationNamespaceLister helps list and get Integrations.
type IntegrationNamespaceLister interface {
	// List lists all Integrations in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.Integration, err error)
	// Get retrieves the Integration from the indexer for a given namespace and name.
	Get(name string) (*v1.Integration, error)
	IntegrationNamespaceListerExpansion
}

// integrationNamespaceLister implements the IntegrationNamespaceLister
// interface.
type integrationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Integrations in the indexer for a given namespace.
func (s integrationNamespaceLister) List(selector labels.Selector) (ret []*v1.Integration, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Integration))
	})
	return ret, err
}

// Get retrieves the Integration from the indexer for a given namespace and name.
func (s integrationNamespaceLister) Get(name string) (*v1.Integration, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("integration"), name)
	}
	return obj.(*v1.Integration), nil
}
