/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/eventing-contrib/github/pkg/apis/bindings/v1alpha1"
	scheme "knative.dev/eventing-contrib/github/pkg/client/clientset/versioned/scheme"
)

// GitHubBindingsGetter has a method to return a GitHubBindingInterface.
// A group's client should implement this interface.
type GitHubBindingsGetter interface {
	GitHubBindings(namespace string) GitHubBindingInterface
}

// GitHubBindingInterface has methods to work with GitHubBinding resources.
type GitHubBindingInterface interface {
	Create(*v1alpha1.GitHubBinding) (*v1alpha1.GitHubBinding, error)
	Update(*v1alpha1.GitHubBinding) (*v1alpha1.GitHubBinding, error)
	UpdateStatus(*v1alpha1.GitHubBinding) (*v1alpha1.GitHubBinding, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.GitHubBinding, error)
	List(opts v1.ListOptions) (*v1alpha1.GitHubBindingList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GitHubBinding, err error)
	GitHubBindingExpansion
}

// gitHubBindings implements GitHubBindingInterface
type gitHubBindings struct {
	client rest.Interface
	ns     string
}

// newGitHubBindings returns a GitHubBindings
func newGitHubBindings(c *BindingsV1alpha1Client, namespace string) *gitHubBindings {
	return &gitHubBindings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the gitHubBinding, and returns the corresponding gitHubBinding object, and an error if there is any.
func (c *gitHubBindings) Get(name string, options v1.GetOptions) (result *v1alpha1.GitHubBinding, err error) {
	result = &v1alpha1.GitHubBinding{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("githubbindings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of GitHubBindings that match those selectors.
func (c *gitHubBindings) List(opts v1.ListOptions) (result *v1alpha1.GitHubBindingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.GitHubBindingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("githubbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested gitHubBindings.
func (c *gitHubBindings) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("githubbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a gitHubBinding and creates it.  Returns the server's representation of the gitHubBinding, and an error, if there is any.
func (c *gitHubBindings) Create(gitHubBinding *v1alpha1.GitHubBinding) (result *v1alpha1.GitHubBinding, err error) {
	result = &v1alpha1.GitHubBinding{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("githubbindings").
		Body(gitHubBinding).
		Do().
		Into(result)
	return
}

// Update takes the representation of a gitHubBinding and updates it. Returns the server's representation of the gitHubBinding, and an error, if there is any.
func (c *gitHubBindings) Update(gitHubBinding *v1alpha1.GitHubBinding) (result *v1alpha1.GitHubBinding, err error) {
	result = &v1alpha1.GitHubBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("githubbindings").
		Name(gitHubBinding.Name).
		Body(gitHubBinding).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *gitHubBindings) UpdateStatus(gitHubBinding *v1alpha1.GitHubBinding) (result *v1alpha1.GitHubBinding, err error) {
	result = &v1alpha1.GitHubBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("githubbindings").
		Name(gitHubBinding.Name).
		SubResource("status").
		Body(gitHubBinding).
		Do().
		Into(result)
	return
}

// Delete takes name of the gitHubBinding and deletes it. Returns an error if one occurs.
func (c *gitHubBindings) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("githubbindings").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *gitHubBindings) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("githubbindings").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched gitHubBinding.
func (c *gitHubBindings) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GitHubBinding, err error) {
	result = &v1alpha1.GitHubBinding{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("githubbindings").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
