// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/virtual_service.proto

// Configuration affecting traffic routing. Here are a few terms useful to define
// in the context of traffic routing.
//
// `Service` a unit of application behavior bound to a unique name in a
// service registry. Services consist of multiple network *endpoints*
// implemented by workload instances running on pods, containers, VMs etc.
//
// `Service versions (a.k.a. subsets)` - In a continuous deployment
// scenario, for a given service, there can be distinct subsets of
// instances running different variants of the application binary. These
// variants are not necessarily different API versions. They could be
// iterative changes to the same service, deployed in different
// environments (prod, staging, dev, etc.). Common scenarios where this
// occurs include A/B testing, canary rollouts, etc. The choice of a
// particular version can be decided based on various criterion (headers,
// url, etc.) and/or by weights assigned to each version. Each service has
// a default version consisting of all its instances.
//
// `Source` - A downstream client calling a service.
//
// `Host` - The address used by a client when attempting to connect to a
// service.
//
// `Access model` - Applications address only the destination service
// (Host) without knowledge of individual service versions (subsets). The
// actual choice of the version is determined by the proxy/sidecar, enabling the
// application code to decouple itself from the evolution of dependent
// services.
//
// A `VirtualService` defines a set of traffic routing rules to apply when a host is
// addressed. Each routing rule defines matching criteria for traffic of a specific
// protocol. If the traffic is matched, then it is sent to a named destination service
// (or subset/version of it) defined in the registry.
//
// The source of traffic can also be matched in a routing rule. This allows routing
// to be customized for specific client contexts.
//
// The following example on Kubernetes, routes all HTTP traffic by default to
// pods of the reviews service with label "version: v1". In addition,
// HTTP requests with path starting with /wpcatalog/ or /consumercatalog/ will
// be rewritten to /newcatalog and sent to pods with label "version: v2".
//
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   http:
//   - name: "reviews-v2-routes"
//     match:
//     - uri:
//         prefix: "/wpcatalog"
//     - uri:
//         prefix: "/consumercatalog"
//     rewrite:
//       uri: "/newcatalog"
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v2
//   - name: "reviews-v1-route"
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v1
// ```
//
// A subset/version of a route destination is identified with a reference
// to a named service subset which must be declared in a corresponding
// `DestinationRule`.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: reviews-destination
// spec:
//   host: reviews.prod.svc.cluster.local
//   subsets:
//   - name: v1
//     labels:
//       version: v1
//   - name: v2
//     labels:
//       version: v2
// ```
//

package v1alpha3

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	io "io"
	_ "istio.io/gogo-genproto/googleapis/google/api"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Configuration affecting traffic routing.
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type VirtualService struct {
	// The destination hosts to which traffic is being sent. Could
	// be a DNS name with wildcard prefix or an IP address.  Depending on the
	// platform, short-names can also be used instead of a FQDN (i.e. has no
	// dots in the name). In such a scenario, the FQDN of the host would be
	// derived based on the underlying platform.
	//
	// A single VirtualService can be used to describe all the traffic
	// properties of the corresponding hosts, including those for multiple
	// HTTP and TCP ports. Alternatively, the traffic properties of a host
	// can be defined using more than one VirtualService, with certain
	// caveats. Refer to the
	// [Operations Guide](https://istio.io/docs/ops/traffic-management/deploy-guidelines/#multiple-virtual-services-and-destination-rules-for-the-same-host)
	// for details.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews" will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. _To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names._
	//
	// The hosts field applies to both HTTP and TCP services. Service inside
	// the mesh, i.e., those found in the service registry, must always be
	// referred to using their alphanumeric names. IP addresses are allowed
	// only for services defined via the Gateway.
	Hosts []string `protobuf:"bytes,1,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// The names of gateways and sidecars that should apply these routes. A
	// single VirtualService is used for sidecars inside the mesh as well as
	// for one or more gateways. The selection condition imposed by this
	// field can be overridden using the source field in the match conditions
	// of protocol-specific routes. The reserved word `mesh` is used to imply
	// all the sidecars in the mesh. When this field is omitted, the default
	// gateway (`mesh`) will be used, which would apply the rule to all
	// sidecars in the mesh. If a list of gateway names is provided, the
	// rules will apply only to the gateways. To apply the rules to both
	// gateways and sidecars, specify `mesh` as one of the gateway names.
	Gateways []string `protobuf:"bytes,2,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// An ordered list of route rules for HTTP traffic. HTTP routes will be
	// applied to platform service ports named 'http-*'/'http2-*'/'grpc-*', gateway
	// ports with protocol HTTP/HTTP2/GRPC/ TLS-terminated-HTTPS and service
	// entry ports using HTTP/HTTP2/GRPC protocols.  The first rule matching
	// an incoming request is used.
	Http []*HTTPRoute `protobuf:"bytes,3,rep,name=http,proto3" json:"http,omitempty"`
	// An ordered list of route rule for non-terminated TLS & HTTPS
	// traffic. Routing is typically performed using the SNI value presented
	// by the ClientHello message. TLS routes will be applied to platform
	// service ports named 'https-*', 'tls-*', unterminated gateway ports using
	// HTTPS/TLS protocols (i.e. with "passthrough" TLS mode) and service
	// entry ports using HTTPS/TLS protocols.  The first rule matching an
	// incoming request is used.  NOTE: Traffic 'https-*' or 'tls-*' ports
	// without associated virtual service will be treated as opaque TCP
	// traffic.
	Tls []*TLSRoute `protobuf:"bytes,5,rep,name=tls,proto3" json:"tls,omitempty"`
	// An ordered list of route rules for opaque TCP traffic. TCP routes will
	// be applied to any port that is not a HTTP or TLS port. The first rule
	// matching an incoming request is used.
	Tcp []*TCPRoute `protobuf:"bytes,4,rep,name=tcp,proto3" json:"tcp,omitempty"`
	// A list of namespaces to which this virtual service is exported. Exporting a
	// virtual service allows it to be used by sidecars and gateways defined in
	// other namespaces. This feature provides a mechanism for service owners
	// and mesh administrators to control the visibility of virtual services
	// across namespace boundaries.
	//
	// If no namespaces are specified then the virtual service is exported to all
	// namespaces by default.
	//
	// The value "." is reserved and defines an export to the same namespace that
	// the virtual service is declared in. Similarly the value "*" is reserved and
	// defines an export to all namespaces.
	//
	// NOTE: in the current release, the `exportTo` value is restricted to
	// "." or "*" (i.e., the current namespace or all namespaces).
	ExportTo             []string `protobuf:"bytes,6,rep,name=export_to,json=exportTo,proto3" json:"export_to,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VirtualService) Reset()         { *m = VirtualService{} }
func (m *VirtualService) String() string { return proto.CompactTextString(m) }
func (*VirtualService) ProtoMessage()    {}
func (*VirtualService) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{0}
}
func (m *VirtualService) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VirtualService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VirtualService.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VirtualService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VirtualService.Merge(m, src)
}
func (m *VirtualService) XXX_Size() int {
	return m.Size()
}
func (m *VirtualService) XXX_DiscardUnknown() {
	xxx_messageInfo_VirtualService.DiscardUnknown(m)
}

var xxx_messageInfo_VirtualService proto.InternalMessageInfo

func (m *VirtualService) GetHosts() []string {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *VirtualService) GetGateways() []string {
	if m != nil {
		return m.Gateways
	}
	return nil
}

func (m *VirtualService) GetHttp() []*HTTPRoute {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *VirtualService) GetTls() []*TLSRoute {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *VirtualService) GetTcp() []*TCPRoute {
	if m != nil {
		return m.Tcp
	}
	return nil
}

func (m *VirtualService) GetExportTo() []string {
	if m != nil {
		return m.ExportTo
	}
	return nil
}

// Destination indicates the network addressable service to which the
// request/connection will be sent after processing a routing rule. The
// destination.host should unambiguously refer to a service in the service
// registry. Istio's service registry is composed of all the services found
// in the platform's service registry (e.g., Kubernetes services, Consul
// services), as well as services declared through the
// [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry) resource.
//
// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
// instead of "reviews.default.svc.cluster.local"), Istio will interpret
// the short name based on the namespace of the rule, not the service. A
// rule in the "default" namespace containing a host "reviews will be
// interpreted as "reviews.default.svc.cluster.local", irrespective of the
// actual namespace associated with the reviews service. _To avoid potential
// misconfigurations, it is recommended to always use fully qualified
// domain names over short names._
//
// The following Kubernetes example routes all traffic by default to pods
// of the reviews service with label "version: v1" (i.e., subset v1), and
// some to subset v2, in a Kubernetes environment.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route
//   namespace: foo
// spec:
//   hosts:
//   - reviews # interpreted as reviews.foo.svc.cluster.local
//   http:
//   - match:
//     - uri:
//         prefix: "/wpcatalog"
//     - uri:
//         prefix: "/consumercatalog"
//     rewrite:
//       uri: "/newcatalog"
//     route:
//     - destination:
//         host: reviews # interpreted as reviews.foo.svc.cluster.local
//         subset: v2
//   - route:
//     - destination:
//         host: reviews # interpreted as reviews.foo.svc.cluster.local
//         subset: v1
// ```
//
// And the associated DestinationRule
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: reviews-destination
//   namespace: foo
// spec:
//   host: reviews # interpreted as reviews.foo.svc.cluster.local
//   subsets:
//   - name: v1
//     labels:
//       version: v1
//   - name: v2
//     labels:
//       version: v2
// ```
//
// The following VirtualService sets a timeout of 5s for all calls to
// productpage.prod.svc.cluster.local service in Kubernetes. Notice that
// there are no subsets defined in this rule. Istio will fetch all
// instances of productpage.prod.svc.cluster.local service from the service
// registry and populate the sidecar's load balancing pool. Also, notice
// that this rule is set in the istio-system namespace but uses the fully
// qualified domain name of the productpage service,
// productpage.prod.svc.cluster.local. Therefore the rule's namespace does
// not have an impact in resolving the name of the productpage service.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: my-productpage-rule
//   namespace: istio-system
// spec:
//   hosts:
//   - productpage.prod.svc.cluster.local # ignores rule namespace
//   http:
//   - timeout: 5s
//     route:
//     - destination:
//         host: productpage.prod.svc.cluster.local
// ```
//
// To control routing for traffic bound to services outside the mesh, external
// services must first be added to Istio's internal service registry using the
// ServiceEntry resource. VirtualServices can then be defined to control traffic
// bound to these external services. For example, the following rules define a
// Service for wikipedia.org and set a timeout of 5s for http requests.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: ServiceEntry
// metadata:
//   name: external-svc-wikipedia
// spec:
//   hosts:
//   - wikipedia.org
//   location: MESH_EXTERNAL
//   ports:
//   - number: 80
//     name: example-http
//     protocol: HTTP
//   resolution: DNS
//
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: my-wiki-rule
// spec:
//   hosts:
//   - wikipedia.org
//   http:
//   - timeout: 5s
//     route:
//     - destination:
//         host: wikipedia.org
// ```
type Destination struct {
	// The name of a service from the service registry. Service
	// names are looked up from the platform's service registry (e.g.,
	// Kubernetes services, Consul services, etc.) and from the hosts
	// declared by [ServiceEntry](https://istio.io/docs/reference/config/networking/service-entry/#ServiceEntry). Traffic forwarded to
	// destinations that are not found in either of the two, will be dropped.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. _To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names._
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// The name of a subset within the service. Applicable only to services
	// within the mesh. The subset must be defined in a corresponding
	// DestinationRule.
	Subset string `protobuf:"bytes,2,opt,name=subset,proto3" json:"subset,omitempty"`
	// Specifies the port on the host that is being addressed. If a service
	// exposes only a single port it is not required to explicitly select the
	// port.
	Port                 *PortSelector `protobuf:"bytes,3,opt,name=port,proto3" json:"port,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Destination) Reset()         { *m = Destination{} }
func (m *Destination) String() string { return proto.CompactTextString(m) }
func (*Destination) ProtoMessage()    {}
func (*Destination) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{1}
}
func (m *Destination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Destination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Destination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Destination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Destination.Merge(m, src)
}
func (m *Destination) XXX_Size() int {
	return m.Size()
}
func (m *Destination) XXX_DiscardUnknown() {
	xxx_messageInfo_Destination.DiscardUnknown(m)
}

var xxx_messageInfo_Destination proto.InternalMessageInfo

func (m *Destination) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Destination) GetSubset() string {
	if m != nil {
		return m.Subset
	}
	return ""
}

func (m *Destination) GetPort() *PortSelector {
	if m != nil {
		return m.Port
	}
	return nil
}

// Describes match conditions and actions for routing HTTP/1.1, HTTP2, and
// gRPC traffic. See VirtualService for usage examples.
type HTTPRoute struct {
	// The name assigned to the route for debugging purposes. The
	// route's name will be concatenated with the match's name and will
	// be logged in the access logs for requests matching this
	// route/match.
	Name string `protobuf:"bytes,17,opt,name=name,proto3" json:"name,omitempty"`
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*HTTPMatchRequest `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// A http rule can either redirect or forward (default) traffic. The
	// forwarding target can be one of several versions of a service (see
	// glossary in beginning of document). Weights associated with the
	// service version determine the proportion of traffic it receives.
	Route []*HTTPRouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	// A http rule can either redirect or forward (default) traffic. If
	// traffic passthrough option is specified in the rule,
	// route/redirect will be ignored. The redirect primitive can be used to
	// send a HTTP 301 redirect to a different URI or Authority.
	Redirect *HTTPRedirect `protobuf:"bytes,3,opt,name=redirect,proto3" json:"redirect,omitempty"`
	// Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
	// Redirect primitive. Rewrite will be performed before forwarding.
	Rewrite *HTTPRewrite `protobuf:"bytes,4,opt,name=rewrite,proto3" json:"rewrite,omitempty"`
	// Deprecated. Websocket upgrades are done automatically starting from Istio 1.0.
	// $hide_from_docs
	WebsocketUpgrade bool `protobuf:"varint,5,opt,name=websocket_upgrade,json=websocketUpgrade,proto3" json:"websocket_upgrade,omitempty"`
	// Timeout for HTTP requests.
	Timeout *types.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Retry policy for HTTP requests.
	Retries *HTTPRetry `protobuf:"bytes,7,opt,name=retries,proto3" json:"retries,omitempty"`
	// Fault injection policy to apply on HTTP traffic at the client side.
	// Note that timeouts or retries will not be enabled when faults are
	// enabled on the client side.
	Fault *HTTPFaultInjection `protobuf:"bytes,8,opt,name=fault,proto3" json:"fault,omitempty"`
	// Mirror HTTP traffic to a another destination in addition to forwarding
	// the requests to the intended destination. Mirrored traffic is on a
	// best effort basis where the sidecar/gateway will not wait for the
	// mirrored cluster to respond before returning the response from the
	// original destination.  Statistics will be generated for the mirrored
	// destination.
	Mirror *Destination `protobuf:"bytes,9,opt,name=mirror,proto3" json:"mirror,omitempty"`
	// Percentage of the traffic to be mirrored by the `mirror` field.
	// If this field is absent, all the traffic (100%) will be mirrored.
	// Max value is 100.
	MirrorPercent *types.UInt32Value `protobuf:"bytes,18,opt,name=mirror_percent,json=mirrorPercent,proto3" json:"mirror_percent,omitempty"`
	// Cross-Origin Resource Sharing policy (CORS). Refer to
	// [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
	// for further details about cross origin resource sharing.
	CorsPolicy *CorsPolicy `protobuf:"bytes,10,opt,name=cors_policy,json=corsPolicy,proto3" json:"cors_policy,omitempty"`
	// $hide_from_docs
	AppendHeaders map[string]string `protobuf:"bytes,11,rep,name=append_headers,json=appendHeaders,proto3" json:"append_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// $hide_from_docs
	RemoveResponseHeaders []string `protobuf:"bytes,12,rep,name=remove_response_headers,json=removeResponseHeaders,proto3" json:"remove_response_headers,omitempty"` // Deprecated: Do not use.
	// $hide_from_docs
	AppendResponseHeaders map[string]string `protobuf:"bytes,13,rep,name=append_response_headers,json=appendResponseHeaders,proto3" json:"append_response_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// $hide_from_docs
	RemoveRequestHeaders []string `protobuf:"bytes,14,rep,name=remove_request_headers,json=removeRequestHeaders,proto3" json:"remove_request_headers,omitempty"` // Deprecated: Do not use.
	// $hide_from_docs
	AppendRequestHeaders map[string]string `protobuf:"bytes,15,rep,name=append_request_headers,json=appendRequestHeaders,proto3" json:"append_request_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// Header manipulation rules
	Headers              *Headers `protobuf:"bytes,16,opt,name=headers,proto3" json:"headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPRoute) Reset()         { *m = HTTPRoute{} }
func (m *HTTPRoute) String() string { return proto.CompactTextString(m) }
func (*HTTPRoute) ProtoMessage()    {}
func (*HTTPRoute) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{2}
}
func (m *HTTPRoute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRoute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPRoute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPRoute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRoute.Merge(m, src)
}
func (m *HTTPRoute) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRoute) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRoute.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRoute proto.InternalMessageInfo

func (m *HTTPRoute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPRoute) GetMatch() []*HTTPMatchRequest {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *HTTPRoute) GetRoute() []*HTTPRouteDestination {
	if m != nil {
		return m.Route
	}
	return nil
}

func (m *HTTPRoute) GetRedirect() *HTTPRedirect {
	if m != nil {
		return m.Redirect
	}
	return nil
}

func (m *HTTPRoute) GetRewrite() *HTTPRewrite {
	if m != nil {
		return m.Rewrite
	}
	return nil
}

func (m *HTTPRoute) GetWebsocketUpgrade() bool {
	if m != nil {
		return m.WebsocketUpgrade
	}
	return false
}

func (m *HTTPRoute) GetTimeout() *types.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *HTTPRoute) GetRetries() *HTTPRetry {
	if m != nil {
		return m.Retries
	}
	return nil
}

func (m *HTTPRoute) GetFault() *HTTPFaultInjection {
	if m != nil {
		return m.Fault
	}
	return nil
}

func (m *HTTPRoute) GetMirror() *Destination {
	if m != nil {
		return m.Mirror
	}
	return nil
}

func (m *HTTPRoute) GetMirrorPercent() *types.UInt32Value {
	if m != nil {
		return m.MirrorPercent
	}
	return nil
}

func (m *HTTPRoute) GetCorsPolicy() *CorsPolicy {
	if m != nil {
		return m.CorsPolicy
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRoute) GetAppendHeaders() map[string]string {
	if m != nil {
		return m.AppendHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRoute) GetRemoveResponseHeaders() []string {
	if m != nil {
		return m.RemoveResponseHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRoute) GetAppendResponseHeaders() map[string]string {
	if m != nil {
		return m.AppendResponseHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRoute) GetRemoveRequestHeaders() []string {
	if m != nil {
		return m.RemoveRequestHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRoute) GetAppendRequestHeaders() map[string]string {
	if m != nil {
		return m.AppendRequestHeaders
	}
	return nil
}

func (m *HTTPRoute) GetHeaders() *Headers {
	if m != nil {
		return m.Headers
	}
	return nil
}

// Message headers can be manipulated when Envoy forwards requests to,
// or responses from, a destination service. Header manipulation rules can
// be specified for a specific route destination or for all destinations.
// The following VirtualService adds a `test` header with the value `true`
// to requests that are routed to any `reviews` service destination.
// It also romoves the `foo` response header, but only from responses
// coming from the `v1` subset (version) of the `reviews` service.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   http:
//   - headers:
//       request:
//         set:
//           test: true
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v2
//       weight: 25
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v1
//       headers:
//         response:
//           remove:
//           - foo
//       weight: 75
// ```
type Headers struct {
	// Header manipulation rules to apply before forwarding a request
	// to the destination service
	Request *Headers_HeaderOperations `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
	// Header manipulation rules to apply before returning a response
	// to the caller
	Response             *Headers_HeaderOperations `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Headers) Reset()         { *m = Headers{} }
func (m *Headers) String() string { return proto.CompactTextString(m) }
func (*Headers) ProtoMessage()    {}
func (*Headers) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{3}
}
func (m *Headers) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Headers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Headers.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Headers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Headers.Merge(m, src)
}
func (m *Headers) XXX_Size() int {
	return m.Size()
}
func (m *Headers) XXX_DiscardUnknown() {
	xxx_messageInfo_Headers.DiscardUnknown(m)
}

var xxx_messageInfo_Headers proto.InternalMessageInfo

func (m *Headers) GetRequest() *Headers_HeaderOperations {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *Headers) GetResponse() *Headers_HeaderOperations {
	if m != nil {
		return m.Response
	}
	return nil
}

// HeaderOperations Describes the header manipulations to apply
type Headers_HeaderOperations struct {
	// Overwrite the headers specified by key with the given values
	Set map[string]string `protobuf:"bytes,1,rep,name=set,proto3" json:"set,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Append the given values to the headers specified by keys
	// (will create a comma-separated list of values)
	Add map[string]string `protobuf:"bytes,2,rep,name=add,proto3" json:"add,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Remove a the specified headers
	Remove               []string `protobuf:"bytes,3,rep,name=remove,proto3" json:"remove,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Headers_HeaderOperations) Reset()         { *m = Headers_HeaderOperations{} }
func (m *Headers_HeaderOperations) String() string { return proto.CompactTextString(m) }
func (*Headers_HeaderOperations) ProtoMessage()    {}
func (*Headers_HeaderOperations) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{3, 0}
}
func (m *Headers_HeaderOperations) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Headers_HeaderOperations) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Headers_HeaderOperations.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Headers_HeaderOperations) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Headers_HeaderOperations.Merge(m, src)
}
func (m *Headers_HeaderOperations) XXX_Size() int {
	return m.Size()
}
func (m *Headers_HeaderOperations) XXX_DiscardUnknown() {
	xxx_messageInfo_Headers_HeaderOperations.DiscardUnknown(m)
}

var xxx_messageInfo_Headers_HeaderOperations proto.InternalMessageInfo

func (m *Headers_HeaderOperations) GetSet() map[string]string {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Headers_HeaderOperations) GetAdd() map[string]string {
	if m != nil {
		return m.Add
	}
	return nil
}

func (m *Headers_HeaderOperations) GetRemove() []string {
	if m != nil {
		return m.Remove
	}
	return nil
}

// Describes match conditions and actions for routing unterminated TLS
// traffic (TLS/HTTPS) The following routing rule forwards unterminated TLS
// traffic arriving at port 443 of gateway called "mygateway" to internal
// services in the mesh based on the SNI value.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-sni
// spec:
//   hosts:
//   - "*.bookinfo.com"
//   gateways:
//   - mygateway
//   tls:
//   - match:
//     - port: 443
//       sniHosts:
//       - login.bookinfo.com
//     route:
//     - destination:
//         host: login.prod.svc.cluster.local
//   - match:
//     - port: 443
//       sniHosts:
//       - reviews.bookinfo.com
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
// ```
type TLSRoute struct {
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*TLSMatchAttributes `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// The destination to which the connection should be forwarded to.
	Route                []*RouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TLSRoute) Reset()         { *m = TLSRoute{} }
func (m *TLSRoute) String() string { return proto.CompactTextString(m) }
func (*TLSRoute) ProtoMessage()    {}
func (*TLSRoute) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{4}
}
func (m *TLSRoute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSRoute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSRoute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TLSRoute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSRoute.Merge(m, src)
}
func (m *TLSRoute) XXX_Size() int {
	return m.Size()
}
func (m *TLSRoute) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSRoute.DiscardUnknown(m)
}

var xxx_messageInfo_TLSRoute proto.InternalMessageInfo

func (m *TLSRoute) GetMatch() []*TLSMatchAttributes {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *TLSRoute) GetRoute() []*RouteDestination {
	if m != nil {
		return m.Route
	}
	return nil
}

// Describes match conditions and actions for routing TCP traffic. The
// following routing rule forwards traffic arriving at port 27017 for
// mongo.prod.svc.cluster.local to another Mongo server on port 5555.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: bookinfo-Mongo
// spec:
//   hosts:
//   - mongo.prod.svc.cluster.local
//   tcp:
//   - match:
//     - port: 27017
//     route:
//     - destination:
//         host: mongo.backup.svc.cluster.local
//         port:
//           number: 5555
// ```
type TCPRoute struct {
	// Match conditions to be satisfied for the rule to be
	// activated. All conditions inside a single match block have AND
	// semantics, while the list of match blocks have OR semantics. The rule
	// is matched if any one of the match blocks succeed.
	Match []*L4MatchAttributes `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
	// The destination to which the connection should be forwarded to.
	Route                []*RouteDestination `protobuf:"bytes,2,rep,name=route,proto3" json:"route,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TCPRoute) Reset()         { *m = TCPRoute{} }
func (m *TCPRoute) String() string { return proto.CompactTextString(m) }
func (*TCPRoute) ProtoMessage()    {}
func (*TCPRoute) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{5}
}
func (m *TCPRoute) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPRoute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TCPRoute.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TCPRoute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPRoute.Merge(m, src)
}
func (m *TCPRoute) XXX_Size() int {
	return m.Size()
}
func (m *TCPRoute) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPRoute.DiscardUnknown(m)
}

var xxx_messageInfo_TCPRoute proto.InternalMessageInfo

func (m *TCPRoute) GetMatch() []*L4MatchAttributes {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *TCPRoute) GetRoute() []*RouteDestination {
	if m != nil {
		return m.Route
	}
	return nil
}

// HttpMatchRequest specifies a set of criterion to be met in order for the
// rule to be applied to the HTTP request. For example, the following
// restricts the rule to match only requests where the URL path
// starts with /ratings/v2/ and the request contains a custom `end-user` header
// with value `jason`.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - match:
//     - headers:
//         end-user:
//           exact: jason
//       uri:
//         prefix: "/ratings/v2/"
//       ignoreUriCase: true
//     route:
//     - destination:
//         host: ratings.prod.svc.cluster.local
// ```
//
// HTTPMatchRequest CANNOT be empty.
type HTTPMatchRequest struct {
	// The name assigned to a match. The match's name will be
	// concatenated with the parent route's name and will be logged in
	// the access logs for requests matching this route.
	Name string `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// URI to match
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for ECMAscript style regex-based match
	//
	// **Note:** Case-insensitive matching could be enabled via the
	// `ignore_uri_case` flag.
	Uri *StringMatch `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI Scheme
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for ECMAscript style regex-based match
	//
	Scheme *StringMatch `protobuf:"bytes,2,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// HTTP Method
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for ECMAscript style regex-based match
	//
	Method *StringMatch `protobuf:"bytes,3,opt,name=method,proto3" json:"method,omitempty"`
	// HTTP Authority
	// values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for ECMAscript style regex-based match
	//
	Authority *StringMatch `protobuf:"bytes,4,opt,name=authority,proto3" json:"authority,omitempty"`
	// The header keys must be lowercase and use hyphen as the separator,
	// e.g. _x-request-id_.
	//
	// Header values are case-sensitive and formatted as follows:
	//
	// - `exact: "value"` for exact string match
	//
	// - `prefix: "value"` for prefix-based match
	//
	// - `regex: "value"` for ECMAscript style regex-based match
	//
	// **Note:** The keys `uri`, `scheme`, `method`, and `authority` will be ignored.
	Headers map[string]*StringMatch `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies the ports on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they support,
	// in these cases it is not required to explicitly select the port.
	Port uint32 `protobuf:"varint,6,opt,name=port,proto3" json:"port,omitempty"`
	// One or more labels that constrain the applicability of a rule to
	// workloads with the given labels. If the VirtualService has a list of
	// gateways specified at the top, it must include the reserved gateway
	// `mesh` for this field to be applicable.
	SourceLabels map[string]string `protobuf:"bytes,7,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// $hide_from_docs
	Gateways []string `protobuf:"bytes,8,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Query parameters for matching.
	//
	// Ex:
	// - For a query parameter like "?key=true", the map key would be "key" and
	//   the string match could be defined as `exact: "true"`.
	// - For a query parameter like "?key", the map key would be "key" and the
	//   string match could be defined as `exact: ""`.
	// - For a query parameter like "?key=123", the map key would be "key" and the
	//   string match could be defined as `regex: "\d+$"`. Note that this
	//   configuration will only match values like "123" but not "a123" or "123a".
	//
	// **Note:** `prefix` matching is currently not supported.
	QueryParams map[string]*StringMatch `protobuf:"bytes,9,rep,name=query_params,json=queryParams,proto3" json:"query_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Flag to specify whether the URI matching should be case-insensitive.
	//
	// **Note:** The case will be ignored only in the case of `exact` and `prefix`
	// URI matches.
	IgnoreUriCase        bool     `protobuf:"varint,10,opt,name=ignore_uri_case,json=ignoreUriCase,proto3" json:"ignore_uri_case,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPMatchRequest) Reset()         { *m = HTTPMatchRequest{} }
func (m *HTTPMatchRequest) String() string { return proto.CompactTextString(m) }
func (*HTTPMatchRequest) ProtoMessage()    {}
func (*HTTPMatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{6}
}
func (m *HTTPMatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPMatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPMatchRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPMatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPMatchRequest.Merge(m, src)
}
func (m *HTTPMatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *HTTPMatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPMatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPMatchRequest proto.InternalMessageInfo

func (m *HTTPMatchRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPMatchRequest) GetUri() *StringMatch {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (m *HTTPMatchRequest) GetScheme() *StringMatch {
	if m != nil {
		return m.Scheme
	}
	return nil
}

func (m *HTTPMatchRequest) GetMethod() *StringMatch {
	if m != nil {
		return m.Method
	}
	return nil
}

func (m *HTTPMatchRequest) GetAuthority() *StringMatch {
	if m != nil {
		return m.Authority
	}
	return nil
}

func (m *HTTPMatchRequest) GetHeaders() map[string]*StringMatch {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HTTPMatchRequest) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HTTPMatchRequest) GetSourceLabels() map[string]string {
	if m != nil {
		return m.SourceLabels
	}
	return nil
}

func (m *HTTPMatchRequest) GetGateways() []string {
	if m != nil {
		return m.Gateways
	}
	return nil
}

func (m *HTTPMatchRequest) GetQueryParams() map[string]*StringMatch {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *HTTPMatchRequest) GetIgnoreUriCase() bool {
	if m != nil {
		return m.IgnoreUriCase
	}
	return false
}

// Each routing rule is associated with one or more service versions (see
// glossary in beginning of document). Weights associated with the version
// determine the proportion of traffic it receives. For example, the
// following rule will route 25% of traffic for the "reviews" service to
// instances with the "v2" tag and the remaining traffic (i.e., 75%) to
// "v1".
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   http:
//   - route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v2
//       weight: 25
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v1
//       weight: 75
// ```
//
// And the associated DestinationRule
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: DestinationRule
// metadata:
//   name: reviews-destination
// spec:
//   host: reviews.prod.svc.cluster.local
//   subsets:
//   - name: v1
//     labels:
//       version: v1
//   - name: v2
//     labels:
//       version: v2
// ```
//
// Traffic can also be split across two entirely different services without
// having to define new subsets. For example, the following rule forwards 25% of
// traffic to reviews.com to dev.reviews.com
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route-two-domains
// spec:
//   hosts:
//   - reviews.com
//   http:
//   - route:
//     - destination:
//         host: dev.reviews.com
//       weight: 25
//     - destination:
//         host: reviews.com
//       weight: 75
// ```
type HTTPRouteDestination struct {
	// Destination uniquely identifies the instances of a service
	// to which the request/connection should be forwarded to.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// The proportion of traffic to be forwarded to the service
	// version. (0-100). Sum of weights across destinations SHOULD BE == 100.
	// If there is only one destination in a rule, the weight value is assumed to
	// be 100.
	Weight int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Use of `remove_response_header` is deprecated. Use the `headers`
	// field instead.
	RemoveResponseHeaders []string `protobuf:"bytes,3,rep,name=remove_response_headers,json=removeResponseHeaders,proto3" json:"remove_response_headers,omitempty"` // Deprecated: Do not use.
	// Use of `append_response_headers` is deprecated. Use the `headers`
	// field instead.
	AppendResponseHeaders map[string]string `protobuf:"bytes,4,rep,name=append_response_headers,json=appendResponseHeaders,proto3" json:"append_response_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// Use of `remove_request_headers` is deprecated. Use the `headers`
	// field instead.
	RemoveRequestHeaders []string `protobuf:"bytes,5,rep,name=remove_request_headers,json=removeRequestHeaders,proto3" json:"remove_request_headers,omitempty"` // Deprecated: Do not use.
	// Use of `append_request_headers` is deprecated. Use the `headers`
	// field instead.
	AppendRequestHeaders map[string]string `protobuf:"bytes,6,rep,name=append_request_headers,json=appendRequestHeaders,proto3" json:"append_request_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Deprecated: Do not use.
	// Header manipulation rules
	Headers              *Headers `protobuf:"bytes,7,opt,name=headers,proto3" json:"headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPRouteDestination) Reset()         { *m = HTTPRouteDestination{} }
func (m *HTTPRouteDestination) String() string { return proto.CompactTextString(m) }
func (*HTTPRouteDestination) ProtoMessage()    {}
func (*HTTPRouteDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{7}
}
func (m *HTTPRouteDestination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRouteDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPRouteDestination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPRouteDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRouteDestination.Merge(m, src)
}
func (m *HTTPRouteDestination) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRouteDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRouteDestination.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRouteDestination proto.InternalMessageInfo

func (m *HTTPRouteDestination) GetDestination() *Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *HTTPRouteDestination) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// Deprecated: Do not use.
func (m *HTTPRouteDestination) GetRemoveResponseHeaders() []string {
	if m != nil {
		return m.RemoveResponseHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRouteDestination) GetAppendResponseHeaders() map[string]string {
	if m != nil {
		return m.AppendResponseHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRouteDestination) GetRemoveRequestHeaders() []string {
	if m != nil {
		return m.RemoveRequestHeaders
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPRouteDestination) GetAppendRequestHeaders() map[string]string {
	if m != nil {
		return m.AppendRequestHeaders
	}
	return nil
}

func (m *HTTPRouteDestination) GetHeaders() *Headers {
	if m != nil {
		return m.Headers
	}
	return nil
}

// L4 routing rule weighted destination.
type RouteDestination struct {
	// Destination uniquely identifies the instances of a service
	// to which the request/connection should be forwarded to.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// The proportion of traffic to be forwarded to the service
	// version. If there is only one destination in a rule, all traffic will be
	// routed to it irrespective of the weight.
	Weight               int32    `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RouteDestination) Reset()         { *m = RouteDestination{} }
func (m *RouteDestination) String() string { return proto.CompactTextString(m) }
func (*RouteDestination) ProtoMessage()    {}
func (*RouteDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{8}
}
func (m *RouteDestination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RouteDestination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RouteDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteDestination.Merge(m, src)
}
func (m *RouteDestination) XXX_Size() int {
	return m.Size()
}
func (m *RouteDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteDestination.DiscardUnknown(m)
}

var xxx_messageInfo_RouteDestination proto.InternalMessageInfo

func (m *RouteDestination) GetDestination() *Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *RouteDestination) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// L4 connection match attributes. Note that L4 connection matching support
// is incomplete.
type L4MatchAttributes struct {
	// IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
	// a.b.c.d/xx form or just a.b.c.d.
	DestinationSubnets []string `protobuf:"bytes,1,rep,name=destination_subnets,json=destinationSubnets,proto3" json:"destination_subnets,omitempty"`
	// Specifies the port on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they support,
	// in these cases it is not required to explicitly select the port.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
	// form or just a.b.c.d
	// $hide_from_docs
	SourceSubnet string `protobuf:"bytes,3,opt,name=source_subnet,json=sourceSubnet,proto3" json:"source_subnet,omitempty"`
	// One or more labels that constrain the applicability of a rule to
	// workloads with the given labels. If the VirtualService has a list of
	// gateways specified at the top, it should include the reserved gateway
	// `mesh` in order for this field to be applicable.
	SourceLabels map[string]string `protobuf:"bytes,4,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Names of gateways where the rule should be applied to. Gateway names
	// at the top of the VirtualService (if any) are overridden. The gateway
	// match is independent of sourceLabels.
	Gateways             []string `protobuf:"bytes,5,rep,name=gateways,proto3" json:"gateways,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *L4MatchAttributes) Reset()         { *m = L4MatchAttributes{} }
func (m *L4MatchAttributes) String() string { return proto.CompactTextString(m) }
func (*L4MatchAttributes) ProtoMessage()    {}
func (*L4MatchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{9}
}
func (m *L4MatchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *L4MatchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_L4MatchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *L4MatchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_L4MatchAttributes.Merge(m, src)
}
func (m *L4MatchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *L4MatchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_L4MatchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_L4MatchAttributes proto.InternalMessageInfo

func (m *L4MatchAttributes) GetDestinationSubnets() []string {
	if m != nil {
		return m.DestinationSubnets
	}
	return nil
}

func (m *L4MatchAttributes) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *L4MatchAttributes) GetSourceSubnet() string {
	if m != nil {
		return m.SourceSubnet
	}
	return ""
}

func (m *L4MatchAttributes) GetSourceLabels() map[string]string {
	if m != nil {
		return m.SourceLabels
	}
	return nil
}

func (m *L4MatchAttributes) GetGateways() []string {
	if m != nil {
		return m.Gateways
	}
	return nil
}

// TLS connection match attributes.
type TLSMatchAttributes struct {
	// SNI (server name indicator) to match on. Wildcard prefixes
	// can be used in the SNI value, e.g., *.com will match foo.example.com
	// as well as example.com. An SNI value must be a subset (i.e., fall
	// within the domain) of the corresponding virtual serivce's hosts.
	SniHosts []string `protobuf:"bytes,1,rep,name=sni_hosts,json=sniHosts,proto3" json:"sni_hosts,omitempty"`
	// IPv4 or IPv6 ip addresses of destination with optional subnet.  E.g.,
	// a.b.c.d/xx form or just a.b.c.d.
	DestinationSubnets []string `protobuf:"bytes,2,rep,name=destination_subnets,json=destinationSubnets,proto3" json:"destination_subnets,omitempty"`
	// Specifies the port on the host that is being addressed. Many services
	// only expose a single port or label ports with the protocols they
	// support, in these cases it is not required to explicitly select the
	// port.
	Port uint32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// IPv4 or IPv6 ip address of source with optional subnet. E.g., a.b.c.d/xx
	// form or just a.b.c.d
	// $hide_from_docs
	SourceSubnet string `protobuf:"bytes,4,opt,name=source_subnet,json=sourceSubnet,proto3" json:"source_subnet,omitempty"`
	// One or more labels that constrain the applicability of a rule to
	// workloads with the given labels. If the VirtualService has a list of
	// gateways specified at the top, it should include the reserved gateway
	// `mesh` in order for this field to be applicable.
	SourceLabels map[string]string `protobuf:"bytes,5,rep,name=source_labels,json=sourceLabels,proto3" json:"source_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Names of gateways where the rule should be applied to. Gateway names
	// at the top of the VirtualService (if any) are overridden. The gateway
	// match is independent of sourceLabels.
	Gateways             []string `protobuf:"bytes,6,rep,name=gateways,proto3" json:"gateways,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TLSMatchAttributes) Reset()         { *m = TLSMatchAttributes{} }
func (m *TLSMatchAttributes) String() string { return proto.CompactTextString(m) }
func (*TLSMatchAttributes) ProtoMessage()    {}
func (*TLSMatchAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{10}
}
func (m *TLSMatchAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSMatchAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSMatchAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TLSMatchAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSMatchAttributes.Merge(m, src)
}
func (m *TLSMatchAttributes) XXX_Size() int {
	return m.Size()
}
func (m *TLSMatchAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSMatchAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_TLSMatchAttributes proto.InternalMessageInfo

func (m *TLSMatchAttributes) GetSniHosts() []string {
	if m != nil {
		return m.SniHosts
	}
	return nil
}

func (m *TLSMatchAttributes) GetDestinationSubnets() []string {
	if m != nil {
		return m.DestinationSubnets
	}
	return nil
}

func (m *TLSMatchAttributes) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *TLSMatchAttributes) GetSourceSubnet() string {
	if m != nil {
		return m.SourceSubnet
	}
	return ""
}

func (m *TLSMatchAttributes) GetSourceLabels() map[string]string {
	if m != nil {
		return m.SourceLabels
	}
	return nil
}

func (m *TLSMatchAttributes) GetGateways() []string {
	if m != nil {
		return m.Gateways
	}
	return nil
}

// HTTPRedirect can be used to send a 301 redirect response to the caller,
// where the Authority/Host and the URI in the response can be swapped with
// the specified values. For example, the following rule redirects
// requests for /v1/getProductRatings API on the ratings service to
// /v1/bookRatings provided by the bookratings service.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - match:
//     - uri:
//         exact: /v1/getProductRatings
//     redirect:
//       uri: /v1/bookRatings
//       authority: newratings.default.svc.cluster.local
//   ...
// ```
type HTTPRedirect struct {
	// On a redirect, overwrite the Path portion of the URL with this
	// value. Note that the entire path will be replaced, irrespective of the
	// request URI being matched as an exact path or prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// On a redirect, overwrite the Authority/Host portion of the URL with
	// this value.
	Authority string `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	// On a redirect, Specifies the HTTP status code to use in the redirect
	// response. The default response code is MOVED_PERMANENTLY (301).
	RedirectCode         uint32   `protobuf:"varint,3,opt,name=redirect_code,json=redirectCode,proto3" json:"redirect_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPRedirect) Reset()         { *m = HTTPRedirect{} }
func (m *HTTPRedirect) String() string { return proto.CompactTextString(m) }
func (*HTTPRedirect) ProtoMessage()    {}
func (*HTTPRedirect) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{11}
}
func (m *HTTPRedirect) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRedirect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPRedirect.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPRedirect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRedirect.Merge(m, src)
}
func (m *HTTPRedirect) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRedirect) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRedirect.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRedirect proto.InternalMessageInfo

func (m *HTTPRedirect) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HTTPRedirect) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

func (m *HTTPRedirect) GetRedirectCode() uint32 {
	if m != nil {
		return m.RedirectCode
	}
	return 0
}

// HTTPRewrite can be used to rewrite specific parts of a HTTP request
// before forwarding the request to the destination. Rewrite primitive can
// be used only with HTTPRouteDestination. The following example
// demonstrates how to rewrite the URL prefix for api call (/ratings) to
// ratings service before making the actual API call.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - match:
//     - uri:
//         prefix: /ratings
//     rewrite:
//       uri: /v1/bookRatings
//     route:
//     - destination:
//         host: ratings.prod.svc.cluster.local
//         subset: v1
// ```
//
type HTTPRewrite struct {
	// rewrite the path (or the prefix) portion of the URI with this
	// value. If the original URI was matched based on prefix, the value
	// provided in this field will replace the corresponding matched prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// rewrite the Authority/Host header with this value.
	Authority            string   `protobuf:"bytes,2,opt,name=authority,proto3" json:"authority,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPRewrite) Reset()         { *m = HTTPRewrite{} }
func (m *HTTPRewrite) String() string { return proto.CompactTextString(m) }
func (*HTTPRewrite) ProtoMessage()    {}
func (*HTTPRewrite) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{12}
}
func (m *HTTPRewrite) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRewrite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPRewrite.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPRewrite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRewrite.Merge(m, src)
}
func (m *HTTPRewrite) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRewrite) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRewrite.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRewrite proto.InternalMessageInfo

func (m *HTTPRewrite) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HTTPRewrite) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

// Describes how to match a given string in HTTP headers. Match is
// case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Regex
	MatchType            isStringMatch_MatchType `protobuf_oneof:"match_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StringMatch) Reset()         { *m = StringMatch{} }
func (m *StringMatch) String() string { return proto.CompactTextString(m) }
func (*StringMatch) ProtoMessage()    {}
func (*StringMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{13}
}
func (m *StringMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringMatch.Merge(m, src)
}
func (m *StringMatch) XXX_Size() int {
	return m.Size()
}
func (m *StringMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_StringMatch.DiscardUnknown(m)
}

var xxx_messageInfo_StringMatch proto.InternalMessageInfo

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StringMatch) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

// Describes the retry policy to use when a HTTP request fails. For
// example, the following rule sets the maximum number of retries to 3 when
// calling ratings:v1 service, with a 2s timeout per retry attempt.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - route:
//     - destination:
//         host: ratings.prod.svc.cluster.local
//         subset: v1
//     retries:
//       attempts: 3
//       perTryTimeout: 2s
//       retryOn: gateway-error,connect-failure,refused-stream
// ```
//
type HTTPRetry struct {
	// Number of retries for a given request. The interval
	// between retries will be determined automatically (25ms+). Actual
	// number of retries attempted depends on the httpReqTimeout.
	Attempts int32 `protobuf:"varint,1,opt,name=attempts,proto3" json:"attempts,omitempty"`
	// Timeout per retry attempt for a given request. format: 1h/1m/1s/1ms. MUST BE >=1ms.
	PerTryTimeout *types.Duration `protobuf:"bytes,2,opt,name=per_try_timeout,json=perTryTimeout,proto3" json:"per_try_timeout,omitempty"`
	// Specifies the conditions under which retry takes place.
	// One or more policies can be specified using a ‘,’ delimited list.
	// See the [retry policies](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on)
	// and [gRPC retry policies](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-grpc-on) for more details.
	RetryOn              string   `protobuf:"bytes,3,opt,name=retry_on,json=retryOn,proto3" json:"retry_on,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPRetry) Reset()         { *m = HTTPRetry{} }
func (m *HTTPRetry) String() string { return proto.CompactTextString(m) }
func (*HTTPRetry) ProtoMessage()    {}
func (*HTTPRetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{14}
}
func (m *HTTPRetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPRetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPRetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPRetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPRetry.Merge(m, src)
}
func (m *HTTPRetry) XXX_Size() int {
	return m.Size()
}
func (m *HTTPRetry) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPRetry.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPRetry proto.InternalMessageInfo

func (m *HTTPRetry) GetAttempts() int32 {
	if m != nil {
		return m.Attempts
	}
	return 0
}

func (m *HTTPRetry) GetPerTryTimeout() *types.Duration {
	if m != nil {
		return m.PerTryTimeout
	}
	return nil
}

func (m *HTTPRetry) GetRetryOn() string {
	if m != nil {
		return m.RetryOn
	}
	return ""
}

// Describes the Cross-Origin Resource Sharing (CORS) policy, for a given
// service. Refer to [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS)
// for further details about cross origin resource sharing. For example,
// the following rule restricts cross origin requests to those originating
// from example.com domain using HTTP POST/GET, and sets the
// `Access-Control-Allow-Credentials` header to false. In addition, it only
// exposes `X-Foo-bar` header and sets an expiry period of 1 day.
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - route:
//     - destination:
//         host: ratings.prod.svc.cluster.local
//         subset: v1
//     corsPolicy:
//       allowOrigin:
//       - example.com
//       allowMethods:
//       - POST
//       - GET
//       allowCredentials: false
//       allowHeaders:
//       - X-Foo-Bar
//       maxAge: "24h"
// ```
//
type CorsPolicy struct {
	// The list of origins that are allowed to perform CORS requests. The
	// content will be serialized into the Access-Control-Allow-Origin
	// header. Wildcard * will allow all origins.
	AllowOrigin []string `protobuf:"bytes,1,rep,name=allow_origin,json=allowOrigin,proto3" json:"allow_origin,omitempty"`
	// List of HTTP methods allowed to access the resource. The content will
	// be serialized into the Access-Control-Allow-Methods header.
	AllowMethods []string `protobuf:"bytes,2,rep,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// List of HTTP headers that can be used when requesting the
	// resource. Serialized to Access-Control-Allow-Headers header.
	AllowHeaders []string `protobuf:"bytes,3,rep,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// A white list of HTTP headers that the browsers are allowed to
	// access. Serialized into Access-Control-Expose-Headers header.
	ExposeHeaders []string `protobuf:"bytes,4,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies how long the results of a preflight request can be
	// cached. Translates to the `Access-Control-Max-Age` header.
	MaxAge *types.Duration `protobuf:"bytes,5,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// Indicates whether the caller is allowed to send the actual request
	// (not the preflight) using credentials. Translates to
	// `Access-Control-Allow-Credentials` header.
	AllowCredentials     *types.BoolValue `protobuf:"bytes,6,opt,name=allow_credentials,json=allowCredentials,proto3" json:"allow_credentials,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CorsPolicy) Reset()         { *m = CorsPolicy{} }
func (m *CorsPolicy) String() string { return proto.CompactTextString(m) }
func (*CorsPolicy) ProtoMessage()    {}
func (*CorsPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{15}
}
func (m *CorsPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CorsPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CorsPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CorsPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CorsPolicy.Merge(m, src)
}
func (m *CorsPolicy) XXX_Size() int {
	return m.Size()
}
func (m *CorsPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_CorsPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_CorsPolicy proto.InternalMessageInfo

func (m *CorsPolicy) GetAllowOrigin() []string {
	if m != nil {
		return m.AllowOrigin
	}
	return nil
}

func (m *CorsPolicy) GetAllowMethods() []string {
	if m != nil {
		return m.AllowMethods
	}
	return nil
}

func (m *CorsPolicy) GetAllowHeaders() []string {
	if m != nil {
		return m.AllowHeaders
	}
	return nil
}

func (m *CorsPolicy) GetExposeHeaders() []string {
	if m != nil {
		return m.ExposeHeaders
	}
	return nil
}

func (m *CorsPolicy) GetMaxAge() *types.Duration {
	if m != nil {
		return m.MaxAge
	}
	return nil
}

func (m *CorsPolicy) GetAllowCredentials() *types.BoolValue {
	if m != nil {
		return m.AllowCredentials
	}
	return nil
}

// HTTPFaultInjection can be used to specify one or more faults to inject
// while forwarding http requests to the destination specified in a route.
// Fault specification is part of a VirtualService rule. Faults include
// aborting the Http request from downstream service, and/or delaying
// proxying of requests. A fault rule MUST HAVE delay or abort or both.
//
// *Note:* Delay and abort faults are independent of one another, even if
// both are specified simultaneously.
type HTTPFaultInjection struct {
	// Delay requests before forwarding, emulating various failures such as
	// network issues, overloaded upstream service, etc.
	Delay *HTTPFaultInjection_Delay `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
	// Abort Http request attempts and return error codes back to downstream
	// service, giving the impression that the upstream service is faulty.
	Abort                *HTTPFaultInjection_Abort `protobuf:"bytes,2,opt,name=abort,proto3" json:"abort,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *HTTPFaultInjection) Reset()         { *m = HTTPFaultInjection{} }
func (m *HTTPFaultInjection) String() string { return proto.CompactTextString(m) }
func (*HTTPFaultInjection) ProtoMessage()    {}
func (*HTTPFaultInjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{16}
}
func (m *HTTPFaultInjection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPFaultInjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPFaultInjection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPFaultInjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPFaultInjection.Merge(m, src)
}
func (m *HTTPFaultInjection) XXX_Size() int {
	return m.Size()
}
func (m *HTTPFaultInjection) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPFaultInjection.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPFaultInjection proto.InternalMessageInfo

func (m *HTTPFaultInjection) GetDelay() *HTTPFaultInjection_Delay {
	if m != nil {
		return m.Delay
	}
	return nil
}

func (m *HTTPFaultInjection) GetAbort() *HTTPFaultInjection_Abort {
	if m != nil {
		return m.Abort
	}
	return nil
}

// Delay specification is used to inject latency into the request
// forwarding path. The following example will introduce a 5 second delay
// in 1 out of every 1000 requests to the "v1" version of the "reviews"
// service from all pods with label env: prod
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: reviews-route
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   http:
//   - match:
//     - sourceLabels:
//         env: prod
//     route:
//     - destination:
//         host: reviews.prod.svc.cluster.local
//         subset: v1
//     fault:
//       delay:
//         percentage:
//           value: 0.1
//         fixedDelay: 5s
// ```
//
// The _fixedDelay_ field is used to indicate the amount of delay in seconds.
// The optional _percentage_ field can be used to only delay a certain
// percentage of requests. If left unspecified, all request will be delayed.
type HTTPFaultInjection_Delay struct {
	// Percentage of requests on which the delay will be injected (0-100).
	// Use of integer `percent` value is deprecated. Use the double `percentage`
	// field instead.
	Percent int32 `protobuf:"varint,1,opt,name=percent,proto3" json:"percent,omitempty"` // Deprecated: Do not use.
	// Types that are valid to be assigned to HttpDelayType:
	//	*HTTPFaultInjection_Delay_FixedDelay
	//	*HTTPFaultInjection_Delay_ExponentialDelay
	HttpDelayType isHTTPFaultInjection_Delay_HttpDelayType `protobuf_oneof:"http_delay_type"`
	// Percentage of requests on which the delay will be injected.
	Percentage           *Percent `protobuf:"bytes,5,opt,name=percentage,proto3" json:"percentage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPFaultInjection_Delay) Reset()         { *m = HTTPFaultInjection_Delay{} }
func (m *HTTPFaultInjection_Delay) String() string { return proto.CompactTextString(m) }
func (*HTTPFaultInjection_Delay) ProtoMessage()    {}
func (*HTTPFaultInjection_Delay) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{16, 0}
}
func (m *HTTPFaultInjection_Delay) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPFaultInjection_Delay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPFaultInjection_Delay.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPFaultInjection_Delay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPFaultInjection_Delay.Merge(m, src)
}
func (m *HTTPFaultInjection_Delay) XXX_Size() int {
	return m.Size()
}
func (m *HTTPFaultInjection_Delay) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPFaultInjection_Delay.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPFaultInjection_Delay proto.InternalMessageInfo

type isHTTPFaultInjection_Delay_HttpDelayType interface {
	isHTTPFaultInjection_Delay_HttpDelayType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HTTPFaultInjection_Delay_FixedDelay struct {
	FixedDelay *types.Duration `protobuf:"bytes,2,opt,name=fixed_delay,json=fixedDelay,proto3,oneof"`
}
type HTTPFaultInjection_Delay_ExponentialDelay struct {
	ExponentialDelay *types.Duration `protobuf:"bytes,3,opt,name=exponential_delay,json=exponentialDelay,proto3,oneof"`
}

func (*HTTPFaultInjection_Delay_FixedDelay) isHTTPFaultInjection_Delay_HttpDelayType()       {}
func (*HTTPFaultInjection_Delay_ExponentialDelay) isHTTPFaultInjection_Delay_HttpDelayType() {}

func (m *HTTPFaultInjection_Delay) GetHttpDelayType() isHTTPFaultInjection_Delay_HttpDelayType {
	if m != nil {
		return m.HttpDelayType
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPFaultInjection_Delay) GetPercent() int32 {
	if m != nil {
		return m.Percent
	}
	return 0
}

func (m *HTTPFaultInjection_Delay) GetFixedDelay() *types.Duration {
	if x, ok := m.GetHttpDelayType().(*HTTPFaultInjection_Delay_FixedDelay); ok {
		return x.FixedDelay
	}
	return nil
}

func (m *HTTPFaultInjection_Delay) GetExponentialDelay() *types.Duration {
	if x, ok := m.GetHttpDelayType().(*HTTPFaultInjection_Delay_ExponentialDelay); ok {
		return x.ExponentialDelay
	}
	return nil
}

func (m *HTTPFaultInjection_Delay) GetPercentage() *Percent {
	if m != nil {
		return m.Percentage
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HTTPFaultInjection_Delay) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HTTPFaultInjection_Delay_FixedDelay)(nil),
		(*HTTPFaultInjection_Delay_ExponentialDelay)(nil),
	}
}

// Abort specification is used to prematurely abort a request with a
// pre-specified error code. The following example will return an HTTP 400
// error code for 1 out of every 1000 requests to the "ratings" service "v1".
//
// ```yaml
// apiVersion: networking.istio.io/v1alpha3
// kind: VirtualService
// metadata:
//   name: ratings-route
// spec:
//   hosts:
//   - ratings.prod.svc.cluster.local
//   http:
//   - route:
//     - destination:
//         host: ratings.prod.svc.cluster.local
//         subset: v1
//     fault:
//       abort:
//         percentage:
//           value: 0.1
//         httpStatus: 400
// ```
//
// The _httpStatus_ field is used to indicate the HTTP status code to
// return to the caller. The optional _percentage_ field can be used to only
// abort a certain percentage of requests. If not specified, all requests are
// aborted.
type HTTPFaultInjection_Abort struct {
	// Percentage of requests to be aborted with the error code provided (0-100).
	// Use of integer `percent` value is deprecated. Use the double `percentage`
	// field instead.
	Percent int32 `protobuf:"varint,1,opt,name=percent,proto3" json:"percent,omitempty"` // Deprecated: Do not use.
	// Types that are valid to be assigned to ErrorType:
	//	*HTTPFaultInjection_Abort_HttpStatus
	//	*HTTPFaultInjection_Abort_GrpcStatus
	//	*HTTPFaultInjection_Abort_Http2Error
	ErrorType isHTTPFaultInjection_Abort_ErrorType `protobuf_oneof:"error_type"`
	// Percentage of requests to be aborted with the error code provided.
	Percentage           *Percent `protobuf:"bytes,5,opt,name=percentage,proto3" json:"percentage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPFaultInjection_Abort) Reset()         { *m = HTTPFaultInjection_Abort{} }
func (m *HTTPFaultInjection_Abort) String() string { return proto.CompactTextString(m) }
func (*HTTPFaultInjection_Abort) ProtoMessage()    {}
func (*HTTPFaultInjection_Abort) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{16, 1}
}
func (m *HTTPFaultInjection_Abort) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPFaultInjection_Abort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPFaultInjection_Abort.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPFaultInjection_Abort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPFaultInjection_Abort.Merge(m, src)
}
func (m *HTTPFaultInjection_Abort) XXX_Size() int {
	return m.Size()
}
func (m *HTTPFaultInjection_Abort) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPFaultInjection_Abort.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPFaultInjection_Abort proto.InternalMessageInfo

type isHTTPFaultInjection_Abort_ErrorType interface {
	isHTTPFaultInjection_Abort_ErrorType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HTTPFaultInjection_Abort_HttpStatus struct {
	HttpStatus int32 `protobuf:"varint,2,opt,name=http_status,json=httpStatus,proto3,oneof"`
}
type HTTPFaultInjection_Abort_GrpcStatus struct {
	GrpcStatus string `protobuf:"bytes,3,opt,name=grpc_status,json=grpcStatus,proto3,oneof"`
}
type HTTPFaultInjection_Abort_Http2Error struct {
	Http2Error string `protobuf:"bytes,4,opt,name=http2_error,json=http2Error,proto3,oneof"`
}

func (*HTTPFaultInjection_Abort_HttpStatus) isHTTPFaultInjection_Abort_ErrorType() {}
func (*HTTPFaultInjection_Abort_GrpcStatus) isHTTPFaultInjection_Abort_ErrorType() {}
func (*HTTPFaultInjection_Abort_Http2Error) isHTTPFaultInjection_Abort_ErrorType() {}

func (m *HTTPFaultInjection_Abort) GetErrorType() isHTTPFaultInjection_Abort_ErrorType {
	if m != nil {
		return m.ErrorType
	}
	return nil
}

// Deprecated: Do not use.
func (m *HTTPFaultInjection_Abort) GetPercent() int32 {
	if m != nil {
		return m.Percent
	}
	return 0
}

func (m *HTTPFaultInjection_Abort) GetHttpStatus() int32 {
	if x, ok := m.GetErrorType().(*HTTPFaultInjection_Abort_HttpStatus); ok {
		return x.HttpStatus
	}
	return 0
}

func (m *HTTPFaultInjection_Abort) GetGrpcStatus() string {
	if x, ok := m.GetErrorType().(*HTTPFaultInjection_Abort_GrpcStatus); ok {
		return x.GrpcStatus
	}
	return ""
}

func (m *HTTPFaultInjection_Abort) GetHttp2Error() string {
	if x, ok := m.GetErrorType().(*HTTPFaultInjection_Abort_Http2Error); ok {
		return x.Http2Error
	}
	return ""
}

func (m *HTTPFaultInjection_Abort) GetPercentage() *Percent {
	if m != nil {
		return m.Percentage
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HTTPFaultInjection_Abort) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HTTPFaultInjection_Abort_HttpStatus)(nil),
		(*HTTPFaultInjection_Abort_GrpcStatus)(nil),
		(*HTTPFaultInjection_Abort_Http2Error)(nil),
	}
}

// PortSelector specifies the number of a port to be used for
// matching or selection for final routing.
type PortSelector struct {
	// Valid port number
	Number               uint32   `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PortSelector) Reset()         { *m = PortSelector{} }
func (m *PortSelector) String() string { return proto.CompactTextString(m) }
func (*PortSelector) ProtoMessage()    {}
func (*PortSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{17}
}
func (m *PortSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortSelector.Merge(m, src)
}
func (m *PortSelector) XXX_Size() int {
	return m.Size()
}
func (m *PortSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_PortSelector.DiscardUnknown(m)
}

var xxx_messageInfo_PortSelector proto.InternalMessageInfo

func (m *PortSelector) GetNumber() uint32 {
	if m != nil {
		return m.Number
	}
	return 0
}

// Percent specifies a percentage in the range of [0.0, 100.0].
type Percent struct {
	Value                float64  `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Percent) Reset()         { *m = Percent{} }
func (m *Percent) String() string { return proto.CompactTextString(m) }
func (*Percent) ProtoMessage()    {}
func (*Percent) Descriptor() ([]byte, []int) {
	return fileDescriptor_e85a9a4fa9c17a22, []int{18}
}
func (m *Percent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Percent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Percent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Percent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Percent.Merge(m, src)
}
func (m *Percent) XXX_Size() int {
	return m.Size()
}
func (m *Percent) XXX_DiscardUnknown() {
	xxx_messageInfo_Percent.DiscardUnknown(m)
}

var xxx_messageInfo_Percent proto.InternalMessageInfo

func (m *Percent) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func init() {
	proto.RegisterType((*VirtualService)(nil), "istio.networking.v1alpha3.VirtualService")
	proto.RegisterType((*Destination)(nil), "istio.networking.v1alpha3.Destination")
	proto.RegisterType((*HTTPRoute)(nil), "istio.networking.v1alpha3.HTTPRoute")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPRoute.AppendHeadersEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPRoute.AppendRequestHeadersEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPRoute.AppendResponseHeadersEntry")
	proto.RegisterType((*Headers)(nil), "istio.networking.v1alpha3.Headers")
	proto.RegisterType((*Headers_HeaderOperations)(nil), "istio.networking.v1alpha3.Headers.HeaderOperations")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.Headers.HeaderOperations.AddEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.Headers.HeaderOperations.SetEntry")
	proto.RegisterType((*TLSRoute)(nil), "istio.networking.v1alpha3.TLSRoute")
	proto.RegisterType((*TCPRoute)(nil), "istio.networking.v1alpha3.TCPRoute")
	proto.RegisterType((*HTTPMatchRequest)(nil), "istio.networking.v1alpha3.HTTPMatchRequest")
	proto.RegisterMapType((map[string]*StringMatch)(nil), "istio.networking.v1alpha3.HTTPMatchRequest.HeadersEntry")
	proto.RegisterMapType((map[string]*StringMatch)(nil), "istio.networking.v1alpha3.HTTPMatchRequest.QueryParamsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPMatchRequest.SourceLabelsEntry")
	proto.RegisterType((*HTTPRouteDestination)(nil), "istio.networking.v1alpha3.HTTPRouteDestination")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPRouteDestination.AppendRequestHeadersEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.HTTPRouteDestination.AppendResponseHeadersEntry")
	proto.RegisterType((*RouteDestination)(nil), "istio.networking.v1alpha3.RouteDestination")
	proto.RegisterType((*L4MatchAttributes)(nil), "istio.networking.v1alpha3.L4MatchAttributes")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.L4MatchAttributes.SourceLabelsEntry")
	proto.RegisterType((*TLSMatchAttributes)(nil), "istio.networking.v1alpha3.TLSMatchAttributes")
	proto.RegisterMapType((map[string]string)(nil), "istio.networking.v1alpha3.TLSMatchAttributes.SourceLabelsEntry")
	proto.RegisterType((*HTTPRedirect)(nil), "istio.networking.v1alpha3.HTTPRedirect")
	proto.RegisterType((*HTTPRewrite)(nil), "istio.networking.v1alpha3.HTTPRewrite")
	proto.RegisterType((*StringMatch)(nil), "istio.networking.v1alpha3.StringMatch")
	proto.RegisterType((*HTTPRetry)(nil), "istio.networking.v1alpha3.HTTPRetry")
	proto.RegisterType((*CorsPolicy)(nil), "istio.networking.v1alpha3.CorsPolicy")
	proto.RegisterType((*HTTPFaultInjection)(nil), "istio.networking.v1alpha3.HTTPFaultInjection")
	proto.RegisterType((*HTTPFaultInjection_Delay)(nil), "istio.networking.v1alpha3.HTTPFaultInjection.Delay")
	proto.RegisterType((*HTTPFaultInjection_Abort)(nil), "istio.networking.v1alpha3.HTTPFaultInjection.Abort")
	proto.RegisterType((*PortSelector)(nil), "istio.networking.v1alpha3.PortSelector")
	proto.RegisterType((*Percent)(nil), "istio.networking.v1alpha3.Percent")
}

func init() {
	proto.RegisterFile("networking/v1alpha3/virtual_service.proto", fileDescriptor_e85a9a4fa9c17a22)
}

var fileDescriptor_e85a9a4fa9c17a22 = []byte{
	// 1951 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x8f, 0xfe, 0x8c, 0x25, 0xbd, 0x91, 0x12, 0xb9, 0xc9, 0x26, 0x63, 0x91, 0x4a, 0xbc, 0x0a,
	0x1b, 0x4c, 0x2d, 0x2b, 0x17, 0x36, 0x2c, 0xae, 0x25, 0x9b, 0x5d, 0xd9, 0xc9, 0xae, 0xb2, 0x95,
	0x10, 0xd3, 0x76, 0xf6, 0xc0, 0x65, 0xaa, 0x35, 0xd3, 0x96, 0x86, 0x48, 0xd3, 0x93, 0x9e, 0x1e,
	0x5b, 0xaa, 0x3d, 0x52, 0x45, 0x15, 0x14, 0x17, 0x4e, 0x9c, 0xe0, 0xc4, 0xa7, 0xe0, 0xc2, 0x75,
	0x8f, 0x54, 0xf1, 0x05, 0xb6, 0x42, 0xc1, 0xe7, 0xa0, 0xba, 0x7b, 0x46, 0x1a, 0x4b, 0xb6, 0x46,
	0x32, 0xa1, 0xd8, 0x93, 0xd5, 0xdd, 0xef, 0xf7, 0xde, 0xeb, 0xd7, 0xdd, 0xef, 0xfd, 0xe6, 0x19,
	0x7e, 0xe0, 0x53, 0x71, 0xc6, 0xf8, 0x2b, 0xcf, 0xef, 0x6d, 0x9f, 0xfe, 0x88, 0x0c, 0x82, 0x3e,
	0xd9, 0xdd, 0x3e, 0xf5, 0xb8, 0x88, 0xc8, 0xc0, 0x0e, 0x29, 0x3f, 0xf5, 0x1c, 0xda, 0x0a, 0x38,
	0x13, 0x0c, 0x6d, 0x78, 0xa1, 0xf0, 0x58, 0x6b, 0x0a, 0x68, 0x25, 0x80, 0xc6, 0xbd, 0x1e, 0x63,
	0xbd, 0x01, 0xdd, 0x26, 0x81, 0xb7, 0x7d, 0xe2, 0xd1, 0x81, 0x6b, 0x77, 0x69, 0x9f, 0x9c, 0x7a,
	0x8c, 0x6b, 0x6c, 0xe3, 0x6e, 0x2c, 0xa0, 0x46, 0xdd, 0xe8, 0x64, 0xdb, 0x8d, 0x38, 0x11, 0x1e,
	0xf3, 0x2f, 0x5b, 0x3f, 0xe3, 0x24, 0x08, 0x28, 0x0f, 0xf5, 0x7a, 0xf3, 0xf7, 0x79, 0xb8, 0xfe,
	0xa5, 0xf6, 0xea, 0x48, 0x3b, 0x85, 0x36, 0xc0, 0xe8, 0xb3, 0x50, 0x84, 0x56, 0x6e, 0xb3, 0xb0,
	0x55, 0xd9, 0x2f, 0x7c, 0xd3, 0xce, 0x63, 0x3d, 0x83, 0x1a, 0x50, 0xee, 0x11, 0x41, 0xcf, 0xc8,
	0x38, 0xb4, 0xf2, 0x72, 0x15, 0x4f, 0xc6, 0x68, 0x0f, 0x8a, 0x7d, 0x21, 0x02, 0xab, 0xb0, 0x59,
	0xd8, 0x32, 0x77, 0xbe, 0xd7, 0xba, 0x74, 0x53, 0xad, 0xce, 0xf1, 0xf1, 0x21, 0x66, 0x91, 0xa0,
	0x58, 0x21, 0xd0, 0x4f, 0xa0, 0x20, 0x06, 0xa1, 0x65, 0x28, 0xe0, 0xfd, 0x05, 0xc0, 0xe3, 0x67,
	0x47, 0x1a, 0x27, 0xe5, 0x15, 0xcc, 0x09, 0xac, 0x62, 0x36, 0xec, 0xe0, 0x30, 0x81, 0x39, 0x01,
	0xfa, 0x2e, 0x54, 0xe8, 0x28, 0x60, 0x5c, 0xd8, 0x82, 0x59, 0x6b, 0x7a, 0x13, 0x7a, 0xe2, 0x98,
	0x35, 0xbf, 0x02, 0xf3, 0x31, 0x0d, 0x85, 0xe7, 0xab, 0x18, 0xa2, 0xdb, 0x50, 0x94, 0x1b, 0xb7,
	0x72, 0x9b, 0xb9, 0x24, 0x12, 0x6a, 0x02, 0xdd, 0x82, 0xb5, 0x30, 0xea, 0x86, 0x54, 0x58, 0x79,
	0xb9, 0x84, 0xe3, 0x11, 0xfa, 0x19, 0x14, 0xa5, 0x26, 0xab, 0xb0, 0x99, 0xdb, 0x32, 0x77, 0xbe,
	0xbf, 0xc0, 0xa9, 0x43, 0xc6, 0xc5, 0x11, 0x1d, 0x50, 0x47, 0x30, 0x8e, 0x15, 0xa8, 0xf9, 0xb5,
	0x09, 0x95, 0x49, 0x6c, 0x10, 0x82, 0xa2, 0x4f, 0x86, 0xd4, 0x5a, 0x57, 0x06, 0xd4, 0x6f, 0xd4,
	0x06, 0x63, 0x48, 0x84, 0xd3, 0x57, 0x47, 0x63, 0xee, 0xbc, 0x9f, 0x11, 0xe4, 0xe7, 0x52, 0x16,
	0xd3, 0xd7, 0x11, 0x0d, 0x05, 0xd6, 0x48, 0xf4, 0x04, 0x0c, 0x2e, 0xf5, 0xab, 0xf3, 0x33, 0x77,
	0xb6, 0x97, 0x39, 0xa7, 0x54, 0x48, 0xb0, 0x46, 0xa3, 0x03, 0x28, 0x73, 0xea, 0x7a, 0x9c, 0x3a,
	0xcb, 0x6c, 0x56, 0x69, 0x8a, 0xc5, 0xf1, 0x04, 0x88, 0x3e, 0x85, 0x12, 0xa7, 0x67, 0xdc, 0x13,
	0xd4, 0x2a, 0x2a, 0x1d, 0x0f, 0x32, 0x75, 0x28, 0x69, 0x9c, 0xc0, 0xd0, 0xfb, 0xb0, 0x7e, 0x46,
	0xbb, 0x21, 0x73, 0x5e, 0x51, 0x61, 0x47, 0x41, 0x8f, 0x13, 0x97, 0x5a, 0xc6, 0x66, 0x6e, 0xab,
	0x8c, 0xeb, 0x93, 0x85, 0x97, 0x7a, 0x1e, 0xed, 0x42, 0x49, 0x78, 0x43, 0xca, 0x22, 0x61, 0xad,
	0x29, 0x73, 0x1b, 0x2d, 0xfd, 0x3a, 0x5a, 0xc9, 0xeb, 0x68, 0x3d, 0x8e, 0x5f, 0x0f, 0x4e, 0x24,
	0xd1, 0x23, 0xe9, 0xa3, 0xe0, 0x1e, 0x0d, 0xad, 0x92, 0x02, 0x65, 0xde, 0x6c, 0x2a, 0xf8, 0x18,
	0x27, 0x20, 0x74, 0x00, 0xc6, 0x09, 0x89, 0x06, 0xc2, 0x2a, 0x2b, 0xf4, 0x07, 0x19, 0xe8, 0xcf,
	0xa4, 0xec, 0x53, 0xff, 0x57, 0xd4, 0xd1, 0xd1, 0x56, 0x58, 0xf4, 0x08, 0xd6, 0x86, 0x1e, 0xe7,
	0x8c, 0x5b, 0x95, 0xcc, 0x38, 0xa5, 0x0f, 0x2b, 0x46, 0xa1, 0x03, 0xb8, 0xae, 0x7f, 0xd9, 0x01,
	0xe5, 0x0e, 0xf5, 0x85, 0x85, 0x94, 0x9e, 0x3b, 0x73, 0x01, 0x78, 0xf9, 0xd4, 0x17, 0xbb, 0x3b,
	0x5f, 0x92, 0x41, 0x44, 0x71, 0x4d, 0x63, 0x0e, 0x35, 0x04, 0x7d, 0x06, 0xa6, 0xc3, 0x78, 0x68,
	0x07, 0x6c, 0xe0, 0x39, 0x63, 0x0b, 0x94, 0x86, 0xf7, 0x16, 0x78, 0x72, 0xc0, 0x78, 0x78, 0xa8,
	0x84, 0x31, 0x38, 0x93, 0xdf, 0xa8, 0x0b, 0xd7, 0x65, 0x0a, 0xf2, 0x5d, 0xbb, 0x4f, 0x89, 0x4b,
	0x79, 0x68, 0x99, 0xea, 0x2a, 0xfe, 0x74, 0x99, 0xab, 0xd8, 0x6a, 0x2b, 0x68, 0x47, 0x23, 0x9f,
	0xf8, 0x82, 0x8f, 0xf7, 0xf3, 0x56, 0x0e, 0xd7, 0x48, 0x7a, 0x1e, 0x7d, 0x04, 0xb7, 0x39, 0x1d,
	0xb2, 0x53, 0x6a, 0x73, 0x1a, 0x06, 0xcc, 0x0f, 0xe9, 0xc4, 0x58, 0x55, 0x65, 0x35, 0x89, 0x79,
	0x47, 0x8b, 0xe0, 0x58, 0x22, 0xc1, 0x7e, 0x05, 0xb7, 0x63, 0xff, 0xe6, 0xb0, 0x35, 0xe5, 0xe8,
	0x27, 0x2b, 0x38, 0x3a, 0xa3, 0x7c, 0xea, 0xf0, 0x3b, 0xe4, 0xa2, 0x75, 0xb4, 0x07, 0xb7, 0x26,
	0x8e, 0xab, 0x77, 0x3b, 0xb1, 0x7d, 0x7d, 0xe2, 0xf7, 0xcd, 0xc4, 0x6f, 0x25, 0x90, 0x20, 0x47,
	0x70, 0x6b, 0xe2, 0xf6, 0x79, 0xe4, 0x0d, 0xe5, 0xf5, 0xa3, 0x95, 0xbc, 0x4e, 0xab, 0x9e, 0x3a,
	0x7d, 0x93, 0x5c, 0xb0, 0x8c, 0x1e, 0x42, 0x29, 0x31, 0x55, 0x57, 0x97, 0xa2, 0xb9, 0xc8, 0x94,
	0x96, 0xc4, 0x09, 0xa4, 0xf1, 0x29, 0xa0, 0xf9, 0x33, 0x45, 0x75, 0x28, 0xbc, 0xa2, 0x63, 0x9d,
	0x78, 0xb1, 0xfc, 0x89, 0x6e, 0x82, 0x71, 0x2a, 0xaf, 0x65, 0x9c, 0x71, 0xf5, 0xe0, 0xa3, 0xfc,
	0x5e, 0xae, 0xd1, 0x81, 0xc6, 0xe5, 0xc1, 0x5e, 0x49, 0xd3, 0xe7, 0xb0, 0x71, 0x69, 0x00, 0x56,
	0x51, 0xd4, 0xfc, 0x77, 0x01, 0x4a, 0x49, 0x78, 0x9e, 0xcb, 0x0c, 0xa2, 0xd4, 0x29, 0xac, 0xb9,
	0xb3, 0x9b, 0x1d, 0x9e, 0xf8, 0xef, 0x8b, 0x80, 0xea, 0x7c, 0x14, 0xe2, 0x44, 0x07, 0x7a, 0x21,
	0x33, 0xaf, 0xde, 0xa7, 0xb2, 0x7b, 0x45, 0x7d, 0x13, 0x25, 0x8d, 0xbf, 0xe6, 0xa1, 0x3e, 0xbb,
	0x8c, 0x7e, 0x0e, 0x05, 0x59, 0xdd, 0x74, 0x9d, 0x79, 0x78, 0x05, 0x03, 0xad, 0x23, 0x2a, 0x54,
	0xdc, 0xb0, 0x54, 0x24, 0xf5, 0x11, 0xd7, 0x8d, 0x8b, 0xce, 0x95, 0xf4, 0xb5, 0x5d, 0x37, 0xd6,
	0x47, 0x5c, 0x57, 0x16, 0x60, 0xfd, 0x0a, 0x14, 0xdf, 0xa8, 0xe0, 0x78, 0xd4, 0xf8, 0x10, 0xca,
	0x89, 0xe1, 0x95, 0x4e, 0xfe, 0x43, 0x28, 0x27, 0x06, 0x56, 0x3a, 0xe8, 0x3f, 0xe6, 0xa0, 0x9c,
	0xd0, 0x12, 0xd4, 0x39, 0x5f, 0x9e, 0x3f, 0x58, 0x4c, 0x65, 0x54, 0x75, 0x6e, 0x0b, 0xc1, 0xbd,
	0x6e, 0x24, 0x68, 0x18, 0x13, 0x2d, 0x5d, 0xa5, 0xdb, 0xe7, 0xab, 0xf4, 0xa2, 0x42, 0x7f, 0x49,
	0x85, 0x6e, 0xfe, 0x41, 0x7a, 0x16, 0x33, 0x1f, 0xb4, 0x7f, 0xde, 0xb3, 0x1f, 0x2e, 0xd0, 0xf7,
	0xec, 0xc7, 0x33, 0x8e, 0xbd, 0x45, 0x9f, 0xfe, 0x52, 0x82, 0xfa, 0x2c, 0x31, 0x99, 0x10, 0x1d,
	0x33, 0x45, 0x74, 0xf6, 0xa0, 0x10, 0x71, 0x2f, 0x7e, 0x2f, 0x8b, 0xaa, 0xdd, 0x91, 0xe0, 0x9e,
	0xdf, 0xd3, 0xfa, 0x24, 0x44, 0x96, 0xca, 0xd0, 0xe9, 0xd3, 0x61, 0xf2, 0x38, 0x96, 0x05, 0xc7,
	0x28, 0x55, 0x6a, 0xa9, 0xe8, 0x33, 0x37, 0xa6, 0x35, 0x4b, 0xe3, 0x35, 0x0a, 0x3d, 0x86, 0x0a,
	0x89, 0x44, 0x9f, 0x71, 0x4f, 0x8c, 0x97, 0x60, 0x35, 0x69, 0x15, 0x53, 0x20, 0xc2, 0xd3, 0x94,
	0xaa, 0x69, 0xf1, 0xde, 0x0a, 0x54, 0xaf, 0x95, 0x4e, 0x5b, 0x93, 0x44, 0x2b, 0xe3, 0xac, 0xb8,
	0xa9, 0xe4, 0x3e, 0x35, 0x4d, 0x39, 0x51, 0x17, 0x6a, 0x21, 0x8b, 0xb8, 0x43, 0xed, 0x01, 0xe9,
	0xd2, 0x81, 0xe4, 0x38, 0xd2, 0xda, 0xc7, 0xab, 0x58, 0x3b, 0x52, 0x0a, 0x9e, 0x29, 0xbc, 0x36,
	0x59, 0x0d, 0x53, 0x53, 0xe7, 0x3e, 0x1a, 0xca, 0x33, 0x1f, 0x0d, 0x36, 0x54, 0x5f, 0x47, 0x94,
	0x8f, 0xed, 0x80, 0x70, 0x32, 0x0c, 0xad, 0x4a, 0x76, 0x7e, 0x98, 0x35, 0xff, 0x0b, 0x89, 0x3f,
	0x54, 0x70, 0x6d, 0xdd, 0x7c, 0x3d, 0x9d, 0x41, 0x0f, 0xe0, 0x86, 0xd7, 0xf3, 0x19, 0xa7, 0x76,
	0xc4, 0x3d, 0xdb, 0x21, 0x21, 0x55, 0xc4, 0xa5, 0x8c, 0x6b, 0x7a, 0xfa, 0x25, 0xf7, 0x0e, 0x48,
	0x48, 0x1b, 0x5d, 0xa8, 0x66, 0x24, 0xfb, 0x87, 0xe9, 0x1c, 0xb0, 0xfc, 0xa1, 0xa6, 0x72, 0xcc,
	0x27, 0xb0, 0x3e, 0x17, 0xab, 0x95, 0x92, 0xd4, 0x09, 0xd4, 0x67, 0x77, 0xfb, 0xbf, 0x70, 0xb4,
	0xf9, 0x0f, 0x03, 0x6e, 0x5e, 0x44, 0xfe, 0xd1, 0x73, 0x30, 0xdd, 0xe9, 0x70, 0x89, 0xe7, 0x99,
	0x02, 0xeb, 0xfc, 0x96, 0xc6, 0xcb, 0x24, 0x7e, 0x46, 0xbd, 0x5e, 0x5f, 0x7f, 0x45, 0x19, 0x38,
	0x1e, 0x2d, 0x62, 0x6f, 0x85, 0x2c, 0xf6, 0xf6, 0x9b, 0xdc, 0xe5, 0xf4, 0x4d, 0x7f, 0x2a, 0x7e,
	0xb1, 0xe2, 0x27, 0xcf, 0x5b, 0x67, 0x72, 0x46, 0x06, 0x93, 0xfb, 0x75, 0xee, 0x52, 0x2a, 0xb7,
	0xa6, 0x76, 0xf0, 0xf4, 0xaa, 0x3b, 0xb8, 0x22, 0xab, 0x2b, 0xad, 0xce, 0xea, 0xbe, 0x85, 0x9c,
	0x6c, 0x0c, 0xf5, 0xff, 0xd3, 0x85, 0x6e, 0xfe, 0x2d, 0x0f, 0xeb, 0x73, 0x75, 0x15, 0x6d, 0xc3,
	0x77, 0x52, 0x60, 0x3b, 0x8c, 0xba, 0x3e, 0x4d, 0xda, 0x2e, 0x18, 0xa5, 0x96, 0x8e, 0xf4, 0xca,
	0x24, 0x83, 0xe7, 0x53, 0x19, 0xfc, 0xfe, 0x24, 0x83, 0x6b, 0xbc, 0x2a, 0x5b, 0x95, 0x24, 0x05,
	0x6b, 0x24, 0x72, 0x66, 0xd3, 0x7c, 0x31, 0xf3, 0x93, 0x60, 0xce, 0xdd, 0x95, 0xf2, 0xbc, 0x71,
	0x3e, 0xcf, 0xff, 0xd7, 0xa9, 0xaf, 0xf9, 0xcf, 0x3c, 0xa0, 0x79, 0xce, 0x84, 0x36, 0xa1, 0x12,
	0xfa, 0x9e, 0x3d, 0xd7, 0xaf, 0x2a, 0x87, 0xbe, 0xd7, 0x51, 0x2d, 0xab, 0x4b, 0x82, 0x9c, 0xcf,
	0x0c, 0x72, 0x61, 0x51, 0x90, 0x8b, 0x17, 0x04, 0xd9, 0x9d, 0x0d, 0xb2, 0x91, 0xf9, 0xb5, 0x38,
	0xbf, 0xa3, 0x95, 0xa2, 0xbc, 0xf6, 0xb6, 0xa3, 0xec, 0x40, 0x35, 0xdd, 0xaa, 0x91, 0xd8, 0x84,
	0x86, 0x55, 0x34, 0xbd, 0xba, 0x93, 0xa6, 0x37, 0x1a, 0x9f, 0xa2, 0x2d, 0xf7, 0xa1, 0x96, 0x34,
	0x77, 0x6c, 0x87, 0xb9, 0x34, 0x0e, 0x62, 0x35, 0x99, 0x3c, 0x60, 0x2e, 0x6d, 0x7e, 0x0c, 0x66,
	0xaa, 0x97, 0xb3, 0xaa, 0x8d, 0x26, 0x05, 0x33, 0x55, 0xb6, 0xd0, 0x2d, 0x30, 0xe8, 0x88, 0x38,
	0x71, 0x8f, 0xae, 0x73, 0x0d, 0xeb, 0x21, 0xb2, 0x60, 0x2d, 0xe0, 0xf4, 0xc4, 0x1b, 0x69, 0x0d,
	0x9d, 0x6b, 0x38, 0x1e, 0x4b, 0x04, 0xa7, 0x3d, 0x3a, 0xd2, 0x2f, 0x45, 0x22, 0xd4, 0x70, 0xbf,
	0x0a, 0xa0, 0x88, 0xae, 0x2d, 0xc6, 0x01, 0x6d, 0xfe, 0x2e, 0x17, 0x37, 0xe3, 0xa8, 0x0c, 0xe2,
	0x3d, 0x28, 0x13, 0x21, 0xe8, 0x30, 0x50, 0xd7, 0x2c, 0xb7, 0x65, 0xc4, 0xd7, 0x2c, 0x99, 0x44,
	0x6d, 0xb8, 0x11, 0x50, 0x6e, 0x0b, 0x3e, 0xb6, 0x93, 0x1e, 0x53, 0x3e, 0xab, 0xc7, 0x54, 0x0b,
	0x28, 0x3f, 0xe6, 0xe3, 0xe3, 0xb8, 0xd3, 0xb4, 0x21, 0x3f, 0xec, 0xa4, 0x02, 0xe6, 0xc7, 0x8f,
	0x58, 0x35, 0x91, 0xc6, 0x2f, 0xfc, 0xe6, 0x9f, 0xf2, 0x00, 0xd3, 0x6e, 0x0a, 0x7a, 0x17, 0xaa,
	0x64, 0x30, 0x60, 0x67, 0x36, 0xe3, 0x5e, 0xcf, 0xf3, 0xe3, 0x8c, 0x61, 0xaa, 0xb9, 0x17, 0x6a,
	0x4a, 0x9e, 0x84, 0x16, 0xd1, 0xb4, 0x34, 0xb9, 0xf0, 0x1a, 0xf7, 0x5c, 0xcf, 0x4d, 0x85, 0xce,
	0x55, 0xd7, 0x58, 0x28, 0xa9, 0x03, 0xef, 0xc1, 0x75, 0x3a, 0x0a, 0xd8, 0x4c, 0x19, 0xad, 0xe0,
	0x9a, 0x9e, 0x4d, 0xc4, 0x76, 0xa0, 0x34, 0x24, 0x23, 0x9b, 0xf4, 0x74, 0xff, 0x6d, 0xe1, 0xc6,
	0xd7, 0x86, 0x64, 0xd4, 0xee, 0x51, 0xf4, 0x39, 0xac, 0x6b, 0xfb, 0x0e, 0xa7, 0x2e, 0xf5, 0x85,
	0x47, 0x06, 0x61, 0xdc, 0x9a, 0x6b, 0xcc, 0xa1, 0xf7, 0x19, 0x1b, 0xe8, 0xbe, 0x54, 0x5d, 0x81,
	0x0e, 0xa6, 0x98, 0xe6, 0x9f, 0x0d, 0x40, 0xf3, 0xdd, 0x33, 0xf4, 0x14, 0x0c, 0x97, 0x0e, 0xc8,
	0x78, 0x99, 0xef, 0xee, 0x39, 0x74, 0xeb, 0xb1, 0x84, 0x62, 0xad, 0x41, 0xaa, 0x22, 0xdd, 0x24,
	0xf7, 0xae, 0xac, 0xaa, 0x2d, 0xa1, 0x58, 0x6b, 0x68, 0xfc, 0x36, 0x0f, 0x86, 0xd2, 0x8d, 0xee,
	0x40, 0x29, 0xe9, 0xc7, 0xe9, 0x4b, 0x25, 0xab, 0x71, 0x32, 0x85, 0xda, 0x60, 0x9e, 0x78, 0x23,
	0xea, 0xda, 0x7a, 0x0f, 0x59, 0xd7, 0x49, 0xdd, 0xc8, 0xce, 0x35, 0x0c, 0x0a, 0xa4, 0x0d, 0x74,
	0x60, 0x5d, 0x9e, 0x92, 0xaf, 0xe3, 0x14, 0x2b, 0x2a, 0x64, 0x28, 0xea, 0x5c, 0xc3, 0xf5, 0x14,
	0x4a, 0x6b, 0xda, 0x07, 0x88, 0xfd, 0x9a, 0x9e, 0xf0, 0x22, 0x42, 0x10, 0x37, 0x0d, 0x71, 0x0a,
	0xb5, 0xbf, 0x0e, 0x37, 0xfa, 0x42, 0x04, 0xda, 0x0d, 0xf5, 0xca, 0x1a, 0xff, 0xca, 0x81, 0xa1,
	0x82, 0x93, 0x11, 0x8b, 0x07, 0x60, 0x2a, 0x68, 0x28, 0x88, 0x88, 0x42, 0x5d, 0x5d, 0x27, 0x1b,
	0x96, 0x2b, 0x47, 0x6a, 0x01, 0xbd, 0x0b, 0x66, 0x8f, 0x07, 0x4e, 0x22, 0x97, 0xbc, 0x70, 0x90,
	0x93, 0x53, 0x11, 0x09, 0xd8, 0xb1, 0xa9, 0x6a, 0xa8, 0x16, 0x13, 0x11, 0x35, 0xf9, 0x44, 0xb5,
	0x4b, 0xdf, 0xc6, 0x66, 0xab, 0x00, 0xca, 0x80, 0xce, 0x26, 0x3b, 0x50, 0x4d, 0x37, 0xfc, 0x25,
	0x51, 0xf0, 0xa3, 0x61, 0x97, 0x72, 0xb5, 0xd9, 0x1a, 0x8e, 0x47, 0x5f, 0x14, 0xcb, 0xf9, 0x7a,
	0x41, 0x7f, 0x03, 0x37, 0xef, 0x41, 0x29, 0x69, 0xbd, 0x4e, 0x32, 0xb6, 0x94, 0xce, 0xc5, 0x19,
	0x7b, 0xbf, 0xf5, 0xf5, 0x9b, 0xbb, 0xb9, 0xbf, 0xbf, 0xb9, 0x9b, 0xfb, 0xe6, 0xcd, 0xdd, 0xdc,
	0x2f, 0x37, 0xb5, 0x7f, 0x1e, 0x53, 0xff, 0x2c, 0xba, 0xe0, 0xbf, 0x4f, 0xdd, 0x35, 0x75, 0xd4,
	0xbb, 0xff, 0x09, 0x00, 0x00, 0xff, 0xff, 0xa0, 0xe6, 0x9e, 0x31, 0x9b, 0x1a, 0x00, 0x00,
}

func (m *VirtualService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualService) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VirtualService) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExportTo) > 0 {
		for iNdEx := len(m.ExportTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExportTo[iNdEx])
			copy(dAtA[i:], m.ExportTo[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.ExportTo[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Tls) > 0 {
		for iNdEx := len(m.Tls) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tls[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Tcp) > 0 {
		for iNdEx := len(m.Tcp) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tcp[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Http) > 0 {
		for iNdEx := len(m.Http) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Http[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Gateways) > 0 {
		for iNdEx := len(m.Gateways) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Gateways[iNdEx])
			copy(dAtA[i:], m.Gateways[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Gateways[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Hosts) > 0 {
		for iNdEx := len(m.Hosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Hosts[iNdEx])
			copy(dAtA[i:], m.Hosts[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Hosts[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Destination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Destination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Destination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Port != nil {
		{
			size, err := m.Port.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Subset) > 0 {
		i -= len(m.Subset)
		copy(dAtA[i:], m.Subset)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Subset)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HTTPRoute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRoute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPRoute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MirrorPercent != nil {
		{
			size, err := m.MirrorPercent.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Headers != nil {
		{
			size, err := m.Headers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.AppendRequestHeaders) > 0 {
		for k := range m.AppendRequestHeaders {
			v := m.AppendRequestHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x7a
		}
	}
	if len(m.RemoveRequestHeaders) > 0 {
		for iNdEx := len(m.RemoveRequestHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemoveRequestHeaders[iNdEx])
			copy(dAtA[i:], m.RemoveRequestHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.RemoveRequestHeaders[iNdEx])))
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.AppendResponseHeaders) > 0 {
		for k := range m.AppendResponseHeaders {
			v := m.AppendResponseHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.RemoveResponseHeaders) > 0 {
		for iNdEx := len(m.RemoveResponseHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemoveResponseHeaders[iNdEx])
			copy(dAtA[i:], m.RemoveResponseHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.RemoveResponseHeaders[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.AppendHeaders) > 0 {
		for k := range m.AppendHeaders {
			v := m.AppendHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.CorsPolicy != nil {
		{
			size, err := m.CorsPolicy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.Mirror != nil {
		{
			size, err := m.Mirror.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Fault != nil {
		{
			size, err := m.Fault.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Retries != nil {
		{
			size, err := m.Retries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Timeout != nil {
		{
			size, err := m.Timeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.WebsocketUpgrade {
		i--
		if m.WebsocketUpgrade {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Rewrite != nil {
		{
			size, err := m.Rewrite.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Redirect != nil {
		{
			size, err := m.Redirect.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Route) > 0 {
		for iNdEx := len(m.Route) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Route[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Match) > 0 {
		for iNdEx := len(m.Match) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Match[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Headers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Headers) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Headers) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Headers_HeaderOperations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Headers_HeaderOperations) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Headers_HeaderOperations) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Remove) > 0 {
		for iNdEx := len(m.Remove) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Remove[iNdEx])
			copy(dAtA[i:], m.Remove[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Remove[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Add) > 0 {
		for k := range m.Add {
			v := m.Add[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Set) > 0 {
		for k := range m.Set {
			v := m.Set[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TLSRoute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSRoute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TLSRoute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Route) > 0 {
		for iNdEx := len(m.Route) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Route[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Match) > 0 {
		for iNdEx := len(m.Match) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Match[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TCPRoute) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPRoute) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TCPRoute) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Route) > 0 {
		for iNdEx := len(m.Route) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Route[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Match) > 0 {
		for iNdEx := len(m.Match) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Match[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintVirtualService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPMatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPMatchRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPMatchRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x5a
	}
	if m.IgnoreUriCase {
		i--
		if m.IgnoreUriCase {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.QueryParams) > 0 {
		for k := range m.QueryParams {
			v := m.QueryParams[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintVirtualService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Gateways) > 0 {
		for iNdEx := len(m.Gateways) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Gateways[iNdEx])
			copy(dAtA[i:], m.Gateways[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Gateways[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.SourceLabels) > 0 {
		for k := range m.SourceLabels {
			v := m.SourceLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Port != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Headers) > 0 {
		for k := range m.Headers {
			v := m.Headers[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintVirtualService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Authority != nil {
		{
			size, err := m.Authority.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Method != nil {
		{
			size, err := m.Method.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Scheme != nil {
		{
			size, err := m.Scheme.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Uri != nil {
		{
			size, err := m.Uri.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HTTPRouteDestination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRouteDestination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPRouteDestination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Headers != nil {
		{
			size, err := m.Headers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.AppendRequestHeaders) > 0 {
		for k := range m.AppendRequestHeaders {
			v := m.AppendRequestHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.RemoveRequestHeaders) > 0 {
		for iNdEx := len(m.RemoveRequestHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemoveRequestHeaders[iNdEx])
			copy(dAtA[i:], m.RemoveRequestHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.RemoveRequestHeaders[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.AppendResponseHeaders) > 0 {
		for k := range m.AppendResponseHeaders {
			v := m.AppendResponseHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.RemoveResponseHeaders) > 0 {
		for iNdEx := len(m.RemoveResponseHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RemoveResponseHeaders[iNdEx])
			copy(dAtA[i:], m.RemoveResponseHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.RemoveResponseHeaders[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Weight != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Weight))
		i--
		dAtA[i] = 0x10
	}
	if m.Destination != nil {
		{
			size, err := m.Destination.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RouteDestination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteDestination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RouteDestination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Weight != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Weight))
		i--
		dAtA[i] = 0x10
	}
	if m.Destination != nil {
		{
			size, err := m.Destination.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *L4MatchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *L4MatchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *L4MatchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Gateways) > 0 {
		for iNdEx := len(m.Gateways) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Gateways[iNdEx])
			copy(dAtA[i:], m.Gateways[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Gateways[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.SourceLabels) > 0 {
		for k := range m.SourceLabels {
			v := m.SourceLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.SourceSubnet) > 0 {
		i -= len(m.SourceSubnet)
		copy(dAtA[i:], m.SourceSubnet)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.SourceSubnet)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DestinationSubnets) > 0 {
		for iNdEx := len(m.DestinationSubnets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DestinationSubnets[iNdEx])
			copy(dAtA[i:], m.DestinationSubnets[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.DestinationSubnets[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TLSMatchAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSMatchAttributes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TLSMatchAttributes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Gateways) > 0 {
		for iNdEx := len(m.Gateways) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Gateways[iNdEx])
			copy(dAtA[i:], m.Gateways[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Gateways[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.SourceLabels) > 0 {
		for k := range m.SourceLabels {
			v := m.SourceLabels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintVirtualService(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintVirtualService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.SourceSubnet) > 0 {
		i -= len(m.SourceSubnet)
		copy(dAtA[i:], m.SourceSubnet)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.SourceSubnet)))
		i--
		dAtA[i] = 0x22
	}
	if m.Port != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x18
	}
	if len(m.DestinationSubnets) > 0 {
		for iNdEx := len(m.DestinationSubnets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DestinationSubnets[iNdEx])
			copy(dAtA[i:], m.DestinationSubnets[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.DestinationSubnets[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SniHosts) > 0 {
		for iNdEx := len(m.SniHosts) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SniHosts[iNdEx])
			copy(dAtA[i:], m.SniHosts[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.SniHosts[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPRedirect) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRedirect) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPRedirect) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RedirectCode != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.RedirectCode))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Authority) > 0 {
		i -= len(m.Authority)
		copy(dAtA[i:], m.Authority)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Authority)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Uri) > 0 {
		i -= len(m.Uri)
		copy(dAtA[i:], m.Uri)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Uri)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HTTPRewrite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRewrite) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPRewrite) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Authority) > 0 {
		i -= len(m.Authority)
		copy(dAtA[i:], m.Authority)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Authority)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Uri) > 0 {
		i -= len(m.Uri)
		copy(dAtA[i:], m.Uri)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Uri)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StringMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMatch) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StringMatch) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MatchType != nil {
		{
			size := m.MatchType.Size()
			i -= size
			if _, err := m.MatchType.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *StringMatch_Exact) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Exact) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Exact)
	copy(dAtA[i:], m.Exact)
	i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Exact)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}
func (m *StringMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Prefix) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Prefix)
	copy(dAtA[i:], m.Prefix)
	i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Prefix)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *StringMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *StringMatch_Regex) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Regex)
	copy(dAtA[i:], m.Regex)
	i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Regex)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *HTTPRetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPRetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPRetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RetryOn) > 0 {
		i -= len(m.RetryOn)
		copy(dAtA[i:], m.RetryOn)
		i = encodeVarintVirtualService(dAtA, i, uint64(len(m.RetryOn)))
		i--
		dAtA[i] = 0x1a
	}
	if m.PerTryTimeout != nil {
		{
			size, err := m.PerTryTimeout.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Attempts != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Attempts))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CorsPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CorsPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CorsPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AllowCredentials != nil {
		{
			size, err := m.AllowCredentials.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.MaxAge != nil {
		{
			size, err := m.MaxAge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ExposeHeaders) > 0 {
		for iNdEx := len(m.ExposeHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExposeHeaders[iNdEx])
			copy(dAtA[i:], m.ExposeHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.ExposeHeaders[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.AllowHeaders) > 0 {
		for iNdEx := len(m.AllowHeaders) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AllowHeaders[iNdEx])
			copy(dAtA[i:], m.AllowHeaders[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.AllowHeaders[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.AllowMethods) > 0 {
		for iNdEx := len(m.AllowMethods) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AllowMethods[iNdEx])
			copy(dAtA[i:], m.AllowMethods[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.AllowMethods[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.AllowOrigin) > 0 {
		for iNdEx := len(m.AllowOrigin) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AllowOrigin[iNdEx])
			copy(dAtA[i:], m.AllowOrigin[iNdEx])
			i = encodeVarintVirtualService(dAtA, i, uint64(len(m.AllowOrigin[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HTTPFaultInjection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPFaultInjection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPFaultInjection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Abort != nil {
		{
			size, err := m.Abort.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Delay != nil {
		{
			size, err := m.Delay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HTTPFaultInjection_Delay) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPFaultInjection_Delay) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPFaultInjection_Delay) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Percentage != nil {
		{
			size, err := m.Percentage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.HttpDelayType != nil {
		{
			size := m.HttpDelayType.Size()
			i -= size
			if _, err := m.HttpDelayType.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Percent != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Percent))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HTTPFaultInjection_Delay_FixedDelay) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *HTTPFaultInjection_Delay_FixedDelay) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.FixedDelay != nil {
		{
			size, err := m.FixedDelay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *HTTPFaultInjection_Delay_ExponentialDelay) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *HTTPFaultInjection_Delay_ExponentialDelay) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExponentialDelay != nil {
		{
			size, err := m.ExponentialDelay.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *HTTPFaultInjection_Abort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPFaultInjection_Abort) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPFaultInjection_Abort) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Percentage != nil {
		{
			size, err := m.Percentage.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintVirtualService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.ErrorType != nil {
		{
			size := m.ErrorType.Size()
			i -= size
			if _, err := m.ErrorType.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Percent != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Percent))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HTTPFaultInjection_Abort_HttpStatus) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *HTTPFaultInjection_Abort_HttpStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i = encodeVarintVirtualService(dAtA, i, uint64(m.HttpStatus))
	i--
	dAtA[i] = 0x10
	return len(dAtA) - i, nil
}
func (m *HTTPFaultInjection_Abort_GrpcStatus) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *HTTPFaultInjection_Abort_GrpcStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.GrpcStatus)
	copy(dAtA[i:], m.GrpcStatus)
	i = encodeVarintVirtualService(dAtA, i, uint64(len(m.GrpcStatus)))
	i--
	dAtA[i] = 0x1a
	return len(dAtA) - i, nil
}
func (m *HTTPFaultInjection_Abort_Http2Error) MarshalTo(dAtA []byte) (int, error) {
	return m.MarshalToSizedBuffer(dAtA[:m.Size()])
}

func (m *HTTPFaultInjection_Abort_Http2Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Http2Error)
	copy(dAtA[i:], m.Http2Error)
	i = encodeVarintVirtualService(dAtA, i, uint64(len(m.Http2Error)))
	i--
	dAtA[i] = 0x22
	return len(dAtA) - i, nil
}
func (m *PortSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortSelector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortSelector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Number != 0 {
		i = encodeVarintVirtualService(dAtA, i, uint64(m.Number))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Percent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Percent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Percent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintVirtualService(dAtA []byte, offset int, v uint64) int {
	offset -= sovVirtualService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *VirtualService) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Hosts) > 0 {
		for _, s := range m.Hosts {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Gateways) > 0 {
		for _, s := range m.Gateways {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Http) > 0 {
		for _, e := range m.Http {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Tcp) > 0 {
		for _, e := range m.Tcp {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Tls) > 0 {
		for _, e := range m.Tls {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.ExportTo) > 0 {
		for _, s := range m.ExportTo {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Destination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	l = len(m.Subset)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPRoute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, e := range m.Match {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Route) > 0 {
		for _, e := range m.Route {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.Redirect != nil {
		l = m.Redirect.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Rewrite != nil {
		l = m.Rewrite.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.WebsocketUpgrade {
		n += 2
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Retries != nil {
		l = m.Retries.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Fault != nil {
		l = m.Fault.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Mirror != nil {
		l = m.Mirror.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.CorsPolicy != nil {
		l = m.CorsPolicy.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if len(m.AppendHeaders) > 0 {
		for k, v := range m.AppendHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.RemoveResponseHeaders) > 0 {
		for _, s := range m.RemoveResponseHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AppendResponseHeaders) > 0 {
		for k, v := range m.AppendResponseHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.RemoveRequestHeaders) > 0 {
		for _, s := range m.RemoveRequestHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AppendRequestHeaders) > 0 {
		for k, v := range m.AppendRequestHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if m.Headers != nil {
		l = m.Headers.Size()
		n += 2 + l + sovVirtualService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 2 + l + sovVirtualService(uint64(l))
	}
	if m.MirrorPercent != nil {
		l = m.MirrorPercent.Size()
		n += 2 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Headers) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Headers_HeaderOperations) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Set) > 0 {
		for k, v := range m.Set {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.Add) > 0 {
		for k, v := range m.Add {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.Remove) > 0 {
		for _, s := range m.Remove {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSRoute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, e := range m.Match {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Route) > 0 {
		for _, e := range m.Route {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TCPRoute) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, e := range m.Match {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.Route) > 0 {
		for _, e := range m.Route {
			l = e.Size()
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPMatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Uri != nil {
		l = m.Uri.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Scheme != nil {
		l = m.Scheme.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Method != nil {
		l = m.Method.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Authority != nil {
		l = m.Authority.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if len(m.Headers) > 0 {
		for k, v := range m.Headers {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovVirtualService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if m.Port != 0 {
		n += 1 + sovVirtualService(uint64(m.Port))
	}
	if len(m.SourceLabels) > 0 {
		for k, v := range m.SourceLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.Gateways) > 0 {
		for _, s := range m.Gateways {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.QueryParams) > 0 {
		for k, v := range m.QueryParams {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovVirtualService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if m.IgnoreUriCase {
		n += 2
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPRouteDestination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Destination != nil {
		l = m.Destination.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovVirtualService(uint64(m.Weight))
	}
	if len(m.RemoveResponseHeaders) > 0 {
		for _, s := range m.RemoveResponseHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AppendResponseHeaders) > 0 {
		for k, v := range m.AppendResponseHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.RemoveRequestHeaders) > 0 {
		for _, s := range m.RemoveRequestHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AppendRequestHeaders) > 0 {
		for k, v := range m.AppendRequestHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if m.Headers != nil {
		l = m.Headers.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RouteDestination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Destination != nil {
		l = m.Destination.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovVirtualService(uint64(m.Weight))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *L4MatchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DestinationSubnets) > 0 {
		for _, s := range m.DestinationSubnets {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.Port != 0 {
		n += 1 + sovVirtualService(uint64(m.Port))
	}
	l = len(m.SourceSubnet)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if len(m.SourceLabels) > 0 {
		for k, v := range m.SourceLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.Gateways) > 0 {
		for _, s := range m.Gateways {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSMatchAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SniHosts) > 0 {
		for _, s := range m.SniHosts {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.DestinationSubnets) > 0 {
		for _, s := range m.DestinationSubnets {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.Port != 0 {
		n += 1 + sovVirtualService(uint64(m.Port))
	}
	l = len(m.SourceSubnet)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if len(m.SourceLabels) > 0 {
		for k, v := range m.SourceLabels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovVirtualService(uint64(len(k))) + 1 + len(v) + sovVirtualService(uint64(len(v)))
			n += mapEntrySize + 1 + sovVirtualService(uint64(mapEntrySize))
		}
	}
	if len(m.Gateways) > 0 {
		for _, s := range m.Gateways {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPRedirect) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uri)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	l = len(m.Authority)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.RedirectCode != 0 {
		n += 1 + sovVirtualService(uint64(m.RedirectCode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPRewrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Uri)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	l = len(m.Authority)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StringMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchType != nil {
		n += m.MatchType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StringMatch_Exact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Exact)
	n += 1 + l + sovVirtualService(uint64(l))
	return n
}
func (m *StringMatch_Prefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovVirtualService(uint64(l))
	return n
}
func (m *StringMatch_Regex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovVirtualService(uint64(l))
	return n
}
func (m *HTTPRetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Attempts != 0 {
		n += 1 + sovVirtualService(uint64(m.Attempts))
	}
	if m.PerTryTimeout != nil {
		l = m.PerTryTimeout.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	l = len(m.RetryOn)
	if l > 0 {
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CorsPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.AllowOrigin) > 0 {
		for _, s := range m.AllowOrigin {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AllowMethods) > 0 {
		for _, s := range m.AllowMethods {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.AllowHeaders) > 0 {
		for _, s := range m.AllowHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if len(m.ExposeHeaders) > 0 {
		for _, s := range m.ExposeHeaders {
			l = len(s)
			n += 1 + l + sovVirtualService(uint64(l))
		}
	}
	if m.MaxAge != nil {
		l = m.MaxAge.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.AllowCredentials != nil {
		l = m.AllowCredentials.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPFaultInjection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Delay != nil {
		l = m.Delay.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.Abort != nil {
		l = m.Abort.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPFaultInjection_Delay) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Percent != 0 {
		n += 1 + sovVirtualService(uint64(m.Percent))
	}
	if m.HttpDelayType != nil {
		n += m.HttpDelayType.Size()
	}
	if m.Percentage != nil {
		l = m.Percentage.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPFaultInjection_Delay_FixedDelay) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FixedDelay != nil {
		l = m.FixedDelay.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	return n
}
func (m *HTTPFaultInjection_Delay_ExponentialDelay) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExponentialDelay != nil {
		l = m.ExponentialDelay.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	return n
}
func (m *HTTPFaultInjection_Abort) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Percent != 0 {
		n += 1 + sovVirtualService(uint64(m.Percent))
	}
	if m.ErrorType != nil {
		n += m.ErrorType.Size()
	}
	if m.Percentage != nil {
		l = m.Percentage.Size()
		n += 1 + l + sovVirtualService(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HTTPFaultInjection_Abort_HttpStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovVirtualService(uint64(m.HttpStatus))
	return n
}
func (m *HTTPFaultInjection_Abort_GrpcStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GrpcStatus)
	n += 1 + l + sovVirtualService(uint64(l))
	return n
}
func (m *HTTPFaultInjection_Abort_Http2Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Http2Error)
	n += 1 + l + sovVirtualService(uint64(l))
	return n
}
func (m *PortSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Number != 0 {
		n += 1 + sovVirtualService(uint64(m.Number))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Percent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovVirtualService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozVirtualService(x uint64) (n int) {
	return sovVirtualService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *VirtualService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateways", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateways = append(m.Gateways, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Http = append(m.Http, &HTTPRoute{})
			if err := m.Http[len(m.Http)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tcp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tcp = append(m.Tcp, &TCPRoute{})
			if err := m.Tcp[len(m.Tcp)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tls = append(m.Tls, &TLSRoute{})
			if err := m.Tls[len(m.Tls)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExportTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExportTo = append(m.ExportTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Destination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Destination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Destination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subset", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subset = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &PortSelector{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRoute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRoute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRoute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = append(m.Match, &HTTPMatchRequest{})
			if err := m.Match[len(m.Match)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Route = append(m.Route, &HTTPRouteDestination{})
			if err := m.Route[len(m.Route)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Redirect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Redirect == nil {
				m.Redirect = &HTTPRedirect{}
			}
			if err := m.Redirect.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rewrite", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rewrite == nil {
				m.Rewrite = &HTTPRewrite{}
			}
			if err := m.Rewrite.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WebsocketUpgrade", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WebsocketUpgrade = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &types.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Retries == nil {
				m.Retries = &HTTPRetry{}
			}
			if err := m.Retries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fault", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Fault == nil {
				m.Fault = &HTTPFaultInjection{}
			}
			if err := m.Fault.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mirror", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mirror == nil {
				m.Mirror = &Destination{}
			}
			if err := m.Mirror.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CorsPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CorsPolicy == nil {
				m.CorsPolicy = &CorsPolicy{}
			}
			if err := m.CorsPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppendHeaders == nil {
				m.AppendHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AppendHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveResponseHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoveResponseHeaders = append(m.RemoveResponseHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendResponseHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppendResponseHeaders == nil {
				m.AppendResponseHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AppendResponseHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveRequestHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoveRequestHeaders = append(m.RemoveRequestHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendRequestHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppendRequestHeaders == nil {
				m.AppendRequestHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AppendRequestHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = &Headers{}
			}
			if err := m.Headers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MirrorPercent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MirrorPercent == nil {
				m.MirrorPercent = &types.UInt32Value{}
			}
			if err := m.MirrorPercent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Headers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Headers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Headers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &Headers_HeaderOperations{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &Headers_HeaderOperations{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Headers_HeaderOperations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderOperations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderOperations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Set[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Add", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Add == nil {
				m.Add = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Add[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remove = append(m.Remove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSRoute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSRoute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSRoute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = append(m.Match, &TLSMatchAttributes{})
			if err := m.Match[len(m.Match)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Route = append(m.Route, &RouteDestination{})
			if err := m.Route[len(m.Route)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TCPRoute) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPRoute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPRoute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = append(m.Match, &L4MatchAttributes{})
			if err := m.Match[len(m.Match)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Route = append(m.Route, &RouteDestination{})
			if err := m.Route[len(m.Route)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPMatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPMatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPMatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Uri == nil {
				m.Uri = &StringMatch{}
			}
			if err := m.Uri.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scheme == nil {
				m.Scheme = &StringMatch{}
			}
			if err := m.Scheme.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Method == nil {
				m.Method = &StringMatch{}
			}
			if err := m.Method.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authority", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Authority == nil {
				m.Authority = &StringMatch{}
			}
			if err := m.Authority.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = make(map[string]*StringMatch)
			}
			var mapkey string
			var mapvalue *StringMatch
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthVirtualService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMatch{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Headers[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceLabels == nil {
				m.SourceLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SourceLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateways", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateways = append(m.Gateways, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryParams == nil {
				m.QueryParams = make(map[string]*StringMatch)
			}
			var mapkey string
			var mapvalue *StringMatch
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthVirtualService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMatch{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.QueryParams[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IgnoreUriCase", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IgnoreUriCase = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRouteDestination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRouteDestination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRouteDestination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Destination == nil {
				m.Destination = &Destination{}
			}
			if err := m.Destination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveResponseHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoveResponseHeaders = append(m.RemoveResponseHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendResponseHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppendResponseHeaders == nil {
				m.AppendResponseHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AppendResponseHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoveRequestHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoveRequestHeaders = append(m.RemoveRequestHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppendRequestHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AppendRequestHeaders == nil {
				m.AppendRequestHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AppendRequestHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = &Headers{}
			}
			if err := m.Headers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteDestination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteDestination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteDestination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destination", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Destination == nil {
				m.Destination = &Destination{}
			}
			if err := m.Destination.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *L4MatchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: L4MatchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: L4MatchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationSubnets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationSubnets = append(m.DestinationSubnets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceSubnet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceSubnet = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceLabels == nil {
				m.SourceLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SourceLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateways", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateways = append(m.Gateways, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSMatchAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSMatchAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSMatchAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SniHosts", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SniHosts = append(m.SniHosts, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationSubnets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationSubnets = append(m.DestinationSubnets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceSubnet", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceSubnet = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceLabels == nil {
				m.SourceLabels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowVirtualService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthVirtualService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipVirtualService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthVirtualService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SourceLabels[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gateways", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Gateways = append(m.Gateways, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRedirect) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRedirect: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRedirect: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authority", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authority = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RedirectCode", wireType)
			}
			m.RedirectCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RedirectCode |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRewrite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRewrite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRewrite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authority", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authority = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Exact{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPRetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPRetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPRetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attempts", wireType)
			}
			m.Attempts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Attempts |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerTryTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerTryTimeout == nil {
				m.PerTryTimeout = &types.Duration{}
			}
			if err := m.PerTryTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryOn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryOn = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CorsPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CorsPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CorsPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOrigin", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowOrigin = append(m.AllowOrigin, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMethods", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowMethods = append(m.AllowMethods, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowHeaders = append(m.AllowHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExposeHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExposeHeaders = append(m.ExposeHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxAge == nil {
				m.MaxAge = &types.Duration{}
			}
			if err := m.MaxAge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowCredentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AllowCredentials == nil {
				m.AllowCredentials = &types.BoolValue{}
			}
			if err := m.AllowCredentials.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPFaultInjection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPFaultInjection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPFaultInjection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delay == nil {
				m.Delay = &HTTPFaultInjection_Delay{}
			}
			if err := m.Delay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Abort", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Abort == nil {
				m.Abort = &HTTPFaultInjection_Abort{}
			}
			if err := m.Abort.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPFaultInjection_Delay) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Delay: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Delay: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percent", wireType)
			}
			m.Percent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Percent |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Duration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HttpDelayType = &HTTPFaultInjection_Delay_FixedDelay{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Duration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HttpDelayType = &HTTPFaultInjection_Delay_ExponentialDelay{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percentage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Percentage == nil {
				m.Percentage = &Percent{}
			}
			if err := m.Percentage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPFaultInjection_Abort) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Abort: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Abort: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percent", wireType)
			}
			m.Percent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Percent |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpStatus", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ErrorType = &HTTPFaultInjection_Abort_HttpStatus{v}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = &HTTPFaultInjection_Abort_GrpcStatus{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = &HTTPFaultInjection_Abort_Http2Error{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percentage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthVirtualService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthVirtualService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Percentage == nil {
				m.Percentage = &Percent{}
			}
			if err := m.Percentage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			m.Number = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Number |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Percent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Percent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Percent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipVirtualService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthVirtualService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipVirtualService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowVirtualService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowVirtualService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthVirtualService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthVirtualService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowVirtualService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipVirtualService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthVirtualService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthVirtualService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowVirtualService   = fmt.Errorf("proto: integer overflow")
)
