/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	internalinterfaces "knative.dev/operator/pkg/client/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// KnativeEventings returns a KnativeEventingInformer.
	KnativeEventings() KnativeEventingInformer
	// KnativeServings returns a KnativeServingInformer.
	KnativeServings() KnativeServingInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// KnativeEventings returns a KnativeEventingInformer.
func (v *version) KnativeEventings() KnativeEventingInformer {
	return &knativeEventingInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// KnativeServings returns a KnativeServingInformer.
func (v *version) KnativeServings() KnativeServingInformer {
	return &knativeServingInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
