/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1beta1 "knative.dev/eventing/pkg/apis/messaging/v1beta1"
	scheme "knative.dev/eventing/pkg/client/clientset/versioned/scheme"
)

// InMemoryChannelsGetter has a method to return a InMemoryChannelInterface.
// A group's client should implement this interface.
type InMemoryChannelsGetter interface {
	InMemoryChannels(namespace string) InMemoryChannelInterface
}

// InMemoryChannelInterface has methods to work with InMemoryChannel resources.
type InMemoryChannelInterface interface {
	Create(*v1beta1.InMemoryChannel) (*v1beta1.InMemoryChannel, error)
	Update(*v1beta1.InMemoryChannel) (*v1beta1.InMemoryChannel, error)
	UpdateStatus(*v1beta1.InMemoryChannel) (*v1beta1.InMemoryChannel, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta1.InMemoryChannel, error)
	List(opts v1.ListOptions) (*v1beta1.InMemoryChannelList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.InMemoryChannel, err error)
	InMemoryChannelExpansion
}

// inMemoryChannels implements InMemoryChannelInterface
type inMemoryChannels struct {
	client rest.Interface
	ns     string
}

// newInMemoryChannels returns a InMemoryChannels
func newInMemoryChannels(c *MessagingV1beta1Client, namespace string) *inMemoryChannels {
	return &inMemoryChannels{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the inMemoryChannel, and returns the corresponding inMemoryChannel object, and an error if there is any.
func (c *inMemoryChannels) Get(name string, options v1.GetOptions) (result *v1beta1.InMemoryChannel, err error) {
	result = &v1beta1.InMemoryChannel{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("inmemorychannels").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of InMemoryChannels that match those selectors.
func (c *inMemoryChannels) List(opts v1.ListOptions) (result *v1beta1.InMemoryChannelList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.InMemoryChannelList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("inmemorychannels").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested inMemoryChannels.
func (c *inMemoryChannels) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("inmemorychannels").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a inMemoryChannel and creates it.  Returns the server's representation of the inMemoryChannel, and an error, if there is any.
func (c *inMemoryChannels) Create(inMemoryChannel *v1beta1.InMemoryChannel) (result *v1beta1.InMemoryChannel, err error) {
	result = &v1beta1.InMemoryChannel{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("inmemorychannels").
		Body(inMemoryChannel).
		Do().
		Into(result)
	return
}

// Update takes the representation of a inMemoryChannel and updates it. Returns the server's representation of the inMemoryChannel, and an error, if there is any.
func (c *inMemoryChannels) Update(inMemoryChannel *v1beta1.InMemoryChannel) (result *v1beta1.InMemoryChannel, err error) {
	result = &v1beta1.InMemoryChannel{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("inmemorychannels").
		Name(inMemoryChannel.Name).
		Body(inMemoryChannel).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *inMemoryChannels) UpdateStatus(inMemoryChannel *v1beta1.InMemoryChannel) (result *v1beta1.InMemoryChannel, err error) {
	result = &v1beta1.InMemoryChannel{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("inmemorychannels").
		Name(inMemoryChannel.Name).
		SubResource("status").
		Body(inMemoryChannel).
		Do().
		Into(result)
	return
}

// Delete takes name of the inMemoryChannel and deletes it. Returns an error if one occurs.
func (c *inMemoryChannels) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("inmemorychannels").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *inMemoryChannels) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("inmemorychannels").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched inMemoryChannel.
func (c *inMemoryChannels) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.InMemoryChannel, err error) {
	result = &v1beta1.InMemoryChannel{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("inmemorychannels").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
