/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1 "knative.dev/eventing/pkg/apis/flows/v1"
	scheme "knative.dev/eventing/pkg/client/clientset/versioned/scheme"
)

// SequencesGetter has a method to return a SequenceInterface.
// A group's client should implement this interface.
type SequencesGetter interface {
	Sequences(namespace string) SequenceInterface
}

// SequenceInterface has methods to work with Sequence resources.
type SequenceInterface interface {
	Create(*v1.Sequence) (*v1.Sequence, error)
	Update(*v1.Sequence) (*v1.Sequence, error)
	UpdateStatus(*v1.Sequence) (*v1.Sequence, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.Sequence, error)
	List(opts metav1.ListOptions) (*v1.SequenceList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Sequence, err error)
	SequenceExpansion
}

// sequences implements SequenceInterface
type sequences struct {
	client rest.Interface
	ns     string
}

// newSequences returns a Sequences
func newSequences(c *FlowsV1Client, namespace string) *sequences {
	return &sequences{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sequence, and returns the corresponding sequence object, and an error if there is any.
func (c *sequences) Get(name string, options metav1.GetOptions) (result *v1.Sequence, err error) {
	result = &v1.Sequence{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sequences").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Sequences that match those selectors.
func (c *sequences) List(opts metav1.ListOptions) (result *v1.SequenceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SequenceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("sequences").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sequences.
func (c *sequences) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("sequences").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a sequence and creates it.  Returns the server's representation of the sequence, and an error, if there is any.
func (c *sequences) Create(sequence *v1.Sequence) (result *v1.Sequence, err error) {
	result = &v1.Sequence{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("sequences").
		Body(sequence).
		Do().
		Into(result)
	return
}

// Update takes the representation of a sequence and updates it. Returns the server's representation of the sequence, and an error, if there is any.
func (c *sequences) Update(sequence *v1.Sequence) (result *v1.Sequence, err error) {
	result = &v1.Sequence{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sequences").
		Name(sequence.Name).
		Body(sequence).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *sequences) UpdateStatus(sequence *v1.Sequence) (result *v1.Sequence, err error) {
	result = &v1.Sequence{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("sequences").
		Name(sequence.Name).
		SubResource("status").
		Body(sequence).
		Do().
		Into(result)
	return
}

// Delete takes name of the sequence and deletes it. Returns an error if one occurs.
func (c *sequences) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sequences").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sequences) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("sequences").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched sequence.
func (c *sequences) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.Sequence, err error) {
	result = &v1.Sequence{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("sequences").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
