/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTektonResults implements TektonResultInterface
type FakeTektonResults struct {
	Fake *FakeOperatorV1alpha1
}

var tektonresultsResource = schema.GroupVersionResource{Group: "operator.tekton.dev", Version: "v1alpha1", Resource: "tektonresults"}

var tektonresultsKind = schema.GroupVersionKind{Group: "operator.tekton.dev", Version: "v1alpha1", Kind: "TektonResult"}

// Get takes name of the tektonResult, and returns the corresponding tektonResult object, and an error if there is any.
func (c *FakeTektonResults) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonResult, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(tektonresultsResource, name), &v1alpha1.TektonResult{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonResult), err
}

// List takes label and field selectors, and returns the list of TektonResults that match those selectors.
func (c *FakeTektonResults) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonResultList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(tektonresultsResource, tektonresultsKind, opts), &v1alpha1.TektonResultList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.TektonResultList{ListMeta: obj.(*v1alpha1.TektonResultList).ListMeta}
	for _, item := range obj.(*v1alpha1.TektonResultList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested tektonResults.
func (c *FakeTektonResults) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(tektonresultsResource, opts))
}

// Create takes the representation of a tektonResult and creates it.  Returns the server's representation of the tektonResult, and an error, if there is any.
func (c *FakeTektonResults) Create(ctx context.Context, tektonResult *v1alpha1.TektonResult, opts v1.CreateOptions) (result *v1alpha1.TektonResult, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(tektonresultsResource, tektonResult), &v1alpha1.TektonResult{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonResult), err
}

// Update takes the representation of a tektonResult and updates it. Returns the server's representation of the tektonResult, and an error, if there is any.
func (c *FakeTektonResults) Update(ctx context.Context, tektonResult *v1alpha1.TektonResult, opts v1.UpdateOptions) (result *v1alpha1.TektonResult, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(tektonresultsResource, tektonResult), &v1alpha1.TektonResult{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonResult), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTektonResults) UpdateStatus(ctx context.Context, tektonResult *v1alpha1.TektonResult, opts v1.UpdateOptions) (*v1alpha1.TektonResult, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(tektonresultsResource, "status", tektonResult), &v1alpha1.TektonResult{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonResult), err
}

// Delete takes name of the tektonResult and deletes it. Returns an error if one occurs.
func (c *FakeTektonResults) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(tektonresultsResource, name), &v1alpha1.TektonResult{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTektonResults) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(tektonresultsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.TektonResultList{})
	return err
}

// Patch applies the patch and returns the patched tektonResult.
func (c *FakeTektonResults) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonResult, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(tektonresultsResource, name, pt, data, subresources...), &v1alpha1.TektonResult{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonResult), err
}
