/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/tektoncd/operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TektonPipelinesGetter has a method to return a TektonPipelineInterface.
// A group's client should implement this interface.
type TektonPipelinesGetter interface {
	TektonPipelines() TektonPipelineInterface
}

// TektonPipelineInterface has methods to work with TektonPipeline resources.
type TektonPipelineInterface interface {
	Create(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.CreateOptions) (*v1alpha1.TektonPipeline, error)
	Update(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (*v1alpha1.TektonPipeline, error)
	UpdateStatus(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (*v1alpha1.TektonPipeline, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TektonPipeline, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TektonPipelineList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonPipeline, err error)
	TektonPipelineExpansion
}

// tektonPipelines implements TektonPipelineInterface
type tektonPipelines struct {
	client rest.Interface
}

// newTektonPipelines returns a TektonPipelines
func newTektonPipelines(c *OperatorV1alpha1Client) *tektonPipelines {
	return &tektonPipelines{
		client: c.RESTClient(),
	}
}

// Get takes name of the tektonPipeline, and returns the corresponding tektonPipeline object, and an error if there is any.
func (c *tektonPipelines) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonPipeline, err error) {
	result = &v1alpha1.TektonPipeline{}
	err = c.client.Get().
		Resource("tektonpipelines").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TektonPipelines that match those selectors.
func (c *tektonPipelines) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonPipelineList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.TektonPipelineList{}
	err = c.client.Get().
		Resource("tektonpipelines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tektonPipelines.
func (c *tektonPipelines) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("tektonpipelines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tektonPipeline and creates it.  Returns the server's representation of the tektonPipeline, and an error, if there is any.
func (c *tektonPipelines) Create(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.CreateOptions) (result *v1alpha1.TektonPipeline, err error) {
	result = &v1alpha1.TektonPipeline{}
	err = c.client.Post().
		Resource("tektonpipelines").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonPipeline).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tektonPipeline and updates it. Returns the server's representation of the tektonPipeline, and an error, if there is any.
func (c *tektonPipelines) Update(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (result *v1alpha1.TektonPipeline, err error) {
	result = &v1alpha1.TektonPipeline{}
	err = c.client.Put().
		Resource("tektonpipelines").
		Name(tektonPipeline.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonPipeline).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tektonPipelines) UpdateStatus(ctx context.Context, tektonPipeline *v1alpha1.TektonPipeline, opts v1.UpdateOptions) (result *v1alpha1.TektonPipeline, err error) {
	result = &v1alpha1.TektonPipeline{}
	err = c.client.Put().
		Resource("tektonpipelines").
		Name(tektonPipeline.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonPipeline).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tektonPipeline and deletes it. Returns an error if one occurs.
func (c *tektonPipelines) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("tektonpipelines").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tektonPipelines) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("tektonpipelines").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tektonPipeline.
func (c *tektonPipelines) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonPipeline, err error) {
	result = &v1alpha1.TektonPipeline{}
	err = c.client.Patch(pt).
		Resource("tektonpipelines").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
